 /*
  * Khoros: $Id: vmpp.c,v 1.2 1992/03/20 23:10:34 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vmpp.c,v 1.2 1992/03/20 23:10:34 dkhoros Exp $";
#endif

 /*
  * $Log: vmpp.c,v $
 * Revision 1.2  1992/03/20  23:10:34  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vmpp.c
 >>>>
 >>>>      Program Name: vmpp
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Compute 2-dimensional information from COMPLEX images
 >>>>	
 >>>>	

 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Mon Mar  9 18:45:47 1992
 >>>>
 >>>>          Routines: main- the main program for vmpp
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vmpp.h"


/****************************************************************
 *
 * Routine Name:  main program for vmpp
 *
 *       Input:  
 *      -i  input image 
 *      -o  resulting output image 
 *
 *
 *      [-k] Type of information 
 *		1 (magnitude),
 *		2 (log of magnitude+1),
 *		3 (power),
 *		4 (log of power),
 *		or 5 (phase)
 *		   [default = 2] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        struct xvimage *image,*readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);
        image = readimage(vmpp->i_file);
        if (image == NULL) exit(1);
        CHECKINPUT(program,image);
/* -main_before_lib_call_end */

/* -main_library_call */
        if(! lvmpp(image,vmpp->k_toggle))
          {
            (void) fprintf(stderr, "lvmpp Failed\n");
            exit(1);
          }
/* -main_library_call_end */

/* -main_after_lib_call */
        writeimage(vmpp->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vmpp 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vmpp :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCompute 2-dimensional information from COMPLEX images\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
fprintf(stderr,"The available information types (selected by the -k argument) are:\n");
fprintf(stderr,"  1 - Magnitude\n");
fprintf(stderr,"  2 - Log(magnitude+1.0)\n");
fprintf(stderr,"  3 - Power\n");
fprintf(stderr,"  4 - Log(power+1.0)\n");
fprintf(stderr,"  5 - Phase\n\n");
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-k]  Type of information \n");
	fprintf(stderr, "\t\t1  (magnitude),\n");
	fprintf(stderr, "\t\t2  (log of magnitude+1),\n");
	fprintf(stderr, "\t\t3  (power),\n");
	fprintf(stderr, "\t\t4  (log of power),\n");
	fprintf(stderr, "\t\tor 5  (phase)\n");
	fprintf(stderr, "\t\t[default = 2]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vmpp\n");
	fprintf(stderr, "\t[-U] Gives the usage for vmpp\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vmpp.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vmpp.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vmpp
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image \n        {outfile}: "; 
char	*k_pstr = "\nEnter: (k) Type of information  -- \n      \t\t1 (magnitude)\n\t\t2 (log of magnitude+1)\n\t\t3 (power)\n\t\t4 (log of power)\n\t\tor 5 (phase)\n  [2]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vmpp", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vmpp.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vmpp: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vmpp.ans");
		}

	     }

	}

	/*
	 * allocate the vmpp structure
	 */
	vmpp = (vmpp_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vmpp_struct));

	/*
	 * get required arguments for vmpp
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vmpp->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vmpp->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vmpp->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vmpp->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vmpp->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vmpp->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vmpp->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vmpp->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vmpp->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vmpp->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


	/*
	 * get optional toggles for vmpp
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		vmpp->k_flag = vget_int(fid, prompt_flag,
		"-k", k_pstr, &(vmpp->k_toggle),
		2, 0, 0);

		if ((vmpp->k_toggle == 1 ) || 
		    (vmpp->k_toggle == 2 ) || 
		    (vmpp->k_toggle == 3 ) || 
		    (vmpp->k_toggle == 4 ) || 
		    (vmpp->k_toggle == 5 ))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		vmpp->k_flag = vget_int(fid, prompt_flag,
		"-k", k_pstr, &(vmpp->k_toggle),
		2, 0, 0);

		if ((vmpp->k_toggle != 1 ) && 
		    (vmpp->k_toggle != 2 ) && 
		    (vmpp->k_toggle != 3 ) && 
		    (vmpp->k_toggle != 4 ) && 
		    (vmpp->k_toggle != 5 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



