 /*
  * Khoros: $Id: vshape.c,v 1.1 1991/05/10 15:47:34 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vshape.c,v 1.1 1991/05/10 15:47:34 khoros Exp $";
#endif

 /*
  * $Log: vshape.c,v $
 * Revision 1.1  1991/05/10  15:47:34  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vshape.c
 >>>>
 >>>>      Program Name: vshape
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Performs shape analysis on images.
 >>>>	
 >>>>	
 >>>>            Author: Pascal ADAM, Shirley Lee
 >>>>
 >>>> Date Last Updated: Wed Mar 27 18:18:01 1991
 >>>>
 >>>>          Routines: main- the main program for vshape
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vshape.h"


/****************************************************************
 *
 * Routine Name:  main program for vshape
 *
 *       Input:  
 *
 *        -i1  input Clust/Label Image    -OR-
 *        -i2  input Grey Level Image
 *
 *        [-o1] output Axis image
 *        [-o2] output outline image
 *        [-o3] output VIFF file
 *        [-f] output ASCII file
 *        [-ms] if yes, compute standard moments
 *        [-mc] if yes, compute central moments
 *        [-mi] if yes, compute invariant moments
 *        [-mr] if no computes axis of bounded box
 *        [-col] if no color = white, with black background
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */

struct xvimage *readimage(),
               *image,
               *outline,
               *axis,
               *img3;

FILE *printdev;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
   if (check_args()) exit(1);

   READINPUT(image) ;
   CHECKINPUT(program, image) ;
   if ( vshape->f_flag ) 
   {
      if (! vwrite_ascii(vshape->f_file, &printdev)) 
      {
         (void) fprintf(stderr, "vshape:  Can't open ascii output file: \n\n");
         exit(1);
      }
   }

   if (lvconvert(image,VFF_TYP_4_BYTE,0,1,0.0,1.0) == 0 ) 
   {
      (void) fprintf(stderr,"vshape: lvconvert failure\n\n");
      exit(1);
   }

   /* Check that one output at least has been selected */

   if ((vshape->o1_flag==FALSE)&&(vshape->o2_flag==FALSE)&&(vshape->o3_flag==FALSE)&&(vshape->f_flag==FALSE))
   {
      (void) fprintf(stderr,
                     "vshape:  Need at least one output selected !!\n\n");
      exit(1);
   }

/* -main_before_lib_call_end */

/* -main_library_call */
lvshape(vshape->i1_flag,
        image,
        vshape->mr_logic,
        vshape->col_logic,
        vshape->o1_flag,
        &axis,
        vshape->o2_flag,
        &outline,
        vshape->o3_flag,
        &img3,
        vshape->f_flag,
        vshape->f_file,
        printdev,
        vshape->ms_logic,
        vshape->mc_logic,
        vshape->mi_logic);

/* -main_library_call_end */

/* -main_after_lib_call */
if ( vshape->f_flag ) (void) fclose(printdev);
if ( vshape->o1_flag ) writeimage(vshape->o1_file,axis);
if ( vshape->o2_flag ) writeimage(vshape->o2_file,outline);
if ( vshape->o3_flag ) writeimage(vshape->o3_file,img3);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vshape 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vshape :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tPerforms shape analysis on images.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr, "\n");
	fprintf(stderr,"\t-i1  input Clust/Label Image  (infile) -OR- \n");
	fprintf(stderr,"\t-i2  input Grey Level Image  (infile) \n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-o1]  output Axis image (outfile) [null]\n");
	fprintf(stderr,"\t[-o2]  output outline image (outfile) [null]\n");
	fprintf(stderr,"\t[-o3]  output VIFF file (outfile) [null]\n");
	fprintf(stderr,"\t[-f]  output ASCII file (outfile) [null]\n");
	fprintf(stderr,"\t[-ms]  if yes, compute standard moments (boolean) [false]\n");
	fprintf(stderr,"\t[-mc]  if yes, compute central moments (boolean) [false]\n");
	fprintf(stderr,"\t[-mi]  if yes, compute invariant moments (boolean) [false]\n");
	fprintf(stderr,"\t[-mr]  if no computes axis of bounded box (boolean) [false]\n");
	fprintf(stderr,"\t[-col]  if no color = white, with black background (boolean) [false]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vshape\n");
	fprintf(stderr, "\t[-U] Gives the usage for vshape\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vshape.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vshape.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vshape
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i1_pstr = 
	"\nEnter: (i1) input Clust/Label Image \n        {infile}: "; 
char	*i2_pstr = 
	"\nEnter: (i2) input Grey Level Image \n        {infile}: "; 
char	*o1_pstr = 
	"\nEnter: (o1) output Axis image \n        {outfile}: "; 
char	*o2_pstr = 
	"\nEnter: (o2) output outline image \n        {outfile}: "; 
char	*o3_pstr = 
	"\nEnter: (o3) output VIFF file \n        {outfile}: "; 
char	*f_pstr = 
	"\nEnter: (f) output ASCII file \n        {outfile}: "; 
char	*ms_pstr = 
	"\nEnter: (ms) if yes, compute standard moments \n        {boolean, (y/n)  [no] }: "; 
char	*mc_pstr = 
	"\nEnter: (mc) if yes, compute central moments \n        {boolean, (y/n)  [no] }: "; 
char	*mi_pstr = 
	"\nEnter: (mi) if yes, compute invariant moments \n        {boolean, (y/n)  [no] }: "; 
char	*mr_pstr = 
	"\nEnter: (mr) if no computes axis of bounded box \n        {boolean, (y/n)  [no] }: "; 
char	*col_pstr = 
	"\nEnter: (col) if no color = white, with black background \n        {boolean, (y/n)  [no] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vshape", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vshape.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vshape: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vshape.ans");
		}

	     }

	}

	/*
	 * allocate the vshape structure
	 */
	vshape = (vshape_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vshape_struct));

	/*
	 * get required mutually exclusive groups for vshape
	 */
	if (prompt_flag == TRUE)
	{
		   fprintf(stderr, "\nThe following prompts are mutually exclusive.\n");
		   fprintf(stderr, "\nHit <cr> until the desired prompt appears.\n");
	   ok = FALSE;
	   while(!ok)
	   {
		vshape->i1_flag = vget_infile(fid, prompt_flag,
		    "-i1", i1_pstr, &(vshape->i1_file))
;

    		if(!( (vshape->i1_flag)))
		    vshape->i2_flag = vget_infile(fid, prompt_flag,
		    "-i2", i2_pstr, &(vshape->i2_file))
;

		if((vshape->i1_flag)|| 
		    (vshape->i2_flag))
		    ok = TRUE;
		else
		{
		   fprintf(stderr, "Error: You MUST specify one of :\n");
		    fprintf(stderr, " -i1  -i2 \n");
		}
	   }
		   fprintf(stderr, "\n ------\n");
	}
	else
	{
		count = 0;
		if(vshape->i1_flag = vget_infile(fid, prompt_flag,
		    "-i1", i1_pstr, &(vshape->i1_file))
)
		    count++;

		if(vshape->i2_flag = vget_infile(fid, prompt_flag,
		    "-i2", i2_pstr, &(vshape->i2_file))
)
		    count++;

		if (count == 0)
		{
		    fprintf(stderr, "Error: You MUST specify one of :\n");
		    fprintf(stderr, " -i1  -i2 \n");
		    gw_usage();
		    exit(1);
		}

		else if (count > 1)
		{
		    fprintf(stderr, "Error: You may specify ONLY ONE of :\n");
		    fprintf(stderr, " -i1  -i2 \n");
		    gw_usage();
		    exit(1);
		}

	}

	/*
	 * get optional arguments for vshape
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vshape->o1_flag = vget_outfile(fid, prompt_flag,
	"-o1", o1_pstr, &(vshape->o1_file))
;

	vshape->o2_flag = vget_outfile(fid, prompt_flag,
	"-o2", o2_pstr, &(vshape->o2_file))
;

	vshape->o3_flag = vget_outfile(fid, prompt_flag,
	"-o3", o3_pstr, &(vshape->o3_file))
;

	vshape->f_flag = vget_outfile(fid, prompt_flag,
	"-f", f_pstr, &(vshape->f_file))
;

	vshape->ms_flag = vget_logic(fid, prompt_flag,
	"-ms", ms_pstr, &(vshape->ms_logic), 0);

	vshape->mc_flag = vget_logic(fid, prompt_flag,
	"-mc", mc_pstr, &(vshape->mc_logic), 0);

	vshape->mi_flag = vget_logic(fid, prompt_flag,
	"-mi", mi_pstr, &(vshape->mi_logic), 0);

	vshape->mr_flag = vget_logic(fid, prompt_flag,
	"-mr", mr_pstr, &(vshape->mr_logic), 0);

	vshape->col_flag = vget_logic(fid, prompt_flag,
	"-col", col_pstr, &(vshape->col_logic), 0);


}



