 /*
  * Khoros: $Id: lvlog.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvlog.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvlog.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvlog.c
 >>>>
 >>>>      Program Name: vlog
 >>>>
 >>>> Date Last Updated: Wed Mar 27 23:58:06 1991 
 >>>>
 >>>>          Routines: lvlog - the library call for vlog
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvlog - library call for vlog
*
* Purpose:
*    
*    Compute the logarithm of an image pixel  by  pixel  with  an
*    optional masking image.
*    
*    
* Input:
*    
*         1. img1 -- first xvimage strcuture
*         2. img2 -- gating mask image
*         3. mflg -- a flag set (equal 1) if gating image mask
*                    available
*         4. tflg -- a flag set to nonzero will perform
*                    logarithm of (x+1), else perform
*                    logarithm (x)
*         5. nflg -- a flag set to nonzero will perform
*                    logarithm base 10 (log10), else perform
*                    natural logarithm (ln).
*    
*         The inputs must be of the same data type and size.
*    
*    
* Output:
*    
*         1. img1 -- holds the result of the logorithm
*                    operation.  The output data
*                    type is the same as the input data
*                    type.
*    
*         img1 is used for both the input xvimage  structure  and  the
*         output  result  xvimage  structure.   This  is  done to save
*         space, but you must be careful not  to  overwrite  important
*         data.
*    
*    
*
* Written By: Scott Wilson
*    
*    27-Feb-91 Jeremy Worley added double precision handling.
*    
*    
****************************************************************/


/* -library_def */
int
lvlog(img1,img2,mflg,tflg,nflg)
struct xvimage *img1, *img2;
int  mflg,tflg,nflg;
/* -library_def_end */

/* -library_code */
{
    int   i,j,k;
    int   *i1,*i2;
    short *s1,*s2;
    float *f1,*f2;
    double *d1,*d2;
    unsigned char *c1,*c2;
    double   lg();

          /* Normal operation count */
    k = img1->row_size*img1->col_size * img1->num_data_bands;
    switch (img1->data_storage_type)
      {
        case VFF_TYP_BIT :
          fprintf(stderr,"lvlog: Don't know how to LOG a BIT image!\n");
          return(0);
          break;
        case VFF_TYP_1_BYTE : 
          c1 = (unsigned char *)(img1->imagedata);
          if (mflg) c2 = (unsigned char *)(img2->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++)
                {
                  if (tflg) i = lg(nflg,(double)(*c1)+1.0);
                  else i = lg(nflg,(double)(*c1));
                  if (i < 0) i = 0;
                  *c1++ = i;
                }
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*c2++)
                    {
                      if (tflg) i = lg(nflg,(double)(*c1)+1.0);
                      else i = lg(nflg,(double)(*c1));
                      if (i < 0) i=0;
                      *c1++ = i;
                    }
                  else c1++;
                }
            }
          break;
        case VFF_TYP_2_BYTE :
          s1 = (short *)(img1->imagedata);
          if (mflg) s2 = (short *)(img2->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++)
                {
                  if (tflg) *s1 = lg(nflg,(double)(*s1)+1.0);
                  else *s1 = lg(nflg,(double)(*s1));
                  s1++;
                }
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*s2++)
                    {
                      if (tflg) *s1 = lg(nflg,(double)(*s1)+1.0);
                      else *s1 = lg(nflg,(double)(*s1));
                      s1++;
                    }
                  else s1++;
                }
            }
          break;
        case VFF_TYP_4_BYTE :
          i1 = (int *)(img1->imagedata);
          if (mflg) i2 = (int *)(img2->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++)
                {
                  if (tflg) *i1 = lg(nflg,(double)(*i1)+1.0);
                  else *i1 = lg(nflg,(double)(*i1));
                  i1++;
                }
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*i2++)
                    {
                      if (tflg) *i1 = lg(nflg,(double)(*i1)+1.0);
                      else *i1 = lg(nflg,(double)(*i1));
                      i1++;
                    }
                  else i1++;
                }
            }
          break;
        case VFF_TYP_FLOAT :
          f1 = (float *)(img1->imagedata);
          if (mflg) f2 = (float *)(img2->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++)
                {
                  if (tflg) *f1 = lg(nflg,(double)(*f1)+1.0);
                  else *f1 = lg(nflg,(double)(*f1));
                  f1++;
                }
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*f2++)
                    {
                      if (tflg) *f1 = lg(nflg,(double)(*f1)+1.0);
                      else *f1 = lg(nflg,(double)(*f1));
                      f1++;
                    }
                  else f1++;
                }
            }
          break;
        case VFF_TYP_DOUBLE :
          d1 = (double *)(img1->imagedata);
          if (mflg) d2 = (double *)(img2->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++)
                {
                  if (tflg) *d1 = lg(nflg,(double)(*d1)+1.0);
                  else *d1 = lg(nflg,(double)(*d1));
                  d1++;
                }
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*d2++)
                    {
                      if (tflg) *d1 = lg(nflg,(double)(*d1)+1.0);
                      else *d1 = lg(nflg,(double)(*d1));
                      d1++;
                    }
                  else d1++;
                }
            }
          break;
        case VFF_TYP_COMPLEX :
        case VFF_TYP_DCOMPLEX :
          fprintf(stderr,"lvlog: Don't know how to LOG a COMPLEX image!\n");
          return(0);
          break;
        default:
          fprintf(stderr,"lvlog: Unknown data storage type, %d\n",img1->data_storage_type);
          return(0);
          break;
      }
      return(1);
}


double lg(i,x)
int i;
double x;
  {
    double y;
    if (x < 0.0) y = -XV_MAXFLOAT;
    else 
      {
        if (i) y = log10(x);      /* Log base 10 */
        else  y = log(x);         /* Natural log */
      }
    return(y);
 
 }
/* -library_code_end */
