 /*
  * Khoros: $Id: gw_lib.c,v 1.2 1991/07/15 05:58:56 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: gw_lib.c,v 1.2 1991/07/15 05:58:56 khoros Exp $";
#endif

 /*
  * $Log: gw_lib.c,v $
 * Revision 1.2  1991/07/15  05:58:56  khoros
 * HellPatch1
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "writer.h"

/************************************************************
*
*  Routine Name: gw_generate_lfile
*
*      Purpose: This routine creates the library file l*.c
*
*        Input: database -  pointer to the internal database struct
*               prog_spec-  pointer to the internal specification struct
*               name     -  name of the program being generated
*
*    Called by: lwriter()
*
*   Written By: Danielle Argiro
*
*************************************************************/

int  gw_generate_lfile(database, prog_spec, name, filename, type)
char **database;
char **prog_spec;
char *name;
char *filename;
char *type;
{
     FILE *file, *tmpfile;
     char  temp[MaxLength], resp;
     time_t clock;
     char **textlines, *textblock;
     char *copyright;
#include 	"gw_str.h"

    /*
     *  see if l*.c file already exists.  If so, prompt to over-write,
     *  return true if the answer is NO
     */
     if (!writer->force)
     {
       if (tmpfile = fopen(filename, "r"))
       {
         fprintf(stderr, "\nOverwrite file '%s'?  [y/n]: ", filename);
         fgets(temp, MaxLength, stdin);
         sscanf(temp, "%c", &resp);
         if ((resp != 'y') && (resp != 'Y')) return(true);
       }
     }

    /*
     *  create & open *.c file
     */
     if ((file = fopen(filename, "w"))== NULL)
     {
          fprintf(stderr, "\nghost_main:\n");
          fprintf(stderr, "  Could not create file '%s'\n", filename);
          return(false);
     }

    /*
     * begin l*.c file with RCS header
     */
     fprintf(file, " /*\n  * Khoros: %cId%c\n  */\n\n", '$','$');
     fprintf(file, "#if !defined(lint) && !defined(SABER)\n");
     fprintf(file, "static char rcsid[] = \"Khoros: %cId%c\";\n", '$','$');
     fprintf(file, "#endif\n\n");
     fprintf(file, " /*\n  * %cLog%c\n  */\n\n", '$','$');
      
    /*
     * follow RCS header with UNM copyright
     */
     copyright = gw_copyright("long");
     if (copyright == NULL) {
         fprintf (stderr, "error in gw_generate_lfile ");
         fprintf (stderr, "- could not print copyright\n");
     }
     else {
         fprintf(file, "%s\n", copyright);
     }

    /*
     *  add header for l.c file
     */
     fprintf(file, "%s", filehdr_top);
     fprintf(file, " >>>>\n%sl%s.c\n", filehdr_file, name);
     fprintf(file, " >>>>\n%s%s\n", filehdr_name, name);
     clock = (time_t) time(NULL);
     sprintf(temp, " >>>>\n%s%s", filehdr_date, ctime(&clock));
     temp[xvf_strlen(temp)-1] = '\0';
     fprintf(file, "%s \n", temp);
     fprintf(file, " >>>>\n%sl%s - the library call for %s\n", 
		   filehdr_mods, name, name);
     fprintf(file, " >>>>\n%s\n\n\n", filehdr_bottom);

    /*
     *  add in #includes
     */
     if ((strcmp(type, "prog") == 0) || (strcmp(type, "fprog") == 0))
        fprintf(file, "%s\n\n", includevin);
     else
        fprintf(file, "%s\n\n", includexvin);

     fprintf(file, "/* -library_includes */\n");
     if (xvf_strlen(prog_spec[LibraryIncludes]) > 0) 
	fprintf(file, "%s", prog_spec[LibraryIncludes]); 
     fprintf(file, "/* -library_includes_end */\n\n\n");

    /*
     *   put in header for main program
     */
     fprintf(file, "%s", comm_beg);
     fprintf(file, "*\n%s l%s - library call for %s\n",
		    comm_name, name, name);
     fprintf(file, "*\n%s\n",    comm_purp); 

	/* print -short_lib_description from .prog file */
     if (xvf_strlen(prog_spec[ShortLibDesc]) > 0) 
     {
        textlines = get_text_lines(prog_spec[ShortLibDesc], writer->format);
        textblock = add_gw_format(textlines, "*    "); 
	fprintf(file, "%s", textblock); 
	fprintf(file, "\n");
     }
     else fprintf(file, "*\n");

	/* print -library_input from .prog file */
     fprintf(file, "%s\n", comm_in);
     if (xvf_strlen(prog_spec[LibraryInput]) > 0) 
     {
        textlines = get_text_lines(prog_spec[LibraryInput], writer->format);
        textblock = add_gw_format(textlines, "*    "); 
	fprintf(file, "%s", textblock); 
	fprintf(file, "\n");
     }

	/* print -library_output from .prog file */
     fprintf(file, "%s\n", comm_out);
     if (xvf_strlen(prog_spec[LibraryOutput]) > 0) 
     {
        textlines = get_text_lines(prog_spec[LibraryOutput], writer->format);
        textblock = add_gw_format(textlines, "*    "); 
	fprintf(file, "%s", textblock); 
	fprintf(file, "\n");
     }

	/* print -authors from .prog file */
     if (xvf_strlen(prog_spec[Authors]) > 0) 
         fprintf(file, "*\n%s %s", comm_auth, prog_spec[Authors]);
     else
         fprintf(file, "%s\n*\n", comm_auth);

	/* print -modifications from .prog file */
     if (xvf_strlen(prog_spec[LibraryMods]) > 0) 
     {
        textlines = get_text_lines(prog_spec[LibraryMods], writer->format);
        textblock = add_gw_format(textlines, "*    "); 
	fprintf(file, "%s", textblock); 
	fprintf(file, "\n");
     }

     fprintf(file, "%s\n\n", comm_end);


    /*
     *   print out library definition
     */
     if (xvf_strlen(prog_spec[LibraryDef]) > 0)
     {
        fprintf(file, "/* -library_def */\n");
	fprintf(file, "%s", prog_spec[LibraryDef]); 
        fprintf(file, "/* -library_def_end */\n\n");
     }
     else
     {
        fprintf(file, "/* -library_def */\n");
        fprintf(file, "int l%s()\n", name);
        fprintf(file, "\n/* -library_def_end */\n");
     }

    /*
     *   print out library code
     */
     if (xvf_strlen(prog_spec[LibraryCode]) > 0)
     {
        fprintf(file, "/* -library_code */\n");
	fprintf(file, "%s", prog_spec[LibraryCode]); 
        fprintf(file, "/* -library_code_end */\n");
     }
     else
     {
        fprintf(file, "/* -library_code */\n");
        fprintf(file, "{\n   return(TRUE);\n}\n"); 
        fprintf(file, "/* -library_code_end */\n\n");
     }
     fclose(file);

     fprintf(stderr, "ghostwriter:  done generating '%s'\n", filename);
     return(true);

}
