 /*
  * Khoros: $Id: init.c,v 1.2 1991/07/15 06:00:58 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: init.c,v 1.2 1991/07/15 06:00:58 khoros Exp $";
#endif

 /*
  * $Log: init.c,v $
 * Revision 1.2  1991/07/15  06:00:58  khoros
 * HellPatch1
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "forms.h"
#include "jp.h"


/************************************************************
*
*  Routine Name: xvf_initialize(argc, argv, program_name)
*
*      Purpose:  Does initializations in preparation for the use of
*                xvforms.  Should be called before any calls to
*                xvf_read_database() or xvf_create_form(). Does the following:
*                    1) initializes the toolkit
*                    2) creates the application context
*                    3) opens the display
*
*        Input:  argc - number of command line arguments
*		 argv - command line arguments
*		 program - program name, or argv[0]
*
*       Output:  returns the DISPLAY on success and NULL on failure.
*                Note: if this routine fails, the application must
*                react appropriately (i.e., do not continue with calls
*                to xvforms, but exit from the program)
*
*
*    Called By:  application program
*
*   Written By:  Danielle Argiro
*
*************************************************************/

String fallback_resources[] = {
	"*input:		True",
	"*showGrip:		off",
	"*value*editType:	edit",
	NULL,
	};

static  xvf_def_fontnum = 10;
static  char *xvf_def_fonts[] =
{
          "fixed",
	  "8x13",
	  "8x13bold",
	  "7x13",
	  "7x13bold",
          "6x13",
          "courier.12",
          "-adobe-times-medium-r-normal--12*",
          "-adobe-times-bold-r-normal--12*",
          "variable"
};

Display *xvf_initialize(argc, argv, program_name)

unsigned int    argc;
char            *argv[];
char		*program_name;
{
	int	        i, fontflag;
   	XFontStruct	*fontstruct = NULL;
   	char 		*fontname, temp[512], *cmdfontname;
		

	/* 
	 *   *****  general initializations  *****
	 */
        int_scroll_list   = NULL;
        float_scroll_list = NULL;
	live_sel_list     = NULL;
	xvf_toplevels     = NULL;

	PROG_NAME = xvf_strcpy(program_name);

	fontflag = vget_string(-1, 0, "-fn", "noprompt", 
				  &cmdfontname, NULL); 

	/*
	 *  *****   Set up for use of X11R4 Toolkit & Athena Widgets  ****
	 */

	/*  initialize the toolkit */
        XtToolkitInitialize();

	/* create an application context */
	xvf_app_context = XtCreateApplicationContext();

	/* in case there was a problem creating application context,
           set fallback resources */
 	XtAppSetFallbackResources(xvf_app_context, fallback_resources);

	/*
	 *  Get the journal playback flags off the command line and then
	 *  consolidate the argument list.
	 */
	(void) vget_logic(-1, 0, "-jg", "noprompt", &jp_grab, 1);
	jp_playing = vget_infile(-1, 0, "-jp", "noprompt", &play_filename);
	jp_recording = vget_outfile(-1, 0, "-jr", "noprompt", &record_filename);
	consolidate_args();

	/*
	 * open the display
	 */
        display = XtOpenDisplay(xvf_app_context, NULL, PROG_NAME, PROG_NAME,
				NULL, (Cardinal) 0, (Cardinal) 
				 &ac, av);
        if (display == NULL)
        {
            fprintf(stderr, "\nxvf_initialize:\n");
            fprintf(stderr, "  Unable to open display...\n");
            return(NULL);
        } 

	/*
	 *  *****  Set up for using  a particular font  *****
	 */

	/* 
	 * First, look in the .Xdefaults file for a line specifying font, eg.
	 * "xvfshow.font: 8x16romankana"
	 */
   	 fontname = XGetDefault(display,PROG_NAME, "font");
   	 if (fontname != NULL)
         {
   	      fontstruct = XLoadQueryFont(display,fontname);
              if (fontstruct == NULL)
	      {
		  fprintf(stderr, "\n   Invalid font specification '-fn %s'\n", 
			  fontname);	
                  fprintf(stderr, "    found in .Xdefaults file\n");
              }
         }

	/*
         *  Next, see if the -fn command was provided on the command line, eg.
	 *  "-fn 8x16romankana" If it was, that font will override any font
	 *  specification in the .Xdefaults file.  If it wasn't the xvf_font
	 *  will already have been set correctly.
	 */
	if ((fontflag) && (cmdfontname != NULL))
        {
              fontstruct = XLoadQueryFont(display,cmdfontname);
              if (fontstruct == NULL)
	      {
		  fprintf(stderr, "\n   Invalid font specification '-fn %s'\n", 
			  cmdfontname);	
              }
        }

	/*
         *  if we still haven't got a font after trying both the .Xdefaults
         *  file and the [-fn] option on the command line, use a default font
         *  which (i hope!) will be defined on all X Servers.
         */
	if (fontstruct == NULL)
	{
	    /* try for one of the predefined fonts */
	    for (i = 0; i < xvf_def_fontnum; i++)
            {
                if ((fontstruct = XLoadQueryFont(display, 
		      xvf_def_fonts[i])) != NULL) 
		{
		   if (khoros_verbose == true)
		   {
		        fprintf(stderr, "\n   Since no font for %s",
		 	  	   	argv[0]);
		   	fprintf(stderr, " was found in your .Xdefaults file,\n");
		   	fprintf(stderr, "   and since the [-fn] option was not used to ");
		   	fprintf(stderr, "specify a valid font,\n   %s will be ", argv[0]);
		   	fprintf(stderr, "using the default font '%s'.\n", 
				   xvf_def_fonts[i]);
		   	fprintf(stderr, "   For a listing of other available fonts, use '%% xlsfonts'\n");
		   }
                   break;
		}

            }
	}

       /* 
	* if fontstruct is STILL unset, error out and prompt the user
	* to specify one 
        */

	if (fontstruct == NULL)
        {
            xvf_error_wait("Can't find any default fonts to use with the graphical user interface!  Please edit your .Xdefaults file and add a font specification for this application, or use the [-fn] option on the command line to specify your desired font.  Note that a listing of fonts available on your X server may be obtained using 'xlsfonts'.", "xvforms", NULL);
            return(display);
         }
	/*
	 *  otherwise, set the font width, font height, and font for forms
	 */
	 else
	 {
	     xvf_font_width  =     fontstruct->max_bounds.width  + 1;
             xvf_font_height =     fontstruct->max_bounds.ascent
                                   + fontstruct->max_bounds.descent + 2;
             xvf_font = fontstruct;
         }


	/*
         *  Now that we have taken everything we need for the forms off the
	 *  command line, AND X11 has gotten all its arguments too,
	 *  check to make sure that the user didn't specify any unknown 
	 *  arguments to the application or the X Toolkit.
	 */
	consolidate_args();
	if (argv[1] != NULL)
	{
	   i = 1;
	   temp[0] = '\0';
	   while (argv[i] != NULL)
	   {
	      (void) strcat(temp, argv[i++]);
	      (void) strcat(temp, " ");
	   }
	   fprintf(stderr, "\n%s: ERROR Invalid Arguments '%s'\n",argv[0],temp);
	   return(NULL);
	}

	/*
	 *  Initialize for journal record/playback
	 */
        jp_initialize();


	/*
	 *  Initialize the widget utilities.  Specifically the action and
	 *  translation tables.
	 */
	xvf_init_widgets();

        /*
         *  Initialize various pointers to be NULL 
	 *  and global variables to default values.
         */
        form_list = NULL;
	xvf_colormap = NULL;
	xvf_visual   = NULL;

        XVF_FILE_DIR   = NULL;
        XVF_ECHO_CMD   = true;
        XVF_EXPRESSION = false;
        return(display);
}

