/* @(#) zoomem.h 2.1 87/12/25 12:26:18 */

/*
The contents of this file are hereby released to the public domain.

                           -- Rahul Dhesi 1986/11/14

Defines parameters used for memory allocation.  

   Xenix notes:  Under Xenix release 3.0 on an Intel 310 machine with an
   80286 cpu, memory is very tight when the small memory model is used. 
   Ooz won't fit if the buffers are 2 K for input and 6 K for output.  
   It does fit if both input and output buffers are 1 K each.  Under
   the large memory model there is no problem.  Zoo requires the large
   memory model.

   AT&T 3B2:  There seem to be no problem at all.  Buffers can always
   be 8192 each.
*/

#ifdef OOZ
#define  IN_BUF_SIZE       8192
#define  OUT_BUF_SIZE      8192
#else
#define  IN_BUF_SIZE       8192
#define  OUT_BUF_SIZE      8192
#endif

#define  MEM_BLOCK_SIZE    (IN_BUF_SIZE + OUT_BUF_SIZE)

/* 
LIST_SIZE is the size of the list built by Zoo to hold all filenames
encountered in an archive.  This is used to know when to replace an
already existing file.  The date and time stored with the filename is
used in comparisons when an archive update has been requested.  To 
add a file to an archive, the archive must not already have more than
LIST_SIZE files in it.

ZOOCOUNT is the number of archive names that may be matched by the
archive filespec specified for a list.

MAXADD is the number of filenames that may be added to an archive
at one go.  The total number of files that an archive may contain
is not determined by MAXADD but is determined by LIST_SIZE.

If USE_MALLOC is defined it tells the memory allocation routine 
emalloc() not to bother with maintaining its own memory blocks but just to 
pass on requests to the library function malloc().  If USE_MALLOC is not 
defined, emalloc() does its own memory management to save overhead on a 
machine with limited memory.
*/

#ifdef   SMALL_MEM
#define  LIST_SIZE  (200)
#define  ZOOCOUNT   (30)
#define  MAXADD     (100)
#define  USE_MALLOC
#endif

#ifdef   MED_MEM
#define  LIST_SIZE  (400)
#define  ZOOCOUNT   (50)
#define  MAXADD     (200)
#define  USE_MALLOC
#endif

#ifdef   BIG_MEM
#define  LIST_SIZE  (4000)
#define  ZOOCOUNT   (400)
#define  MAXADD     (4000)
#define  USE_MALLOC
#endif

/* Customizable sizes */
#ifdef   SPEC_MEM
#define  LIST_SIZE   (600)
#define  ZOOCOUNT    (100)
#define  MAXADD      (400)
#endif

extern char *out_buf_adr;              /* global I/O buffer */
