/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.file;

import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Category;

class Configuration {
    private static final Category log = Category.getInstance(Configuration.class);
    private String resource;

    Configuration() {
        this.resource = "/jiapi.properties";
    }

    Configuration(String resource) {
        this.resource = resource;
    }

    boolean getBoolean(String key) {
        if (key == null) {
            return false;
        }
        Properties p = this.getProperties(this.resource);
        String s = p.getProperty(key);
        boolean b = false;
        try {
            b = Boolean.valueOf(s);
        }
        catch (Exception e) {
            // empty catch block
        }
        return b;
    }

    boolean getBoolean(String key, boolean dflt) {
        if (key == null) {
            return dflt;
        }
        Properties p = this.getProperties(this.resource);
        String s = p.getProperty(key);
        boolean b = dflt;
        try {
            b = Boolean.valueOf(s);
        }
        catch (Exception e) {
            // empty catch block
        }
        return b;
    }

    private Properties getProperties(String name) {
        Properties properties = new Properties();
        try {
            InputStream is = this.getClass().getResourceAsStream(name);
            if (is != null) {
                properties.load(is);
            } else {
                log.warn((Object)("Could not find resource: " + name));
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to get property file " + name + ", " + e));
        }
        return properties;
    }
}

