<?php
// Amortization Schedule Calculator
// ------------------------------------------------------------------------
// Copyright (c) 2005, Amortization-Calc.com
// ------------------------------------------------------------------------
// This file is part of "Amortization Schedule Calculator" software
// ------------------------------------------------------------------------

	include("includes/overall.inc.php");

	$param = get_request_var('param');

	if($param['action'] == 'calculate'){
		$param['principal'] = preg_replace('/[^0-9\.]/', '', $param['principal']);
		if($param['principal'] < $config['min_principal'] || $param['principal'] > $config['max_principal']) $err['principal'] = true;
		if($param['interest_rate'] < $config['min_interest_rate'] || $param['interest_rate'] > $config['max_interest_rate']) $err['interest_rate'] = true;
		if($param['start_year'] < $config['min_start_year'] || $param['start_year'] > $config['max_start_year']) $err['start_year'] = true;
		if($param['start_month'] < 1 || $param['start_month'] > 12) $err['start_month'] = true;
		if($param['term'] < $config['min_term'] || $param['term'] > $config['max_term']) $err['term'] = true;

		if(!isset($err)){
			$summary = loan_summary($param['principal'], $param['interest_rate'], $param['start_year'], $param['start_month'], $param['term'], $config['month_names'], $config['currency_char'], $config['decimals'], $config['dec_point'], $config['thousands_sep']);
   		$smarty->assign('summary', $summary);

			if($param['amort_schedule'] == 1){
				$yvals = amortization_array($param['principal'], $param['interest_rate'], $param['start_year'], $param['start_month'], $param['term'], 'Y', $config['month_names']);
				$yvals = format_numbers($yvals, $config['currency_char'], $config['decimals'], $config['dec_point'], $config['thousands_sep']);
				$smarty->assign('yvals', $yvals);
			} elseif($param['amort_schedule'] == 2){
				$mvals = amortization_array($param['principal'], $param['interest_rate'], $param['start_year'], $param['start_month'], $param['term'], 'M, Y', $config['month_names']);
				$mvals = format_numbers($mvals, $config['currency_char'], $config['decimals'], $config['dec_point'], $config['thousands_sep']);
				$smarty->assign('mvals', $mvals);
			}
		}
	}

  $smarty->assign('current_month', date('n'));
  $smarty->assign('current_year', date('Y'));
  $smarty->assign('years', range($config['min_start_year'], $config['max_start_year']));

	if(isset($err)) $smarty->assign('err', $err);
	$smarty->display('calculator.tpl');
?>
