////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Copyright 1999-2005, Hitek Software LLC
//http://www.sharewarejustice.com
//This source code is subject to change without any prior notice.  
//The source code is subject to a non-disclosure agreement. 
//No part of this source code may be reproduced, transmitted to other Shareware Developers or any other person, without the written permission of Hitek Software LLC.
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// CollectData.cpp: implementation of the CollectData class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "afxtempl.h"
#include "stdio.h"
#include "WinSock.h"
#include "Winbase.h"
#include "Windows.h"
#include "comdef.h"
#include "Tracker.h"
#include "CollectData.h"

#pragma comment(lib, "wsock32.lib")
#pragma comment(lib, "Kernel32.lib")

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

using namespace std;
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


CollectData::CollectData()
{

}

CollectData::~CollectData()
{

}

CString CollectData::GetParameterString(CString method,CString authorid,CString authorpwd,CString mode,CString program,CString version,CString key,CString key2)
{
	try
	{
		CList<CString,CString&> keys;
		CList<CString,CString&> values;
		//add required author data
		//if method = GET, authorid and authorpwd = "***"
		if (method=="GET")
		{
			keys.AddTail(CString("authorid")); values.AddTail(CString("***"));
			keys.AddTail(CString("authorpwd")); values.AddTail(CString("***"));
		}
		else //for POST mode, send in authorid and authorpwd
		{
			keys.AddTail(CString("authorid")); values.AddTail(authorid);
			keys.AddTail(CString("authorpwd")); values.AddTail(authorpwd);
		}
		keys.AddTail(CString("mode")); values.AddTail(mode);
		keys.AddTail(CString("program")); values.AddTail(program);
		keys.AddTail(CString("version")); values.AddTail(version);
		keys.AddTail(CString("key")); values.AddTail(key);
		keys.AddTail(CString("key2")); values.AddTail(key2);
		//add recommended data 
		//this should be noted in license agreement
		keys.AddTail(CString("owner")); values.AddTail(GetRegisteredOwner());
		keys.AddTail(CString("organization")); values.AddTail(GetRegisteredOrganization());
		keys.AddTail(CString("country")); values.AddTail(GetCountry());
		keys.AddTail(CString("userdate")); values.AddTail(GetUserdate());
		keys.AddTail(CString("timezone")); values.AddTail(GetTimezone());
		keys.AddTail(CString("ip_internal")); values.AddTail(GetIP());
		keys.AddTail(CString("computer")); values.AddTail(GetComputer());
		keys.AddTail(CString("username")); values.AddTail(GetUsername());
		keys.AddTail(CString("domain")); values.AddTail(GetDomain());
		keys.AddTail(CString("os")); values.AddTail(GetOS());
		//add optional data added by author from user collected input
		//for example from a user registration form
		keys.AddTail(CString("author1")); values.AddTail(CString(""));
		keys.AddTail(CString("author2")); values.AddTail(CString(""));
		keys.AddTail(CString("author3")); values.AddTail(CString(""));
		keys.AddTail(CString("author4")); values.AddTail(CString(""));
		keys.AddTail(CString("author5")); values.AddTail(CString(""));
		keys.AddTail(CString("author6")); values.AddTail(CString(""));
		keys.AddTail(CString("author7")); values.AddTail(CString(""));
		keys.AddTail(CString("author8")); values.AddTail(CString(""));
		keys.AddTail(CString("author9")); values.AddTail(CString(""));
		keys.AddTail(CString("author10")); values.AddTail(CString(""));
		//data that authors can collect from system
		//this information should be noted in license agreement
		keys.AddTail(CString("tracker1")); values.AddTail(CString(""));
		keys.AddTail(CString("tracker2")); values.AddTail(CString(""));
		keys.AddTail(CString("tracker3")); values.AddTail(CString(""));
		keys.AddTail(CString("tracker4")); values.AddTail(CString(""));
		keys.AddTail(CString("tracker5")); values.AddTail(CString(""));
		keys.AddTail(CString("tracker6")); values.AddTail(CString(""));
		keys.AddTail(CString("tracker7")); values.AddTail(CString(""));
		keys.AddTail(CString("tracker8")); values.AddTail(CString(""));
		keys.AddTail(CString("tracker9")); values.AddTail(CString(""));
		keys.AddTail(CString("tracker10")); values.AddTail(CString(""));
		//add feedback email 
		keys.AddHead(CString("fbEmail"));values.AddTail(CString("support@your_company.com"));

		CString parString = "";
		for (int i = 0; i < keys.GetCount(); i++)
		{
			POSITION pk = keys.FindIndex(i);
			POSITION pv = values.FindIndex(i);
			//very important to do this...
			CString encodedValue = URLEncode(values.GetAt(pv));
			parString += keys.GetAt(pk) + "=" + encodedValue + "&";
		}
		//remove trailing &
		parString = parString.Left(parString.GetLength() - 1);
		return parString;
	}
	catch(CException* e)
	{
		TCHAR szErr[1024];e->GetErrorMessage(szErr, 1024);
		cerr << szErr << endl;e->Delete();
		return "-";
	}
}

CString CollectData::GetRegisteredOwner(void)
{
	try
	{
		#define MY_BUFSIZE 32
		#define RTN_ERROR 13

		HKEY hOwnerKey;
		TCHAR val[MY_BUFSIZE];
		DWORD dwBufLen = MY_BUFSIZE;
		LONG lRet;

		if( RegOpenKeyEx(HKEY_LOCAL_MACHINE,TEXT("SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion"), 
			0, KEY_READ, &hOwnerKey ) != ERROR_SUCCESS )return RTN_ERROR;


		lRet = RegQueryValueEx( hOwnerKey, TEXT("RegisteredOwner"),NULL, 
					NULL,(LPBYTE)val,&dwBufLen);
		
		RegCloseKey( hOwnerKey );
		if(lRet != ERROR_SUCCESS) return RTN_ERROR;

		return CString(val);
	}
	catch(CException* e)
	{
		TCHAR szErr[1024];e->GetErrorMessage(szErr, 1024);
		cerr << szErr << endl;e->Delete();
		return "-";
	}
}

CString CollectData::GetRegisteredOrganization(void)
{
	try
	{ 
		#define MY_BUFSIZE 32
		#define RTN_ERROR 13

		HKEY hOwnerKey;
		TCHAR val[MY_BUFSIZE];
		DWORD dwBufLen = MY_BUFSIZE;
		LONG lRet;

		if( RegOpenKeyEx(HKEY_LOCAL_MACHINE,TEXT("SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion"), 
			0, KEY_READ, &hOwnerKey ) != ERROR_SUCCESS )return RTN_ERROR;


		lRet = RegQueryValueEx( hOwnerKey, TEXT("RegisteredOrganization"),NULL, 
					NULL,(LPBYTE)val,&dwBufLen);
		
		RegCloseKey( hOwnerKey );
		if(lRet != ERROR_SUCCESS) return RTN_ERROR;

		return CString(val);
	}
	catch(CException* e)
	{
		TCHAR szErr[1024];e->GetErrorMessage(szErr, 1024);
		cerr << szErr << endl;e->Delete();
		return "-";
	}
}

CString CollectData::GetUserdate(void)
{
	try
	{
		CTime now = CTime::GetCurrentTime();
		return now.Format("%c");
	}
	catch(CException* e)
	{
		TCHAR szErr[1024];e->GetErrorMessage(szErr, 1024);
		cerr << szErr << endl;e->Delete();
		return "-";
	}
}

CString CollectData::GetCountry(void)
{
	try
	{
		CString country = "";
        return country;	
	}
	catch(CException* e)
	{
		TCHAR szErr[1024];e->GetErrorMessage(szErr, 1024);
		cerr << szErr << endl;e->Delete();
		return "-";
	}
}

CString CollectData::GetTimezone(void)
{
	try
	{
		CTime now = CTime::GetCurrentTime();
		return now.Format("%Z");
	}
	catch(CException* e)
	{
		TCHAR szErr[1024];e->GetErrorMessage(szErr, 1024);
		cerr << szErr << endl;e->Delete();
		return "-";
	}
}

CString CollectData::GetComputer(void)
{
	try
	{	
		TCHAR name[1024];
		DWORD dwSize  = 1024;
		GetComputerName(name,&dwSize);
		CString computerName = (LPCTSTR)name;
		return computerName; 
	}
	catch(CException* e)
	{
		TCHAR szErr[1024];e->GetErrorMessage(szErr, 1024);
		cerr << szErr << endl;e->Delete();
		return "-";
	}
}

CString CollectData::GetUsername(void)
{
	try
	{
		TCHAR name[1024];
		DWORD dwSize  = 1024;
		GetUserName(name,&dwSize);
		CString username = (LPCTSTR)name;
		return username;
	}
	catch(CException* e)
	{
		TCHAR szErr[1024];e->GetErrorMessage(szErr, 1024);
		cerr << szErr << endl;e->Delete();
		return "-";
	}
}

CString CollectData::GetDomain(void)
{
	try
	{
		CString domain = "-";
		//use GetComputerNameEx(.....)
		return domain;
	}
	catch(CException* e)
	{
		TCHAR szErr[1024];e->GetErrorMessage(szErr, 1024);
		cerr << szErr << endl;e->Delete();
		return "-";
	}
}

CString CollectData::GetIP(void)
{
	try
	{
		CString ipAddress = "";
		WORD wVersionRequested;
		WSADATA wsaData;
		char name[255];
		PHOSTENT hostinfo;
		wVersionRequested = MAKEWORD( 1, 1 );
		char *ip;
		if ( WSAStartup( wVersionRequested, &wsaData ) == 0 )
		{
			if( gethostname ( name, sizeof(name)) == 0)
			{
				if((hostinfo = gethostbyname(name)) != NULL)
				{
					int nCount = 0;
					while(hostinfo->h_addr_list[nCount])
					{
						ip = inet_ntoa(*(struct in_addr *)hostinfo->h_addr_list[nCount]);
						printf("IP #%d: %s\n", ++nCount, ip);
						ipAddress = (LPCTSTR)ip;
					}
				}
			}
		}
		return ipAddress;	
	}
	catch(CException* e)
	{
		TCHAR szErr[1024];e->GetErrorMessage(szErr, 1024);
		cerr << szErr << endl;e->Delete();
		return "-";
	}
}

CString CollectData::GetOS(void)
{
	try
	{
		CString os = "-";
		return os;
	}
	catch(CException* e)
	{
		TCHAR szErr[1024];e->GetErrorMessage(szErr, 1024);
		cerr << szErr << endl;e->Delete();
		return "-";
	}
}

///URLEncode function is copied from source code listed below
///http://www.codeproject.com/string/urlencode.asp
CString CollectData::URLEncode(CString sIn)
{
    CString sOut;
	
    const int nLen = sIn.GetLength() + 1;

    register LPBYTE pOutTmp = NULL;
    LPBYTE pOutBuf = NULL;
    register LPBYTE pInTmp = NULL;
    LPBYTE pInBuf =(LPBYTE)sIn.GetBuffer(nLen);
    BYTE b = 0;
	
    //alloc out buffer
    pOutBuf = (LPBYTE)sOut.GetBuffer(nLen  * 3 - 2);//new BYTE [nLen  * 3];

    if(pOutBuf)
    {
        pInTmp	= pInBuf;
	pOutTmp = pOutBuf;
		
	// do encoding
	while (*pInTmp)
	{
	    if(isalnum(*pInTmp))
	        *pOutTmp++ = *pInTmp;
	    else
	        if(isspace(*pInTmp))
		    *pOutTmp++ = '+';
		else
		{
		    *pOutTmp++ = '%';
		    *pOutTmp++ = ToHex(*pInTmp>>4);
		    *pOutTmp++ = ToHex(*pInTmp%16);
		}
	    pInTmp++;
	}
	*pOutTmp = '\0';
	//sOut=pOutBuf;
	//delete [] pOutBuf;
	sOut.ReleaseBuffer();
    }
    sIn.ReleaseBuffer();
    return sOut;
}

TCHAR CollectData::ToHex(const BYTE &x)
{
	return x > 9 ? _T('A') + x-10: _T('0') + x;
}

