<?php

$SE_STATS_RES_NULL = array(
	'google' => 0,
	'yahoo' => 0,
	'msn' => 0,
	'aol' => 0,
	'altavista' => 0,
	'lycos' => 0
);


function db_select($sql)
{
	global $db;
	return $db->queryRows($sql);
}

function db_select_row($sql)
{
	$res = db_select($sql);
	if ($res === false) return false;
	return $res[0]; 
}
function get_common_stats($date)
{
	global $conf_db_pref;
	$sql = "
		SELECT 
			COUNT(*) AS hits, 
			COUNT(DISTINCT ipaddr) AS hosts, 
			COUNT(DISTINCT visitor_id) as visitors  
		FROM {$conf_db_pref}hits 
		WHERE hitdate LIKE '{$date}%'";
	
	return db_select_row($sql);
}


function get_detailed_stats($date)
{
	global $conf_db_pref, $id_tosengine, $SE_STATS_RES_NULL;
	$sql ="SELECT p.page_id, s.searcher, count(s.searcher) as cnt
		FROM {$conf_db_pref}hits h, {$conf_db_pref}searches s, {$conf_db_pref}pages p 
		WHERE s.hit_id=h.hit_id AND p.page_id=h.page_id AND h.hitdate LIKE '{$date}%'
		GROUP BY s.searcher, p.page_id
		ORDER BY p.page_id";
	
	$se_res = db_select($sql);
	if ($se_res === false) return false;
	$se_page_stas = array();
	foreach ($se_res as $row) 
	{
		$page_id = $row['page_id'];
		if (!isset($se_page_stas[$page_id]))
		{
			$se_page_stas[$page_id] = $SE_STATS_RES_NULL;
		}
		
		$se_name = $id_tosengine[$row['searcher']];
		$se_page_stas[$page_id][$se_name] = $row['cnt'];
	}
	
	
	
	$sql = "SELECT p.page_id, p.url, COUNT(h.hit_id) AS hits, COUNT(DISTINCT h.visitor_id) AS visitors, SUM(h.page_loaded) AS loads
		FROM {$conf_db_pref}hits h, {$conf_db_pref}pages p 
		WHERE h.page_id=p.page_id AND h.hitdate LIKE '{$date}%'
		GROUP BY h.page_id
		ORDER BY hits DESC";
	
	$pages_res = db_select($sql);
	if ($pages_res === false) return false;
	
	$result = array();
	foreach ($pages_res as $row) 
	{
		$row['loads'] = sprintf("%.2f", $row['loads']/$row['hits']*100);
		$page_id = $row['page_id'];
		$result[$page_id] = $row;
		if (isset($se_page_stas[$page_id]))
		{
			$result[$page_id]['searches'] = $se_page_stas[$page_id];
		}
		else 
		{
			$result[$page_id]['searches'] = $SE_STATS_RES_NULL;
		}
		
	}
	return $result;
}

function get_query_stats($engine, $page_id, $date)
{
	global $conf_db_pref;
	$sql ="SELECT p.url, s.query, COUNT(s.hit_id) AS cnt
		FROM {$conf_db_pref}hits h, {$conf_db_pref}pages p, {$conf_db_pref}searches s
		WHERE h.hit_id=s.hit_id AND h.page_id=p.page_id AND p.page_id=$page_id AND s.searcher=$engine AND h.hitdate LIKE '{$date}%' 
		GROUP BY s.query
		ORDER BY cnt DESC";
	$query_res = db_select($sql);
	if ($query_res === false) return false;
	if (count($query_res) == 0) return null;
	$result['url'] = $query_res[0]['url'];
	$result['queries'] = $query_res;
	return $result;
}


function get_page_hits($url, $date)
{
	
	global $db, $conf_db_pref;
	
	$page_ch_summ = md5($url);//TODO: maybe crc32 ?

	$sql = "SELECT page_id FROM {$conf_db_pref}pages WHERE ch_summ = '$page_ch_summ' LIMIT 1";
	if (!$db->query($sql)) 
	{
		die($db->getMessage());
	}
	
	$id = $db->queryResultRowField('page_id');
	if ($id == null) return 1;
	
	$sql = "SELECT COUNT(*) AS cnt FROM {$conf_db_pref}hits WHERE page_id=$id AND hitdate LIKE '{$date}%'";
	
	if (!$db->query($sql)) 
	{
		die($db->getMessage());
	}
	return $db->queryResultRowField('cnt');
}

?>
