<?php

require_once("DB.php");

class Database {
	var $type;
	var $host;
	var $user;
	var $pass;
	var $dbname;
	
	var $db;
	var $message;
	
	function Database($type, $host, $user, $pass, $dbname) {
		$this->type = $type;
		$this->host = $host;
		$this->user = $user;
		$this->pass = $pass;
		$this->dbname = $dbname;
	}
	
	function getMessage() {
		return $this->message;
	}
	
	function connect() {		
		$dsn = "$this->type://$this->user:$this->pass@$this->host/$this->dbname";
		$this->db =& DB::connect($dsn);
		if (PEAR::isError($this->db)) {
			$this->message = $this->db->getMessage();
			return false;
		}
		return true;
	}
	
	function query($sql)
	{
		$this->db_res = $this->db->query($sql);
		if (PEAR::isError($this->db_res)) {
			$this->message = $this->db_res->getMessage();
			return false;
		}
		return true;
	}
	
	function queryResultRow()
	{
		if ($this->db_res->fetchInto($row, DB_FETCHMODE_ASSOC))
		{
			return $row;
		}
		return null;
	}
	
	function queryResultRowField($name)
	{
		if ($this->db_res->fetchInto($row, DB_FETCHMODE_ASSOC))
		{
			return $row[$name];
		}
		return null;
	}
	
	function queryRows($sql)
	{
		if (!Database::query($sql))
		{
			return false;
		}
		$rcArr = array();
		while ($this->db_res->fetchInto($row, DB_FETCHMODE_ASSOC)) 
		{
    		$rcArr[] = $row;
		}
		return $rcArr;
	}
}
?>