package com.softviewtech.jbillboard;

import java.awt.*;
import javax.swing.*;
import com.borland.jbcl.layout.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;

/**
 * Title:        JBillboard
 * Description:  The builder for billboard applets.
 * Copyright:    Copyright (c) 2002
 * Company:      SoftView Technology
 * @author J.Y. Weng
 * @version 1.0
 */

public class DlgInputSN extends JDialog {
    JPanel panel1 = new JPanel();
    XYLayout xYLayout1 = new XYLayout();
    JTextField txtSN = new JTextField();
    JButton btnContinue = new JButton();
    JButton btnBrowser0 = new JButton();
    JLabel lblSN = new JLabel();
    JTextArea txtTrial = new JTextArea();
    JButton btnSN = new JButton();

    private boolean lairt=true;

    public DlgInputSN(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            jbInit();
            pack();
        }
        catch(Exception ex) {
            ex.printStackTrace();
        }
    }

    public DlgInputSN() {
        this(null, "", true);
    }
    void jbInit() throws Exception {
        panel1.setLayout(xYLayout1);
        panel1.setPreferredSize(new Dimension(400, 305));
        btnContinue.setNextFocusableComponent(this);
        btnContinue.setText("Continue");
        btnContinue.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnContinue_actionPerformed(e);
            }
        });
        btnBrowser0.setText("Register now");
        btnBrowser0.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnBrowser0_actionPerformed(e);
            }
        });
        lblSN.setRequestFocusEnabled(false);
        lblSN.setText("Input Serical Number:");
        txtTrial.setRequestFocusEnabled(false);
        txtTrial.setText("This is a trial version of JBillboard. There \n"+
                         "will be a JBillboard ad appear in the banner \n" +
                         "created by this version. To remove the ad by \n"+
                         "registering:");
        txtTrial.setEditable(false);
        txtTrial.setBackground(SystemColor.scrollbar);
        btnSN.setText("Enter");
        btnSN.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnSN_actionPerformed(e);
            }
        });
        btnSN.setVisible(false);
        txtSN.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(KeyEvent e) {
                txtSN_keyReleased(e);
            }
        });
        getContentPane().add(panel1);
        panel1.add(btnBrowser0, new XYConstraints(127, 100, 139, 25));
        panel1.add(txtTrial, new XYConstraints(39, 26, -1, -1));
        panel1.add(btnContinue, new XYConstraints(138, 242, 116, 25));
        panel1.add(txtSN, new XYConstraints(127, 170, 139, -1));
        panel1.add(lblSN, new XYConstraints(40, 148, -1, -1));
        panel1.add(btnSN, new XYConstraints(275, 168, 73, 25));

        btnContinue.requestFocus();
    }



    void btnBrowser0_actionPerformed(ActionEvent e) {
        BrowserControl.displayURL(
            "http://www.softviewtech.com/software/jbillboard");
    }

    void txtSN_keyReleased(KeyEvent e) {
        String str=txtSN.getText();
        if(!btnSN.isVisible()) {
            btnSN.requestFocus();
            txtSN.requestFocus();
        }
        if(str!=null && str.length()!=0)
            btnSN.setVisible(true);
        else
            btnSN.setVisible(false);

    }

    void btnSN_actionPerformed(ActionEvent e) {
        if(svt(txtSN.getText())) {
            lairt=false;
            setVisible(false);
            dispose();
            JOptionPane.showMessageDialog(this,
                    "JBillboard has been upgrated to registered version.");
        }
        else {
            JOptionPane.showMessageDialog(this,
                                            "Invalid Serial Numer. Try again.");
        }
    }
    void btnContinue_actionPerformed(ActionEvent e) {
        setVisible(false);
        dispose();
    }

    public boolean getLairt() {
        return lairt;
    }

    private boolean svt(String str) {
        // similar to the svt() in the class Frame1
        long s=0;
        try {
            s=Long.parseLong(str);
        }
        catch(NumberFormatException ex) {
            return false;
        }
        Random rdm=new Random(19900719);

        // range !!!
        for(int i=0; i<100; i++) {
            if((rdm.nextLong()&9999999999L)==s) {
                // save the sn inot the file of sn.txt
                try {
                    File f=new File("sn.txt");
                    FileWriter w=new FileWriter(f);
                    w.write(str);
                    w.flush();
                    w.close();
                }
                catch(IOException ex) {

                    ex.printStackTrace();
                }
                return true;
            }
        }
        return false;
    }


}