
{*******************************************************}
{                                                       }
{       ScaleRichView                                   }
{       The given component represents TPaintBox for    }
{       work with ScaleRichView, signatures of such kind}
{       are used on headings of the majority of windows.}
{                                                       }
{       Copyright (c) Ilya Zelenskiy                    }
{       Ilya.Zelenskiy@gmail.com                        }
{       http://www.trichview.com                        }
{                                                       }
{*******************************************************}

unit SRVPaintBox;

interface
{$I RV_Defs.inc}
uses
  Windows, Messages, Forms, Graphics, Controls, Classes, SRVControl;

type
  TSRVPaintBox = class(TSRVCanvasControl)
  private
  protected
  public
    constructor Create(AOwner: TComponent); override;
  published
    property Anchors;
    property Align;
    property Caption;
    property DrawOnPrint;
    property Font;
    property Height default 50;
    property Hint;
    property Enabled;
    property PopupMenu;
    property ShowHint;
    property Visible;
    property Width default 50;
    property OnClick;
    {$IFDEF RICHVIEWDEF5}
    property OnContextPopup;
    {$ENDIF}
    property OnDblClick;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('SRichView', [TSRVPaintBox]);
end;

constructor TSRVPaintBox.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Height := 50;
  Width := 50;
end;

end.
