
{*******************************************************}
{                                                       }
{       ScaleRichView                                   }
{       The given component represents TLabel for work  }
{       with ScaleRichView, signatures of such kind are }
{       used on headings of the majority of windows.    }
{                                                       }
{       Copyright (c) Ilya Zelenskiy                    }
{       Ilya.Zelenskiy@gmail.com                        }
{       http://www.trichview.com                        }
{                                                       }
{*******************************************************}

unit SRVLabel;

interface
{$I RV_Defs.inc}
uses
  Windows, Messages, Forms, Graphics, Controls, Classes, SRVControl;

type
  TSRVLabel = class(TSRVGraphicControl)
  private
  protected
  public
    constructor Create(AOwner: TComponent); override;
    procedure Invalidate; override;
    procedure PaintTo(DC : THandle; X, Y : Integer); override;
  published
    property Anchors;
    property Align;
    property AutoSize;
    property Caption;
    property Alignment;
    property DrawOnPrint;
    property Font;
    property ForegroundColor;
    property BackgroundColor;
    property Offset;
    property Height default 14;
    property Hint;
    property Enabled;
    property PopupMenu;
    property ShowHint;
    property Visible;
    property Width default 47;
    property OnClick;
    {$IFDEF RICHVIEWDEF5}
    property OnContextPopup;
    {$ENDIF}
    property OnDblClick;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('SRichView', [TSRVLabel]);
end;

constructor TSRVLabel.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Height := 14;
  Width := 47;
end;

procedure TSRVLabel.Invalidate;
begin
  if Parent = nil then exit;
  Realign;

  PaintTo(Canvas.handle, 0, 0);
end;

procedure TSRVLabel.PaintTo(DC : THandle; X, Y : Integer);
var
     Rector: TRect;
     Canvas: TCanvas;
     Flag: LongInt;
begin
  Canvas := TCanvas.Create;

  try
    Canvas.Handle := DC;
    Rector := GetClientRect;
    OffsetRect(Rector, X, Y);

    Canvas.Brush.Style := bsClear;
    Flag := Alignments[Alignment];
    Canvas.Font := Font;
    Canvas.Font.Color := BackgroundColor;
    Rector.Top := Rector.Top+Offset;
    Rector.Left := Rector.Left+Offset;
    DrawText(Canvas.handle, PChar(Caption), Length(Caption), Rector, Flag);
    Canvas.Font.Color := ForegroundColor;

    Rector := GetClientRect;
    OffsetRect(Rector, X, Y);
    Case Alignment of
      taCenter:
        begin
          Rector.Left := Rector.Left - (Offset div 2);
          Rector.Right := Rector.Right - (Offset div 2);
        end;
      taRightJustify:
        begin
          Rector.Left := Rector.Left - Offset;
          Rector.Right := Rector.Right - Offset;
        end;
    end;
    DrawText(Canvas.handle, PChar(Caption), Length(Caption), Rector, Flag);

  finally
    Canvas.Handle := 0;
    Canvas.Free;
  end;
end;

end.
