unit Demo6Frm;

interface
{$I RV_Defs.inc}
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, RVScroll, RichView, ExtCtrls,
  {$IFDEF RICHVIEWDEF4}
  ImgList,
  {$ENDIF}
  RVStyle, SclRView;

type
  TfrmDemo6 = class(TForm)
    rvs: TRVStyle;
    tmr: TTimer;
    il: TImageList;
    srv: TSRichViewEdit;
    procedure FormCreate(Sender: TObject);
    procedure tmrTimer(Sender: TObject);
  private
    { Private declarations }
    Red: Byte;
    DRed: Shortint;
    ImageIndex: Integer;
  public
    { Public declarations }
  end;

var
  frmDemo6: TfrmDemo6;

implementation

{$R *.DFM}

procedure TfrmDemo6.FormCreate(Sender: TObject);
const crlf:String = chr(13)+chr(10);
begin
  ImageIndex := 0;
  Red  := 150;
  DRed := 5;
  srv.SetMargin(0, 0, 0, 0);
  rvs.TextStyles[rvsHeading].Color := RGB(Red,0,0);
  srv.RichViewEdit.TopMargin := srv.Height;
  srv.RichViewEdit.BottomMargin := srv.Height;

  srv.RichViewEdit.Clear;
  srv.RichViewEdit.AddBulletEx('',0,il,1);
  srv.RichViewEdit.Add('Credits Demo', 1);
  srv.RichViewEdit.AddTextNL(
        'Roberto Nelson'+crlf+
        'Bruce Young'+crlf+
        'Kim Lambert'+crlf+
        'Leslie Johnson'+crlf+
        'Phil Forest'+crlf+
        'K.J. Weston'+crlf+
        'Lee Terry'+crlf+
        'Stewart Hall'+crlf+
        'Katherine Young'+crlf+
        'Chris Papadopulos'+crlf+
        'Pete Fisher'+crlf+
        'Ann Bennet'+crlf+
        'Roger De Sousa'+crlf+
        'Janet Boldwin'+crlf+
        'Roger Reeves'+crlf+
        'Willie Stansbury'+crlf+
        'Leslie Phong'+crlf+
        'Ashok Ramanathan',0,0,0);
  srv.RichViewEdit.AddNL('and other people from Employee.db',2,0);
  srv.RichViewEdit.VSmallStep := 1;
  srv.RichViewEdit.Format;
end;

procedure TfrmDemo6.tmrTimer(Sender: TObject);
begin
   if srv.VScrollPos<>srv.VMaxScrollPos then
     srv.VScrollPos := srv.VScrollPos+1
   else
     srv.VScrollPos := 0;
   inc(Red, DRed);
   rvs.TextStyles[rvsHeading].Color := RGB(Red,0,0);
   if (Red=255) or (Red=100) then DRed := -DRed;
   inc(ImageIndex);
   if ImageIndex=il.Count then
     ImageIndex := 0;
   srv.RichViewEdit.SetBulletInfo(0,'',ImageIndex,nil,0);
end;

end.
