{
This demo shows how to:
- define pages positions;
- change page zooming;
- create groups defining Z-order of pages.

In the free positioning mode, in OnGetPagePos event, you can change value of DefaultPageOrder parameter
(by default it has the same value as the prior page) to create groups of pages.

There are 2 groups of pages in this demo:
1) the group of clicked pages; it contains only one page chosen in  OnClickPage event;
2) the group containing the rest of pages.
We assign higher Z-order priority for the clicked page, so it is displayed above all other pages.
}

unit MFMenuPages;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, RVScroll, RVEdit, ExtCtrls, SclRView, RVStyle, Menus, Ruler, RVRuler,
  SclRVRuler, StdCtrls, Printers, ComCtrls, ToolWin, Buttons, SRVToolBar,
  ImgList, CRVFData, SRVToolWindow, RVTable, RVMisc;

type
  TFMenuPages = class(TForm)
    Panel1: TPanel;
    Panel3: TPanel;
    SclRVRuler1: TSclRVRuler;
    Panel4: TPanel;
    Panel5: TPanel;
    SRichViewEdit1: TSRichViewEdit;
    SclRVRuler2: TSclRVRuler;
    RVRulerItemSelector1: TRVRulerItemSelector;
    procedure FormCreate(Sender: TObject);
    procedure SRichViewEdit1ClickPage(Sender: TSRichViewEdit;
      Button: TMouseButton; Shift: TShiftState; X, Y, PageNo: Integer);
    procedure SRichViewEdit1GetPagePos(Sender: TSRichViewEdit; PageNo,
      StartItemNo, EndItemNo, OffsetInStartItem, StartTableRow,
      EndTableRow: Integer; var Position: TPoint; var ZoomPercent: Single;
      var ZOrder: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
    ClickedPageNo : Integer;
  end;

var FMenuPages: TFMenuPages;


implementation

uses Math;

{$R *.dfm}

procedure ShowInfo(const msg,cpt: String);
begin
  Application.MessageBox(PChar(msg),PChar(cpt),MB_OK or MB_ICONINFORMATION);
end;
{------------------------------------------------------------------------------}
procedure TFMenuPages.FormCreate(Sender: TObject);
begin
  ClickedPageNo := -1;
  SRichViewEdit1.RichViewEdit.ReadOnly := True;
  SRichViewEdit1.RichViewEdit.Options := SRichViewEdit1.RichViewEdit.Options - [rvoAllowSelection];
  SRichViewEdit1.LoadRVF(ExtractFilePath(Application.ExeName)+'Menu.rvf');
  SRichViewEdit1.ViewProperty.ZoomPercent := 25;
  SRichViewEdit1.PageProperty.PageFormat := srvfmA6;

  SRichViewEdit1.SetMargin(10, 50, 10, 10);
  SRichViewEdit1.CalculateAllPagePositions;
end;
{------------------------------------------------------------------------------}
procedure TFMenuPages.SRichViewEdit1GetPagePos(Sender: TSRichViewEdit;
  PageNo, StartItemNo, EndItemNo, OffsetInStartItem, StartTableRow,
  EndTableRow: Integer; var Position: TPoint; var ZoomPercent: Single;
  var ZOrder: Integer);
begin
  ZoomPercent := 25;
  Position.X := 10 + ((PageNo - 1) mod 4) * (Round(SRichViewEdit1.PageWidth100Pix * ZoomPercent * 0.01) + 30);;
  Position.Y := 10 + ((PageNo - 1) div 4) * (Round(SRichViewEdit1.PageHeight100Pix * ZoomPercent * 0.01) + 10);
  if PageNo = ClickedPageNo then
    begin
      ZoomPercent := 50;
      ZOrder := PageNo;
    end;
end;
{------------------------------------------------------------------------------}
procedure TFMenuPages.SRichViewEdit1ClickPage(Sender: TSRichViewEdit;
  Button: TMouseButton; Shift: TShiftState; X, Y, PageNo: Integer);
var
     tmp : Integer;
begin
  tmp := ClickedPageNo;
  if ClickedPageNo = PageNo then
    ClickedPageNo := -1
  else
    ClickedPageNo := PageNo;
  SRichViewEdit1.CalculatePagePosition(tmp);
  SRichViewEdit1.CalculatePagePosition(ClickedPageNo);
  SRichViewEdit1.Update;
end;

end.
