{****************************************************************************
This example shows how to use SetVariable and GetVariable for data
exchange between Delphi and Flash.

Based on the book
"Flash and Delphi ", Varibrus O.A., Odessa, November, 2006
****************************************************************************}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, OleCtrls, ShockwaveFlashObjects_TLB, ExtCtrls, StdCtrls,
  SclRView, RVStyle;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Button1: TButton;
    Edit1: TEdit;
    ComboBox1: TComboBox;
    Button2: TButton;
    Panel1: TPanel;
    SRichViewEdit1: TSRichViewEdit;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  ShockwaveFlash1 : TShockwaveFlash;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  ShockwaveFlash1 := TShockwaveFlash.Create(nil);
  SRichViewEdit1.RichViewEdit.InsertControl('teste', ShockwaveFlash1, rvvaMiddle);
  ShockwaveFlash1.Movie := ExtractFilePath(Application.ExeName) + 'DelphiToFlash.swf';
  Label3.Caption :=  ShockwaveFlash1.GetVariable ('DelphiText.borderColor');
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  ShockwaveFlash1.SetVariable ('DelphiVarText', StringToOleStr(Edit1.Text));
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
  ShockwaveFlash1.SetVariable ('DelphiText.borderColor', StringToOleStr(ComboBox1.Text));
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  Label3.Caption := ShockwaveFlash1.GetVariable ('DelphiText.borderColor');
  Label3.Font.Color := StrToIntDef(Label3.Caption, 0)
end;

initialization
  RegisterClass(TShockwaveFlash);

end.
