
{*******************************************************}
{                                                       }
{       RichView                                        }
{       function LoadCSV                                }
{       loads CSV and tab-separated files in table      }
{                                                       }
{       Copyright (c) Sergey Tkachenko                  }
{       svt@trichview.com                               }
{       http://www.trichview.com                        }
{                                                       }
{*******************************************************}


unit rvcsv;

interface
uses SysUtils, RichView, RVTable, RVTypes;

{
  Parameters:
    FileName - file to load.
    rv - richview or richviewedit where you plan to insert loaded table.
    Separator - character used to separate values.
      Most common possible values:
      ',' (comma)
      ';' (semicolon)
      ' ' (space)
      #9  (tab)
    UseQuotes - if True, double-quotes are used to allow separators inside
      text values (in the input file);
      double double-quotes are treated as double-quote character.
    TextStyleNo, ParaNo - styles of text and paragraph used to add text
      in cells.
  Return value:
    loaded table; nil in case of failure.
}

function LoadCSV(const FileName: String; rv: TCustomRichView;
  Separator: TRVAnsiChar; UseQuotes: Boolean;
  TextStyleNo, ParaNo: Integer): TRVTableItemInfo;

implementation

function LoadCSV(const FileName: String; rv: TCustomRichView;
  Separator: TRVAnsiChar; UseQuotes: Boolean;
  TextStyleNo, ParaNo: Integer): TRVTableItemInfo;
var F: TextFile;
    s, line: TRVAnsiString;
    i, j, r, c: Integer;
    quote, prevquote,added: Boolean;
    {...............................................}
    procedure AddCell(table: TRVTableItemInfo);
    begin
      if table.Rows[0].Count<=c then
        table.InsertCols(table.Rows[0].Count, 1, -1);
      table.Cells[r,c].Clear;
      table.Cells[r,c].AddNLATag(line, TextStyleNo, ParaNo, 0);
      inc(c);
      line := '';
    end;
    {...............................................}
begin
  Result := nil;
  try
    AssignFile(F, FileName);
    Reset(F);
    try
      Result := TRVTableItemInfo.CreateEx(0,0, rv.RVData);
      r := 0;
      while not EOF(F) do begin
        Readln(F, s);
        if s='' then
          break;
        Result.InsertRows(Result.Rows.Count, 1, -1);
        c := 0;
        line := '';
        j := 1;
        added := False;
        prevquote := False;
        quote := False;
        for i := 1 to Length(s) do begin
          added := False;
          case s[i] of
            '"':
              begin
                if not UseQuotes then
                  continue;
                line := line + Copy(s, j, i-j);
                j := i+1;
                if prevquote then
                  line := line+'"';
                prevquote := not prevquote;
              end;
            else
              begin
                if prevquote then begin
                  prevquote := False;
                  quote := not quote;
                end;
                if not quote and (Separator=s[i]) then begin
                  line := line + Copy(s, j, i-j);
                  j := i+1;
                  AddCell(Result);
                end;
              end;
          end;
        end;
        if not added then begin
          line := line + Copy(s, j, Length(s)+1-j);
          AddCell(Result);
        end;
        inc(r);
      end;
    finally
      if (Result.Rows.Count=0) or (Result.Rows[0].Count=0) then begin
        Result.Free;
        Result := nil;
      end;
      CloseFile(F);
    end;
  except
    Result.Free;
    Result := nil;
  end;
end;

end.
