{*******************************************************}
{                                                       }
{       RichViewActions                                 }
{       Dialog for table and cell borders               }
{                                                       }
{       Copyright (c) Sergey Tkachenko                  }
{       svt@trichview.com                               }
{       http://www.trichview.com                        }
{                                                       }
{*******************************************************}


unit TableBrdrRVFrm;

interface

{$I RichViewActions.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, BaseRVFrm,
  {$IFDEF USERVKSDEVTE}
  te_controls,
  {$ENDIF}
  {$IFDEF USERVTNT}
  TntStdCtrls,
  {$ENDIF}      
  Dialogs, RVOfficeRadioBtn, ImgList, StdCtrls, RVColorCombo, RVTable, RVALocalize;

type
  TfrmRVTableBrdr = class(TfrmRVBase)
    gbTableBorder: TGroupBox;
    lblTableBorderColor: TLabel;
    lblTableBorderWidth: TLabel;
    lblTableBorderLightColor: TLabel;
    cmbBorderColor: TRVColorCombo;
    cmbBorderWidth: TComboBox;
    cmbBorderLightColor: TRVColorCombo;
    ImageList1: TImageList;
    rgBorderType: TRVOfficeRadioGroup;
    btnOk: TButton;
    btnCancel: TButton;
    procedure cmbBorderWidthDrawItem(Control: TWinControl;
      Index: Integer; Rect: TRect; State: TOwnerDrawState);
    procedure cmbBorderColorColorChange(Sender: TObject);
    procedure rgBorderTypeClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure cmbBorderWidthChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    Updating: Boolean;
  protected
    _cmbBorderWidth, _lblTableBorderColor, _lblTableBorderLightColor: TControl;  
    {$IFDEF RVASKINNED}
    procedure OnCreateThemedControl(OldControl, NewControl: TControl); override;
    {$ENDIF}
    {$IFDEF USERVKSDEVTE}
    procedure tecmbWidthDrawItem(Control: TWinControl; Canvas: TCanvas; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    {$ENDIF}
  public
    { Public declarations }
    ColorDialog: TColorDialog;
    procedure SetData(BorderStyle: TRVTableBorderStyle; ColorL, ColorD: TColor;
                      BorderWidth: Integer);
    procedure GetData(var BorderStyle: TRVTableBorderStyle; var ColorL, ColorD: TColor;
                      var BorderWidth: Integer);
    procedure Localize; override;
  end;

implementation
uses RichViewActions;
{$R *.dfm}

procedure TfrmRVTableBrdr.FormCreate(Sender: TObject);
begin
  _cmbBorderWidth := cmbBorderWidth;
  _lblTableBorderColor := lblTableBorderColor;
  _lblTableBorderLightColor := lblTableBorderLightColor;
  inherited;
end;

procedure TfrmRVTableBrdr.SetData(BorderStyle: TRVTableBorderStyle; ColorL,
  ColorD: TColor; BorderWidth: Integer);
begin
  if BorderStyle in [rvtbRaised, rvtbLowered] then begin
    cmbBorderColor.ChosenColor := cmbBorderColor.AutoColor;
    cmbBorderLightColor.ChosenColor := cmbBorderLightColor.AutoColor;
    end
  else begin
    cmbBorderColor.ChosenColor := ColorD;
    cmbBorderLightColor.ChosenColor := ColorL;
  end;
  if BorderWidth<=0 then begin
    rgBorderType.ItemIndex := 0;
    end
  else begin
    if BorderWidth-1<GetXBoxItemCount(_cmbBorderWidth) then
      SetXBoxItemIndex(_cmbBorderWidth, BorderWidth-1);
    case BorderStyle of
      rvtbLowered, rvtbLoweredColor:
        rgBorderType.ItemIndex := 1;
      rvtbRaised, rvtbRaisedColor:
        rgBorderType.ItemIndex := 2;
      rvtbColor:
        rgBorderType.ItemIndex := 3;
    end;
  end;
end;

procedure TfrmRVTableBrdr.GetData(var BorderStyle: TRVTableBorderStyle;
  var ColorL, ColorD: TColor; var BorderWidth: Integer);
begin
  if rgBorderType.ItemIndex=0 then begin
    BorderWidth := 0
    end
  else begin
    if GetXBoxItemIndex(_cmbBorderWidth)>=0 then
      BorderWidth := GetXBoxItemIndex(_cmbBorderWidth)+1;
    if BorderWidth=0 then
      BorderWidth := 1;
    case rgBorderType.ItemIndex of
      1:
        begin
          if (cmbBorderColor.ChosenColor=cmbBorderColor.AutoColor) and
             (cmbBorderLightColor.ChosenColor=cmbBorderLightColor.AutoColor) then
            BorderStyle := rvtbLowered
          else begin
            BorderStyle := rvtbLoweredColor;
            ColorL := cmbBorderLightColor.ChosenColor;
            ColorD := cmbBorderColor.ChosenColor;
          end;
        end;
      2:
        begin
          if (cmbBorderColor.ChosenColor=cmbBorderColor.AutoColor) and
             (cmbBorderLightColor.ChosenColor=cmbBorderLightColor.AutoColor) then
            BorderStyle := rvtbRaised
          else begin
            BorderStyle := rvtbRaisedColor;
            ColorL := cmbBorderLightColor.ChosenColor;
            ColorD := cmbBorderColor.ChosenColor;
          end;
        end;
      3:
        begin
          BorderStyle := rvtbColor;
          ColorD := cmbBorderColor.ChosenColor;
        end;
    end;
  end;
end;

procedure TfrmRVTableBrdr.cmbBorderColorColorChange(Sender: TObject);
begin
  if not Visible then
    exit;
  _cmbBorderWidth.Invalidate;
  if rgBorderType.ItemIndex<1 then
    rgBorderType.ItemIndex := 1;
end;

procedure TfrmRVTableBrdr.rgBorderTypeClick(Sender: TObject);
begin
  if not Visible or Updating then
    exit;
  Updating := True;
  try
    if rgBorderType.ItemIndex=0 then
      SetXBoxItemIndex(_cmbBorderWidth, -1)
    else if GetXBoxItemIndex(_cmbBorderWidth)<0 then
      SetXBoxItemIndex(_cmbBorderWidth, 0);
    if rgBorderType.ItemIndex=3 then begin
      SetControlCaption(_lblTableBorderColor, RVA_GetS(rvam_tb_Color));
      _lblTableBorderLightColor.Visible := False;
      cmbBorderLightColor.Visible := False;
      end
    else begin
      SetControlCaption(_lblTableBorderColor, RVA_GetS(rvam_tb_ShadowColor));
      _lblTableBorderLightColor.Visible := True;
      cmbBorderLightColor.Visible := True;
    end;
    _cmbBorderWidth.Invalidate;
  finally
    Updating := False;
  end;
end;

procedure TfrmRVTableBrdr.FormActivate(Sender: TObject);
begin
  inherited;
  cmbBorderColor.ColorDialog := ColorDialog;
  cmbBorderLightColor.ColorDialog := ColorDialog;
  rgBorderTypeClick(Sender);
end;


procedure TfrmRVTableBrdr.cmbBorderWidthChange(Sender: TObject);
begin
  if not Visible then
    exit;
  if not Updating and (rgBorderType.ItemIndex<1) then
    rgBorderType.ItemIndex := 1;
end;

procedure TfrmRVTableBrdr.Localize;
begin
  inherited;
  btnOk.Caption := RVA_GetS(rvam_btn_OK);
  btnCancel.Caption := RVA_GetS(rvam_btn_Cancel);
  Caption := {$IFDEF USERVTNT}_GetWideString{$ENDIF}(RVA_GetS(rvam_tb_Title));
  gbTableBorder.Caption := RVA_GetSH(rvam_tb_Settings);
  lblTableBorderColor.Caption := RVA_GetS(rvam_tb_Color);
  lblTableBorderLightColor.Caption := RVA_GetS(rvam_tb_LightColor);
  lblTableBorderWidth.Caption := RVA_GetS(rvam_tb_Width);
  rgBorderType.Caption := RVA_GetS(rvam_tb_BorderType);
  rgBorderType.Items[0].Caption := RVA_GetS(rvam_tb_BTNone);
  rgBorderType.Items[1].Caption := RVA_GetS(rvam_tb_BTSunken);
  rgBorderType.Items[2].Caption := RVA_GetS(rvam_tb_BTRaised);
  rgBorderType.Items[3].Caption := RVA_GetS(rvam_tb_BTFlat);
end;

procedure TfrmRVTableBrdr.cmbBorderWidthDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
var c1, c2: TColor;
begin
  case rgBorderType.ItemIndex of
    0,3:
      begin
        c1 := cmbBorderColor.ChosenColor;
        c2 := c1;
      end;
    1:
      begin
        c1 := cmbBorderColor.ChosenColor;
        c2 := cmbBorderLightColor.ChosenColor;
      end;
    else
      begin
        c2 := cmbBorderColor.ChosenColor;
        c1 := cmbBorderLightColor.ChosenColor;
      end;
  end;
  {$IFDEF USERVTNT}
  RVA_DrawCmbWidthItem2(TTntComboBox(_cmbBorderWidth).Canvas, Rect, Index, c1, c2, State);
  {$ELSE}
  RVA_DrawCmbWidthItem2(TComboBox(_cmbBorderWidth).Canvas, Rect, Index, c1, c2, State);
  {$ENDIF}
end;

{$IFDEF USERVKSDEVTE}
procedure TfrmRVTableBrdr.tecmbWidthDrawItem(Control: TWinControl;
  Canvas: TCanvas; Index: Integer; Rect: TRect; State: TOwnerDrawState);
var c1, c2: TColor;
begin
  case rgBorderType.ItemIndex of
    0,3:
      begin
        c1 := cmbBorderColor.ChosenColor;
        c2 := c1;
      end;
    1:
      begin
        c1 := cmbBorderColor.ChosenColor;
        c2 := cmbBorderLightColor.ChosenColor;
      end;
    else
      begin
        c2 := cmbBorderColor.ChosenColor;
        c1 := cmbBorderLightColor.ChosenColor;
      end;
  end;
  RVA_DrawCmbWidthItem2(Canvas, Rect, Index, c1, c2, State);
end;
{$ENDIF}

{$IFDEF RVASKINNED}
procedure TfrmRVTableBrdr.OnCreateThemedControl(OldControl,
  NewControl: TControl);
begin
  if OldControl = _cmbBorderWidth then begin
    _cmbBorderWidth := NewControl;
    {$IFDEF USERVKSDEVTE}
    TTeComboBox(_cmbBorderWidth).OnDrawItem := tecmbWidthDrawItem;
    {$ENDIF}
    end
  else if OldControl=_lblTableBorderColor then
    _lblTableBorderColor := NewControl
  else if OldControl=_lblTableBorderLightColor then
    _lblTableBorderLightColor := NewControl
end;
{$ENDIF}


end.
