unit RVALocRuler;

interface

uses RVRuler, RVALocalize;

procedure RVALocalizeRuler(Ruler: TRVRuler);

implementation

procedure RVALocalizeRuler(Ruler: TRVRuler);
begin
  with Ruler.RulerTexts do begin
    HintColumnMove := RVA_GetS(rvam_ruler_ColumnMove);
    HintRowMove := RVA_GetS(rvam_ruler_RowMove);
    HintIndentFirst := RVA_GetS(rvam_ruler_FirstIndent);
    HintIndentLeft := RVA_GetS(rvam_ruler_LeftIndent);
    HintIndentHanging := RVA_GetS(rvam_ruler_HangingIndent);
    HintIndentRight := RVA_GetS(rvam_ruler_RightIndent);

    HintLevelDec := RVA_GetS(rvam_ruler_listlevel_Dec); // moves left = Promote One Level
    HintLevelInc := RVA_GetS(rvam_ruler_listlevel_Inc); // moves right = Demote One Level

    HintMarginBottom := RVA_GetS(rvam_ruler_MarginBottom);
    HintMarginLeft := RVA_GetS(rvam_ruler_MarginLeft);
    HintMarginRight := RVA_GetS(rvam_ruler_MarginRight);
    HintMarginTop := RVA_GetS(rvam_ruler_MarginTop);

    HintTabLeft := RVA_GetS(rvam_ruler_tab_Left);
    HintTabCenter := RVA_GetS(rvam_ruler_tab_Center);
    HintTabRight := RVA_GetS(rvam_ruler_tab_Right);
    HintTabDecimal := '-'; // RVA_GetS(rvam_ruler_tab_Decimal);
    HintTabWordBar := '-'; // RVA_GetS(rvam_ruler_tab_WordBar);

    MenuTabLeft := RVA_GetS(rvam_ruler_tab_Left);
    MenuTabCenter := RVA_GetS(rvam_ruler_tab_Center);
    MenuTabRight := RVA_GetS(rvam_ruler_tab_Right);
    MenuTabDecimal := '-'; // RVA_GetS(rvam_ruler_tab_Decimal);
    MenuTabWordBar := '-'; // RVA_GetS(rvam_ruler_tab_WordBar);
  end;
end;

end.
