
{*******************************************************}
{                                                       }
{       RichViewActions                                 }
{       Dialog for displaying menu                      }
{                                                       }
{       Copyright (c) Sergey Tkachenko                  }
{       svt@trichview.com                               }
{       http://www.trichview.com                        }
{                                                       }
{*******************************************************}

unit ListRVFrm;

interface

{$I RV_Defs.inc}
{$I RichViewActions.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  {$IFDEF USERVTNT}
  TntStdCtrls,
  {$ENDIF}
  Dialogs, BaseRVFrm, StdCtrls, Clipbrd, RVALocalize;

type
  TfrmRVList = class(TfrmRVBase)
    btnOk: TButton;
    btnCancel: TButton;
    lst: TListBox;
    lbl: TLabel;
    procedure lstDblClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  protected
    {$IFDEF RVASKINNED}
    procedure OnCreateThemedControl(OldControl, NewControl: TControl); override;
    {$ENDIF}  
  public
    { Public declarations }
    _btnOk, _btnCancel, _lbl: TControl;
    _lst: TControl;
    procedure InitPasteAs(const RVFCaption: String);
    procedure Localize; override;
  end;

implementation
uses RVStr, RichViewActions;

{$R *.dfm}

{ TfrmRVList }

procedure TfrmRVList.InitPasteAs(const RVFCaption: String);

  procedure AddFormat(Format: Integer; const Caption: String; id: Integer);
  begin
    if Clipboard.HasFormat(Format) then
      XBoxItemsAddObject(_lst, Caption, TObject(id));
  end;

begin
  SetControlCaption(_lbl, RVA_GetS(rvam_ps_Label));
  {$IFDEF USERVKSDEVTE}
  tef.Caption := RVA_GetS(rvam_ps_Title);
  {$ELSE}
  Caption := RVA_GetS(rvam_ps_Title);
  {$ENDIF}
  ClearXBoxItems(_lst);
  AddFormat(RegisterClipboardFormat(RVFormatName), RVFCaption, 1);
  AddFormat(RegisterClipboardFormat(RTFormatName), RVA_GetS(rvam_ps_RTF), 2) ;
  {$IFDEF USERVHTML}
  if RVA_RVHTML<>nil then
    AddFormat(RegisterClipboardFormat(HTMLFormatName), RVA_GetS(rvam_ps_HTML), 7) ;
  {$ENDIF}
  AddFormat(CF_TEXT, RVA_GetS(rvam_ps_Text), 3);
  AddFormat(CF_UNICODETEXT, RVA_GetS(rvam_ps_UnicodeText), 4);
  AddFormat(CF_BITMAP, RVA_GetS(rvam_ps_BMP), 5);
  AddFormat(CF_METAFILEPICT, RVA_GetS(rvam_ps_WMF), 6);
  AddFormat(CF_HDROP, RVA_GetS(rvam_ps_GraphicFiles), 8);
  if GetXBoxItemCount(_lst)>0 then
    SetXBoxItemIndex(_lst, 0);
  HelpContext := 91300;
end;

procedure TfrmRVList.Localize;
begin
  inherited;
  btnOk.Caption := RVA_GetS(rvam_btn_OK);
  btnCancel.Caption := RVA_GetS(rvam_btn_Cancel);
end;

procedure TfrmRVList.lstDblClick(Sender: TObject);
begin
  ModalResult := mrOk;
end;

{$IFDEF RVASKINNED}
procedure TfrmRVList.OnCreateThemedControl(OldControl,
  NewControl: TControl);
begin
  if OldControl = _btnOk then
    _btnOk := NewControl
  else if OldControl = _btnCancel then
    _btnCancel := NewControl
  else if OldControl = _lst then
    _lst := NewControl
  else if OldControl = lbl then
    _lbl := NewControl;
end;
{$ENDIF}

procedure TfrmRVList.FormCreate(Sender: TObject);
begin
  _btnOk := btnOk;
  _btnCancel := btnCancel;
  _lst := lst;
  _lbl := lbl;
  inherited;
end;

end.
