
{*******************************************************}
{                                                       }
{       RichViewActions                                 }
{       Insert-table dialog                             }
{                                                       }
{       Copyright (c) 2002-2003, Sergey Tkachenko       }
{       svt@trichview.com                               }
{       http://www.trichview.com                        }
{                                                       }
{*******************************************************}

unit InsTableRVFrm;

interface

{$I RichViewActions.inc}

uses
  Windows, Messages, SysUtils,
  Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, BaseRVFrm, Buttons, RVSpinEdit, RVALocalize;

type
  TfrmInsTable = class(TfrmRVBase)
    gbSize: TGroupBox;
    lblnCols: TLabel;
    lblnRows: TLabel;
    cbRemember: TCheckBox;
    btnOk: TButton;
    btnCancel: TButton;
    seColumns: TRVSpinEdit;
    seRows: TRVSpinEdit;
    gbLayout: TGroupBox;
    rbFitContents: TRadioButton;
    rbFitWindow: TRadioButton;
    rbFitManual: TRadioButton;
    seWidth: TRVSpinEdit;
    cmbWidthType: TComboBox;
    procedure rbFitManualClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    _rbFitContents, _rbFitWindow, _rbFitManual,
    _cmbWidthType: TControl;
    function GetBestWidth: integer;
    function GetColumns: integer;
    function GetRows: integer;
    procedure SetBestWidth(const Value: integer);
    procedure SetColumns(const Value: integer);
    procedure SetRows(const Value: integer);
    procedure CheckEnabled;
  protected
    {$IFDEF RVASKINNED}
    procedure OnCreateThemedControl(OldControl, NewControl: TControl); override;
    {$ENDIF}
  public
    { Public declarations }
    _cbRemember: TControl;
    procedure Localize; override;
    property Columns: integer read GetColumns write SetColumns;
    property Rows: integer read GetRows write SetRows;
    property BestWidth: integer read GetBestWidth write SetBestWidth;
  end;

implementation

{$R *.dfm}

{ TInsTable }

procedure TfrmInsTable.CheckEnabled;
begin
  seWidth.Enabled := GetRadioButtonChecked(_rbFitManual);
  _cmbWidthType.Enabled := GetRadioButtonChecked(_rbFitManual);
end;

function TfrmInsTable.GetBestWidth: integer;
begin
  if GetRadioButtonChecked(_rbFitContents) then
    result := 0
  else if GetRadioButtonChecked(_rbFitWindow) then
    result := -100
  else begin
    if GetXBoxItemIndex(_cmbWidthType) = 0 then
      result := -seWidth.AsInteger
    else
      result := seWidth.AsInteger;
  end;
  if Result<-100 then
    Result := -1;
end;

function TfrmInsTable.GetColumns: integer;
begin
  result := seColumns.AsInteger;
end;

function TfrmInsTable.GetRows: integer;
begin
  result := seRows.AsInteger;
end;

procedure TfrmInsTable.SetBestWidth(const Value: integer);
begin
  if Value = 0 then
    SetRadioButtonChecked(_rbFitContents, True)
  else if Value = -100 then
    SetRadioButtonChecked(_rbFitWindow, True)
  else begin
    SetRadioButtonChecked(_rbFitManual, True);
    seWidth.Value := abs(Value);
    if Value > 0 then
      SetXBoxItemIndex(_cmbWidthType, 1)
    else
      SetXBoxItemIndex(_cmbWidthType, 0);
  end;
end;

procedure TfrmInsTable.SetColumns(const Value: integer);
begin
  seColumns.Value := Value;
end;

procedure TfrmInsTable.SetRows(const Value: integer);
begin
  seRows.Value := Value;
end;

procedure TfrmInsTable.rbFitManualClick(Sender: TObject);
begin
  CheckEnabled;
end;

procedure TfrmInsTable.FormCreate(Sender: TObject);
begin
  _rbFitContents := rbFitContents;
  _rbFitWindow := rbFitWindow;
  _rbFitManual := rbFitManual;
  _cbRemember := cbRemember;
  _cmbWidthType := cmbWidthType;
  inherited;
  SetXBoxItemIndex(_cmbWidthType, 0);
  CheckEnabled;
end;

procedure TfrmInsTable.Localize;
begin
  inherited;
  btnOk.Caption := RVA_GetS(rvam_btn_OK);
  btnCancel.Caption := RVA_GetS(rvam_btn_Cancel);
  Caption := {$IFDEF USERVTNT}_GetWideString{$ENDIF}(RVA_GetS(rvam_it_Title));
  gbSize.Caption := RVA_GetSH(rvam_it_TableSize);
  lblnCols.Caption := RVA_GetS(rvam_it_nCols);
  lblnRows.Caption := RVA_GetS(rvam_it_nRows);
  gbLayout.Caption := RVA_GetSH(rvam_it_TableLayout);
  rbFitContents.Caption := RVA_GetS(rvam_it_Autosize);
  rbFitWindow.Caption := RVA_GetS(rvam_it_Fit);
  rbFitManual.Caption := RVA_GetS(rvam_it_Manual);
  cbRemember.Caption := RVA_GetS(rvam_it_Remember);
  cmbWidthType.Items[0] := RVA_GetS(rvam_Percents);
  cmbWidthType.Items[1] := RVA_GetS(rvam_Pixels);
end;

{$IFDEF RVASKINNED}
procedure TfrmInsTable.OnCreateThemedControl(OldControl,
  NewControl: TControl);
begin
  if OldControl = _rbFitContents then
    _rbFitContents := NewControl
  else if OldControl= _rbFitWindow then
    _rbFitWindow := NewControl
  else if OldControl= _rbFitManual then
    _rbFitManual := NewControl
  else if OldControl= _cbRemember then
    _cbRemember := NewControl
  else if OldControl = _cmbWidthType then
    _cmbWidthType := NewControl;
end;
{$ENDIF}

end.
