// CodeGear C++Builder
// Copyright (c) 1995, 2007 by CodeGear
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Rvtable.pas' rev: 11.00

#ifndef RvtableHPP
#define RvtableHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <Sysutils.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Forms.hpp>	// Pascal unit
#include <Rvclasses.hpp>	// Pascal unit
#include <Rvitem.hpp>	// Pascal unit
#include <Rvdatalist.hpp>	// Pascal unit
#include <Crvdata.hpp>	// Pascal unit
#include <Crvfdata.hpp>	// Pascal unit
#include <Rvstyle.hpp>	// Pascal unit
#include <Rvfuncs.hpp>	// Pascal unit
#include <Rvrvdata.hpp>	// Pascal unit
#include <Rvervdata.hpp>	// Pascal unit
#include <Dlines.hpp>	// Pascal unit
#include <Rvback.hpp>	// Pascal unit
#include <Rvmarker.hpp>	// Pascal unit
#include <Rvseqitem.hpp>	// Pascal unit
#include <Rvnote.hpp>	// Pascal unit
#include <Rvscroll.hpp>	// Pascal unit
#include <Richview.hpp>	// Pascal unit
#include <Rvedit.hpp>	// Pascal unit
#include <Rvfmisc.hpp>	// Pascal unit
#include <Ptblrv.hpp>	// Pascal unit
#include <Ptrvdata.hpp>	// Pascal unit
#include <Typinfo.hpp>	// Pascal unit
#include <Rvuni.hpp>	// Pascal unit
#include <Rvundo.hpp>	// Pascal unit
#include <Rvstr.hpp>	// Pascal unit
#include <Rvtypes.hpp>	// Pascal unit
#include <Rvctrldata.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Rvtable
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TRVCellHAlign { rvcLeft, rvcCenter, rvcRight };
#pragma option pop

#pragma option push -b-
enum TRVCellVAlign { rvcTop, rvcMiddle, rvcBottom, rvcVDefault };
#pragma option pop

#pragma option push -b-
enum TRVTableOption { rvtoEditing, rvtoRowSizing, rvtoColSizing, rvtoRowSelect, rvtoColSelect, rvtoNoCellSelect, rvtoRTFSaveCellPixelBestWidth, rvtoRTFAllowAutofit, rvtoHideGridLines, rvtoOverlappingCorners, rvtoCellBelowBorders, rvtoIgnoreContentWidth, rvtoIgnoreContentHeight };
#pragma option pop

typedef Set<TRVTableOption, rvtoEditing, rvtoIgnoreContentHeight>  TRVTableOptions;

#pragma option push -b-
enum TRVTablePrintOption { rvtoHalftoneBorders, rvtoRowsSplit, rvtoWhiteBackground };
#pragma option pop

typedef Set<TRVTablePrintOption, rvtoHalftoneBorders, rvtoWhiteBackground>  TRVTablePrintOptions;

#pragma option push -b-
enum TRVTableBorderStyle { rvtbRaised, rvtbLowered, rvtbColor, rvtbRaisedColor, rvtbLoweredColor };
#pragma option pop

typedef int TRVHTMLLength;

class DELPHICLASS TRVTableItemInfo;
typedef void __fastcall (__closure *TRVCellEditingEvent)(TRVTableItemInfo* Sender, int Row, int Col, bool Automatic, bool &AllowEdit);

typedef void __fastcall (__closure *TRVCellEndEditEvent)(TRVTableItemInfo* Sender, int Row, int Col, bool Clearing);

class DELPHICLASS TRVTableCellData;
class DELPHICLASS TRVTableRow;
class PASCALIMPLEMENTATION TRVTableCellData : public Rvdatalist::TRVItemFormattedData 
{
	typedef Rvdatalist::TRVItemFormattedData inherited;
	
private:
	Graphics::TColor FColor;
	TRVCellVAlign FVAlign;
	TRVHTMLLength FBestWidth;
	int FBestHeight;
	int FRowSpan;
	int FColSpan;
	int FLeft;
	int FTop;
	int FWidth;
	int FHeight;
	Rvstyle::TRVBooleanRect* FVisibleBorders;
	Crvfdata::TCustomRVFormattedData* FChosenRVData;
	Rvitem::TCustomRVItemInfo* FChosenItem;
	Rvundo::TRVUndoInfo* ContainerUndoItem;
	Graphics::TColor FBorderColor;
	Graphics::TColor FBorderLightColor;
	Rvback::TRVBackground* FBackground;
	AnsiString FBackgroundImageFileName;
	AnsiString FHint;
	void __fastcall SetBestHeight(const int Value);
	void __fastcall SetBestWidth(const TRVHTMLLength Value);
	void __fastcall SetVisibleBorders(const Rvstyle::TRVBooleanRect* Value);
	bool __fastcall CanClear(void);
	void __fastcall SetColor(const Graphics::TColor Value);
	Graphics::TGraphic* __fastcall GetBackgroundImage(void);
	Rvstyle::TRVItemBackgroundStyle __fastcall GetBackgroundStyle(void);
	void __fastcall SetBackgroundImage_(const Graphics::TGraphic* Value, bool Copy);
	void __fastcall SetBackgroundImage(const Graphics::TGraphic* Value);
	void __fastcall SetBackgroundStyle(const Rvstyle::TRVItemBackgroundStyle Value);
	void __fastcall BackgroundImageWriter(Classes::TStream* Stream);
	void __fastcall BackgroundImageReader(Classes::TStream* Stream);
	bool __fastcall StoreVisibleBorders(void);
	
protected:
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	void __fastcall AssignSizeFrom(TRVTableCellData* Cell);
	TRVCellVAlign __fastcall GetRealVAlign(void);
	DYNAMIC bool __fastcall SupportsPageBreaks(void);
	virtual Rvscroll::TRVOptions __fastcall GetOptions(void);
	DYNAMIC void __fastcall DataWriter(Classes::TStream* Stream);
	
public:
	virtual void __fastcall GetItemBackground(int ItemNo, const Types::TRect &r, bool MakeImageRect, Graphics::TColor &Color, Graphics::TBitmap* &bmp, bool &UseBitmap);
	DYNAMIC void __fastcall ResetSubCoords(void);
	virtual Rvback::TRVBackground* __fastcall GetBackground(void);
	int __fastcall GetExtraVOffs(void);
	bool __fastcall IsTransparent(void);
	DYNAMIC void __fastcall GetParentInfo(int &ParentItemNo, Rvitem::TRVStoreSubRVData* &Location);
	TRVTableItemInfo* __fastcall GetTable(void);
	DYNAMIC AnsiString __fastcall GetItemHint(Crvdata::TCustomRVData* RVData, int ItemNo, const AnsiString UpperRVDataHint);
	void __fastcall AssignAttributesFrom(TRVTableCellData* Cell, bool IncludeSize, int DivColSpan, int DivRowSpan);
	DYNAMIC void __fastcall Deselect(Rvitem::TCustomRVItemInfo* NewPartiallySelected, bool MakeEvent);
	DYNAMIC Controls::TWinControl* __fastcall GetEditor(void);
	virtual void __fastcall GetOrigin(int &ALeft, int &ATop);
	DYNAMIC void __fastcall GetOriginEx(int &ALeft, int &ATop);
	virtual int __fastcall GetWidth(void);
	virtual int __fastcall GetHeight(void);
	virtual Graphics::TColor __fastcall GetColor(void);
	virtual int __fastcall GetHOffs(void);
	virtual int __fastcall GetVOffs(void);
	virtual int __fastcall GetAreaWidth(void);
	DYNAMIC void __fastcall AssignChosenRVData(Crvfdata::TCustomRVFormattedData* RVData, Rvitem::TCustomRVItemInfo* Item);
	DYNAMIC void __fastcall UnassignChosenRVData(Crvdata::TCustomRVData* RVData);
	DYNAMIC Crvdata::TCustomRVData* __fastcall GetChosenRVData(void);
	DYNAMIC Rvitem::TCustomRVItemInfo* __fastcall GetChosenItem(void);
	void __fastcall MovingToUndoList(Rvundo::TRVUndoInfo* AContainerUndoItem);
	void __fastcall MovingFromUndoList(void);
	int __fastcall GetCellHeight(bool IgnoreContentHeight);
	int __fastcall GetMinWidth(Rvstyle::PRVScreenAndDevice sad, Graphics::TCanvas* Canvas);
	bool __fastcall HasData(bool CheckStyles);
	virtual Crvdata::TCustomRVData* __fastcall GetRVData(void);
	DYNAMIC void __fastcall DoSelect(void);
	DYNAMIC void __fastcall ControlAction(Crvdata::TCustomRVData* RVData, Rvstyle::TRVControlAction ControlAction, int ItemNo, Rvitem::TCustomRVItemInfo* Item);
	DYNAMIC void __fastcall ControlAction2(Crvdata::TCustomRVData* RVData, Rvstyle::TRVControlAction ControlAction, int ItemNo, Controls::TControl* &Control);
	virtual void __fastcall ItemAction(Rvstyle::TRVItemAction ItemAction, Rvitem::TCustomRVItemInfo* Item, AnsiString &Text, Crvdata::TCustomRVData* RVData);
	DYNAMIC void __fastcall AdjustFocus(int NewFocusedItemNo, Classes::TPersistent* TopLevelRVData, int TopLevelItemNo);
	__fastcall TRVTableCellData(TRVTableRow* ARow);
	__fastcall virtual ~TRVTableCellData(void);
	DYNAMIC Rvmarker::TRVMarkerList* __fastcall GetMarkers(bool AllowCreate);
	DYNAMIC Rvseqitem::TRVSeqList* __fastcall GetSeqList(bool AllowCreate);
	DYNAMIC Crvdata::TCustomRVData* __fastcall Edit(void);
	__property int Left = {read=FLeft, nodefault};
	__property int Top = {read=FTop, nodefault};
	__property int Height = {read=FHeight, nodefault};
	__property int Width = {read=FWidth, nodefault};
	__property int ColSpan = {read=FColSpan, nodefault};
	__property int RowSpan = {read=FRowSpan, nodefault};
	
__published:
	__property Graphics::TColor Color = {read=FColor, write=SetColor, default=536870911};
	__property Graphics::TColor BorderColor = {read=FBorderColor, write=FBorderColor, default=536870911};
	__property Graphics::TColor BorderLightColor = {read=FBorderLightColor, write=FBorderLightColor, default=536870911};
	__property TRVHTMLLength BestWidth = {read=FBestWidth, write=SetBestWidth, default=0};
	__property int BestHeight = {read=FBestHeight, write=SetBestHeight, default=0};
	__property Rvstyle::TRVBooleanRect* VisibleBorders = {read=FVisibleBorders, write=SetVisibleBorders, stored=StoreVisibleBorders};
	__property TRVCellVAlign VAlign = {read=FVAlign, write=FVAlign, default=3};
	__property Graphics::TGraphic* BackgroundImage = {read=GetBackgroundImage, write=SetBackgroundImage, stored=false};
	__property Rvstyle::TRVItemBackgroundStyle BackgroundStyle = {read=GetBackgroundStyle, write=SetBackgroundStyle, default=0};
	__property AnsiString BackgroundImageFileName = {read=FBackgroundImageFileName, write=FBackgroundImageFileName};
	__property AnsiString Hint = {read=FHint, write=FHint};
};


class DELPHICLASS TRVTableRows;
class PASCALIMPLEMENTATION TRVTableRows : public Rvclasses::TRVList 
{
	typedef Rvclasses::TRVList inherited;
	
public:
	TRVTableRow* operator[](int Index) { return Items[Index]; }
	
private:
	HIDESBASE TRVTableRow* __fastcall Get(int Index);
	HIDESBASE void __fastcall Put(int Index, const TRVTableRow* Value);
	int __fastcall GetMinColWidth(int Col, Rvstyle::PRVScreenAndDevice sad, Graphics::TCanvas* Canvas);
	int __fastcall GetPercentColWidth(int Col, int TableWidth);
	bool __fastcall IsPercentWidthColumn(int Col);
	int __fastcall GetPixelColWidth(int Col);
	bool __fastcall StartMergeCells(int TopRow, int LeftCol, int &ColSpan, int &RowSpan);
	
protected:
	Crvdata::TCustomRVData* FMainRVData;
	TRVTableItemInfo* FTable;
	int __fastcall GetColCount(void);
	bool __fastcall IsEmptyRows(int TopRow, int LeftCol, int ColSpan, int RowSpan, int TopRow2, int RowSpan2);
	bool __fastcall IsEmptyCols(int TopRow, int LeftCol, int ColSpan, int RowSpan, int LeftCol2, int ColSpan2);
	int __fastcall GetBestWidth(int TopRow, int LeftCol, int ColSpan, int RowSpan);
	void __fastcall UnmergeCell(int Row, int Col, bool UnmergeRows, bool UnmergeCols);
	void __fastcall UnmergeCells(int TopRow, int LeftCol, int ColSpan, int RowSpan, bool UnmergeRows, bool UnmergeCols);
	void __fastcall InsertRows(int Index, int Count, int CopyIndex, bool DivideHeights);
	void __fastcall InsertCols(int Index, int Count, int CopyIndex, bool DivideWidths);
	void __fastcall DeleteRows(int Index, int Count, bool DecreaseHeight);
	void __fastcall DeleteCols(int Index, int Count, bool DecreaseWidth);
	int __fastcall SplitCellVertically(int Row, int Col, int ColCount);
	int __fastcall SplitCellsVertically(int TopRow, int LeftCol, int ColSpan, int RowSpan, int ColCount);
	int __fastcall SplitCellHorizontally(int Row, int Col, int RowCount);
	int __fastcall SplitCellsHorizontally(int TopRow, int LeftCol, int ColSpan, int RowSpan, int RowCount);
	void __fastcall MovingToUndoList(int Row, int Col, int ColSpan, int RowSpan, Rvundo::TRVUndoInfo* AContainerUndoItem);
	void __fastcall MovingFromUndoList(int Row, int Col, int ColSpan, int RowSpan);
	void __fastcall Do_BeforeInsertRows(int ItemNo, int Row, int Count);
	void __fastcall Do_InsertRows(int Row, int Count);
	void __fastcall Do_UnInsertRows(int Row, int Count);
	void __fastcall Do_BeforeInsertCell(int ItemNo, int Row, int Col);
	void __fastcall Do_BeforeSpreadOverEmptyCells(int ItemNo, int Row, int Col, int ColSpan);
	void __fastcall Do_SpreadOverEmptyCells(int Row, int Col, int ColSpan);
	void __fastcall Do_UnSpreadOverEmptyCells(int Row, int Col, int ColSpan);
	void __fastcall Do_SetSpan(int ItemNo, int Row, int Col, int Span, bool IsColSpan);
	void __fastcall Do_BeforeFreeEmptyCells(int ItemNo, int Row, int Col, int ColSpan, int RowSpan);
	void __fastcall Do_FreeEmptyCells(int Row, int Col, int ColSpan, int RowSpan);
	void __fastcall Do_UnFreeEmptyCells(int Row, int Col, int ColSpan, int RowSpan);
	void __fastcall Do_ChangeEmptyCellStyles(int ItemNo, int Row, int Col, int StyleNo, int ParaNo);
	void __fastcall Do_BeforeInsertEmptyCells(int ItemNo, int Row, int Col, int ColCount, int RowCount);
	void __fastcall Do_InsertEmptyCells(int Row, int Col, int ColCount, int RowCount);
	void __fastcall Do_UnInsertEmptyCells(int Row, int Col, int ColCount, int RowCount);
	void __fastcall Do_BeforeSplitCellHorz(int ItemNo, int Row, int Col, int Row2, bool DecreaseHeight);
	void __fastcall Do_SplitCellHorz(int Row, int Col, int Row2, bool DecreaseHeight);
	void __fastcall Do_UnSplitCellHorz(int Row, int Col, int Row2, int OldBestHeight);
	void __fastcall Do_BeforeSplitCellVert(int ItemNo, int Row, int Col, int Col2, bool DecreaseWidth);
	void __fastcall Do_SplitCellVert(int Row, int Col, int Col2, bool DecreaseWidth);
	void __fastcall Do_UnSplitCellVert(int Row, int Col, int Col2, int OldBestWidth);
	Rvundo::TRVUndoInfo* __fastcall Do_BeforeDeleteRows(int ItemNo, int Row, int Count);
	void __fastcall Do_DeleteRows(int ItemNo, int Row, int Count, Rvundo::TRVUndoInfo* ui);
	void __fastcall Do_UnDeleteRows(int Row, Classes::TList* RowList);
	Rvundo::TRVUndoInfo* __fastcall Do_BeforeDeleteCols(int ItemNo, int Col, int Count);
	void __fastcall Do_DeleteCols(int ItemNo, int Col, int Count, Rvundo::TRVUndoInfo* ui);
	void __fastcall Do_UnDeleteCols(int Col, Classes::TList* CellList);
	Rvundo::TRVUndoInfo* __fastcall Do_BeforeMergeCells(int ItemNo, int Row, int Col, int ColSpan, int RowSpan);
	void __fastcall Do_MergeCells(int ItemNo, int Row, int Col, int ColSpan, int RowSpan, Rvundo::TRVUndoInfo* ui, bool ChangeBestWidth);
	void __fastcall Do_UndoMergeCells(int ItemNo, int Row, int Col, int OldColSpan, int OldRowSpan, Rvclasses::TRVList* MergedItemsList, TRVHTMLLength OldBestWidth);
	void __fastcall Do_BeforeUnmergeCell(int ItemNo, int Row, int Col, bool UnmergeRows, bool UnmergeCols);
	void __fastcall Do_UnmergeCell(int ItemNo, int Row, int Col, bool UnmergeRows, bool UnmergeCols);
	void __fastcall Do_UndoUnmergeCell(int ItemNo, int Row, int Col, int OldColSpan, int OldRowSpan, TRVHTMLLength OldBestWidth, int OldBestHeight);
	Rvundo::TRVUndoInfo* __fastcall Do_BeforeClearCells(int ItemNo, Rvclasses::TRVIntegerList* RowList, Rvclasses::TRVIntegerList* ColList, Classes::TList* &CellsList);
	void __fastcall Do_AfterFillingCells(Classes::TList* CellsList, Rvclasses::TRVIntegerList* RowList, Rvclasses::TRVIntegerList* ColList, Rvundo::TRVUndoInfo* ui);
	void __fastcall Do_ClearCells(Classes::TList* CellsList, Rvclasses::TRVIntegerList* RowList, Rvclasses::TRVIntegerList* ColList, Rvundo::TRVUndoInfo* ui);
	void __fastcall Do_UnClearCells(Classes::TList* CellsList, Rvclasses::TRVIntegerList* RowList, Rvclasses::TRVIntegerList* ColList);
	void __fastcall InsertPointer(int Index, TRVTableRow* Item);
	
public:
	__fastcall TRVTableRows(int nRows, int nCols, Crvdata::TCustomRVData* AMainRVData, TRVTableItemInfo* ATable);
	__fastcall virtual ~TRVTableRows(void);
	void __fastcall MergeCells(int TopRow, int LeftCol, int ColSpan, int RowSpan, bool AllowMergeRC, bool ChangeBestWidth);
	bool __fastcall Empty(void);
	HIDESBASE TRVTableRow* __fastcall Add(int nCols);
	TRVTableCellData* __fastcall GetMainCell(int ARow, int ACol, int &MRow, int &MCol);
	HIDESBASE TRVTableRow* __fastcall Insert(int Index, int nCols);
	void __fastcall Reset(int nRows, int nCols);
	bool __fastcall CanMergeCells(int TopRow, int LeftCol, int ColSpan, int RowSpan, bool AllowMergeRC);
	__property TRVTableRow* Items[int Index] = {read=Get, write=Put/*, default*/};
};


class PASCALIMPLEMENTATION TRVTableRow : public Rvdatalist::TRVDataList 
{
	typedef Rvdatalist::TRVDataList inherited;
	
public:
	TRVTableCellData* operator[](int Index) { return Items[Index]; }
	
private:
	TRVCellVAlign FVAlign;
	bool FPageBreakBefore;
	HIDESBASE TRVTableCellData* __fastcall Get(int Index);
	HIDESBASE void __fastcall Put(int Index, const TRVTableCellData* Value);
	void __fastcall InsertEmpty(int Index);
	void __fastcall InsertPointer(int Index, TRVTableCellData* Item);
	
protected:
	TRVTableRows* FRows;
	virtual Crvdata::TCustomRVData* __fastcall GetParentRVData(void);
	bool __fastcall HasCellsInRange(int Index, int RangeStart, int Count);
	
public:
	__fastcall TRVTableRow(int nCols, TRVTableRows* ARows, Crvdata::TCustomRVData* MainRVData);
	HIDESBASE TRVTableCellData* __fastcall Add(void);
	HIDESBASE TRVTableCellData* __fastcall Insert(int Index);
	int __fastcall GetHeight(bool IgnoreContentHeight);
	int __fastcall GetBestHeight(void);
	__property TRVCellVAlign VAlign = {read=FVAlign, write=FVAlign, default=0};
	__property bool PageBreakBefore = {read=FPageBreakBefore, write=FPageBreakBefore, default=0};
	__property TRVTableCellData* Items[int Index] = {read=Get, write=Put/*, default*/};
public:
	#pragma option push -w-inl
	/* TRVList.Destroy */ inline __fastcall virtual ~TRVTableRow(void) { }
	#pragma option pop
	
};


#pragma pack(push,4)
struct TRVTableInplaceParamStorage
{
	
public:
	bool Stored;
	int StartNo;
	int EndNo;
	int StartOffs;
	int EndOffs;
	int Row;
	int Col;
	Rvitem::TCustomRVItemInfo* PartialSelected;
} ;
#pragma pack(pop)

class DELPHICLASS TRVTableItemFormattingInfo;
class PASCALIMPLEMENTATION TRVTableItemFormattingInfo : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Rvclasses::TRVIntegerList* ColWidths;
	Rvclasses::TRVIntegerList* RowHeights;
	Rvclasses::TRVIntegerList* ColStarts;
	Rvclasses::TRVIntegerList* RowStarts;
	int FWidth;
	int FHeight;
	
public:
	Rvclasses::TRVList* Rows;
	__fastcall TRVTableItemFormattingInfo(bool CreateRows);
	__fastcall virtual ~TRVTableItemFormattingInfo(void);
	void __fastcall Clear(void);
	void __fastcall QuickClear(void);
};


#pragma option push -b-
enum TRVCellDirection { rvcdLeft, rvcdUp, rvcdRight, rvcdDown, rvcdDocTop, rvcdDocBottom, rvcdNext, rvcdPrev };
#pragma option pop

typedef void __fastcall (__closure *TRVTableDrawBorderEvent)(TRVTableItemInfo* Sender, Graphics::TCanvas* Canvas, int Left, int Top, int Right, int Bottom, int Width, Graphics::TColor LightColor, Graphics::TColor Color, Graphics::TColor BackgroundColor, TRVTableBorderStyle Style, bool Printing, Rvstyle::TRVBooleanRect* VisibleBorders, int Row, int Col, bool &DoDefault);

#pragma option push -b-
enum TRVTableState { rvtsInserted, rvtsEditMode, rvtsModified, rvtsFormatInplace, rvtsVerticalDraggedRule, rvtsDRChangeTableWidth, rvtsJustCreated, rvtsInplaceIsReformatting, rvtsSelExists };
#pragma option pop

typedef Set<TRVTableState, rvtsInserted, rvtsSelExists>  TRVTableStates;

class DELPHICLASS TRVTableStreamSaveInfo;
class DELPHICLASS TRVTablePrintPart;
class PASCALIMPLEMENTATION TRVTablePrintPart : public Rvitem::TRVMultiDrawItemPart 
{
	typedef Rvitem::TRVMultiDrawItemPart inherited;
	
public:
	Rvclasses::TRVIntegerList* FTableTopCutLine;
	Rvclasses::TRVIntegerList* FTableBottomCutLine;
	Rvclasses::TRVIntegerList* FRowStarts;
	Rvclasses::TRVIntegerList* FRowIndices;
	bool FRowFinished;
	int FHeadingHeight;
	TRVTableItemFormattingInfo* FFmtRef;
	DYNAMIC int __fastcall GetSoftPageBreakInfo(void);
	DYNAMIC bool __fastcall IsComplexSoftPageBreak(Dlines::TRVDrawLineInfo* DrawItem);
	DYNAMIC void __fastcall AssignSoftPageBreaksToItem(Dlines::TRVDrawLineInfo* DrawItem, Rvitem::TCustomRVItemInfo* Item);
	__fastcall TRVTablePrintPart(TRVTableItemInfo* ATable);
	__fastcall virtual ~TRVTablePrintPart(void);
	void __fastcall UpdateRowStarts(int Index, int RowSpan, int Height);
};


class DELPHICLASS TCellPtblRVData;
#pragma pack(push,4)
struct TRVPageFormatSaveRec
{
	
public:
	int DrawItemNo;
	int StartAt;
	int StartY;
	int Y;
	int EndAt;
	int PagesCount;
	bool Splitting;
} ;
#pragma pack(pop)

class PASCALIMPLEMENTATION TCellPtblRVData : public Ptrvdata::TRectPtblRVData 
{
	typedef Ptrvdata::TRectPtblRVData inherited;
	
private:
	int DrawItemNo;
	int StartAt;
	int StartY;
	int Y;
	int CurPageNo;
	int EndAt;
	bool Splitting;
	TRVPageFormatSaveRec PrevPageInfo;
	void __fastcall ResetDrawItems(int StartDItemNo, Ptrvdata::TRVFootnoteRefList* &FootnoteRVDataList, bool ResetAll, bool InHeader, int &ReleasedHeightAfterFootnotes, bool FootnotesChangeHeight);
	
protected:
	DYNAMIC void __fastcall SetEndAt(int Value);
	
public:
	virtual Rvstyle::TRVStyle* __fastcall GetRVStyle(void);
	HIDESBASE bool __fastcall FormatNextPage(int &AMaxHeight, Ptrvdata::TRVFootnoteRefList* &FootnoteRVDataList, bool FootnotesChangeHeight);
	void __fastcall UnformatLastPage(Ptrvdata::TRVFootnoteRefList* &FootnoteRVDataList, int &ReleasedHeightAfterFootnotes, bool FootnotesChangeHeight);
	void __fastcall ResetPages(Ptrvdata::TRVFootnoteRefList* &FootnoteRVDataList, int &ReleasedHeightAfterFootnotes, bool FootnotesChangeHeight, bool InHeader);
	bool __fastcall Finished(void);
public:
	#pragma option push -w-inl
	/* TRectPtblRVData.Create */ inline __fastcall TCellPtblRVData(Rvscroll::TRVScroller* RichView, Crvdata::TCustomRVData* SourceDataForPrinting, Ptrvdata::TCustomPrintableRVData* ParentPrintData) : Ptrvdata::TRectPtblRVData(RichView, SourceDataForPrinting, ParentPrintData) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TCustomMultiPagePtblRVData.Destroy */ inline __fastcall virtual ~TCellPtblRVData(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TRVTableStreamSaveInfo : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	TRVTablePrintPart* Part;
	int CellPage;
	TCellPtblRVData* CellPtblRVData;
	int TopRow;
	int LeftCol;
	int RowCount;
	int ColCount;
	bool SaveHeadingRows;
	bool SelectionOnly;
	__fastcall TRVTableStreamSaveInfo(TRVTableItemInfo* table);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TRVTableStreamSaveInfo(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TRVTableItemInfo : public Rvitem::TRVFullLineItemInfo 
{
	typedef Rvitem::TRVFullLineItemInfo inherited;
	
private:
	TRVTableCellData* FPrintCell;
	Types::TRect FPrintCellRect;
	TRVCellEditingEvent FOnCellEditing;
	TRVCellEndEditEvent FOnCellEndEdit;
	TRVTableStates FState;
	int CachedItemNo;
	int MyTop;
	int MyLeft;
	int MyClientTop;
	int MyClientLeft;
	int MouseRow;
	int MouseCol;
	int DRMin;
	int DRMax;
	int DRNo;
	int DRCoord;
	int DRDelta;
	TRVTableRows* FRows;
	int FCellVSpacing;
	int FCellHSpacing;
	int FCellHPadding;
	int FCellVPadding;
	TRVHTMLLength FBestWidth;
	int FBorderWidth;
	Graphics::TColor FBorderColor;
	Graphics::TColor FColor;
	int FCellBorderWidth;
	int FHRuleWidth;
	int FVRuleWidth;
	Graphics::TColor FHRuleColor;
	Graphics::TColor FCellBorderColor;
	Graphics::TColor FVRuleColor;
	TRVTableBorderStyle FBorderStyle;
	TRVTableBorderStyle FCellBorderStyle;
	int FBorderHSpacing;
	int FBorderVSpacing;
	bool FHOutermostRule;
	bool FVOutermostRule;
	Graphics::TColor FCellBorderLightColor;
	Graphics::TColor FBorderLightColor;
	int FSelStartCol;
	int FSelStartRow;
	int FSelColOffs;
	int FSelRowOffs;
	int BusyCount;
	TRVTableOptions FOptions;
	TRVTablePrintOptions FPrintOptions;
	TRVTableInplaceParamStorage FStoredInplace;
	int FMinWidthPlus;
	int FInplaceMinWidthPlus;
	AnsiString FTextRowSeparator;
	AnsiString FTextColSeparator;
	int FocusedCellRow;
	int FocusedCellCol;
	int ChosenCellRow;
	int ChosenCellCol;
	TRVTableDrawBorderEvent FOnDrawBorder;
	int FHeadingRowCount;
	Rvback::TRVBackground* FBackground;
	AnsiString FBackgroundImageFileName;
	Rvstyle::TRVBooleanRect* FVisibleBorders;
	TRVTableStreamSaveInfo* FStreamSaveInfo;
	bool __fastcall StoreCellPadding(void);
	bool __fastcall StoreCellHPadding(void);
	bool __fastcall StoreCellVPadding(void);
	int __fastcall GetItemNoInRootDocument(void);
	TRVTableCellData* __fastcall GetCells(int Row, int Col);
	void __fastcall SetCells(int Row, int Col, const TRVTableCellData* Value);
	void __fastcall SetBestWidth(const TRVHTMLLength Value);
	int __fastcall GetVerticalRuleNo(int X, int &MinX, int &ZeroChangeX);
	int __fastcall GetHorizontalRuleNo(int Y, int &MinY, int &ZeroChangeY);
	int __fastcall GetColNo(int X);
	int __fastcall GetRowNo(int Y);
	int __fastcall GetCrossed(int Coord, Rvclasses::TRVIntegerList* List);
	void __fastcall UpdateCellXCoords(TRVTableItemFormattingInfo* Fmt, bool NoCaching, bool Reformatting);
	void __fastcall UpdateCellYCoords(TRVTableItemFormattingInfo* Fmt);
	int __fastcall GetHorzExtra(void);
	void __fastcall InplaceEditorChange(Rvedit::TCustomRichViewEdit* Sender, bool ClearRedo);
	void __fastcall InplaceEditorCaretGetout(Rvedit::TCustomRichViewEdit* Sender, Rvedit::TRVGetOutDirection Direction);
	void __fastcall InplaceEditorMouseDown(Richview::TCustomRichView* Sender, Controls::TMouseButton Button, Classes::TShiftState Shift, int ItemNo, int X, int Y);
	void __fastcall InplaceEditorMouseUp(Richview::TCustomRichView* Sender, Controls::TMouseButton Button, Classes::TShiftState Shift, int ItemNo, int X, int Y);
	void __fastcall InplaceEditorMouseMove(System::TObject* Sender, Classes::TShiftState Shift, int X, int Y);
	void __fastcall InplaceEditorDragOver(System::TObject* Sender, System::TObject* Source, int X, int Y, Controls::TDragState State, bool &Accept);
	void __fastcall InplaceEditorDragDrop(System::TObject* Sender, System::TObject* Source, int X, int Y);
	void __fastcall DestroyInplace(bool ReformatCell);
	void __fastcall StoreRVSelection(Crvfdata::TCustomRVFormattedData* RVData, TRVTableInplaceParamStorage &storage);
	void __fastcall RestoreRVSelection(Crvfdata::TCustomRVFormattedData* RVData, const TRVTableInplaceParamStorage &storage);
	void __fastcall Init(int nRows, int nCols, Crvdata::TCustomRVData* AMainRVData);
	void __fastcall CellsWriter(Classes::TWriter* Writer);
	void __fastcall CellsReader(Classes::TReader* Reader);
	void __fastcall ClearTemporal(void);
	void __fastcall SetBorderColor(const Graphics::TColor Value);
	void __fastcall SetBorderHSpacing(const int Value);
	void __fastcall SetBorderLightColor(const Graphics::TColor Value);
	void __fastcall SetBorderStyle(const TRVTableBorderStyle Value);
	void __fastcall SetBorderVSpacing(const int Value);
	void __fastcall SetBorderWidth(const int Value);
	void __fastcall SetCellBorderColorProp(const Graphics::TColor Value);
	void __fastcall SetCellBorderLightColorProp(const Graphics::TColor Value);
	void __fastcall SetCellBorderWidth(const int Value);
	void __fastcall SetCellHSpacing(const int Value);
	void __fastcall SetCellHPadding(const int Value);
	void __fastcall SetCellVPadding(const int Value);
	void __fastcall SetCellPadding(const int Value);
	void __fastcall SetCellVSpacing(const int Value);
	void __fastcall SetColor(const Graphics::TColor Value);
	void __fastcall SetHOutermostRule(const bool Value);
	void __fastcall SetHRuleColor(const Graphics::TColor Value);
	void __fastcall SetHRuleWidth(const int Value);
	void __fastcall SetVOutermostRule(const bool Value);
	void __fastcall SetVRuleColor(const Graphics::TColor Value);
	void __fastcall SetVRuleWidth(const int Value);
	void __fastcall SetCellBorderStyle(const TRVTableBorderStyle Value);
	void __fastcall SetIntProperty(const AnsiString PropertyName, int Value, bool AffectSize, bool AffectWidth);
	void __fastcall SetCellIntProperty(int ItemNo, const AnsiString PropertyName, int Value, int Row, int Col, bool AffectSize, bool AffectWidth);
	void __fastcall SetCellStrProperty(int ItemNo, const AnsiString PropertyName, const AnsiString Value, int Row, int Col);
	bool __fastcall IsFixedWidthTable(void);
	bool __fastcall CompletelySelected(void);
	void __fastcall UnAssignActiveCell(void);
	bool __fastcall DoOnCellEditing(int Row, int Col, bool Automatic);
	bool __fastcall IsInEditor(void);
	void __fastcall SetHeadingRowCount(const int Value);
	Graphics::TGraphic* __fastcall GetBackgroundImage(void);
	void __fastcall SetBackgroundImage_(const Graphics::TGraphic* Value, bool Copy);
	void __fastcall SetBackgroundImage(const Graphics::TGraphic* Value);
	Rvstyle::TRVItemBackgroundStyle __fastcall GetBackgroundStyle(void);
	void __fastcall SetBackgroundStyle(const Rvstyle::TRVItemBackgroundStyle Value);
	void __fastcall BackgroundImageWriter(Classes::TStream* Stream);
	void __fastcall BackgroundImageReader(Classes::TStream* Stream);
	void __fastcall ResetLiveSpell(void);
	void __fastcall SetVisibleBorders(const Rvstyle::TRVBooleanRect* Value);
	bool __fastcall StoreVisibleBorders(void);
	void __fastcall DoSaveRVF(Classes::TStream* Stream, Classes::TPersistent* RVData, int ItemNo, int ParaNo, Rvitem::TRVMultiDrawItemPart* Part, bool ForceSameAsPrev, bool SelectionOnly);
	int __fastcall GetColCount(void);
	int __fastcall GetRowCount(void);
	int __fastcall GetCellPadding(void);
	
protected:
	TRVTableItemFormattingInfo* Fmt;
	Rvstyle::TRVScreenAndDevice *cursad;
	void __fastcall XorDrawing(System::TObject* Sender, Classes::TShiftState Shift, int X, int Y);
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	virtual int __fastcall GetHeight(void);
	virtual int __fastcall GetWidth(void);
	void __fastcall DrawBorder(Graphics::TCanvas* Canvas, int Left, int Top, int Right, int Bottom, int Width, Graphics::TColor LightColor, Graphics::TColor Color, Graphics::TColor BackgroundColor, TRVTableBorderStyle Style, bool DrawEvenEmptyBorder, bool Editing, bool Printing, const Types::TRect &ClipRect, Rvstyle::TRVBooleanRect* VisibleBorders, int r, int c, Rvstyle::TRVColorMode ColorMode);
	bool __fastcall GetCellAt_(int X, int Y, int &Row, int &Col);
	void __fastcall UpdateCellSel(void);
	void __fastcall PaintTo(int Left, int Right, int Top, Graphics::TCanvas* Canvas, Rvitem::TRVItemDrawStates State, Rvstyle::TRVStyle* Style, TRVTableItemFormattingInfo* Fmt, bool UseHeadingRowCount, const Types::TRect &ClipRect, Rvstyle::TRVColorMode ColorMode, Ptrvdata::TCustomPrintableRVData* RVData, TRVTablePrintPart* Part, int ExtraX, int ExtraY);
	int __fastcall GetDevX(int x);
	int __fastcall GetDevY(int y);
	void __fastcall InternalOnDocWidthChange(int DocWidth, TRVTableItemFormattingInfo* Fmt, Graphics::TCanvas* Canvas, bool NoCaching, bool Reformatting);
	void __fastcall Change(void);
	void __fastcall ChangeEx(bool ClearRedo);
	int __fastcall BeginModify(int ItemNo);
	void __fastcall EndModify(int ItemNo, int Data);
	Graphics::TColor __fastcall GetTableColor(bool UseParentBackground);
	Graphics::TColor __fastcall GetCellColor(TRVTableCellData* Cell);
	Graphics::TColor __fastcall GetCellColor2(TRVTableCellData* Cell);
	bool __fastcall CanSeeBackgroundThroughCell(TRVTableCellData* Cell);
	bool __fastcall CanSplitAtRow(int Row);
	int __fastcall GetSplitRowBelow(int Row);
	int __fastcall GetSplitRowAbove(int Row);
	bool __fastcall BeforeChange(void);
	bool __fastcall CanChange(void);
	bool __fastcall CanChangeEx(void);
	void __fastcall InitUndo(void);
	void __fastcall DoneUndo(void);
	void __fastcall AssignCellAttributes(int ItemNo, int Row, int Col, TRVTableCellData* SourceCell, bool IncludeSize, int DivColSpan, int DivRowSpan);
	void __fastcall SetCellBestWidth_(int ItemNo, TRVHTMLLength Value, int Row, int Col);
	void __fastcall SetCellBestHeight_(int ItemNo, int Value, int Row, int Col);
	void __fastcall SetCellColor_(int ItemNo, Graphics::TColor Value, int Row, int Col);
	void __fastcall SetCellBackgroundStyle_(int ItemNo, Rvstyle::TRVItemBackgroundStyle Value, int Row, int Col);
	void __fastcall SetCellBackgroundImageFileName_(int ItemNo, const AnsiString Value, int Row, int Col);
	void __fastcall SetCellHint_(int ItemNo, const AnsiString Value, int Row, int Col);
	void __fastcall SetCellVisibleBorders_(int ItemNo, bool Left, bool Top, bool Right, bool Bottom, int Row, int Col);
	void __fastcall SetCellBorderColor_(int ItemNo, Graphics::TColor Value, int Row, int Col);
	void __fastcall SetCellBorderLightColor_(int ItemNo, Graphics::TColor Value, int Row, int Col);
	void __fastcall SetCellVAlign_(int ItemNo, TRVCellVAlign Value, int Row, int Col);
	void __fastcall SetRowVAlign_(int ItemNo, TRVCellVAlign Value, int Row);
	int __fastcall GetEditorItemNoForUndo(void);
	Rvedit::TCustomRichViewEdit* __fastcall CreateTemporalEditor(void);
	void __fastcall ApplyToCells(Rvitem::TRVEStyleConversionType ConvType, int UserData, bool SelectedOnly);
	void __fastcall ValidateFocused(void);
	void __fastcall ValidateChosen(void);
	bool __fastcall CellIsChosen(void);
	void __fastcall AdjustFocus(int Row, int Col, Classes::TPersistent* TopLevelRVData, int TopLevelItemNo);
	bool __fastcall UndoEnabled(void);
	void __fastcall ChooseSubRVData_(int r, int c);
	void __fastcall EditCell_(int Row, int Col, bool Unquestioning);
	DYNAMIC int __fastcall GetRVFExtraPropertyCount(void);
	DYNAMIC void __fastcall SaveRVFExtraProperties(Classes::TStream* Stream);
	bool __fastcall RowsHavePageBreaksBefore(int StartRow, int EndRow);
	bool __fastcall GetNormalizedSelectionBoundsEx(bool IncludeEditedCell, int &TopRow, int &LeftCol, int &ColSpan, int &RowSpan);
	int __fastcall DoGetMinWidth(Rvstyle::PRVScreenAndDevice sad, Graphics::TCanvas* Canvas, bool UseTableWidth);
	
public:
	bool FMakingSelection;
	Rvedit::TCustomRichViewEdit* FInplaceEditor;
	bool __fastcall CanUseHeadingRowCount(void);
	void __fastcall DrawBackgroundUnderCell(Graphics::TCanvas* Canvas, TRVTableCellData* Cell, const Types::TRect &Rect);
	bool __fastcall IsSemiTransparentBackground(void);
	DYNAMIC void __fastcall ClearSoftPageBreaks(void);
	DYNAMIC int __fastcall GetSoftPageBreakDY(int Data);
	int __fastcall GetMyItemNo(void);
	void __fastcall SaveRowsToStream(Classes::TStream* Stream, int Index, int Count);
	void __fastcall SaveRectangleToStream(Classes::TStream* Stream, int TopRow, int LeftCol, int RowCount, int ColCount, bool SelectionOnly);
	DYNAMIC void __fastcall ResetSubCoords(void);
	DYNAMIC Classes::TPersistent* __fastcall GetSubRVDataAt(int X, int Y);
	bool __fastcall GetCellWhichOwnsControl(Controls::TControl* AControl, int &ARow, int &ACol, int &AItemNo);
	DYNAMIC bool __fastcall AdjustFocusToControl(Controls::TControl* Control, Classes::TPersistent* &TopLevelRVData, int &TopLevelItemNo);
	virtual void __fastcall Print(Graphics::TCanvas* Canvas, int x, int y, int x2, bool Preview, bool Correction, const Rvstyle::TRVScreenAndDevice &sad, Rvscroll::TRVScroller* RichView, Dlines::TRVDrawLineInfo* dli, int Part, Rvstyle::TRVColorMode ColorMode, Classes::TPersistent* RVData);
	void __fastcall CreateInplace(int ItemNo, int Row, int Col, bool BuildJumps, bool CaretAtStart, bool CaretAtEnd, bool SetTime, bool Unquestioning);
	void __fastcall SetInplaceBounds(int Left, int Top, int Width, int Height);
	bool __fastcall StartSelecting(int Row, int Col, bool FromKeyboard);
	DYNAMIC void __fastcall MovingToUndoList(int ItemNo, System::TObject* RVData, System::TObject* AContainerUndoItem);
	DYNAMIC void __fastcall MovingFromUndoList(int ItemNo, System::TObject* RVData);
	DYNAMIC void __fastcall FinalizeUndoGroup(void);
	virtual void __fastcall AdjustInserted(int x, int y, bool adjusty);
	DYNAMIC bool __fastcall OwnsControl(Controls::TControl* AControl);
	DYNAMIC bool __fastcall OwnsInplaceEditor(Controls::TControl* AEditor);
	virtual int __fastcall GetMinWidth(Rvstyle::PRVScreenAndDevice sad, Graphics::TCanvas* Canvas, Classes::TPersistent* RVData);
	virtual void __fastcall PaintFullWidth(int Left, int Right, int Top, Graphics::TCanvas* Canvas, Rvitem::TRVItemDrawStates State, Rvstyle::TRVStyle* Style, const Types::TRect &ClipRect, Dlines::TRVDrawLineInfo* dli, int ExtraX, int ExtraY);
	virtual void __fastcall OnDocWidthChange(int DocWidth, Dlines::TRVDrawLineInfo* dli, bool Printing, Graphics::TCanvas* Canvas, Classes::TPersistent* RVData, Rvstyle::PRVScreenAndDevice sad, int &HShift, int &Desc, bool NoCaching, bool Reformatting);
	void __fastcall ResizeRow(int Index, int Height);
	void __fastcall ResizeCol(int Index, int Width, bool Shift);
	DYNAMIC bool __fastcall MouseMove(Classes::TShiftState Shift, int X, int Y, int ItemNo, System::TObject* RVData);
	DYNAMIC bool __fastcall MouseDown(Controls::TMouseButton Button, Classes::TShiftState Shift, int X, int Y, int ItemNo, System::TObject* RVData);
	DYNAMIC bool __fastcall MouseUp(Controls::TMouseButton Button, Classes::TShiftState Shift, int X, int Y, int ItemNo, System::TObject* RVData);
	DYNAMIC void __fastcall DeselectPartial(void);
	void __fastcall MergeInplaceUndo(bool DestroyLists);
	void __fastcall InplaceDeleted(bool Clearing);
	DYNAMIC bool __fastcall PartiallySelected(void);
	DYNAMIC bool __fastcall CanDeletePartiallySelected(void);
	void __fastcall DoAfterFillingRows(int Row, int Count);
	DYNAMIC void __fastcall DeletePartiallySelected(void);
	virtual bool __fastcall GetBoolValue(Rvitem::TRVItemBoolProperty Prop);
	virtual bool __fastcall GetBoolValueEx(Rvitem::TRVItemBoolPropertyEx Prop, Rvstyle::TRVStyle* RVStyle);
	DYNAMIC void __fastcall SaveRVF(Classes::TStream* Stream, Classes::TPersistent* RVData, int ItemNo, int ParaNo, const AnsiString Name, Rvitem::TRVMultiDrawItemPart* Part, bool ForceSameAsPrev);
	DYNAMIC void __fastcall SaveRVFSelection(Classes::TStream* Stream, Classes::TPersistent* RVData, int ItemNo, int ParaNo);
	DYNAMIC void __fastcall SaveTextSelection(Classes::TStream* Stream, Classes::TPersistent* RVData, int LineWidth, const AnsiString Path, bool TextOnly, bool Unicode);
	DYNAMIC bool __fastcall ReadRVFLine(const AnsiString s, Classes::TPersistent* RVData, int ReadType, int LineNo, int LineCount, AnsiString &Name, Rvitem::TRVFReadMode &ReadMode, Rvitem::TRVFReadState &ReadState, bool UTF8Strings, bool &AssStyleNameUsed);
	DYNAMIC void __fastcall BeforeLoading(Rvstyle::TRVLoadFormat FileFormat);
	DYNAMIC void __fastcall AfterLoading(Rvstyle::TRVLoadFormat FileFormat);
	virtual Dlines::TRVDrawLineInfo* __fastcall CreatePrintingDrawItem(System::TObject* RVData, const Rvstyle::TRVScreenAndDevice &sad);
	virtual void __fastcall DrawBackgroundForPrinting(Graphics::TCanvas* Canvas, const Types::TRect &Rect, const Types::TRect &FullRect, Rvstyle::TRVColorMode ColorMode, int ItemBackgroundLayer);
	void __fastcall SaveInplace(void);
	void __fastcall RestoreInplace(void);
	void __fastcall UpdateStoredInplaceSelection(void);
	DYNAMIC void __fastcall StartExport(void);
	DYNAMIC void __fastcall EndExport(void);
	DYNAMIC void __fastcall MarkStylesInUse(Rvitem::TRVDeleteUnusedStylesData* Data);
	DYNAMIC void __fastcall UpdateStyles(Rvitem::TRVDeleteUnusedStylesData* Data);
	virtual void __fastcall Inserting(System::TObject* RVData, AnsiString &Text, bool Safe);
	virtual void __fastcall Inserted(System::TObject* RVData, int ItemNo);
	DYNAMIC void __fastcall BeforeUndoChangeProperty(void);
	DYNAMIC void __fastcall AfterUndoChangeProperty(void);
	DYNAMIC void __fastcall ApplyStyleConversionToSubRVDatas(int UserData, bool SelectedOnly, Rvitem::TRVEStyleConversionType ConvType);
	bool __fastcall GetCellTo(int Row, int Col, TRVCellDirection Dir, int &NewRow, int &NewCol, bool Quiet, bool CanAddRow);
	DYNAMIC void __fastcall SaveRTF(Classes::TStream* Stream, const AnsiString Path, Classes::TPersistent* RVData, int ItemNo, double TwipsPerPixel, int Level, Rvclasses::TRVColorList* ColorList, Rvclasses::TRVIntegerList* StyleToFont, Rvclasses::TRVIntegerList* ListOverrideOffsetsList1, Rvclasses::TRVIntegerList* ListOverrideOffsetsList2, Rvclasses::TRVList* FontTable);
	DYNAMIC void __fastcall FillRTFTables(Rvclasses::TRVColorList* ColorList, Rvclasses::TRVIntegerList* ListOverrideCountList, Classes::TPersistent* RVData);
	DYNAMIC AnsiString __fastcall AsText(int LineWidth, Classes::TPersistent* RVData, const AnsiString Text, const AnsiString Path, bool TextOnly, bool Unicode);
	DYNAMIC void __fastcall SaveToHTML(Classes::TStream* Stream, Classes::TPersistent* RVData, int ItemNo, const AnsiString Text, const AnsiString Path, const AnsiString imgSavePrefix, int &imgSaveNo, Graphics::TColor CurrentFileColor, Rvstyle::TRVSaveOptions SaveOptions, bool UseCSS, Rvclasses::TRVList* Bullets);
	DYNAMIC bool __fastcall EnterItem(Rvitem::TRVEnterDirection From, int Coord);
	DYNAMIC void __fastcall BuildJumps(int Left, int Top, int &StartJumpNo, Classes::TList* jumps);
	DYNAMIC Classes::TPersistent* __fastcall GetSubRVData(Rvitem::TRVStoreSubRVData* &StoreState, Rvitem::TRVSubRVDataPos Position);
	DYNAMIC void __fastcall ChooseSubRVData(Rvitem::TRVStoreSubRVData* StoreState);
	DYNAMIC void __fastcall CleanUpChosen(void);
	__fastcall virtual TRVTableItemInfo(Classes::TPersistent* RVData);
	__fastcall TRVTableItemInfo(int nRows, int nCols, Crvdata::TCustomRVData* AMainRVData);
	__fastcall virtual ~TRVTableItemInfo(void);
	void __fastcall UnmergeCells(int TopRow, int LeftCol, int ColSpan, int RowSpan, bool UnmergeRows, bool UnmergeCols);
	bool __fastcall CanMergeCells(int TopRow, int LeftCol, int ColSpan, int RowSpan, bool AllowMergeRC);
	void __fastcall MergeCells(int TopRow, int LeftCol, int ColSpan, int RowSpan, bool AllowMergeRC);
	void __fastcall MergeSelectedCells(bool AllowMergeRC);
	bool __fastcall CanMergeSelectedCells(bool AllowMergeRC);
	void __fastcall UnmergeSelectedCells(bool UnmergeRows, bool UnmergeCols);
	void __fastcall SplitSelectedCellsVertically(int ColCount);
	void __fastcall SplitSelectedCellsHorizontally(int RowCount);
	bool __fastcall IsCellSelected(int Row, int Col);
	void __fastcall InsertRows(int Index, int Count, int CopyIndex, bool Select = true);
	void __fastcall InsertCols(int Index, int Count, int CopyIndex, bool Select = true);
	void __fastcall InsertColsLeft(int Count);
	void __fastcall InsertColsRight(int Count);
	void __fastcall InsertRowsAbove(int Count);
	void __fastcall InsertRowsBelow(int Count);
	void __fastcall DeleteRows(int Index, int Count, bool DecreaseHeight);
	void __fastcall DeleteCols(int Index, int Count, bool DecreaseWidth);
	void __fastcall DeleteSelectedRows(void);
	void __fastcall DeleteSelectedCols(void);
	void __fastcall DeleteEmptyRows(void);
	void __fastcall DeleteEmptyCols(void);
	bool __fastcall GetCellAt(int X, int Y, int &Row, int &Col);
	void __fastcall Select(int StartRow, int StartCol, int RowOffs, int ColOffs);
	void __fastcall Deselect(void);
	void __fastcall SelectRows(int StartRow, int Count);
	void __fastcall SelectCols(int StartCol, int Count);
	bool __fastcall GetSelectionBounds(int &StartRow, int &StartCol, int &RowOffs, int &ColOffs);
	bool __fastcall GetNormalizedSelectionBounds(bool IncludeEditedCell, int &TopRow, int &LeftCol, int &ColSpan, int &RowSpan);
	Rvedit::TCustomRichViewEdit* __fastcall GetEditedCell(int &Row, int &Col);
	void __fastcall SaveToStream(Classes::TStream* Stream);
	void __fastcall LoadFromStream(Classes::TStream* Stream);
	void __fastcall LoadFromStreamEx(Classes::TStream* Stream, int StartRow);
	void __fastcall EditCell(int Row, int Col);
	void __fastcall Changed(void);
	__property TRVTableRows* Rows = {read=FRows};
	__property TRVTableCellData* Cells[int Row][int Col] = {read=GetCells, write=SetCells};
	void __fastcall SetCellBestWidth(TRVHTMLLength Value, int Row, int Col);
	void __fastcall SetCellBestHeight(int Value, int Row, int Col);
	void __fastcall SetCellColor(Graphics::TColor Value, int Row, int Col);
	void __fastcall SetCellBackgroundStyle(Rvstyle::TRVItemBackgroundStyle Value, int Row, int Col);
	void __fastcall SetCellBackgroundImage(Graphics::TGraphic* Value, int Row, int Col);
	void __fastcall SetCellBackgroundImageFileName(const AnsiString Value, int Row, int Col);
	void __fastcall SetCellHint(const AnsiString Value, int Row, int Col);
	void __fastcall SetCellVisibleBorders(bool Left, bool Top, bool Right, bool Bottom, int Row, int Col);
	void __fastcall SetTableVisibleBorders(bool Left, bool Top, bool Right, bool Bottom);
	void __fastcall SetCellBorderColor(Graphics::TColor Value, int Row, int Col);
	void __fastcall SetCellBorderLightColor(Graphics::TColor Value, int Row, int Col);
	void __fastcall SetCellVAlign(TRVCellVAlign Value, int Row, int Col);
	void __fastcall SetRowVAlign(TRVCellVAlign Value, int Row);
	DYNAMIC bool __fastcall MoveFocus(bool GoForward, Classes::TPersistent* &TopLevelRVData, int &TopLevelItemNo);
	DYNAMIC void __fastcall ClearFocus(void);
	void __fastcall GetCellPosition(TRVTableCellData* Cell, int &Row, int &Col);
	void __fastcall AssignProperties(TRVTableItemInfo* Source);
	DYNAMIC bool __fastcall SetExtraStrProperty(Rvitem::TRVExtraItemStrProperty Prop, const AnsiString Value);
	DYNAMIC bool __fastcall GetExtraStrProperty(Rvitem::TRVExtraItemStrProperty Prop, AnsiString &Value);
	DYNAMIC void __fastcall KeyDown(Word Key, bool Shift);
	__property AnsiString BackgroundImageFileName = {read=FBackgroundImageFileName, write=FBackgroundImageFileName};
	__property int RowCount = {read=GetRowCount, nodefault};
	__property int ColCount = {read=GetColCount, nodefault};
	__property TRVTableStates State = {read=FState, nodefault};
	
__published:
	__property TRVTableOptions Options = {read=FOptions, write=FOptions, default=31};
	__property TRVTablePrintOptions PrintOptions = {read=FPrintOptions, write=FPrintOptions, default=3};
	__property TRVHTMLLength BestWidth = {read=FBestWidth, write=SetBestWidth, default=0};
	__property Graphics::TColor Color = {read=FColor, write=SetColor, default=-16777211};
	__property Graphics::TGraphic* BackgroundImage = {read=GetBackgroundImage, write=SetBackgroundImage, stored=false};
	__property Rvstyle::TRVItemBackgroundStyle BackgroundStyle = {read=GetBackgroundStyle, write=SetBackgroundStyle, default=0};
	__property int HeadingRowCount = {read=FHeadingRowCount, write=SetHeadingRowCount, default=0};
	__property AnsiString TextRowSeparator = {read=FTextRowSeparator, write=FTextRowSeparator};
	__property AnsiString TextColSeparator = {read=FTextColSeparator, write=FTextColSeparator};
	__property int BorderWidth = {read=FBorderWidth, write=SetBorderWidth, default=0};
	__property Graphics::TColor BorderColor = {read=FBorderColor, write=SetBorderColor, default=-16777208};
	__property Graphics::TColor BorderLightColor = {read=FBorderLightColor, write=SetBorderLightColor, default=-16777196};
	__property TRVTableBorderStyle BorderStyle = {read=FBorderStyle, write=SetBorderStyle, default=0};
	__property int BorderVSpacing = {read=FBorderVSpacing, write=SetBorderVSpacing, default=2};
	__property int BorderHSpacing = {read=FBorderHSpacing, write=SetBorderHSpacing, default=2};
	__property Rvstyle::TRVBooleanRect* VisibleBorders = {read=FVisibleBorders, write=SetVisibleBorders, stored=StoreVisibleBorders};
	__property int CellBorderWidth = {read=FCellBorderWidth, write=SetCellBorderWidth, default=0};
	__property Graphics::TColor CellBorderColor = {read=FCellBorderColor, write=SetCellBorderColorProp, default=-16777208};
	__property Graphics::TColor CellBorderLightColor = {read=FCellBorderLightColor, write=SetCellBorderLightColorProp, default=-16777196};
	__property int CellHPadding = {read=FCellHPadding, write=SetCellHPadding, stored=StoreCellHPadding, nodefault};
	__property int CellVPadding = {read=FCellVPadding, write=SetCellVPadding, stored=StoreCellVPadding, nodefault};
	__property int CellPadding = {read=GetCellPadding, write=SetCellPadding, stored=StoreCellPadding, default=1};
	__property TRVTableBorderStyle CellBorderStyle = {read=FCellBorderStyle, write=SetCellBorderStyle, default=1};
	__property int VRuleWidth = {read=FVRuleWidth, write=SetVRuleWidth, default=0};
	__property Graphics::TColor VRuleColor = {read=FVRuleColor, write=SetVRuleColor, default=-16777208};
	__property int HRuleWidth = {read=FHRuleWidth, write=SetHRuleWidth, default=0};
	__property Graphics::TColor HRuleColor = {read=FHRuleColor, write=SetHRuleColor, default=-16777208};
	__property int CellVSpacing = {read=FCellVSpacing, write=SetCellVSpacing, default=2};
	__property int CellHSpacing = {read=FCellHSpacing, write=SetCellHSpacing, default=2};
	__property bool VOutermostRule = {read=FVOutermostRule, write=SetVOutermostRule, default=0};
	__property bool HOutermostRule = {read=FHOutermostRule, write=SetHOutermostRule, default=0};
	__property TRVCellEditingEvent OnCellEditing = {read=FOnCellEditing, write=FOnCellEditing};
	__property TRVCellEndEditEvent OnCellEndEdit = {read=FOnCellEndEdit, write=FOnCellEndEdit};
	__property TRVTableDrawBorderEvent OnDrawBorder = {read=FOnDrawBorder, write=FOnDrawBorder};
};


class DELPHICLASS TRVTableStoreSubRVData;
class PASCALIMPLEMENTATION TRVTableStoreSubRVData : public Rvitem::TRVStoreSubRVData 
{
	typedef Rvitem::TRVStoreSubRVData inherited;
	
public:
	int Row;
	int Col;
	__fastcall TRVTableStoreSubRVData(int ARow, int ACol);
	DYNAMIC Rvitem::TRVStoreSubRVData* __fastcall Duplicate(void);
	DYNAMIC int __fastcall Compare(Rvitem::TRVStoreSubRVData* StoreSub);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TRVTableStoreSubRVData(void) { }
	#pragma option pop
	
};


class DELPHICLASS TRVTablePrintInfo;
class PASCALIMPLEMENTATION TRVTablePrintInfo : public Ptrvdata::TRVMultiDrawItemInfo 
{
	typedef Ptrvdata::TRVMultiDrawItemInfo inherited;
	
private:
	Rvstyle::TRVScreenAndDevice sad;
	TRVTableItemInfo* FTable;
	int FHeadingRowCount;
	void __fastcall AddFootnotes(Ptrvdata::TRVFootnoteRefList* &FootnoteRVDataList, int &Height, bool FootnotesChangeHeight, int RowCount);
	void __fastcall RemoveFootnotes(Ptrvdata::TRVFootnoteRefList* &FootnoteRVDataList, int &Height, bool FootnotesChangeHeight, int RowCount);
	void __fastcall DecHeightByFootnotes_(int &Height, bool &ThisPageHasFootnotes, int RowCount);
	
public:
	TRVTableItemFormattingInfo* Fmt;
	__fastcall TRVTablePrintInfo(TRVTableItemInfo* ATable);
	virtual void __fastcall SetSize(int AWidth, int AHeight);
	__fastcall virtual ~TRVTablePrintInfo(void);
	DYNAMIC bool __fastcall InitSplit(const Rvstyle::TRVScreenAndDevice &Sad);
	DYNAMIC bool __fastcall CanSplitFirst(int Y, const Rvstyle::TRVScreenAndDevice &Sad, bool FirstOnPage, bool PageHasFootnotes, bool FootnotesChangeHeight);
	DYNAMIC bool __fastcall SplitAt(int Y, const Rvstyle::TRVScreenAndDevice &Sad, bool FirstOnPage, Classes::TList* &FootnoteRVDataList, int &MaxHeight, bool FootnotesChangeHeight);
	DYNAMIC void __fastcall ResetPages(Ptrvdata::TRVFootnoteRefList* &FootnoteRVDataList, int &ReleasedHeightAfterFootnotes, bool FootnotesChangeHeight);
	DYNAMIC void __fastcall UnformatLastPage(Ptrvdata::TRVFootnoteRefList* &FootnoteRVDataList, int &ReleasedHeightAfterFootnotes, bool FootnotesChangeHeight);
	DYNAMIC void __fastcall AddAllFootnotes(Ptrvdata::TRVFootnoteRefList* &FootnoteRVDataList, int &Height, bool FootnotesChangeHeight);
	DYNAMIC void __fastcall RemoveAllFootnotes(Ptrvdata::TRVFootnoteRefList* &FootnoteRVDataList, int &Height, bool FootnotesChangeHeight);
	DYNAMIC void __fastcall DecHeightByFootnotes(int &Height, bool &ThisPageHasFootnotes);
public:
	#pragma option push -w-inl
	/* TRVDrawLineInfo.CreateEx */ inline __fastcall TRVTablePrintInfo(int ALeft, int ATop, int AWidth, int AHeight, int AItemNo, Byte AFromNewLine) : Ptrvdata::TRVMultiDrawItemInfo(ALeft, ATop, AWidth, AHeight, AItemNo, AFromNewLine) { }
	#pragma option pop
	
};


class DELPHICLASS ERVTableInplaceError;
class PASCALIMPLEMENTATION ERVTableInplaceError : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	#pragma option push -w-inl
	/* Exception.Create */ inline __fastcall ERVTableInplaceError(const AnsiString Msg) : Sysutils::Exception(Msg) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall ERVTableInplaceError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall ERVTableInplaceError(int Ident)/* overload */ : Sysutils::Exception(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall ERVTableInplaceError(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : Sysutils::Exception(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall ERVTableInplaceError(const AnsiString Msg, int AHelpContext) : Sysutils::Exception(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall ERVTableInplaceError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall ERVTableInplaceError(int Ident, int AHelpContext)/* overload */ : Sysutils::Exception(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall ERVTableInplaceError(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : Sysutils::Exception(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~ERVTableInplaceError(void) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------
static const Shortint rvsTable = -60;
static const Shortint crRVSelectRow = 0x68;
static const Shortint crRVSelectCol = 0x69;
#define RVTABLEDEFAULTOPTIONS (Set<TRVTableOption, rvtoEditing, rvtoIgnoreContentHeight> () << rvtoEditing << rvtoRowSizing << rvtoColSizing << rvtoRowSelect << rvtoColSelect )
#define RVTABLEDEFAULTPRINTOPTIONS (Set<TRVTablePrintOption, rvtoHalftoneBorders, rvtoWhiteBackground> () << rvtoHalftoneBorders << rvtoRowsSplit )
extern PACKAGE Graphics::TPenStyle RichViewTableGridStyle;
extern PACKAGE Graphics::TPenStyle RichViewTableGridStyle2;
extern PACKAGE Graphics::TColor RichViewTableGridColor;
extern PACKAGE bool RichViewTableDefaultRTFAutofit;
extern PACKAGE bool RichViewTableAutoAddRow;

}	/* namespace Rvtable */
using namespace Rvtable;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Rvtable
