//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "MainFrm.h"
#include "GifImg.hpp"
#include "PngImage.hpp"


//---------------------------------------------------------------------------
#pragma link "RVEdit"
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma link "RVOfficeCnv"
#pragma link "GifImg"
#pragma link "PngImage"
#pragma resource "*.dfm"




TfrmMain *frmMain;
//---------------------------------------------------------------------------
__fastcall TfrmMain::TfrmMain(TComponent* Owner)
    : TForm(Owner)
{

  RegisterClass(__classid(TGIFImage));
  RegisterClass(__classid(TPngImage));
}
//---------------------------------------------------------------------------
void __fastcall TfrmMain::FormCreate(TObject *Sender)
{
  od->Filter = "RTF (Built-In RichView Import)|*.rtf|"+rvc->GetImportFilter();
  sd->Filter = "RTF (Built-In RichView Export)|*.rtf|"+rvc->GetExportFilter();

  rve->Clear();
  rve->AddNLWTag("This demo shows how to use Microsoft Office text converters.",0,0,0);
  rve->AddNLWTag("First items in filters (file masks) of the file-selection dialogs are RTF import/export "
			"by the component itself. Others use converters.",0,0,0);
  rve->AddNLWTag("For HTML import testing, look at test/test.htm.",0,0,0);
  rve->AddNLWTag("After loading, Ctrl+click any hypertext link to view its target.",0,0,0);
  rve->AddNLWTag("You'll see option for HTML export via converters. You can use it, but native RichView HTML"
			" export gives much better results.",0,0,0);
  rve->Format();
}
//---------------------------------------------------------------------------
void __fastcall TfrmMain::btnOpenClick(TObject *Sender)
{
  if (!od->Execute())
    return;

  rve->Clear();
  rve->Format();
  rve->Update();

  rve->Clear();
  bool r;
  if (od->FilterIndex==1)
    r = rve->LoadRTF(od->FileName);
  else
  {
    pb->Visible = true;
    r = rvc->ImportRV(od->FileName, rve, od->FilterIndex-2);
  }
  if (!r)
	Application->MessageBox(L"Error",L"Error",0);
  pb->Visible = false;
  rve->Format();
  rve->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TfrmMain::btnSaveClick(TObject *Sender)
{
  if (!sd->Execute())
	return;
  pb->Visible = true;
  bool r;
  if (sd->FilterIndex==1)
	r = rve->SaveRTF(sd->FileName,false);
  else
  {
	pb->Visible = true;
	r = rvc->ExportRV(sd->FileName, rve, sd->FilterIndex-2);
  }
  if (!r)
	Application->MessageBox(L"Error",L"Error",0);
  pb->Visible = false;
  rve->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TfrmMain::rvcConverting(TObject *Sender, int Percent)
{
  pb->Position = Percent;
}
//==================== Hypertext ============================================
// We store URLs in tags
void __fastcall TfrmMain::rveReadHyperlink(TCustomRichView *Sender,
	const UnicodeString Target, const UnicodeString Extras, TRVLoadFormat DocFormat,
	int &StyleNo, int &ItemTag, TRVRawByteString &ItemName)
{
  ItemTag = (int)StrNew(Target.c_str());
}
//---------------------------------------------------------------------------
void __fastcall TfrmMain::rveWriteHyperlink(TCustomRichView *Sender, int id,
	TCustomRVData *RVData, int ItemNo, TRVSaveFormat SaveFormat,
	UnicodeString &Target, UnicodeString &Extras)
{
  Target = (wchar_t*)RVData->GetItemTag(ItemNo);
}
//---------------------------------------------------------------------------
void __fastcall TfrmMain::rveJump(TObject *Sender, int id)
{
  int ItemNo;
  TCustomRVFormattedData* RVData;

  rve->GetJumpPointLocation(id, RVData, ItemNo);
  UnicodeString s = (wchar_t*)RVData->GetItemTag(ItemNo);
  Application->MessageBox(s.c_str(), L"Link", MB_OK | MB_ICONINFORMATION);
}
//---------------------------------------------------------------------------
