//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "Demo2Frm.h"
//---------------------------------------------------------------------------
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma resource "*.dfm"
TfrmDemo2 *frmDemo2;
//---------------------------------------------------------------------------
__fastcall TfrmDemo2::TfrmDemo2(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void TfrmDemo2::ChangeBackgroundColor()
{
  cdlg->Color = rvs->Color;
  if (cdlg->Execute())
  {
    rvs->Color = cdlg->Color;
    rv->Invalidate();
  }
}
//---------------------------------------------------------------------------
void TfrmDemo2::ChangeBreakColor(int ItemNo)
{
  unsigned char BreakWidth,BreakWidth2;
  int BreakTag;
  TColor BreakColor;
  TRVBreakStyle BreakStyle;
  rv->GetBreakInfo(ItemNo, BreakWidth, BreakStyle, BreakColor, BreakTag);
  cdlg->Color = BreakColor;
  // RichView has no styles of "breaks", each "break" is individual.
  // So for changing color of all "breaks" with the specified width we need
  // to check the whole document
  if (cdlg->Execute())
  {
    for (int i=0; i<rv->ItemCount; i++)
    {
      if (rv->GetItemStyle(i)==rvsBreak)
      {
        rv->GetBreakInfo(i, BreakWidth2, BreakStyle, BreakColor, BreakTag);
        if (BreakWidth2==BreakWidth)
          rv->SetBreakInfo(i, BreakWidth2, BreakStyle, cdlg->Color, BreakTag);
      }
    }
    rv->Invalidate();
  }
}
//---------------------------------------------------------------------------
void TfrmDemo2::ChangeTextStyle(int StyleNo)
{
  fdlg->Font->Assign(rvs->TextStyles->Items[StyleNo]);
  if (fdlg->Execute())
  {
    rvs->TextStyles->Items[StyleNo]->Assign(fdlg->Font);
    rv->Format();
  }
}
//---------------------------------------------------------------------------
void TfrmDemo2::ChangeHighlightColor(int StyleNo)
{
  cdlg->Color = rvs->TextStyles->Items[StyleNo]->HoverColor;
  if (cdlg->Execute())
    rvs->TextStyles->Items[StyleNo]->HoverColor = cdlg->Color;
}
//---------------------------------------------------------------------------
void __fastcall TfrmDemo2::FormCreate(TObject *Sender)
{
  rv->AddNLWTag("Click on text, line or background to customize",1,1,0);
  rv->AddNLWTag("Right click for menu",1,1,0);
  rv->AddBreakEx(1,rvbsLine,clGreen);
  rv->AddBulletEx("", 0, il, 0);
  rv->AddNLWTag(" - thin line", 0,-1,0);
  rv->AddBulletEx("", 1, il, 0);
  rv->AddNLWTag(" - thick line", 0,-1,0);
  rv->AddBreakEx(2,rvbsLine,clSilver);
  rv->AddNLWTag("", 0,0,0);
  rv->AddNLWTag("This is a normal text with ", 0,0,0);
  rv->AddNLWTag("hypertext link",2,-1,0);
  rv->AddNLWTag(".",0,-1,0);
  rv->AddNLWTag("", 0,0,0);
  rv->AddNLWTag("This is a bottom text ", 3,0,0);
  rv->AddBreakEx(1,rvbsLine,clGreen);
  rv->AddNLWTag("ESC closes window",1,1,0);
  rv->Format();
}
//---------------------------------------------------------------------------
void __fastcall TfrmDemo2::FormKeyDown(TObject *Sender, WORD &Key,
	TShiftState Shift)
{
  if (Key==VK_ESCAPE)
	Close();
}
//---------------------------------------------------------------------------
void __fastcall TfrmDemo2::rvRVMouseDown(TCustomRichView *Sender,
	TMouseButton Button, TShiftState Shift, int ItemNo, int X, int Y)
{
  if (Button!=mbLeft)
	return;
  if (ItemNo==-1)
  {
	ChangeBackgroundColor();
	return;
  }
  int StyleNo = rv->GetItemStyle(ItemNo);
  switch (StyleNo)
  {
	case rvsBullet:
	  Application->MessageBox(L"This is just a pointer to 'break'", L"Bullet",
		MB_OK | MB_ICONINFORMATION);
	  break;
	case rvsBreak:
	  ChangeBreakColor(ItemNo);
	  break;
	default:
	  ChangeTextStyle(StyleNo);
	  break;
  }
}
//---------------------------------------------------------------------------
void __fastcall TfrmDemo2::rvRVMouseUp(TCustomRichView *Sender,
	TMouseButton Button, TShiftState Shift, int ItemNo, int X, int Y)
{
  if (Button!=mbRight)
	return;
  pm->Tag = ItemNo;
  int StyleNo = 0; // avoiding warning
  if (ItemNo!=-1)
	StyleNo = rv->GetItemStyle(ItemNo);
  mitBack->Visible  = (ItemNo==-1);
  mitBreak->Visible = (ItemNo>=0 && StyleNo==rvsBreak);
  mitText->Visible  = (ItemNo>=0 && StyleNo>=0);
  mitHighlight->Visible = (mitText->Visible && rvs->TextStyles->Items[StyleNo]->Jump);
  TPoint p = rv->ClientToScreen(Point(X,Y));
  pm->Popup(p.x,p.y);
}
//---------------------------------------------------------------------------
void __fastcall TfrmDemo2::mitBackClick(TObject *Sender)
{
  ChangeBackgroundColor();
}
//---------------------------------------------------------------------------
void __fastcall TfrmDemo2::mitBreakClick(TObject *Sender)
{
  ChangeBreakColor(pm->Tag);
}
//---------------------------------------------------------------------------
void __fastcall TfrmDemo2::mitTextClick(TObject *Sender)
{
  ChangeTextStyle(rv->GetItemStyle(pm->Tag));
}
//---------------------------------------------------------------------------
void __fastcall TfrmDemo2::mitHighlightClick(TObject *Sender)
{
  ChangeHighlightColor(rv->GetItemStyle(pm->Tag));
}
//---------------------------------------------------------------------------
