//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "Demo1Frm.h"
#include "MainFrm.h"
//---------------------------------------------------------------------------
#pragma link "RichView"
#pragma link "RVScroll"
#pragma resource "*.dfm"
TfrmDemo1 *frmDemo1;
//---------------------------------------------------------------------------
__fastcall TfrmDemo1::TfrmDemo1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TfrmDemo1::FormCreate(TObject *Sender)
{
  TSearchRec SearchRec;
  lst->Items->BeginUpdate();
  rv->AddNLWTag("When you scroll this document to some file, the corresponding item in "
	"the left list box is highlighted.",sncomHeading,0,0);
  rv->AddNLWTag("Double-click on the listbox to scroll to the file.",
	sncomHeading,0,0);
  rv->AddNLWTag("Right-click to show/hide 'checkpoints'.",
	sncomHeading,0,0);
  if (FindFirst(ExtractFilePath(Application->ExeName)+L"..\\*.cpp", 0, SearchRec) == 0)
	do
	{
	  lst->Items->Add(SearchRec.Name);
	  // Marking next added item with checkpoint
	  rv->AddNamedCheckpointEx(SearchRec.Name, True);
	  // Adding name of file
	  rv->AddNLWTag(SearchRec.Name,sncomKeyword,3,0);
	  // Adding text from file.
	  // Last parameter = True, so all text will be loaded as one
	  // paragraph, and displayed in the single frame
	  rv->LoadText(ExtractFilePath(Application->ExeName)+L"..\\"+SearchRec.Name, sncomNormal, 2, true);
	} while (FindNext(SearchRec)==0);
  FindClose(SearchRec);
  lst->Items->EndUpdate();
  rv->Format();
}
//---------------------------------------------------------------------------
void __fastcall TfrmDemo1::rvCheckpointVisible(TCustomRichView *Sender,
	TCheckpointData CheckpointData)
{
  if (!CheckpointData)
	lst->ItemIndex = -1;
  else
	lst->ItemIndex = rv->GetCheckpointNo(CheckpointData);
}
//---------------------------------------------------------------------------
void __fastcall TfrmDemo1::lstDblClick(TObject *Sender)
{
  if (lst->ItemIndex!=-1)
	rv->ScrollTo(rv->GetCheckpointY(lst->ItemIndex));
}
//---------------------------------------------------------------------------
void __fastcall TfrmDemo1::FormKeyDown(TObject *Sender, WORD &Key,
	TShiftState Shift)
{
  if (Key==VK_ESCAPE)
	Close();
}
//---------------------------------------------------------------------------
void __fastcall TfrmDemo1::pmPopup(TObject *Sender)
{
  mitShowCP->Checked = rv->Options.Contains(rvoShowCheckpoints);
}
//---------------------------------------------------------------------------
void __fastcall TfrmDemo1::mitShowCPClick(TObject *Sender)
{
  if (rv->Options.Contains(rvoShowCheckpoints))
	rv->Options >> rvoShowCheckpoints;
  else
	rv->Options << rvoShowCheckpoints;
  rv->Invalidate();
}
//---------------------------------------------------------------------------