/*==============================================================================

  This demo shows how to implement listbox-like selection using hypertext.
  Property settings:
  - rvoTagsArePChars is included in rv->Options
  - rvoAllowSelection is excluded from rv->Options
  - rv->TabNavigation = rvtnNone
  - rv->Style = RVStyle1
  - 3 text styles are created in RVStyle->TextStyles
    TextStyles->Items[0] - normal text
    TextStyles->Items[1] - hypertext
    TextStyles->Items[2] - hypertext with background

  NOTE: This demo is a bit overcomplicated.
    If you do not use tables (TRVTableItemInfo), you do not need to
    work with RVData variables (because documents without tables
    have only one RVData - rv->RVData)
  NOTE2: phonebook can be saved (rv->SaveRVFFromFile())
    and loaded (rv->LoadRVFFromFile()). In order to load bullets (images with phones),
    process OnRVFImageListNeeded.

{=============================================================================*/
#include <vcl\vcl.h>
#pragma hdrstop

#include "Unit1.h"
#include "Unit2.h"
//---------------------------------------------------------------------------
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
#define TEXTSTYLE_NOTMALTEXT  0
#define TEXTSTYLE_JUMP        1
#define TEXTSTYLE_SELECTED    2

int TForm1::MakeTag(UnicodeString s)
{
  return (int)StrNew(s.w_str());
}
//---------------------------------------------------------------------------
UnicodeString TForm1::GetTagStr(int tag)
{
  // reverse function
  UnicodeString Result = (wchar_t*)tag;
  for (int i=1; i<=Result.Length(); i++)
    if (Result[i]==1)
      Result[i] = ' ';
  return Result;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  rv->AddNLWTag("Telephone directory:",0,0,0);
  rv->AddBulletEx("",0, ImageList1, 0);
  rv->AddNLWTag("Kim Lumber",TEXTSTYLE_JUMP, -1, MakeTag("123-4567"));
  rv->AddBulletEx("",0, ImageList1, 0);
  rv->AddNLWTag("Phil Forest",TEXTSTYLE_JUMP, -1, MakeTag("234-5678"));
  rv->AddBulletEx("",0, ImageList1, 0);
  rv->AddNLWTag("Woody Young",TEXTSTYLE_JUMP, -1, MakeTag("345-6789"));
  rv->Format();
}
//---------------------------------------------------------------------------
void TForm1::Select(TCustomRVFormattedData* RVData, int ItemNo)
{
  if (FSelectedRVData && FSelectedRVData==RVData && FSelectedItemNo==ItemNo)
  {
    Button2->Click();
    return;
  }
  if (FSelectedRVData)
    FSelectedRVData->GetItem(FSelectedItemNo)->StyleNo = TEXTSTYLE_JUMP;
  if (RVData)
  {
    Edit1->Text = GetTagStr(RVData->GetItemTag(ItemNo));
    RVData->GetItem(ItemNo)->StyleNo = TEXTSTYLE_SELECTED;
  }
  FSelectedRVData = RVData;
  FSelectedItemNo = ItemNo;
  rv->Refresh();
  /*
   In this demo, two text styles (TEXTSTYLE_SELECTED and TEXTSTYLE_JUMP)
   have difference only in colors.
   But if they had different font name/size/style, or different jump flag,
   Refresh() would be not enough - change this line to rv->Format();
  */
}
//---------------------------------------------------------------------------
void __fastcall TForm1::rvJump(TObject *Sender, int id)
{
  TCustomRVFormattedData* RVData;
  int ItemNo;
  rv->GetJumpPointLocation(id, RVData, ItemNo);
  Select(RVData, ItemNo);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  Form2->Edit1->Text = "";
  Form2->Edit2->Text = "";
  if (Form2->ShowModal()==mrOk)
  {
    rv->AddBulletEx("",0, ImageList1, 0);
    rv->AddNLWTag(Form2->Edit1->Text ,TEXTSTYLE_JUMP, -1, MakeTag(Form2->Edit2->Text));
    rv->FormatTail();
    Select(rv->RVData, rv->ItemCount-1);
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button2Click(TObject *Sender)
{
  if (FSelectedRVData==NULL)
  {
    MessageBeep(0);
    return;
  }
  Form2->Edit1->Text = FSelectedRVData->GetItemTextW(FSelectedItemNo);
  Form2->Edit2->Text = GetTagStr(FSelectedRVData->GetItemTag(FSelectedItemNo));
  if (Form2->ShowModal()==mrOk)
  {
    FSelectedRVData->SetItemTextW(FSelectedItemNo, Form2->Edit1->Text);
    FSelectedRVData->SetItemTag(FSelectedItemNo, MakeTag(Form2->Edit2->Text));
    rv->Format();
    Edit1->Text = Form2->Edit2->Text;
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button3Click(TObject *Sender)
{
  if (FSelectedRVData==NULL)
  {
    MessageBeep(0);
    return;
  }
  TCustomRVFormattedData* RVData = FSelectedRVData;
  int ItemNo                     = FSelectedItemNo;
  Select(NULL, -1);
  RVData->DeleteItems(ItemNo-1, 2); // deleting two items: image and text
  rv->Format();
  Edit1->Text = "";
}
//---------------------------------------------------------------------------
