unit ForceHyperText;

interface
uses Classes, RVStyle,RVItem, CRVFData, Forms, RichView;

var SimpleClickHypertext: Boolean = False;

type
  TRVTextItemInfoEx = class (TRVTextItemInfo)
    private
    public
      function MouseMove(Shift: TShiftState; X,Y, ItemNo: Integer; RVData: TObject):Boolean; override;
  end;

implementation

uses Graphics;

{ TRVTextItemInfoEx }

// return value: cursor is changed
function TRVTextItemInfoEx.MouseMove(Shift: TShiftState; X, Y,
  ItemNo: Integer; RVData: TObject): Boolean;
var RVStyle: TRVStyle;
begin
  Result := inherited MouseMove(Shift, X, Y, ItemNo, RVData);
  if SimpleClickHypertext then begin
    RVStyle := TCustomRVFormattedData(RVData).GetRVStyle;
    Result := GetBoolValueEx(rvbpJump, RVStyle);
    if Result then
      TCustomRVFormattedData(RVData).SetCursor(GetHypertextCursor(RVStyle));
  end;
end;

initialization
  RichViewTextItemClass := TRVTextItemInfoEx;

end.
