;NSIS Modern User Interface version 1.63

;
!packhdr tmp.dat "C:\Progra~1\UPX\upx.exe -9 tmp.dat"

!define MUI_PRODUCT "MouseImp Pro Live!"
!define VER_MAJOR 0
!define VER_MINOR 0
!define MUI_VERSION "${VER_MAJOR}.${VER_MINOR}"
!define MUI_BRANDINGTEXT "${MUI_PRODUCT} v${VER_MAJOR}.${VER_MINOR}"

;  .     Install
!define SRC_PATH "..\Release\"

CRCCheck On

!define APP_REG_KEY_PARENT "TV4 Studios"
!define APP_REG_KEY "${APP_REG_KEY_PARENT}\MImpPro"

!define WEB_LINK "http://www.cooler.it/mouseimp/"
!define PUBLISHER "MouseImp Pro Live! Team"

!include "MUI.nsh"
!include "Sections.nsh"
  
;--------------------------------
;Configuration

; Adds an XP manifest to the installer
  XPStyle on

  ;General
  OutFile "MIProLive.exe"

  ;Folder selection page
  InstallDir "$PROGRAMFILES\${MUI_PRODUCT}"
  
  ;Remember install folder
  InstallDirRegKey HKCU "SOFTWARE\${APP_REG_KEY}" ""

  ShowInstDetails show
  ShowUninstDetails show

;--------------------------------
;Modern UI Configuration

  !define MUI_WELCOMEPAGE
  !define MUI_LICENSEPAGE
  !define MUI_COMPONENTSPAGE
  !define MUI_COMPONENTSPAGE_SMALLDESC  
  !define MUI_DIRECTORYPAGE
  !define MUI_FINISHPAGE
  !define MUI_FINISHPAGE_RUN "$INSTDIR\MIProCfg.exe"
  
  !define MUI_ABORTWARNING
  
  !define MUI_UNINSTALLER
  !define MUI_UNCONFIRMPAGE
;        :)
  !define MUI_CHECKBITMAP "${SRC_PATH}..\Install\MImpProLiveCheck.bmp"

;--------------------------------
;Images

;  !define MUI_HEADERBITMAP "${NSISDIR}\Contrib\Icons\modern-header 2.bmp"
  !define MUI_HEADERBITMAP "${SRC_PATH}..\Install\MImpProLiveHeader.bmp"
  !define MUI_SPECIALBITMAP "${SRC_PATH}..\MImpCfg\res\title.bmp"

;--------------------------------
;Interface settings

!define MUI_ICON  "${SRC_PATH}..\MouseImp\res\MImpCfg.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Icons\normal-uninstall.ico"
;!define MUI_UNICON "${NSISDIR}\Contrib\Icons\modern-uninstall.ico"

;--------------------------------
;Languages
  !insertmacro MUI_LANGUAGE "English" 
  !insertmacro MUI_LANGUAGE "Russian"  

;--------------------------------
;Language Strings

  LangString DESC_SecCore ${LANG_ENGLISH} "${MUI_PRODUCT} itself :)"
  LangString DESC_SecCore ${LANG_RUSSIAN} " ${MUI_PRODUCT} :)"

  LangString DESCR_SecCore ${LANG_ENGLISH} "The core files required to use ${MUI_PRODUCT}"
  LangString DESCR_SecCore ${LANG_RUSSIAN} ",    ${MUI_PRODUCT}"

  LangString DESC_SecIcons ${LANG_ENGLISH} "Start Menu and Desktop Shortcuts"
  LangString DESC_SecIcons ${LANG_RUSSIAN} "      "

  LangString DESCR_SecIcons ${LANG_ENGLISH} "Adds icons to your start menu and your desktop for easy access"
  LangString DESCR_SecIcons ${LANG_RUSSIAN} "           "

  LangString DESC_SecSMIcons ${LANG_ENGLISH} "Start Menu Shortcuts"
  LangString DESC_SecSMIcons ${LANG_RUSSIAN} "   "

  LangString DESCR_SecSMIcons ${LANG_ENGLISH} "Adds icons to your start menu for easy access"
  LangString DESCR_SecSMIcons ${LANG_RUSSIAN} "       "

  LangString DESC_SecDSIcons ${LANG_ENGLISH} "Desktop Shortcuts"
  LangString DESC_SecDSIcons ${LANG_RUSSIAN} "   "

  LangString DESCR_SecDSIcons ${LANG_ENGLISH} "Adds an icon to your desktop for easy access"
  LangString DESCR_SecDSIcons ${LANG_RUSSIAN} "       "

  LangString DESC_SecDocs ${LANG_ENGLISH} "Help file"
  LangString DESC_SecDocs ${LANG_RUSSIAN} " "

  LangString DESCR_SecDocs ${LANG_ENGLISH} "Adds Help file"
  LangString DESCR_SecDocs ${LANG_RUSSIAN} "  "

  LangString DESC_SecAplet ${LANG_ENGLISH} "Control Panel Applet"
  LangString DESC_SecAplet ${LANG_RUSSIAN} "  "

  LangString DESCR_SecAplet ${LANG_ENGLISH} "Adds applet to Control Panel for easy access"
  LangString DESCR_SecAplet ${LANG_RUSSIAN} "      "

  LangString DTL_Closing ${LANG_ENGLISH} "Closing existing instances..."
  LangString DTL_Closing ${LANG_RUSSIAN} "  ..."

  LangString un.MSG_UNREBOOT ${LANG_ENGLISH} "Some files are in use and will be deleted after rebooting.$\r$\n$\r$\n Click YES to rebooting, or NO to exit."
  LangString un.MSG_UNREBOOT ${LANG_RUSSIAN} "        .$\r$\n$\r$\n  Yes       No  ."

  LangString un.MSG_DELSETTINGS ${LANG_ENGLISH} "Delete your current ${MUI_PRODUCT} configuration from registry? (You will loose options and productivity statistics)"
  LangString un.MSG_DELSETTINGS ${LANG_RUSSIAN} "  ${MUI_PRODUCT}  ? (   )"

;--------------------------------
;Data

  LicenseData /LANG=${LANG_ENGLISH} "${SRC_PATH}License.txt"
  LicenseData /LANG=${LANG_RUSSIAN} "${SRC_PATH}License_rus.txt"

;--------------------------------
;Reserve Files

  ;Things that need to be extracted on first (keep these lines before any File command!)
  ;Only useful for BZIP2 compression
  ;!insertmacro MUI_RESERVEFILE_WELCOMEFINISHPAGE

;--------------------------------
;Installer Sections

Section "!$(DESC_SecCore)" SecCore
  SectionIn 1 RO
  SetOutPath $INSTDIR

  SetOverwrite on

  ; 
  DetailPrint "$(DTL_Closing)"
  Push "MImpProWndTitle"
  Call CloseProgram
  Push "MouseImp PRO Control"
  Call CloseProgram

  File "${SRC_PATH}MIPro.dll.new"
  File "${SRC_PATH}MIProCfg.exe"
  File "${SRC_PATH}MIProHst.exe"
  File "${SRC_PATH}License.txt"
  File "${SRC_PATH}License_rus.txt"
  File "${SRC_PATH}MIProCfg.exe.manifest"

;Rename   overwrite
  Delete "$INSTDIR\MIPro.dll.del"
  Rename "$INSTDIR\MIPro.dll" "$INSTDIR\MIPro.dll.del"
  Delete /REBOOTOK "$INSTDIR\MIPro.dll.del"
  Delete "$INSTDIR\MIPro.dll"
  Rename "$INSTDIR\MIPro.dll.new" "$INSTDIR\MIPro.dll"
;     MIPro.dll.new
  SetRebootFlag false
  IfFileExists "$INSTDIR\MIPro.dll.new" "" +2
    SetRebootFlag true
    
SectionEnd

Section "$(DESC_SecDocs)" SecDocs
  SectionIn 1
  SetOutPath $INSTDIR
  SetOverwrite on
  File "${SRC_PATH}..\Help\MImpPro.chm"
SectionEnd

SubSection /e "$(DESC_SecIcons)" SecIcons

Section "$(DESC_SecSMIcons)" SecSMIcons
  SectionIn 1
  SetOutPath $INSTDIR
  CreateDirectory "$SMPROGRAMS\${MUI_PRODUCT}"

  IfFileExists "$INSTDIR\MIProCfg.exe" "" +2
    CreateShortCut "$SMPROGRAMS\${MUI_PRODUCT}\${MUI_PRODUCT} Configuration.lnk" "$INSTDIR\MIProCfg.exe" ""

  IfFileExists "$INSTDIR\MImpPro.chm" "" +2
    CreateShortCut "$SMPROGRAMS\${MUI_PRODUCT}\${MUI_PRODUCT} Help.lnk" "$INSTDIR\MImpPro.chm" ""

  IfFileExists "$INSTDIR\MIProHst.exe" "" +2
    CreateShortCut "$SMPROGRAMS\${MUI_PRODUCT}\${MUI_PRODUCT}.lnk" "$INSTDIR\MIProHst.exe" ""

  WriteINIStr "$SMPROGRAMS\${MUI_PRODUCT}\${MUI_PRODUCT} Official Site.url" "InternetShortcut" "URL" "${WEB_LINK}"
  CreateShortCut "$SMPROGRAMS\${MUI_PRODUCT}\Uninstall ${MUI_PRODUCT}.lnk" "$INSTDIR\Uninstall.exe"

  IfFileExists "$INSTDIR\License.txt" "" +2
    CreateShortCut "$SMPROGRAMS\${MUI_PRODUCT}\License agreement.lnk" "$INSTDIR\License.txt" ""

SectionEnd

Section "$(DESC_SecDSIcons)" SecDSIcons
  SectionIn 1
  IfFileExists "$INSTDIR\MIProHst.exe" "" +2
    CreateShortCut "$DESKTOP\${MUI_PRODUCT}.lnk" "$INSTDIR\MIProHst.exe" ""

SectionEnd

SubSectionEnd

Section "$(DESC_SecAplet)" SecAplet
  SectionIn 1
  SetOutPath $SYSDIR
  SetOverwrite on
  File "${SRC_PATH}MIProCpl.cpl"
SectionEnd

Section -post
  SetOutPath $INSTDIR

  WriteRegStr HKCU "SOFTWARE\${APP_REG_KEY}" "" $INSTDIR
  WriteRegExpandStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${MUI_PRODUCT}" "UninstallString" "$INSTDIR\Uninstall.exe"
  WriteRegExpandStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${MUI_PRODUCT}" "InstallLocation" "$INSTDIR"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${MUI_PRODUCT}" "DisplayName" "${MUI_PRODUCT}"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${MUI_PRODUCT}" "DisplayIcon" "$INSTDIR\MIProHst.exe,0"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${MUI_PRODUCT}" "DisplayVersion" "${MUI_VERSION}"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${MUI_PRODUCT}" "Publisher" "${PUBLISHER}"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${MUI_PRODUCT}" "HelpLink" "${WEB_LINK}"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${MUI_PRODUCT}" "URLInfoAbout" "${WEB_LINK}"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${MUI_PRODUCT}" "URLUpdateInfo" "${WEB_LINK}"

  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${MUI_PRODUCT}" "VersionMajor" "${VER_MAJOR}"
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${MUI_PRODUCT}" "VersionMinor" "${VER_MINOR}"
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${MUI_PRODUCT}" "NoModify" "1"
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${MUI_PRODUCT}" "NoRepair" "1"

  Delete "$INSTDIR\Uninstall.exe"
  WriteUninstaller "$INSTDIR\Uninstall.exe"

SectionEnd

;--------------------------------
;Initialization

Function .onInit

  !insertmacro MUI_LANGDLL_DISPLAY

;SecDSIcons   
  SectionGetFlags ${SecDSIcons} $0
  IntOp $0 $0 & ${SECTION_OFF}
  SectionSetFlags ${SecDSIcons} $0

  SetAutoClose false

FunctionEnd

;--------------------------------
;Descriptions

!insertmacro MUI_FUNCTIONS_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SecCore} $(DESCR_SecCore)
  !insertmacro MUI_DESCRIPTION_TEXT ${SecIcons} $(DESCR_SecIcons)
  !insertmacro MUI_DESCRIPTION_TEXT ${SecSMIcons} $(DESCR_SecSMIcons)
  !insertmacro MUI_DESCRIPTION_TEXT ${SecDSIcons} $(DESCR_SecDSIcons)
  !insertmacro MUI_DESCRIPTION_TEXT ${SecDocs} $(DESCR_SecDocs)
  !insertmacro MUI_DESCRIPTION_TEXT ${SecAplet} $(DESCR_SecAplet)
!insertmacro MUI_FUNCTIONS_DESCRIPTION_END

;--------------------------------
;Uninstaller Section

Section "Uninstall"

; MIProHst.exe, MIProCfg.exe
  Push "MImpProWndTitle"
  Call un.CloseProgram
  Push "MouseImp PRO Control"
  Call un.CloseProgram

  Delete /REBOOTOK "$INSTDIR\MIPro.dll.del"
  Delete /REBOOTOK "$INSTDIR\MIPro.dll.new"
  Delete /REBOOTOK "$INSTDIR\MIPro.dll"
  Delete /REBOOTOK "$INSTDIR\MIProCfg.exe"
  Delete /REBOOTOK "$INSTDIR\MIProHst.exe"
  Delete /REBOOTOK "$SYSDIR\MIProCpl.cpl"
  Delete /REBOOTOK "$INSTDIR\License.txt"
  Delete /REBOOTOK "$INSTDIR\License_rus.txt"
  Delete /REBOOTOK "$INSTDIR\MImpPro.chm"
  Delete /REBOOTOK "$INSTDIR\MIProCfg.exe.manifest"
  Delete /REBOOTOK "$INSTDIR\Uninstall.exe"
  
  RMDir "$INSTDIR"

  RMDir /r "$SMPROGRAMS\${MUI_PRODUCT}"
  Delete "$DESKTOP\${MUI_PRODUCT}.lnk"

  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${MUI_PRODUCT}"

  DeleteRegKey HKCU "Software\Microsoft\Windows\CurrentVersion\Run\MImpPro"

  !insertmacro MUI_UNFINISHHEADER

  MessageBox MB_YESNO|MB_ICONINFORMATION $(un.MSG_DELSETTINGS) IDNO nodelreg
    DeleteRegKey HKCU "Software\${APP_REG_KEY}"
    DeleteRegKey /ifempty HKCU "Software\${APP_REG_KEY_PARENT}"
  nodelreg:

  IfRebootFlag "" done
    MessageBox MB_YESNO|MB_ICONINFORMATION $(un.MSG_UNREBOOT) IDNO done
      Reboot

  done:
SectionEnd

;----------------------------
;Functions

;!include WinMessage.nsh

Function CloseProgram
;  ,  $1
  Exch $1
;  $0, $2
  Push $0
  Push $2
; $2 = 0
  IntOp $2 0 & 0
  loop:
;  
    FindWindow $0 "" $1
;  ,   Ok
    IntCmp $0 0 done
;  
    SendMessage $0 ${WM_CLOSE} 0 0
    Sleep 100
;    10 ,    -  
    IntCmp $2 100 done
; 
    Goto loop
  done:
;  
  Pop $2
  Pop $0
  Pop $1
FunctionEnd

;     uninstall' ( NSIS!)
Function un.CloseProgram
  Exch $1
  Push $0
  Push $2
  IntOp $2 0 & 0
  loop:
    FindWindow $0 "" $1
    IntCmp $0 0 done
    SendMessage $0 ${WM_CLOSE} 0 0
    Sleep 100
    IntCmp $2 100 done
    Goto loop
  done:
  Pop $2
  Pop $0
  Pop $1
FunctionEnd
