use perlchartdir;

sub background
{
	my ($img, $filename) = @_;

	#data for chart
	my $data = [85, 156, 179.5, 211, 123];
	my $labels = ["Mon", "Tue", "Wed", "Thu", "Fri"];

	#create a chart object of 300(w) x 300(h) 
	my $c = new XYChart(300, 300);

	if ($img) {
		#has wallpaper image, use it as background
		$c->setWallpaper($img);
	}
	else {
		#no wallpaper image, use a dark background palette
		$c->setColors($perlchartdir::whiteOnBlackPalette);
	}
	
	#set the plot area to start at (50, 50) and of size 200(w) x 200(h)
	$c->setPlotArea(50, 50, 200, 200);

	#Set the labels on the x axis using the supplied labels
	$c->xAxis()->setLabels($labels);

	#Add a 3D bar layer using the supplied data
	$c->addBarLayer($data, 0x00ff00)->set3D();

	#output the chart
	$c->makeChart($filename);
}


background("tile.gif", "imgbg.png");
background("", "darkbg.png");

    