/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Insets;
import java.util.Vector;
import symantec.beans.Beans;
import symantec.itools.awt.BaseTabbedPanel;

public class TabPanel
extends BaseTabbedPanel {
    Vector vPanels = new Vector();
    String[] labels;
    boolean bOsHack;

    public TabPanel() {
        this(0, 0);
    }

    public TabPanel(boolean bTabsOnTop) {
        this(bTabsOnTop ? 0 : 1, bTabsOnTop ? 0 : 1);
    }

    public TabPanel(int tabsPostion, int tabsStyle) {
        super(tabsPostion, tabsStyle);
        String sOS = System.getProperty("os.name");
        if (sOS.equals("Windows 95")) {
            this.bOsHack = true;
            return;
        }
        this.bOsHack = false;
    }

    public int addTabPanel(String sLabel, boolean bEnabled, Component panel) {
        this.vPanels.addElement(panel);
        return this.addTab(sLabel, bEnabled);
    }

    public int getCurrentPanelNdx() {
        return this.curIndex;
    }

    public void setCurrentPanelNdx(int index) {
        this.showTabPanel(index);
        if (!Beans.isDesignTime()) {
            this.curIndex = index;
        }
    }

    public Component add(Component comp) {
        return this.add(comp, -1);
    }

    private String createDefaultLabel(int i) {
        String name = "tab - ";
        name = String.valueOf(name) + String.valueOf(i);
        return name;
    }

    public synchronized Component add(Component comp, int pos) {
        int newIndex = this.addTabPanel(this.createDefaultLabel(this.vPanels.size()), true, comp);
        if (newIndex == this.curIndex || Beans.isDesignTime()) {
            this.showTabPanel(newIndex);
        }
        this.updatePanelLabels();
        return comp;
    }

    public synchronized Component add(String name, Component comp) {
        return comp;
    }

    public synchronized void remove(Component comp) {
        int i = this.getPanelTabIndex(comp);
        if (this.countTabs() == 1) {
            this.removeAllTabPanels();
            return;
        }
        if (i == 0) {
            this.showTabPanel(1);
        } else {
            this.showTabPanel(i - 1);
        }
        this.removeTabPanel(i);
    }

    public void setPanelLabels(String[] sLabels) {
        this.labels = sLabels;
        this.updatePanelLabels();
    }

    public String[] getPanelLabels() {
        return this.labels;
    }

    public void updatePanelLabels() {
        try {
            int i = 0;
            while (i < this.vPanels.size()) {
                String newlabel;
                if (this.labels != null) {
                    try {
                        newlabel = this.labels[i];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        newlabel = this.createDefaultLabel(i);
                    }
                } else {
                    newlabel = this.createDefaultLabel(i);
                }
                this.setLabel(newlabel, i);
                ++i;
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public void setTabsOnBottom(boolean bTabsOnBottom) {
        this.setTabsInfo(bTabsOnBottom ? 1 : 0, bTabsOnBottom ? 1 : 0);
        this.layout();
    }

    public boolean getTabsOnBottom() {
        return this.getTabsPosition() != 0;
    }

    public synchronized void setTabPanel(String sLabel, boolean bEnabled, Component panel, int index) {
        if (index < 0 || index >= this.vPanels.size()) {
            return;
        }
        if (index == this.currentTabIndex() && !bEnabled) {
            return;
        }
        try {
            this.vPanels.setElementAt(panel, index);
            this.setTab(sLabel, bEnabled, index);
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    public synchronized Component getTabPanel(int index) {
        if (index < 0 || index >= this.vPanels.size()) {
            return null;
        }
        Component p = null;
        try {
            p = (Component)this.vPanels.elementAt(index);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return p;
    }

    public synchronized int getPanelTabIndex(Component panel) {
        return this.vPanels.indexOf(panel);
    }

    public synchronized void showTabPanel(int index) {
        if (this.tabIsEnabled(index)) {
            try {
                Component p = (Component)this.vPanels.elementAt(index);
                this.showTab(index);
                this.showPanel(p);
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return;
            }
        }
    }

    public synchronized void enableTabPanel(boolean bEnable, int index) {
        if (index < 0 || index >= this.vPanels.size() || index == this.curIndex) {
            return;
        }
        this.enableTab(bEnable, index);
    }

    public synchronized void removeTabPanel(int index) {
        if (index < 0 || index >= this.vPanels.size() || index == this.curIndex) {
            return;
        }
        try {
            Component p = (Component)this.vPanels.elementAt(index);
            super.remove(p);
            this.vPanels.removeElementAt(index);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        this.removeTab(index);
    }

    public synchronized void removeAllTabPanels() {
        this.vPanels = new Vector();
        this.curIndex = -1;
        this.removeAllTabs();
    }

    public int countTabs() {
        return this.vPanels.size();
    }

    public boolean handleEvent(Event evt) {
        switch (evt.id) {
            case 1001: {
                if (!(evt.target instanceof TabPanel) || evt.target != this) break;
                this.showTabPanel(this.currentTabIndex());
                break;
            }
        }
        return super.handleEvent(evt);
    }

    public Dimension preferredSize() {
        Component pan = null;
        Dimension d = null;
        Dimension p = this.size();
        int s = this.vPanels.size();
        Insets insets = this.insets();
        p.width -= insets.left + insets.right;
        p.height -= insets.top + insets.bottom;
        if (p.width < 0) {
            p.width = 0;
        }
        if (p.height < 0) {
            p.height = 0;
        }
        int x = 0;
        while (x < s) {
            pan = (Component)this.vPanels.elementAt(x);
            if (pan != null) {
                d = pan.minimumSize();
                if (d.width > p.width) {
                    p.width = d.width;
                }
                if (d.height > p.height) {
                    p.height = d.height;
                }
                d = pan.preferredSize();
                if (d.width > p.width) {
                    p.width = d.width;
                }
                if (d.height > p.height) {
                    p.height = d.height;
                }
            }
            ++x;
        }
        p.width += insets.left + insets.right;
        p.height += insets.top + insets.bottom;
        return p;
    }

    public Dimension minimumSize() {
        Component pan = null;
        Dimension d = null;
        Dimension m = new Dimension(0, 0);
        int s = this.vPanels.size();
        int x = 0;
        while (x < s) {
            pan = (Component)this.vPanels.elementAt(x);
            if (pan != null) {
                d = pan.minimumSize();
                if (d.width > m.width) {
                    m.width = d.width;
                }
                if (d.height > m.height) {
                    m.height = d.height;
                }
            }
            ++x;
        }
        Insets insets = this.insets();
        m.width += insets.left + insets.right;
        m.height += insets.top + insets.bottom;
        return m;
    }
}

