/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class MovieFinderInstaller {
    String installDir;
    String shortcutDir;
    String desktopDir;
    boolean win = false;
    boolean mac = false;
    boolean otherOS = false;
    FileReader fin;
    String shortcutName = "MovieFinder";
    String settingsFile = "update.log";
    String email = "support@moviefinder.com";
    String target = "MovieFinder.jar";
    boolean coutChanges = false;
    SplashScreen splash;
    boolean inJar = true;

    public MovieFinderInstaller() {
        this.installMovieFinder();
        this.splash.dispose();
        System.exit(0);
    }

    void installMovieFinder() {
        try {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                System.err.println("Failed to init Look and Feel: " + e.getCause());
            }
            this.splash = new SplashScreen("MovieFinder Installer", 7, this.inJar, false);
            this.splash.updateProgress("checking operating system");
            if (System.getProperty("os.name").startsWith("Win") || System.getProperty("os.name").startsWith("win")) {
                this.win = true;
                System.err.println("Windows Operating System detected.");
                this.installDir = System.getProperty("user.home");
                this.shortcutDir = this.installDir.substring(0, this.installDir.indexOf("Settings\\") + 9) + "All Users";
                this.desktopDir = this.shortcutDir + "\\Desktop";
                this.shortcutDir = this.shortcutDir + "\\Start Menu\\Programs\\MovieFinder";
                this.installDir = this.installDir.substring(0, 2) + "\\Program Files\\MovieFinder";
                this.shortcutName = this.shortcutName + ".lnk";
                File dir = new File(this.shortcutDir);
                if (!dir.exists()) {
                    dir.mkdir();
                }
                this.shortcutDir = this.shortcutDir + "\\";
                dir = new File(this.installDir);
                if (!dir.exists()) {
                    dir.mkdir();
                }
                this.installDir = this.installDir + "\\";
                dir = new File(this.desktopDir);
                if (!dir.exists()) {
                    dir.mkdir();
                }
                this.desktopDir = this.desktopDir + "\\";
            } else {
                if (System.getProperty("os.name").startsWith("Mac") || System.getProperty("os.name").startsWith("mac")) {
                    this.mac = true;
                    System.err.println("Macintosh Operating System detected.");
                    this.installDir = "/Applications/MovieFinder";
                    this.desktopDir = System.getProperty("user.home") + "/Desktop";
                } else {
                    this.otherOS = true;
                    System.err.println(System.getProperty("os.name") + " Operating System detected.");
                    this.installDir = System.getProperty("user.home") + "/MovieFinder";
                }
                File dir = new File(this.installDir);
                if (!dir.exists()) {
                    dir.mkdir();
                }
                this.installDir = this.installDir + "/";
                if (this.mac) {
                    dir = new File(this.desktopDir);
                    if (!dir.exists()) {
                        dir.mkdir();
                    }
                    this.desktopDir = this.desktopDir + "/";
                }
            }
            this.splash.updateProgress(System.getProperty("os.name") + " detected");
            this.installMF();
        }
        catch (Exception e) {
            this.popUpAlert("MovieFinder Installation -- Failed", "The MovieFinder installation program has failed to extract the MovieFinder application files.\n\n A computer administrator is required for proper file permissions.\n\n\n If continue to receive this error, visit www.MovieFinderOnline.com for a solution." + MovieFinderInstaller.getStackTrace(e));
            System.exit(0);
        }
    }

    static String getStackTrace(Exception e) {
        String trace = "\n";
        StackTraceElement[] stack = e.getStackTrace();
        for (int i = 0; i < stack.length; ++i) {
            trace = trace + "\n" + stack[i];
        }
        return trace;
    }

    void installMF() {
        try {
            if (this.win) {
                this.copy(this.target, this.installDir);
                this.copy("UnInstall_MovieFinder.jar", this.installDir);
                this.copy("MovieFinderWin.ico", this.installDir);
                this.splash.updateProgress("installing shortcuts");
                new WindowsShortcut(this.shortcutDir + this.shortcutName, this.installDir + this.target, "", this.installDir, this.installDir + "MovieFinderWin.ico");
                new WindowsShortcut(this.shortcutDir + "UnInstall MovieFinder.lnk", this.installDir + "UnInstall_" + this.target, "", this.installDir, this.installDir + "MovieFinderWin.ico");
                MovieFinderInstaller.cout("placed shortcuts in: " + this.shortcutDir);
                new WindowsShortcut(this.desktopDir + this.shortcutName, this.installDir + this.target, "", this.installDir, this.installDir + "MovieFinderWin.ico");
                MovieFinderInstaller.cout("placed shortcut in: " + this.desktopDir);
                this.splash.updateProgress("installation complete");
                int run = this.popUpQuestion("MovieFinder Installation Complete -- Windows OS", "MovieFinder has completed installation on your Windows computer. \n\n MovieFinder was installed to: \n               " + this.installDir + "\n\n Shortcuts were placed on your Desktop and in your Start Menu.\n\n Would you like to run MovieFinder now?");
                if (run == 0) {
                    new WindowsShortcut(this.desktopDir.charAt(0) + ":\\" + this.shortcutName, this.installDir + this.target, "", this.installDir, this.installDir + "MovieFinderWin.ico");
                    this.runProgram();
                }
            } else if (this.mac) {
                this.splash.updateProgress("extracting " + this.target);
                this.copy(this.target, this.installDir);
                this.copy("UnInstall_MovieFinder.jar", this.installDir);
                this.copy("MovieFinderAliasIcon.sit", this.installDir);
                this.splash.updateProgress("installation complete");
                this.popUpAlert("MovieFinder Installation Complete -- Macintosh OS", "MovieFinder has completed installation on your Macintosh computer. \n\n MovieFinder was installed to: \n               " + this.installDir + "\n\n\n To run MovieFinder, double-click on MovieFinder.jar, found in the above directory.");
            } else {
                this.copy(this.target, this.installDir);
                this.copy("UnInstall_MovieFinder.jar", this.installDir);
                this.copy("MovieFinderIcon32x32.gif", this.installDir);
                this.copy("MovieFinderIcon64x64.gif", this.installDir);
                this.splash.updateProgress("installation complete");
                this.popUpAlert("MovieFinder Installation Complete", "MovieFinder has completed installation on your computer. \n\n MovieFinder was installed to: \n               " + this.installDir + "\n\n\n To run MovieFinder, cd to the above directory and enter the command: 'java -jar MovieFinder.jar'");
            }
        }
        catch (IOException e) {
            this.popUpAlert("MovieFinder Extraction -- Failed", "The MovieFinder installation program has failed to extract the MovieFinder application files.\n\n\n You may wish to reboot your computer and try again.\n\n You may also wish to curse at yourself if you bought a Macintosh.  Just kidding.\n\n\n Seriously though, if all else fails, visit www.MovieFinderOnline.com for a solution." + MovieFinderInstaller.getStackTrace(e));
        }
    }

    public void copy(String filename, String targetDir) throws IOException {
        this.splash.updateProgress("extracting " + filename);
        File fileDest = new File(targetDir + filename);
        FileOutputStream output = new FileOutputStream(fileDest);
        if (!this.inJar) {
            FileInputStream stream = new FileInputStream(new File(filename));
            byte[] b = new byte[1000];
            int v = 0;
            while ((v = stream.read(b)) > -1) {
                output.write(b, 0, v);
            }
            stream.close();
        } else {
            InputStream stream = this.getClass().getResourceAsStream(filename);
            byte[] b = new byte[1000];
            int v = 0;
            while ((v = stream.read(b)) > -1) {
                output.write(b, 0, v);
            }
            stream.close();
        }
        output.flush();
        output.close();
        MovieFinderInstaller.cout("extracted '" + filename + "' to '" + targetDir + "'");
    }

    void runProgram() {
        String os = System.getProperty("os.name").toLowerCase();
        Runtime rt = Runtime.getRuntime();
        try {
            if (this.win) {
                String[] cmd = new String[]{"cmd.exe", "/C", "start", this.desktopDir.charAt(0) + ":\\" + this.shortcutName};
                rt.exec(cmd);
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.splash, "\n\n The system failed to start MovieFinder. Please try again manually. \n\n" + MovieFinderInstaller.getStackTrace(e), "System Error", 2);
        }
    }

    static void cout(String s) {
        System.out.println(s);
    }

    void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            System.out.println("cant sleep" + MovieFinderInstaller.getStackTrace(e));
        }
    }

    void popUpAlert(String frame, String message) {
        JOptionPane.showMessageDialog(this.splash, "\n\n " + message + "\n\n", frame, 2);
    }

    int popUpQuestion(String frame, String message) {
        return JOptionPane.showConfirmDialog(this.splash, "\n\n " + message + "\n\n", frame, 0);
    }

    public static void main(String[] args) {
        new MovieFinderInstaller();
    }
}

