// WinPlot3DF.cpp : implementation of the WinPlot3DF class
// Concrete plotting class derived from Plot3DZ abstract class

#include "stdafx.h"
#include "plot3df.h"
#include "..\common\winplot3d.h"
#include "..\common\PlotCalc.h"

#ifndef	_WINPLOT3DF_H_
#define	_WINPLOT3DF_H_	1	// avoid re-including

/////////////////////////////////////////////////////////////////////////////
class WinPlot3DF : public WinPlot3D, public Plot3DF
{
public:
	WinPlot3DF()  { m_pPlotCalc = new PlotCalc; m_use_sphere_range=0; }
	~WinPlot3DF() { delete m_pPlotCalc; }

	// map to WinPlot3D
	virtual void MoveTo(int xv,int yv) { WinMoveTo(xv,yv);    }
	virtual void DrawTo(int xv,int yv) { WinDrawTo(xv,yv);    }
	virtual void ColorTo(long color)   { WinColorTo(color);   }
	virtual void PlotText(AXIS_PLOT_INFO* pAxisInfo,double degrees,
		int xv,int yv,CString text)    { WinPlotText(pAxisInfo,degrees,xv,yv,text);   }

	// call back routines
	virtual void cbBegPlot()           { WinBegPlot();        }
	virtual void cbEndPlot()           { WinEndPlot();        }
	virtual void cbCheckUserAbort()    { if (IsAbortRequested()) DoAbort(); }

	// must defined these
	virtual long  Color(double x,double y,double z);
	virtual double Func(double x,double y,double z) { return( m_pPlotCalc->Calc(x,y,z) ); }
	virtual int  Within(double x,double y,double z);
	virtual double XParametric(double u,double v);
	virtual double YParametric(double u,double v);
	virtual double ZParametric(double u,double v);

	PlotCalc* m_pPlotCalc;  // Equation Calculator
};

#endif	// _WINPLOT3DF_H_

// ------------------------------  end WinPlot3DF.H  ----------------------------

