// Win3DFView.h : interface of the CWin3DFView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_WIN3DFVIEW_H__A488E708_5D96_11D4_8705_00B0D02C8560__INCLUDED_)
#define AFX_WIN3DFVIEW_H__A488E708_5D96_11D4_8705_00B0D02C8560__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


class CWin3DFView : public CView
{
protected: // create from serialization only
	CWin3DFView();
	DECLARE_DYNCREATE(CWin3DFView)

// Attributes
public:
	CWin3DFDoc* GetDocument();

	// plot variables
	int		m_abort_plotting;// 0=no, 1=abort plotting
	BOOL	m_is_drawn;	// 0=no, 1=plot has been drawn (used for redraw via plot file)
	CString	m_fn_cap;	// pen movement capture file (each view gets it's own file)
	CString	m_fn_input;	// filename for input file (if any)
	CRect	m_plot_rect;// plot rectangle

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CWin3DFView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void OnInitialUpdate();
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CWin3DFView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CWin3DFView)
	afx_msg void OnDrawPlot();
	afx_msg void OnResizeWindow();
	afx_msg void OnEditCopy();
	afx_msg void OnHelpGettingstarted();
	afx_msg void OnHelpHiddenlineremoval();
	afx_msg void OnHelpIntroduction();
	afx_msg void OnHelpPlotparameters();
	afx_msg void OnHelpTips();
	afx_msg void OnHelpCprogramming();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in Win3DFView.cpp
inline CWin3DFDoc* CWin3DFView::GetDocument()
   { return (CWin3DFDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_WIN3DFVIEW_H__A488E708_5D96_11D4_8705_00B0D02C8560__INCLUDED_)
