/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.DTreeNode;
import common.DTreeView;
import java.util.Vector;

public class TreeStructure
extends DTreeView {
    public void setTreeStructure(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            this.clear();
            return;
        }
        this.selectedNode = null;
        this.rootNode = null;
        try {
            this.parseTreeStructure(stringArray);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        this.triggerRedraw();
        this.invalidate();
    }

    public String[] getTreeStructure() {
        if (this.rootNode == null) {
            return null;
        }
        Vector vector = new Vector(this.count);
        this.rootNode.depth = 0;
        this.vectorize(this.rootNode, false, vector);
        int n = vector.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            DTreeNode dTreeNode = (DTreeNode)vector.elementAt(i);
            String string = "";
            for (int j = 0; j < dTreeNode.depth; ++j) {
                string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(' ')));
            }
            stringArray[i] = string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(dTreeNode.text)));
        }
        return stringArray;
    }

    protected void parseTreeStructure(String[] stringArray) throws Exception {
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String string = stringArray[i];
            int n2 = this.findLastPreSpace(string);
            if (n2 == -1) {
                throw new Exception("parseTreeStructure: Empty strings in structure.");
            }
            DTreeNode dTreeNode = this.newTreeNode(string.trim(), this);
            dTreeNode.setDepth(n2);
            if (this.rootNode == null) {
                if (n2 != 0) {
                    throw new Exception("parseTreeStructure: Indented nodes with no root level node.");
                }
                this.append(dTreeNode);
                continue;
            }
            DTreeNode dTreeNode2 = this.rootNode;
            while (dTreeNode2.sibling != null) {
                dTreeNode2 = dTreeNode2.sibling;
            }
            for (n = 1; n < n2; ++n) {
                int n3 = dTreeNode2.numberOfChildren;
                DTreeNode dTreeNode3 = null;
                if (n3 > 0) {
                    dTreeNode3 = dTreeNode2.child;
                    while (dTreeNode3.sibling != null) {
                        dTreeNode3 = dTreeNode3.sibling;
                    }
                }
                if (dTreeNode3 == null) break;
                dTreeNode2 = dTreeNode3;
            }
            if ((n = n2 - dTreeNode2.getDepth()) > 1) {
                throw new Exception("parseTreeStructure: Generation gap. Node with no immediate parent.");
            }
            if (n == 1) {
                this.insert(dTreeNode, dTreeNode2, 0);
                continue;
            }
            this.insert(dTreeNode, dTreeNode2, 1);
        }
    }

    public void printTree(DTreeNode dTreeNode) {
        this.printTree(dTreeNode, false);
    }

    public void printTree(DTreeNode dTreeNode, boolean bl) {
        if (dTreeNode == null) {
            return;
        }
        String string = new String();
        if (bl) {
            for (int i = 0; i < dTreeNode.depth; ++i) {
                string = "  ".concat(String.valueOf(String.valueOf(string)));
            }
        }
        System.out.println(String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(dTreeNode.text))));
        this.printTree(dTreeNode.child, bl);
        this.printTree(dTreeNode.sibling, bl);
    }

    protected int findLastPreSpace(String string) {
        if (string != null && string.length() > 0) {
            int n = string.length();
            if (string.charAt(0) != ' ' && string.charAt(0) != '\t') {
                return 0;
            }
            for (int i = 1; i < n; ++i) {
                if (string.charAt(i) == ' ' || string.charAt(i) == '\t') continue;
                return i;
            }
        }
        return -1;
    }
}

