/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.awt.TextArea;

public class TextModel {
    TextArea ta;
    String UndoText;
    int UndoPos;
    static String separator = System.getProperty("line.separator");

    public TextModel(TextArea textArea) {
        this.ta = textArea;
        this.clearUndo();
    }

    public int size() {
        return this.ta.getText().length();
    }

    public int EOLCount(int n) {
        int n2 = 0;
        String string = this.ta.getText();
        for (int i = 0; i <= n; ++i) {
            if (string.charAt(i) != '\n') continue;
            ++n2;
        }
        return n2;
    }

    public void wrapIt(int n) {
        int n2 = this.size();
        String string = this.ta.getText();
        int n3 = separator.length();
        int n4 = n2 + n2 / n + 5;
        StringBuffer stringBuffer = new StringBuffer(n4);
        char c = '\u0000';
        char c2 = '\u0000';
        try {
            c = separator.charAt(0);
            c2 = separator.charAt(1);
        }
        catch (Exception exception) {
            c2 = '\u0000';
        }
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            try {
                char c3 = string.charAt(i);
                stringBuffer.append(c3);
                ++n5;
                if (c3 == c && (string.charAt(i + 1) == c2 || c2 == '\u0000')) {
                    n5 = 0;
                }
                if (n5 < n) continue;
                for (int j = i; j > 0 && n5 > 0; --j, --n5) {
                    if (stringBuffer.charAt(j) != ' ') continue;
                    stringBuffer.insert(j + 1, separator);
                    break;
                }
                n5 = 0;
                continue;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                stringIndexOutOfBoundsException.printStackTrace();
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(i))).append(" > ").append(n4))));
            }
        }
        this.ta.setText(new String(stringBuffer));
    }

    public int getRow() {
        int n = this.getCaretPosition();
        String string = this.ta.getText();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) != '\n') continue;
            ++n2;
        }
        return n2 + 1;
    }

    public int getStartOfLine() {
        int n = this.getCaretPosition();
        String string = this.ta.getText();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) != '\n') continue;
            n2 = i;
        }
        return n2 + 1;
    }

    public int[] getLineCol() {
        int n = this.getCaretPosition();
        String string = this.ta.getText();
        int n2 = 0;
        int n3 = 0;
        int[] nArray = new int[2];
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) != '\n') continue;
            n2 = i;
            ++n3;
        }
        nArray[0] = n3 + 1;
        nArray[1] = n - n2 + 1;
        return nArray;
    }

    public int countLines() {
        String string = this.ta.getText();
        int n = 0;
        int n2 = 0;
        boolean bl = true;
        while (bl) {
            try {
                if (string.charAt(n2++) != '\n') continue;
                ++n;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                bl = false;
            }
        }
        return n;
    }

    public int getPosition(int n) {
        String string = this.ta.getText();
        int n2 = 0;
        while (n2 < n) {
            if (string.charAt(n2++) != '\n') continue;
            --n;
        }
        return n;
    }

    public int getCaretPosition() {
        return this.ta.getCaretPosition();
    }

    public int getSelectionStart() {
        return this.ta.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.ta.getSelectionEnd();
    }

    public boolean isSelected() {
        int n = this.ta.getSelectionStart();
        int n2 = this.ta.getSelectionEnd();
        return n2 > n;
    }

    public String getSelectedText() {
        int n = this.ta.getSelectionStart();
        int n2 = this.ta.getSelectionEnd();
        String string = this.ta.getText();
        int n3 = 0;
        while (n3 < n) {
            if (string.charAt(n3++) != '\n') continue;
            --n;
            --n2;
        }
        while (n3 < n2) {
            if (string.charAt(n3++) != '\n') continue;
            --n2;
        }
        return string.substring(n, n2);
    }

    public void setText(String string) {
        this.ta.setText(string);
    }

    public String getText() {
        return this.ta.getText();
    }

    public void insert(String string, int n) {
        this.ta.insert(string, n);
    }

    public void insert(String string) {
        this.ta.insert(string, this.getCaretPosition());
    }

    public void replace(String string, int n, int n2) {
        String string2 = this.ta.getText();
        int n3 = string2.length();
        StringBuffer stringBuffer = new StringBuffer(n3 + string.length());
        stringBuffer.append(string2.substring(0, n));
        stringBuffer.append(string);
        stringBuffer.append(string2.substring(n2, n3));
        this.ta.setText(new String(stringBuffer));
    }

    public void replace(String string) {
        int n = this.getSelectionStart();
        int n2 = this.getSelectionEnd();
        this.replace(string, n, n2);
    }

    public void replaceSelection(String string) {
        int n = this.getPosition(this.ta.getSelectionStart());
        int n2 = this.getPosition(this.ta.getSelectionEnd());
        this.ta.replaceRange(string, n, n2);
    }

    public int getLastPosition() {
        return this.ta.getText().length() + this.countLines();
    }

    public void remove(int n, int n2) {
        this.UndoText = this.getText().substring(n, n2 + 1);
        this.UndoPos = n;
        this.ta.replaceRange("", n, n2);
    }

    public void clearEOL() {
        int n;
        int n2 = this.getCaretPosition();
        String string = this.ta.getText();
        for (n = n2; n < string.length() && string.charAt(n) != '\n'; ++n) {
        }
        this.remove(n2, n);
    }

    public void clearLine() {
        int n;
        int n2 = this.getCaretPosition();
        String string = this.ta.getText();
        int n3 = n2;
        for (n = n2; n > 0 && string.charAt(n) != '\n'; --n) {
        }
        while (n3 < string.length() && string.charAt(n3) != '\n') {
            ++n3;
        }
        this.remove(n, n3);
    }

    public void undo() {
        if (this.UndoText.length() > 0) {
            this.ta.insert(this.UndoText, this.UndoPos);
            this.clearUndo();
        }
    }

    public void clearUndo() {
        this.UndoText = "";
        this.UndoPos = 0;
    }
}

