/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.DBPanel;
import common.DCheckbox;
import common.DirManager;
import common.PanelGenerator;
import common.Path;
import common.Preferences;
import common.TSpinner;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;

public class PanelThumbnail
extends PanelGenerator {
    TSpinner spinnerW;
    TSpinner spinnerH;
    DCheckbox checkBorder;
    DCheckbox checkName;
    DCheckbox checkSize;
    DCheckbox checkType;
    String graph = ".png.bmp.gif.jpg.";

    public PanelThumbnail(Frame frame) {
        super(frame);
        this.setTitle("THUMBNAIL");
        this.setAction("Make a thumbnail of selected files");
        DBPanel dBPanel = new DBPanel(1);
        dBPanel.setLabel("Options");
        this.add((Component)dBPanel, "Center");
        Label label = new Label("Image width");
        label.setBounds(24, 22, 92, 20);
        dBPanel.add(label);
        this.spinnerW = new TSpinner(Preferences.ThumbWidth, 16, 256);
        this.spinnerW.setBounds(118, 22, 72, 20);
        this.spinnerW.addActionListener(this);
        dBPanel.add(this.spinnerW);
        Label label2 = new Label("Cell width");
        label2.setBounds(220, 22, 74, 20);
        dBPanel.add(label2);
        this.spinnerH = new TSpinner(Preferences.ThumbCell, 16, 256);
        this.spinnerH.setBounds(304, 22, 72, 20);
        this.spinnerH.addActionListener(this);
        dBPanel.add(this.spinnerH);
        this.checkName = new DCheckbox("Display the names", Preferences.ThumbName);
        this.checkName.setBounds(20, 64, 156, 22);
        this.checkName.addItemListener(this);
        dBPanel.add(this.checkName);
        this.checkBorder = new DCheckbox("Draw a border", Preferences.ThumbBorder);
        this.checkBorder.setBounds(212, 64, 132, 22);
        this.checkBorder.addItemListener(this);
        dBPanel.add(this.checkBorder);
        this.checkSize = new DCheckbox("Display the sizes", Preferences.ThumbSize);
        this.checkSize.setBounds(20, 96, 140, 22);
        this.checkSize.addItemListener(this);
        dBPanel.add(this.checkSize);
        this.checkType = new DCheckbox("Display the types", Preferences.ThumbType);
        this.checkType.setBounds(212, 96, 140, 22);
        this.checkType.addItemListener(this);
        dBPanel.add(this.checkType);
    }

    public void select(DirManager dirManager) {
        if (dirManager.isSelected()) {
            return;
        }
        int n = 0;
        String[] stringArray = dirManager.getFiles();
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2 = stringArray[i];
            if (string2 == null || !DirManager.inside(this.graph, string = Path.getExtension(string2).toLowerCase())) continue;
            dirManager.selectCtrl(string2);
            ++n;
        }
        this.dispTip(String.valueOf(String.valueOf(n)).concat(" graphic files with valid format"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.spinnerW) {
            Preferences.ThumbWidth = this.spinnerW.current;
        } else if (object == this.spinnerH) {
            Preferences.ThumbCell = this.spinnerH.current;
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.checkBorder) {
            Preferences.ThumbBorder = this.checkBorder.getState();
        } else if (object == this.checkName) {
            Preferences.ThumbName = this.checkName.getState();
        } else if (object == this.checkSize) {
            Preferences.ThumbSize = this.checkSize.getState();
        } else if (object == this.checkType) {
            Preferences.ThumbType = this.checkType.getState();
        }
    }
}

