/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.net.URL;

public class ImagePanel
extends Panel {
    public static final int IMAGE_TILED = 0;
    public static final int IMAGE_CENTERED = 1;
    public static final int IMAGE_SCALED_TO_FIT = 2;
    public static final int IMAGE_MAPPED = 2;
    public static final int IMAGE_NORMAL = 3;
    public static final int BORDER_NONE = 0;
    public static final int BORDER_LINE = 1;
    public int border;
    private transient Image image;
    private URL imageURL;
    private int imageStyle;
    public int stringX = 0;
    public int stringY = 0;
    public String iString = null;

    public ImagePanel() {
        super.setLayout(null);
        this.image = null;
        this.border = 0;
        this.imageStyle = 1;
    }

    public ImagePanel(int n, int n2) {
        super.setLayout(null);
        this.image = null;
        this.imageStyle = n2;
        this.border = n;
    }

    public void setStyle(int n) {
        this.imageStyle = n;
    }

    public void setBorder(int n) {
        this.border = n;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        graphics.clearRect(0, 0, n, n2);
        if (this.image != null) {
            int n3 = this.image.getWidth(this);
            int n4 = this.image.getHeight(this);
            switch (this.imageStyle) {
                case 0: {
                    int n5 = n / n3;
                    if (n % n3 != 0) {
                        ++n5;
                    }
                    int n6 = n2 / n4;
                    if (n2 % n4 != 0) {
                        ++n6;
                    }
                    int n7 = 0;
                    for (int i = 0; i < n6; ++i) {
                        int n8 = 0;
                        for (int j = 0; j < n5; ++j) {
                            graphics.drawImage(this.image, n8, n7, n3, n4, this);
                            n8 += n3;
                        }
                        n7 += n4;
                    }
                    break;
                }
                default: {
                    int n9 = (n - n3) / 2;
                    int n10 = (n2 - n4) / 2;
                    int n11 = 0;
                    if (this.border != 0) {
                        graphics.setColor(Color.black);
                        graphics.drawRect(n9, n10, n3 - 1, n4 - 1);
                        n11 = 1;
                    }
                    graphics.drawImage(this.image, n9 + n11, n10 + n11, n3 - n11 * 2, n4 - n11 * 2, this);
                    break;
                }
                case 2: {
                    int n12 = 0;
                    if (this.border != 0) {
                        graphics.setColor(Color.black);
                        graphics.drawRect(0, 0, n - 1, n2 - 1);
                        n12 = 1;
                    }
                    graphics.drawImage(this.image, n12, n12, n - n12 * 2, n2 - n12 * 2, this);
                    break;
                }
                case 3: {
                    graphics.drawImage(this.image, 0, 0, this);
                }
            }
        }
        if (this.iString != null) {
            graphics.drawString(this.iString, this.stringX, this.stringY);
        }
        super.paint(graphics);
    }

    public void setImage(URL uRL) {
        if (!this.imageURL.equals(uRL)) {
            this.imageURL = uRL;
            if (this.imageURL != null) {
                this.image = this.getToolkit().getImage(this.imageURL);
                if (this.image != null) {
                    MediaTracker mediaTracker = new MediaTracker(this);
                    try {
                        mediaTracker.addImage(this.image, 0);
                        mediaTracker.waitForAll();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } else if (this.image != null) {
                this.image.flush();
                this.image = null;
            }
            this.repaint();
        }
    }

    public void setImage(Image image) {
        if (image != null) {
            this.image = image;
            MediaTracker mediaTracker = new MediaTracker(this);
            try {
                mediaTracker.addImage(this.image, 0);
                mediaTracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.repaint();
    }

    public void setImage(String string) {
        if (string != null) {
            this.setImage(this.getToolkit().getImage(string));
        } else if (this.image != null) {
            this.image.flush();
            this.image = null;
            this.repaint();
        }
    }

    public URL getImageURL() {
        return this.imageURL;
    }

    public Image getImage() {
        return this.image;
    }

    public void setString(String string, int n, int n2) {
        this.stringX = n;
        this.stringY = n2;
        this.iString = string;
    }
}

