/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.DirBox;
import common.DirIcons;
import common.OS;
import common.Path;
import common.Sort;
import common.VectorLong;
import common.VectorString;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Directory {
    public final int MAXINDISKS = 0;
    public int MAXINDIRS;
    public int MAXINFILES;
    public int MAXINLIST;
    final short TYPE_DISK = 0;
    final short TYPE_FLOPPY = 1;
    final short TYPE_CDROM = (short)2;
    final short TYPE_REM = (short)3;
    final short TYPE_MEDIA = (short)8;
    final short TYPE_DIR = (short)16;
    final short TYPE_FILE = (short)24;
    final short TYPE_HTML = (short)25;
    final short TYPE_EXE = (short)26;
    final short TYPE_DOC = (short)27;
    final short TYPE_SOUND = (short)32;
    final short TYPE_IMAGE = (short)48;
    final short TYPE_ZIP = (short)64;
    DirBox dirbox;
    public Image image;
    Sort sort = null;
    String[] Contenu;
    int[] Idx;
    VectorLong EntrySizes;
    VectorLong EntryTimes;
    int Index;
    String path;
    String directory;
    String filter;
    boolean updated;
    public String arcname = null;
    public boolean EXTENDED = false;
    public boolean maskOther = false;
    public boolean maskImage = false;
    public static boolean Sorting = true;
    public boolean zipMode = false;
    public boolean isArchive = false;
    public boolean isImage = false;
    public boolean isOther = false;
    public boolean jarMask = false;
    public static String root;
    static DirIcons di;
    private boolean arcSort = true;
    public int Displayed;
    public int Masked;

    public Directory(boolean bl) {
        this.EXTENDED = bl;
        root = OS.isWindows() ? "\\" : "/";
    }

    public Directory() {
        this(false);
    }

    public int getMax() {
        return this.MAXINLIST;
    }

    public int getNumber() {
        return this.MAXINLIST;
    }

    public String getDir() {
        return this.directory;
    }

    public String getDrive() {
        return Path.splitDrive(this.directory);
    }

    public String getPath() {
        return this.path;
    }

    public String getFilter() {
        return this.filter;
    }

    public boolean hasFilter() {
        return this.filter != null && this.filter.length() > 0;
    }

    void setArchive(boolean bl) {
        this.isArchive = bl;
    }

    void setZipMode(boolean bl) {
        this.zipMode = bl;
    }

    void setFileMask(boolean bl) {
        this.maskOther = bl;
        this.updated = false;
    }

    void setImageMask(boolean bl) {
        this.maskImage = bl;
        this.updated = false;
    }

    void setArcSort(boolean bl) {
        if (bl != this.arcSort) {
            this.arcSort = bl;
            this.updated = false;
        }
    }

    public void setPath(String string) {
        try {
            this.path = string;
            this.directory = Path.splitPath(string);
            this.arcname = this.filter = Path.splitFile(string);
            this.updated = false;
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("Error directory empty");
        }
    }

    public void setArcFile(String string) {
        try {
            this.arcname = string;
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            this.arcname = "";
        }
    }

    public static boolean createDir(String string, String string2) {
        File file = new File(string, string2);
        if (file.exists()) {
            return file.isDirectory();
        }
        return file.mkdirs();
    }

    public static boolean createDir(String string) {
        return new File(string).mkdirs();
    }

    public void goDrive(String string) {
        if (!this.directory.startsWith(string)) {
            this.setPath(string);
        }
        this.setArchive(false);
    }

    public String nullDir() {
        if (OS.isWindows()) {
            return "";
        }
        return "/";
    }

    public String goParent() {
        String string = "";
        if (this.filter.length() > 0) {
            if (this.zipMode) {
                string = this.filter;
            }
            this.setPath(this.directory);
        } else {
            File file = new File(this.directory);
            String string2 = file.getParent();
            if (string2 == null) {
                return this.nullDir();
            }
            if (string2.length() == 0) {
                return this.nullDir();
            }
            string = Path.splitLast(this.directory);
            int n = string2.lastIndexOf(File.separator);
            if (n == string2.length() - 1) {
                string2 = string2.substring(0, n);
            }
            this.setPath(string2);
        }
        this.setArchive(false);
        return string;
    }

    public void goHome() {
        if (OS.isWindows()) {
            String string = Path.splitDrive(this.directory);
            if (Path.isValidDrive(string)) {
                this.setPath(string);
            } else {
                this.setPath(File.separator);
            }
        } else {
            this.setPath("/");
        }
        this.setArchive(false);
    }

    public static boolean IsEmpty(File file) {
        String[] stringArray;
        return !file.exists() || !(file.isDirectory() ? (stringArray = file.list()) != null && stringArray.length > 0 : file.length() > (long)0);
    }

    public static boolean isArchive(String string) {
        if (Directory.isZip(string)) {
            return true;
        }
        return Directory.isGZip(string);
    }

    public static boolean isZip(String string) {
        String string2 = string.toLowerCase();
        if (string2.indexOf("*") != -1) {
            return false;
        }
        if (string2.endsWith(".zip")) {
            return true;
        }
        return string2.endsWith(".jar");
    }

    public static boolean isGZip(String string) {
        String string2 = string.toLowerCase();
        if (string2.indexOf("*") != -1) {
            return false;
        }
        if (string2.endsWith(".gz")) {
            return true;
        }
        return string2.endsWith(".tgz");
    }

    public boolean isZip() {
        if (this.isArchive) {
            return true;
        }
        if (this.arcname == null) {
            return false;
        }
        return Directory.isZip(this.arcname);
    }

    private void swapList(int n, int n2) {
        int n3 = this.Idx[n];
        this.Idx[n] = this.Idx[n2];
        this.Idx[n2] = n3;
    }

    public void separeDirs() {
        this.MAXINDIRS = 0;
        int n = this.MAXINDIRS + 1;
        while (n <= this.MAXINLIST) {
            if (new File(this.directory, this.Contenu[this.Idx[this.MAXINDIRS]]).isDirectory()) {
                ++this.MAXINDIRS;
                if (n != this.MAXINDIRS) continue;
                ++n;
                continue;
            }
            if (n < this.MAXINLIST && new File(this.directory, this.Contenu[this.Idx[n]]).isDirectory()) {
                this.swapList(this.MAXINDIRS, n);
                ++this.MAXINDIRS;
            }
            ++n;
        }
        this.MAXINFILES = this.MAXINLIST - this.MAXINDIRS;
    }

    public void sortList() throws Exception {
        this.sort = new Sort(this.Contenu, this.Idx);
        if (this.MAXINDIRS > 0) {
            this.SortRange(0, this.MAXINDIRS);
        }
        if (this.MAXINFILES > 0) {
            this.SortRange(this.MAXINDIRS, this.MAXINLIST);
        }
    }

    public void SortRange(int n, int n2) {
        this.sort.insertion(n, n2);
    }

    public boolean getList() {
        Object object;
        Object object2;
        this.Contenu = null;
        System.gc();
        this.MAXINDIRS = 0;
        this.MAXINLIST = 0;
        if (this.directory == null) {
            this.directory = Path.getSysPath();
        }
        if (this.EXTENDED) {
            this.EntrySizes = new VectorLong(1024, 16);
            this.EntryTimes = new VectorLong(1024, 16);
        }
        if (this.isZip()) {
            this.zipMode = true;
            this.isArchive = false;
            try {
                object2 = new ZipFile(Path.merge(this.directory, this.arcname));
                Enumeration<? extends ZipEntry> enumeration = ((ZipFile)object2).entries();
                object = new VectorString(1024, 16);
                boolean bl = true;
                while (enumeration.hasMoreElements() && bl) {
                    try {
                        String string = ((Object)enumeration.nextElement()).toString();
                        ((VectorString)object).addElement(string);
                        if (!this.EXTENDED) continue;
                        ZipEntry zipEntry = ((ZipFile)object2).getEntry(string);
                        this.EntrySizes.addElement(zipEntry.getSize());
                        this.EntryTimes.addElement(zipEntry.getTime());
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        System.out.println("No such element");
                        bl = false;
                    }
                }
                this.Contenu = ((VectorString)object).toArray();
                ((ZipFile)object2).close();
            }
            catch (IOException iOException) {
                System.out.println("Error in Zip");
                this.zipMode = false;
            }
            if (!this.zipMode) {
                return false;
            }
        } else {
            this.zipMode = false;
            this.arcname = "";
            object2 = new File(this.directory, root);
            if (!OS.isWindows()) {
                System.out.println(this.directory);
            }
            try {
                this.Contenu = ((File)object2).list();
                if (this.EXTENDED) {
                    for (int i = 0; i < this.Contenu.length; ++i) {
                        object = new File(this.directory, this.Contenu[i]);
                        this.EntrySizes.addElement(((File)object).length());
                        this.EntryTimes.addElement(((File)object).lastModified());
                    }
                }
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (NullPointerException nullPointerException) {
                System.out.println("Dir list not filled");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                arrayIndexOutOfBoundsException.printStackTrace();
            }
        }
        if (this.Contenu == null) {
            return false;
        }
        this.MAXINLIST = this.Contenu.length;
        this.Idx = new int[this.MAXINLIST];
        for (int i = 0; i < this.MAXINLIST; ++i) {
            this.Idx[i] = i;
        }
        this.separeDirs();
        if (this.zipMode ? !this.arcSort : !Sorting) {
            return true;
        }
        try {
            this.sortList();
        }
        catch (Exception exception) {
            System.out.println("Enable to sort");
        }
        return true;
    }

    public int getType(int n) {
        String string;
        if (n < 0) {
            return 0;
        }
        if (n < this.MAXINDIRS) {
            return 16;
        }
        n = this.Idx[n];
        int n2 = this.Contenu[n].length();
        int n3 = this.Contenu[n].lastIndexOf(46);
        if (n2 > 5 && n3 == n2 - 5) {
            String string2 = this.Contenu[n].substring(n2 - 4, n2);
            if (string2.equalsIgnoreCase("html")) {
                return 27;
            }
            if (string2.equalsIgnoreCase("php4")) {
                return 27;
            }
            if (string2.equalsIgnoreCase("php5")) {
                return 27;
            }
            return 24;
        }
        if (n2 > 4 && n3 == n2 - 4) {
            String string3 = this.Contenu[n].substring(n2 - 3, n2);
            if (string3.equalsIgnoreCase("zip")) {
                return 64;
            }
            if (string3.equalsIgnoreCase("gif")) {
                return 48;
            }
            if (string3.equalsIgnoreCase("jpg")) {
                return 48;
            }
            if (string3.equalsIgnoreCase("pcx")) {
                return 48;
            }
            if (string3.equalsIgnoreCase("png")) {
                return 48;
            }
            if (string3.equalsIgnoreCase("wav")) {
                return 32;
            }
            if (string3.equalsIgnoreCase("exe")) {
                return 26;
            }
            if (string3.equalsIgnoreCase("doc")) {
                return 27;
            }
            if (string3.equalsIgnoreCase("rtf")) {
                return 27;
            }
            if (string3.equalsIgnoreCase("hlp")) {
                return 27;
            }
            if (string3.equalsIgnoreCase("htm")) {
                return 27;
            }
            if (string3.equalsIgnoreCase("php")) {
                return 27;
            }
            if (string3.equalsIgnoreCase("asp")) {
                return 27;
            }
            if (string3.equalsIgnoreCase("wri")) {
                return 27;
            }
            if (string3.equalsIgnoreCase("mid")) {
                return 32;
            }
            if (this.jarMask) {
                if (string3.equalsIgnoreCase("jar")) {
                    return 64;
                }
                if (string3.equalsIgnoreCase("ico")) {
                    return 48;
                }
                if (string3.equalsIgnoreCase("raw")) {
                    return 48;
                }
                if (string3.equalsIgnoreCase("pal")) {
                    return 48;
                }
                if (string3.equalsIgnoreCase("aaz")) {
                    return 64;
                }
            }
            return 24;
        }
        if (n2 > 3 && n3 == n2 - 3 && (string = this.Contenu[n].substring(n2 - 2, n2)).equalsIgnoreCase("au")) {
            return 32;
        }
        return 24;
    }

    public String getFile(int n) {
        if (n < this.MAXINLIST) {
            return this.Contenu[this.Idx[n]];
        }
        return null;
    }

    void setCategory(int n) {
        this.isImage = false;
        this.isOther = false;
        switch (this.getType(n)) {
            case 64: {
                this.image = DirIcons.IconZip;
                this.isImage = true;
                break;
            }
            case 48: {
                this.image = DirIcons.IconPic;
                this.isImage = true;
                break;
            }
            case 32: {
                this.image = DirIcons.IconWav;
                this.isImage = true;
                break;
            }
            case 27: {
                this.image = DirIcons.IconDoc;
                break;
            }
            case 26: {
                this.image = DirIcons.IconExe;
                break;
            }
            default: {
                this.image = DirIcons.IconFile;
                this.isOther = true;
            }
        }
    }

    public void dispDir(DirBox dirBox, String string) {
        this.dispDir(dirBox, string, 0);
    }

    public void dispDir(DirBox dirBox, String string, int n) {
        int n2;
        boolean bl;
        String string2 = null;
        String string3 = null;
        boolean bl2 = true;
        this.dirbox = dirBox;
        int n3 = this.dirbox.getSelectedIndex();
        if (!this.getList()) {
            this.dirbox.clear(0);
            this.dirbox.setVisible(false);
            this.dirbox.setVisible(true);
            this.updated = true;
            return;
        }
        if (string == null || this.zipMode) {
            bl = false;
        } else {
            string2 = Path.splitNode(string);
            string3 = Path.getExtension(string);
            bl = string.length() > 0;
        }
        this.Displayed = 0;
        this.Masked = 0;
        this.dirbox.clear(this.Contenu.length);
        this.dirbox.setModel(this.Contenu);
        this.dirbox.setImage(DirIcons.IconDir);
        for (n2 = 0; n2 < this.MAXINDIRS; ++n2) {
            this.dirbox.addItemDir(this.Idx[n2]);
        }
        for (n2 = this.MAXINDIRS; n2 < this.MAXINLIST; ++n2) {
            this.setCategory(n2);
            bl2 = true;
            if (this.maskImage && !this.isImage) {
                bl2 = false;
            }
            if (this.maskOther && this.isOther) {
                bl2 = false;
            }
            int n4 = this.Idx[n2];
            if (bl) {
                String string4;
                String string5;
                String string6 = this.Contenu[n4];
                int n5 = string6.indexOf(46);
                if (n5 == -1) {
                    string5 = string6;
                    string4 = "";
                } else {
                    string5 = string6.substring(0, n5);
                    string4 = string6.substring(n5 + 1);
                }
                boolean bl3 = bl2 = !(!string2.equals("*") && !string2.equalsIgnoreCase(string5) || !string3.equals("*") && !string3.equalsIgnoreCase(string4));
            }
            if (bl2) {
                this.dirbox.addItemFile(this.image, n4, this.EntrySizes.elementAt(n4), this.EntryTimes.elementAt(n4));
                ++this.Displayed;
                continue;
            }
            ++this.Masked;
        }
        this.dirbox.setVisible(false);
        this.dirbox.setTopRow(n);
        this.dirbox.setLastSelected(n3);
        this.dirbox.setVisible(true);
        this.updated = true;
    }

    static {
        di = new DirIcons();
    }
}

