// HexEdit.h : main header file for the HEXEDIT application
//
// Copyright (c) 1999 by Andrew W. Phillips.
//
// No restrictions are placed on the noncommercial use of this code,
// as long as this text (from the above copyright notice to the
// disclaimer below) is preserved.
//
// This code may be redistributed as long as it remains unmodified
// and is not sold for profit without the author's written consent.
//
// This code, or any part of it, may not be used in any software that
// is sold for profit, without the author's written consent.
//
// DISCLAIMER: This file is provided "as is" with no expressed or
// implied warranty. The author accepts no liability for any damage
// or loss of business that this product may cause.
//

#ifndef __AFXWIN_H__
        #error include 'stdafx.h' before including this file for PCH
#endif

typedef long FILE_ADDRESS;   // Eventually this will be used everywhere and changed to __int64

#if 0 // ndef SM_CMONITORS
// It seems there's a bug in winuser.h (assumed Win 98 was WIN_VER == 5 not 4.10)
// which causes the following multiple monitor stuff not to be conditionally compiled in
#define SM_CMONITORS            80
#define SM_XVIRTUALSCREEN       76
#define SM_YVIRTUALSCREEN       77
#define SM_CXVIRTUALSCREEN      78
#define SM_CYVIRTUALSCREEN      79
#define SM_SAMEDISPLAYFORMAT    81
#endif

#include <vector>           // For vector of keys that stores keystroke macro
#include <afxmt.h>          // For MFC IPC (CCriticalSection)

#include "resource.h"       // main symbols

#include "Options.h"        // For C*Page classes used below
#include "HexEditMacro.h"

class CHexEditDoc;
class CHexFileList;

/////////////////////////////////////////////////////////////////////////////
// CHexEditApp:
// See HexEdit.cpp for the implementation of this class
//

class CHexEditView;         // Declare this so we can store a ptr to out view class (pview_)
class boyer;

class CHexEditApp : public CWinApp
{
public:
        CHexEditApp();

// Overrides
        // ClassWizard generated virtual function overrides
        //{{AFX_VIRTUAL(CHexEditApp)
	public:
        virtual BOOL InitInstance();
        virtual int ExitInstance();
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	virtual BOOL OnIdle(LONG lCount);
	//}}AFX_VIRTUAL

// Command handlers
protected:
    afx_msg void OnFileNew();
    afx_msg void OnFileOpen();
    afx_msg BOOL OnOpenRecentFile(UINT nID);
    afx_msg void OnFilePrintSetup();
	afx_msg void OnBGSearchFinished(WPARAM wParam, LPARAM lParam);
    afx_msg void OnAppExit();
    void LoadStdProfileSettings(UINT nMaxMRU = _AFX_MRU_COUNT);
    CMultiDocTemplate* m_pDocTemplate;

public:
// Implementation
    static const char *szHexEditClassName; // Class name of mainframe
    static UINT wm_hexedit;     // Message for communicating between different HexEdit instances (to open files)
    HWND hwnd_1st_;             // Handle of previous instance mainfarm window or NULL if no previous instance

    CHexFileList *GetFileList() const { return (CHexFileList *)m_pRecentFileList; }
    void LoadOptions();
    bool GetColours(const char *, const char *, const char *, const char *, partn &retval);
    void SetColours(const char *, const char *, const char *, const char *, const partn &v);
    void SaveOptions();         // Save global options to INI/registry
    void get_options();         // Load global options into prop pages
    void set_general();         // Get options from System options page
    void set_sysdisplay();      // Get options from System Display page
    void set_macro();           // Get options from macro page
    bool set_display();         // Get options from window display page
    bool set_partitions();      // Get options from window colours (partitions) page
    void set_defaults();        // Get options from defaults page

    // Current search info
    void CheckBGSearchFinished();
    CCriticalSection appdata_;  // Protects access to following data
    boyer *pboyer_;             // Ptr to current search pattern (NULL if none)
                                // (Also stores search bytes and their length.)
    BOOL icase_;                // Indicates a case-insensitive search
    int text_type_;             // Type of text search (only matters if icase == TRUE)

    void StartSearches(CHexEditDoc *pp);
    void NewSearch(const unsigned char *pat, size_t len, BOOL icase, int tt);

        //{{AFX_MSG(CHexEditApp)
        afx_msg void OnAppAbout();
        afx_msg void OnOptions();
        afx_msg void OnOptions2();
        afx_msg void OnMacroRecord();
        afx_msg void OnMacroPlay();
        afx_msg void OnUpdateMacroPlay(CCmdUI* pCmdUI);
        afx_msg void OnUpdateMacroRecord(CCmdUI* pCmdUI);
        afx_msg void OnProperties();
        afx_msg void OnOptions3();
        afx_msg void OnMultiPlay();
        afx_msg void OnHelpEmail();
        afx_msg void OnUpdateHelpEmail(CCmdUI* pCmdUI);
	afx_msg void OnTest();
	afx_msg void OnHelpWeb();
	afx_msg void OnUpdateHelpWeb(CCmdUI* pCmdUI);
	afx_msg void OnWebPage();
	//}}AFX_MSG
        DECLARE_MESSAGE_MAP()

public:
    static const short version_;        // Eg. 101 means HexEdit version 1.01

    // Pages of the options tabbed dialog
    // (These are here so they can be easily accessed)
    CGeneralPage opt_general;
    CSysDisplayPage opt_sysdisplay;
    CMacroPage opt_macro;
    CDisplayPage opt_display;
    CDefaultsPage opt_defaults;
    CPartitionsPage opt_partitions;

    BOOL is_nt_;                        // Are we running under NT?
    BOOL mult_monitor_;                 // Are we running on an OS with multiple monitor support?
    BOOL is_us_;                        // Are we in US?  (for spelling fixes)

    // Stuff for keystroke macros
    void macro_play(long play_times=1, const std::vector<key_macro> *pmac=NULL, int halt_lev=-1);
    BOOL macro_save(const char *filename, const std::vector<key_macro> *pmac = NULL,
                    const char *comment = NULL, int halt_lev = -1, long plays = 1);
    BOOL macro_load(const char *filename, std::vector<key_macro> *pmac,
                    CString &comment, int &halt_lev, long &plays);
    void RunAutoExec();

    CString mac_dir_;                   // Where macros are saved
    CString mac_comment_;               // Description of last loaded macro
    CString mac_filename_;              // Filename of last loaded macro

    BOOL recording_;                    // Are we recording a macro?
    BOOL no_keys_;                      // Have we recorded any keys yet?
    int playing_;                       // 0 if not playing else nest level
    CHexEditView *pview_;               // Last view that had focus
    std::vector<key_macro> mac_;        // Stores the "keys" of the current macro
    int mac_error_;                     // Error level set during play of macro
    bool refresh_off_;                  // Disables refresh during playback
    bool view_changed_;                 // Has view changed during playback?
    // mac_error_ = 0  No error
    // mac_error_ = 1  Warning
    // mac_error_ = 2  Ignorable error
    // mac_error_ = 5  Normal error - warn user
    // mac_error_ = 10 Serious error - user has already been informed
    // mac_error_ = 20 Unlikely system/internal error

    size_t last_cb_size_;               // Size of last thing we put on the clipboard
    void ClipBoardAdd(size_t len) { last_cb_size_ = len; }

    // Save the entry in the macro vector if we are currently recording
    void SaveToMacro(enum km_type k, unsigned __int64 v64 = 0)
    {
        // Make sure that this is not called for special macro types
        ASSERT(k != km_find_text && k != km_open &&
               k != km_read_file && k != km_focus &&
               k != km_font &&
               k != km_mouse && k != km_shift_mouse);
        if (recording_)
        {
            if (no_keys_)
            {
                // This is the first "keystroke" of the macro so
                // clear the previous macro (if any)
                no_keys_ = FALSE;
                mac_filename_.Empty();
                mac_comment_.Empty();
                mac_.clear();
            }
            mac_.push_back(key_macro(k, v64));
        }
    }
#if 0 // Remove this (replaced by above) due to ambiguous calls problems
      // Note that this may cause portability problems since for some macro
      // key types we assign to v64 of the union but get the value from v.
    void SaveToMacro(enum km_type k, long v)
    {
        ASSERT(k != km_find_text && k != km_open &&
               k != km_read_file && k != km_focus &&
               k != km_font &&
               k != km_mouse && k != km_shift_mouse);
        if (recording_)
        {
            if (no_keys_)
            {
                // This is the first "keystroke" of the macro so
                // clear the previous macro (if any)
                no_keys_ = FALSE;
                mac_filename_.Empty();
                mac_comment_.Empty();
                mac_.clear();
            }
            mac_.push_back(key_macro(k,v));
        }
    }
#endif
    void SaveToMacro(enum km_type k, CString &ss)
    {
        ASSERT(k == km_find_text || k == km_open || k == km_read_file || k == km_focus);
        if (recording_)
        {
            if (no_keys_)
            {
                // This is the first "keystroke" of the macro so
                // clear the previous macro (if any)
                no_keys_ = FALSE;
                mac_filename_.Empty();
                mac_comment_.Empty();
                mac_.clear();
            }
            mac_.push_back(key_macro(k,ss));
        }
    }
    void SaveToMacro(enum km_type k, LOGFONT *plf)
    {
        ASSERT(k == km_font);
        if (recording_)
        {
            if (no_keys_)
            {
                // This is the first "keystroke" of the macro so
                // clear the previous macro (if any)
                no_keys_ = FALSE;
                mac_filename_.Empty();
                mac_comment_.Empty();
                mac_.clear();
            }
            mac_.push_back(key_macro(k,plf));
        }
    }
    void SaveToMacro(enum km_type k, mouse_sel *pms)
    {
        ASSERT(k == km_mouse || k == km_shift_mouse);
        if (recording_)
        {
            if (no_keys_)
            {
                // This is the first "keystroke" of the macro so
                // clear the previous macro (if any)
                no_keys_ = FALSE;
                mac_filename_.Empty();
                mac_comment_.Empty();
                mac_.clear();
            }
            mac_.push_back(key_macro(k,pms));
        }
    }

    // Macro options
    int refresh_;                       // Refresh type (0=none,1=secs,2=keys,3=plays)
    long num_secs_;                     // Number of seconds before refresh (refresh_ == 1)
    long num_keys_;                     // Number of keys before refresh (refresh_ == 2)
    long num_plays_;                    // Number of plays before refresh (refresh_ == 3)
    int halt_level_;                    // When to halt (0=any warning/error,1=any error,2=major errors)
    BOOL refresh_props_;                // Refresh properties dialog when refreshing
    BOOL refresh_bars_;                 // Refresh status bar and tools on edit bar
    long plays_;                        // Default number of plays in Multiplay dlg

    // Global options
    BOOL save_exit_;                    // Save settings on exit?
    BOOL orig_save_exit_;               // Original value of save_exit_
    BOOL open_restore_;                 // Restore main frame window on startup?
    BOOL hex_ucase_;                    // Display hex in upper case?
    BOOL nice_addr_;                    // Display nice looking addresses?
    BOOL backup_;                       // Create backup files on save?
    BOOL bg_search_;                    // Do background searches?
    BOOL one_only_;                     // Only allow one instance of app to run
    BOOL large_cursor_;                 // Use large (block) cursor

    // Use member function to say if backups required in case we want to
    // do anything more complicated later
    BOOL backup() const { return backup_; }

    // Default window states
    BOOL open_max_;                     // Open new windows maximized?
    BOOL open_autofit_;                 // Use auto-fit on open?
    BOOL open_dec_addr_;                // Display decimal addresses on open
    BOOL open_display_char_;            // Display chars (on right) on open
    BOOL open_ebcdic_;                  // Display chars in EBCDIC on open
    BOOL open_control_;                 // Display control chars on open
    BOOL open_graphic_;                 // Display graphic chars on open
    BOOL open_oem_;                     // Display OEM graphic chars on open

    LOGFONT *open_plf_;                 // Pointer to default font or NULL if none
    LOGFONT *open_oem_plf_;             // Pointer to default OEM font or NULL if none

    std::vector<partn> default_partitions_;  // Factory set default colours
    std::vector<partn> open_partitions_;     // Current default colours

    BOOL open_allow_mods_;              // Turn off read only on open?
    BOOL open_insert_;                  // Turn off overtype on open?

    int open_rowsize_;                  // Default number of display columns
    int open_group_by_;                 // Default column grouping
    int open_offset_;                   // Display offset on open

    // Saved stuff about the current view while we change view options
    long start_addr_, end_addr_;
    BOOL end_base_;

    // Remembered user interface stuff (may even be saved to registry)
    CString dir_open_, dir_read_, dir_write_; // Default directories for file dialogs
    int find_x_, find_y_;               // Last screen posn of the find (modeless) dialog
    int calc_x_, calc_y_;               // Last screen posn of the calculator
    int prop_x_, prop_y_;               // Last screen posn of the prop sheet
    int prop_page_;                     // Last active properties page
    int prop_dec_signed_;               // Display signed decimal values
    BOOL prop_dec_endian_;              // Display big-endian decimal values
    int prop_fp_format_;                // Which IEEE fp format to display
    BOOL prop_fp_endian_;               // Display big-endian floating pt values
    int prop_ibmfp_format_;             // Which IBM floting point format to display
    BOOL prop_ibmfp_endian_;            // Display big-endian IBM fp values
    int calc_radix_;                    // Radix used in calculator
    int calc_bits_;                     // Number of bits used in calculator

private:
    void display_options(CPropertyPage *display_page = NULL);
    void refresh_display(bool do_all = false);
    void enable_carets();
    void disable_carets();

    void ShowTipAtStartup(void);
    void ShowTipOfTheDay(void);
    void InitEbcdic();
};

class CCommandLineParser : public CCommandLineInfo
{
public:
    CCommandLineParser() { non_std = TRUE; }

    virtual void ParseParam(const TCHAR* pszParam, BOOL bFlag, BOOL bLast);

private:
    BOOL non_std;
};

extern unsigned char e2a_tab[256];
extern unsigned char a2e_tab[128];

extern CHexEditView *GetView();
extern int HMessageBox(LPCTSTR lpszText, UINT nType = MB_OK, UINT nIDHelp = 0);
extern int HMessageBox(UINT nIDPrompt, UINT nType = MB_OK, UINT nIDHelp = (UINT) -1);

/////////////////////////////////////////////////////////////////////////////
