package com.sciapp.demo;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.border.*;

import com.sciapp.table.*;
import com.sciapp.filter.FilterTablePanel;
import com.sciapp.renderers.*;
/**
 *
 */
public class TableDemoPanel extends JPanel {
	//feature components
	private JButton addButton;
	private JTextField rowField;
	private JButton removeButton;
	private JCheckBox showLastColumn;
	private JCheckBox singleMode;
	private DataFeeder dataFeeder = new DataFeeder();

	//table
	private JTable table;
	private SortTableModel sortTableModel; //a reference to the sort table model.
	private ListTableModel model; //a reference to the model of the table. may be same as above.

	private DefaultListTableModel innerDataModel;

	private ActionHandler actionHandler = new ActionHandler();

	private class ActionHandler implements ActionListener {
		public void actionPerformed(java.awt.event.ActionEvent e) {
			action(e);
		};
	}
/**
 *
 */
public TableDemoPanel() {
	setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));

	JPanel tablePanel = createTablePanel();
	JPanel tableFeaturePanel = createTableFeaturePanel();

	add(tablePanel);
	add(tableFeaturePanel);
}
/**
 *
 */
private void action(ActionEvent e) {
	Object source = e.getSource();

	if (source == addButton) {
		addRows();
	}
	else if (source == removeButton) {
		int rows[] = table.getSelectedRows();
		model.removeRows(rows);
	}
	else if (source == showLastColumn) {
		boolean selected = showLastColumn.isSelected();
		if (table instanceof AdvancedJTable) ((AdvancedJTable) table).setShowDummyColumn(selected);
	}
	else if (source == singleMode) {
		boolean selected = singleMode.isSelected();
		sortTableModel.setSortMode(
			selected ? SortTableModel.MULTI_SORT : SortTableModel.SINGLE_SORT);
	}
}
/**
 *
 */
private void addRows() {
	String text = rowField.getText();
	if (text == null) return;

	int rows = parseStringToInt(text);
	addRows(rows);
}
/**
 *
 */
private void addRows(int rows) {
	if (rows == 1) {
		Object o = dataFeeder.nextRow();
		model.addRow(o);
	}
	else if (rows > 1) {
		java.util.List list = dataFeeder.nextRows(rows);
		model.addRows(list);
	}
}
/**
 *
 */
private JPanel createTableFeaturePanel() {
	JPanel p = new JPanel();

	//border
	Border comp =
		BorderFactory.createCompoundBorder(
			new TitledBorder(" Features "),
			BorderFactory.createEmptyBorder(5, 10, 0, 20));
	p.setBorder(comp);

	p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));

	//add rows stuff
	addButton = new JButton("Add row(s)");
	addButton.addActionListener(actionHandler);

	rowField = new JTextField(6);
	rowField.addKeyListener(new KeyAdapter() {
		public void keyTyped(KeyEvent e) {
			if (e.getKeyChar() == KeyEvent.VK_ENTER) addRows();
		}
	});
	Dimension d = rowField.getMaximumSize();
	d.height = rowField.getPreferredSize().height;
	rowField.setMaximumSize(d);

	JPanel addPanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
	addPanel.add(addButton);
	addPanel.add(rowField);
	addPanel.add(new JLabel("Enter the number of rows you want to add to the table."));
	p.add(addPanel);

	//remove stuff
	removeButton = new JButton("Remove row(s)");
	removeButton.addActionListener(actionHandler);
	JPanel removePanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
	removePanel.add(removeButton);
	removePanel.add(new JLabel("Remove the selected row(s)."));
	p.add(removePanel);

	//last column
	showLastColumn = new JCheckBox("Show Last Column", true);
	showLastColumn.addActionListener(actionHandler);
	JPanel column = new JPanel(new FlowLayout(FlowLayout.LEFT));
	column.add(showLastColumn);
	p.add(column);

	//sort mode
	singleMode = new JCheckBox("Multiple Column Sort Mode", true);
	singleMode.addActionListener(actionHandler);
	JPanel sortMode = new JPanel(new FlowLayout(FlowLayout.LEFT));
	sortMode.add(singleMode);
	p.add(sortMode);

	return p;
}
/**
 *
 */
private JPanel createTablePanel() {
	JPanel p = new JPanel();
	p.setLayout(new BorderLayout());

	//border
	Border comp =
		BorderFactory.createCompoundBorder(
			new TitledBorder(" Table "),
			BorderFactory.createEmptyBorder(0, 0, 0, 0));
	p.setBorder(comp);

	//set data
	ObjectTableModel otm = new PersonTableModel();

	//models
	ListTableModel ltm = otm;
	FilterTableModel ftm = new FilterTableModel(ltm);
	SortTableModel stm = new SortTableModel(ftm);

	//set class variables
	sortTableModel = stm;
	model = stm;

	//add some data
	addRows(2);

	//table
	table = new AdvancedJTable(stm);
	JScrollPane scroller = new AdvancedJScrollPane(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
	scroller.setViewportView(table);
	stm.setHeader(table.getTableHeader());

	//customize date renderer
	DateRenderer dr = (DateRenderer) table.getDefaultRenderer(java.util.Date.class);
	dr.setDateFormat(java.text.DateFormat.getDateInstance());

	//set alternate color in renderers
	DefaultRenderer def;

	Color c = new Color(194, 194, 194);
	def = (DefaultRenderer) table.getDefaultRenderer(Object.class);
	def.setOddColor(c);
	def = (DefaultRenderer) table.getDefaultRenderer(Boolean.class);
	def.setOddColor(c);
	def = (DefaultRenderer) table.getDefaultRenderer(Number.class);
	def.setOddColor(c);
	def = (DefaultRenderer) table.getDefaultRenderer(Float.class);
	def.setOddColor(c);
	def = (DefaultRenderer) table.getDefaultRenderer(java.util.Date.class);
	def.setOddColor(c);

	//filter panel
	FilterTablePanel lfp = new FilterTablePanel(ftm);
	lfp.addTableFilterListener(ftm);

	//border
	Border border =
		BorderFactory.createCompoundBorder(
			new TitledBorder(" Filter "),
			BorderFactory.createEmptyBorder(0, 5, 0, 5));
	lfp.setBorder(border);

	//add to panel
	p.add(scroller, BorderLayout.CENTER);
	p.add(lfp, BorderLayout.NORTH);

	return p;
}
/**
 *
 */
private static int parseStringToInt(String str) {
	int ret = -1;
	if (str == null) return ret;
	try {
		ret = Integer.parseInt(str);
	} catch (NumberFormatException e){
	}
	return ret;
}
}
