Public Class MyTranslucencyForm
    Inherits FlashPlayerControlLibrary.FlashPlayerForm

    Private Declare Function ShellExecuteA Lib "shell32.dll" (ByVal hwnd As Integer, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Integer) As Integer
    Private Const SW_SHOW = 5

    Private Const WM_NCHITTEST = &H84
    Private Const HTCAPTION = 2
    Private Const WM_NCRBUTTONUP = &HA5

    Protected Overrides Sub WndProc(ByRef m As Message)
        Select Case m.Msg
            Case WM_NCHITTEST
                m.Result = New System.IntPtr(HTCAPTION)
            Case WM_NCRBUTTONUP
                ContextMenu.Show(Me, PointToClient(MousePosition))
            Case Else
                MyBase.WndProc(m)
        End Select
    End Sub

    Private Sub MyTranslucencyForm_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Load

        Text = "Sample 4 - Translucency"

        Dim Menu As New ContextMenu

        Dim MenuItemMinimize As New MenuItem
        MenuItemMinimize.Text = "Minimize"
        Menu.MenuItems.Add(MenuItemMinimize)
        AddHandler MenuItemMinimize.Click, AddressOf Me.OnMenuMinimize

        Dim MenuItemClose As New MenuItem
        MenuItemClose.Text = "Close"
        Menu.MenuItems.Add(MenuItemClose)
        AddHandler MenuItemClose.Click, AddressOf Me.OnMenuClose

        ' Add separator
        Menu.MenuItems.Add("-")

        Dim MenuItemAbout As New MenuItem
        MenuItemAbout.Text = "More about FlashPlayerControl .NET"
        Menu.MenuItems.Add(MenuItemAbout)
        AddHandler MenuItemAbout.Click, AddressOf Me.OnMenuAbout

        Dim MenuItemOrder As New MenuItem
        MenuItemOrder.Text = "Order FlashPlayerControl .NET"
        Menu.MenuItems.Add(MenuItemOrder)
        AddHandler MenuItemOrder.Click, AddressOf Me.OnMenuOrder

        ContextMenu = Menu
    End Sub

    Private Sub OnMenuMinimize(ByVal sender As Object, ByVal e As System.EventArgs)
        WindowState = FormWindowState.Minimized
    End Sub

    Private Sub OnMenuClose(ByVal sender As Object, ByVal e As System.EventArgs)
        Close()
    End Sub

    Private Sub OnMenuAbout(ByVal sender As Object, ByVal e As System.EventArgs)
        ShellExecuteA(0, Nothing, "http://www.flashplayercontrol.com/dotnet/", Nothing, Nothing, SW_SHOW)
    End Sub

    Private Sub OnMenuOrder(ByVal sender As Object, ByVal e As System.EventArgs)
        ShellExecuteA(0, Nothing, "http://www.flashplayercontrol.com/dotnet/order.html", Nothing, Nothing, SW_SHOW)
    End Sub
End Class
