//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "RVTable.hpp"

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "RichView"
#pragma link "RVEdit"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma link "RVTable"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
// Callback function for EnumFontFamilies
int CALLBACK EnumFontCharsets(const ENUMLOGFONT FAR *lpelf,
    const NEWTEXTMETRIC FAR *lpntm,
    int FontType,
    LPARAM lParam)
{
  TForm1 * frm = (TForm1*)lParam;
  frm->Found = lpelf->elfLogFont.lfCharSet==frm->CurrentCharset;
  return (frm->Found)? 0 : 1;
}
//---------------------------------------------------------------------------
// Calling "Changed()" for all tables
void EnsureReformatting(TCustomRVData* RVData)
{
  TRVTableItemInfo* table;
  for (int i = 0; i < RVData->Items->Count; i++)
    if (RVData->GetItemStyle(i)==rvsTable)
    {
      table = (TRVTableItemInfo*)RVData->GetItem(i);
      table->Changed();
      for (int r=0; r<table->Rows->Count-1; r++)
        for (int c=0; c<table->Rows->Items[r]->Count; c++)
          if (table->Cells[r][c])
            EnsureReformatting(table->Cells[r][c]->GetRVData());
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  Screen->Cursor = crHourGlass;
  FillComboBox(cmbA, ARABIC_CHARSET);
  FillComboBox(cmbH, HEBREW_CHARSET);
  rveA->Clear();
  rveH->Clear();
  if (cmbA->Items->Count>0)
  {
    rveA->AddNL("Open Arabic RTF or text file, for example ARABIC.RTF",0,0);
    rveA->Format();
    cmbA->ItemIndex = 0;
    cmbAClick(cmbA);
  }
  else
  {
    rveA->AddNL("There are no Arabic fonts installed",0,0);
    rveA->Format();
    btnOpenA->Enabled = false;
  }
  if (cmbH->Items->Count>0)
  {
    rveH->AddNL("Open Hebrew RTF or text file, for example HEBREW.RTF",0,0);
    rveH->Format();
    cmbH->ItemIndex = 0;
    cmbHClick(cmbH);
  }
  else
  {
    rveH->AddNL("There are no Hebrew fonts installed",0,0);
    rveH->Format();
    btnOpenH->Enabled = false;
  }
  Screen->Cursor = crDefault;
}
//---------------------------------------------------------------------------
// Filling combobox with fonts with given charset
void TForm1::FillComboBox(TComboBox* cmb, TFontCharset Charset)
{
  CurrentCharset = Charset;
  HDC DC = GetDC(0);
  cmb->Items->BeginUpdate();
  for (int i=0; i<Screen->Fonts->Count; i++)
  {
    Found = false;
    EnumFontFamilies(DC, Screen->Fonts->Strings[i].c_str(), (FONTENUMPROC)EnumFontCharsets, (LPARAM)this);
    if (Found)
      cmb->Items->Add(Screen->Fonts->Strings[i]);
  }
  cmb->Items->EndUpdate();
  ReleaseDC(0, DC);
}
//---------------------------------------------------------------------------
// Changing font of all text styles
void TForm1::ApplyFont(const AnsiString FontName, TRVStyle* rvs,
                        TFontCharset Charset,
                        TRichViewEdit* rve)
{
  for (int i=0; i<rvs->TextStyles->Count; i++)
  {
    rvs->TextStyles->Items[i]->FontName = FontName;
    rvs->TextStyles->Items[i]->Charset = Charset;
  }
  rve->SetSelectionBounds(0, rve->GetOffsBeforeItem(0),0, rve->GetOffsBeforeItem(0));
  EnsureReformatting(rve->RVData);
  rve->Format();
}
//---------------------------------------------------------------------------
void TForm1::OpenFile(TRichViewEdit* rve)
{
  if (!od->Execute())
    return;
  rve->Clear();
  bool r = false;
  switch (od->FilterIndex)
  {
    case 1:
      r = rve->LoadRTF(od->FileName);
      break;
    case 2:
      r = rve->LoadText(od->FileName,0,0,false);
      break;
  }
  if (!r)
    Application->MessageBox("Error loading file", "Error", MB_OK | MB_ICONSTOP);
  rve->Format();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::cmbAClick(TObject *Sender)
{
  if (cmbA->ItemIndex>=0)
    ApplyFont(cmbA->Items->Strings[cmbA->ItemIndex], rvsA, ARABIC_CHARSET, rveA);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::cmbHClick(TObject *Sender)
{
  if (cmbH->ItemIndex>=0)
    ApplyFont(cmbH->Items->Strings[cmbH->ItemIndex], rvsH, HEBREW_CHARSET, rveH);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::btnOpenAClick(TObject *Sender)
{
  OpenFile(rveA);
  cmbAClick(cmbA);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::btnOpenHClick(TObject *Sender)
{
  OpenFile(rveH);
  cmbHClick(cmbH);
}
//---------------------------------------------------------------------------

