//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "fLayers.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
bool LayersDialogExecute(TsgDXFImage *AImage, TControl *Control)
{
  if (AImage == NULL) return false;
  bool Result = false;
  TfmLayers *fmLayers = new TfmLayers(Application);
  try
  {
    fmLayers->Control = Control;
    fmLayers->Image = AImage;
    for (int i = 0; i < AImage->Converter->Counts[csLayers]; i++)
    {
      fmLayers->clbLayers->Items->AddObject(AImage->Converter->Layers[i]->Name,
        AImage->Converter->Layers[i]);
      fmLayers->clbLayers->Checked[i] = AImage->Converter->Layers[i]->Visible;
    }
    if (fmLayers->clbLayers->Items->Count > 0)
      fmLayers->clbLayers->ItemIndex = 0;
    TList *vSLs = new TList;
    for (int i = 0; i < AImage->Converter->Counts[csLayers]; i++)
      vSLs->Add((void *)AImage->Converter->Layers[i]->Visible);
    fmLayers->ShowModal();
    Result = fmLayers->ModalResult == mrOk;
    if (fmLayers->ModalResult == mrCancel)
    {
      for (int i = 0; i < AImage->Converter->Counts[csLayers]; i++)
        AImage->Converter->Layers[i]->Visible = bool(vSLs->Items[i]);
      fmLayers->Control->Invalidate();
    }
    delete vSLs;
  }
  __finally
  {
    delete fmLayers;
  }
  return Result;
}

//---------------------------------------------------------------------------
__fastcall TfmLayers::TfmLayers(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------


void __fastcall TfmLayers::SetControl(TControl *value)
{
  FControl = value;
}

TControl* __fastcall TfmLayers::GetControl()
{
  return FControl;
}


void __fastcall TfmLayers::SetImage(TsgDXFImage * value)
{
  FImage = value;
}

TsgDXFImage * __fastcall TfmLayers::GetImage()
{
  return FImage;
}


void __fastcall TfmLayers::FormKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
  switch (Key) {
    case VK_ESCAPE:
      Close();
      break;
  }

}
//---------------------------------------------------------------------------

void __fastcall TfmLayers::clbLayersClickCheck(TObject *Sender)
{
  for (int i = 0; i < clbLayers->Items->Count; i++)
  {
    ((TsgDXFLayer *)(clbLayers->Items->Objects[i]))->Visible =
      clbLayers->Checked[i];
  }
  FControl->Invalidate();
}
//---------------------------------------------------------------------------

void __fastcall TfmLayers::clbLayersDrawItem(TWinControl *Control,
      int Index, TRect &Rect, TOwnerDrawState State)
{
  if (Index > clbLayers->Items->Count - 1) return;
  clbLayers->Canvas->Pen->Color = clWindow;
  clbLayers->Canvas->Rectangle(Rect.Left, Rect.Top, Rect.Right, Rect.Bottom);
  clbLayers->Canvas->Pen->Color = clWindowFrame;
  clbLayers->Canvas->Brush->Color =
    ((TsgDXFLayer *)(clbLayers->Items->Objects[Index]))->Pen->Color;
  clbLayers->Canvas->Rectangle(Rect.Left, Rect.Top + 2, Rect.Left + 16,
    Rect.Bottom - 2);
  clbLayers->Canvas->Brush->Color = clWindow;
  TOwnerDrawState St;
  if (State == St)
  {
    clbLayers->Canvas->Brush->Color = clWindow;
    clbLayers->Canvas->Pen->Color = clWindowText;
  }
  else
  {
    clbLayers->Canvas->Brush->Color = clHighlight;
    clbLayers->Canvas->Pen->Color = clHighlightText;
  }
  clbLayers->Canvas->TextOut(Rect.Left + 24, Rect.Top,
    clbLayers->Items->Strings[Index]);
  clbLayers->Canvas->Brush->Color = clWindow;
  clbLayers->Canvas->Pen->Color = clWindowText;
}
//---------------------------------------------------------------------------

void __fastcall TfmLayers::clbLayersKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
  if (Key == VK_RETURN)
    ModalResult = mrOk;
}
//---------------------------------------------------------------------------

