// Borland C++ Builder
// Copyright (c) 1995, 2005 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Dxfconv.pas' rev: 10.00

#ifndef DxfconvHPP
#define DxfconvHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <Sysutils.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Math.hpp>	// Pascal unit
#include <Mvfont.hpp>	// Pascal unit
#include <Extrusion.hpp>	// Pascal unit
#include <Shx.hpp>	// Pascal unit
#include <Sglines.hpp>	// Pascal unit
#include <Sgconsts.hpp>	// Pascal unit
#include <Sghatch.hpp>	// Pascal unit
#include <Activex.hpp>	// Pascal unit
#include <Ttf.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Dxfconv
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS EsgDXFHatchError;
class PASCALIMPLEMENTATION EsgDXFHatchError : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	#pragma option push -w-inl
	/* Exception.Create */ inline __fastcall EsgDXFHatchError(const AnsiString Msg) : Sysutils::Exception(Msg) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EsgDXFHatchError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EsgDXFHatchError(int Ident)/* overload */ : Sysutils::Exception(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EsgDXFHatchError(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : Sysutils::Exception(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EsgDXFHatchError(const AnsiString Msg, int AHelpContext) : Sysutils::Exception(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EsgDXFHatchError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EsgDXFHatchError(int Ident, int AHelpContext)/* overload */ : Sysutils::Exception(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EsgDXFHatchError(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : Sysutils::Exception(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EsgDXFHatchError(void) { }
	#pragma option pop
	
};


#pragma option push -b-
enum TConvSection { csTables, csBlocks, csEntities, csLTypes, csLayers, csStyles, csDimStyles, csBlockRecords, csVPorts };
#pragma option pop

typedef TMetaClass* TsgDXFEntityClass;

typedef void __fastcall (__closure *TFPointProc)(const Sgconsts::TFPoint &P);

class DELPHICLASS TsgDXFEntity;
typedef int __fastcall (__closure *TsgCADEntityProc)(TsgDXFEntity* Entity);

#pragma option push -b-
enum TsgDXFTextPos { csNone, csFraction, csDenominator, csWord, csHiWord, csLowWord };
#pragma option pop

struct TsgPlotSettings;
typedef TsgPlotSettings *PsgPlotSettings;

struct TsgPlotSettings
{
	
public:
	int PlotLayoutFlag;
	int PlotPaperUnits;
	Byte StandardScaleType;
	double NumeratorOfCustomPrintScale;
	double DenominatorOfCustomPrintScale;
} ;

struct TsgCADIterate;
typedef TsgCADIterate *PsgCADIterate;

class DELPHICLASS TsgDXFInsert;
class DELPHICLASS TsgDXFCustomVertex;
class DELPHICLASS TsgDXFObjectEntity;
class DELPHICLASS TsgDXFConverter;
class DELPHICLASS TsgDXFLayer;
class PASCALIMPLEMENTATION TsgDXFEntity : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	TsgDXFEntity* operator[](int Index) { return Entities[Index]; }
	
protected:
	virtual Sgconsts::TFRect __fastcall GetBox();
	virtual Graphics::TColor __fastcall GetColor(void);
	virtual bool __fastcall GetComplex(void);
	virtual TsgDXFConverter* __fastcall GetConverter(void);
	virtual int __fastcall GetCount(void);
	virtual TsgDXFEntity* __fastcall GetEntity(int Index);
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
	virtual Sgconsts::TFPoint __fastcall GetExtrusion();
	virtual int __fastcall GetHandle(void);
	virtual TsgDXFLayer* __fastcall GetLayer(void);
	virtual float __fastcall GetLineTypeScale(void);
	virtual double __fastcall GetLineWeight(void);
	virtual Classes::TNotifyEvent __fastcall GetOnDraw();
	virtual int __fastcall GetPaperSpace(void);
	virtual char * __fastcall GetSrcEnd(void);
	virtual char * __fastcall GetSrcStart(void);
	virtual bool __fastcall GetVisible(void);
	virtual bool __fastcall GetVisibility(void);
	virtual void __fastcall Invoke(TsgDXFConverter* AConverter, TsgCADEntityProc Proc, TsgCADEntityProc FinishProc);
	virtual bool __fastcall IsInvoke(TsgDXFConverter* AConverter);
	virtual void __fastcall Loaded(TsgDXFConverter* AConverter);
	virtual void __fastcall SetExtrusion(const Sgconsts::TFPoint &Value);
	virtual void __fastcall SetHandle(const int Value);
	virtual void __fastcall SetLayer(const TsgDXFLayer* Value);
	virtual void __fastcall SetLineTypeScale(float Value);
	virtual void __fastcall SetLineWeight(double Value);
	virtual void __fastcall SetOnDraw(const Classes::TNotifyEvent Value);
	virtual void __fastcall SetPaperSpace(const int Value);
	virtual void __fastcall SetSrcEnd(const char * Value);
	virtual void __fastcall SetSrcStart(const char * Value);
	virtual void __fastcall SetVisible(bool Value);
	virtual void __fastcall SetVisibility(const bool Value);
	
public:
	__fastcall virtual TsgDXFEntity(void);
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	virtual bool __fastcall AddEntity(TsgDXFEntity* Entity);
	virtual void __fastcall Draw(void);
	virtual AnsiString __fastcall EntName();
	virtual bool __fastcall GetBoxPoints(TFPointProc Proc, bool Full);
	virtual double __fastcall GetThickness(void);
	virtual void __fastcall SetColor(Graphics::TColor Value);
	virtual void __fastcall SetLType(TsgDXFEntity* Value);
	virtual void __fastcall SetLWeight(int Value);
	__property Sgconsts::TFRect Box = {read=GetBox};
	__property bool Complex = {read=GetComplex, nodefault};
	__property TsgDXFConverter* Converter = {read=GetConverter};
	__property int Count = {read=GetCount, nodefault};
	__property Graphics::TColor Color = {read=GetColor, write=SetColor, nodefault};
	__property TsgDXFEntity* Entities[int Index] = {read=GetEntity/*, default*/};
	__property Sgconsts::TsgCADEnities EntType = {read=GetEntType, nodefault};
	__property int Handle = {read=GetHandle, write=SetHandle, nodefault};
	__property float LineTypeScale = {read=GetLineTypeScale, write=SetLineTypeScale};
	__property double LineWeight = {read=GetLineWeight, write=SetLineWeight};
	__property TsgDXFLayer* Layer = {read=GetLayer, write=SetLayer};
	__property Classes::TNotifyEvent OnDraw = {read=GetOnDraw, write=SetOnDraw};
	__property int PaperSpace = {read=GetPaperSpace, write=SetPaperSpace, nodefault};
	__property char * SrcEnd = {read=GetSrcEnd, write=SetSrcEnd};
	__property char * SrcStart = {read=GetSrcStart, write=SetSrcStart};
	__property bool Visible = {read=GetVisible, write=SetVisible, nodefault};
	__property bool Visibility = {read=GetVisibility, write=SetVisibility, nodefault};
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TsgDXFEntity(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TsgDXFObjectEntity : public TsgDXFEntity 
{
	typedef TsgDXFEntity inherited;
	
private:
	TsgDXFConverter* FConverter;
	int FHandle;
	TsgDXFLayer* FLayer;
	char *FSrcEnd;
	char *FSrcStart;
	bool FVisibility;
	
protected:
	virtual TsgDXFConverter* __fastcall GetConverter(void);
	virtual int __fastcall GetHandle(void);
	virtual TsgDXFLayer* __fastcall GetLayer(void);
	virtual char * __fastcall GetSrcEnd(void);
	virtual char * __fastcall GetSrcStart(void);
	virtual bool __fastcall GetVisibility(void);
	virtual void __fastcall SetHandle(const int Value);
	virtual void __fastcall SetLayer(const TsgDXFLayer* Value);
	virtual void __fastcall SetSrcEnd(const char * Value);
	virtual void __fastcall SetSrcStart(const char * Value);
	virtual void __fastcall SetVisibility(const bool Value);
	
public:
	__fastcall virtual TsgDXFObjectEntity(void);
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TsgDXFObjectEntity(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TsgDXFCustomVertex : public TsgDXFObjectEntity 
{
	typedef TsgDXFObjectEntity inherited;
	
private:
	Sgconsts::TFPoint FPoint;
	
protected:
	virtual Sgconsts::TFRect __fastcall GetBox();
	Sgconsts::TFPoint __fastcall GetPoint();
	virtual void __fastcall SetPoint(const Sgconsts::TFPoint &AValue);
	
public:
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	__property Sgconsts::TFPoint Point = {read=FPoint, write=SetPoint};
public:
	#pragma option push -w-inl
	/* TsgDXFObjectEntity.Create */ inline __fastcall virtual TsgDXFCustomVertex(void) : TsgDXFObjectEntity() { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TsgDXFCustomVertex(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgDXFBlock;
class DELPHICLASS TsgDXFGroup;
class DELPHICLASS TsgDXFViewport;
class DELPHICLASS TsgDXFPenEntity;
class PASCALIMPLEMENTATION TsgDXFPenEntity : public TsgDXFObjectEntity 
{
	typedef TsgDXFObjectEntity inherited;
	
private:
	Graphics::TPen* FPen;
	float FLineTypeScale;
	
protected:
	virtual Graphics::TColor __fastcall GetColor(void);
	virtual float __fastcall GetLineTypeScale(void);
	virtual void __fastcall SetLineTypeScale(float Value);
	
public:
	__fastcall virtual TsgDXFPenEntity(void);
	__fastcall virtual ~TsgDXFPenEntity(void);
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	virtual void __fastcall SetColor(Graphics::TColor Value);
	__property Graphics::TPen* Pen = {read=FPen};
};


class PASCALIMPLEMENTATION TsgDXFViewport : public TsgDXFPenEntity 
{
	typedef TsgDXFPenEntity inherited;
	
private:
	float FBackClipPlane;
	Sgconsts::TFRect FBox;
	TsgDXFEntity* FClippingBoundary;
	int FClippingBoundaryHandle;
	int FFlags;
	float FFrontClipPlane;
	Classes::TList* FFrozenLayers;
	double FMatrix[4][3];
	Sgconsts::TFPoint FMSpaceCenter;
	float FMSpaceHeight;
	int FOrdIndex;
	TsgDXFBlock* FPaperSpaceBlock;
	Sgconsts::TFPoint FPSpaceCenter;
	float FPSpaceHeight;
	float FPSpaceWidth;
	Sgconsts::TFRect FRect;
	Sgconsts::TFPoint FScale;
	int FStatusField;
	int FThisID;
	Sgconsts::TFPoint FViewDirection;
	Sgconsts::TFPoint FViewTarget;
	float FViewTwistAngle;
	bool FVisibleBoundary;
	AnsiString FXDataAppName;
	
protected:
	float __fastcall GetBackClipPlane(void);
	virtual Sgconsts::TFRect __fastcall GetBox();
	bool __fastcall GetDrawModel(void);
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
	float __fastcall GetFrontClipPlane(void);
	Sgconsts::TFPoint __fastcall GetMSpaceCenter();
	float __fastcall GetPSpaceHeight(void);
	float __fastcall GetPSpaceWidth(void);
	Sgconsts::TFPoint __fastcall GetViewDirection();
	Sgconsts::TFPoint __fastcall GetViewTarget();
	float __fastcall GetViewTwistAngle(void);
	void __fastcall SetBackClipPlane(const float Value);
	void __fastcall SetFrontClipPlane(const float Value);
	void __fastcall SetMSpaceCenter(const Sgconsts::TFPoint &Value);
	void __fastcall SetPSpaceHeight(const float Value);
	void __fastcall SetPSpaceWidth(const float Value);
	void __fastcall SetViewDirection(const Sgconsts::TFPoint &Value);
	void __fastcall SetViewTarget(const Sgconsts::TFPoint &Value);
	void __fastcall SetViewTwistAngle(const float Value);
	virtual void __fastcall Invoke(TsgDXFConverter* AConverter, TsgCADEntityProc Proc, TsgCADEntityProc FinishProc);
	virtual void __fastcall Loaded(TsgDXFConverter* AConverter);
	
public:
	__fastcall virtual TsgDXFViewport(void);
	__fastcall virtual ~TsgDXFViewport(void);
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	TsgDXFEntity* __fastcall GetBoundary(TsgDXFConverter* AConverter);
	void __fastcall Offset(const Sgconsts::TFPoint &P);
	void __fastcall SetBoundary(TsgDXFEntity* ABoundary);
	__property float BackClipPlane = {read=GetBackClipPlane, write=SetBackClipPlane};
	__property int ClippingBoundaryHandle = {read=FClippingBoundaryHandle, write=FClippingBoundaryHandle, nodefault};
	__property int Flags = {read=FFlags, write=FFlags, nodefault};
	__property float FrontClipPlane = {read=GetFrontClipPlane, write=SetFrontClipPlane};
	__property Classes::TList* FrozenLayers = {read=FFrozenLayers, write=FFrozenLayers};
	__property Sgconsts::TFPoint MSpaceCenter = {read=GetMSpaceCenter, write=SetMSpaceCenter};
	__property float MSpaceHeight = {read=FMSpaceHeight, write=FMSpaceHeight};
	__property int OrdIndex = {read=FOrdIndex, write=FOrdIndex, nodefault};
	__property Sgconsts::TFPoint PSpaceCenter = {read=FPSpaceCenter, write=FPSpaceCenter};
	__property float PSpaceHeight = {read=GetPSpaceHeight, write=SetPSpaceHeight};
	__property float PSpaceWidth = {read=GetPSpaceWidth, write=SetPSpaceWidth};
	__property Sgconsts::TFRect Rect = {read=FRect};
	__property int StatusField = {read=FStatusField, write=FStatusField, nodefault};
	__property int ThisID = {read=FThisID, write=FThisID, nodefault};
	__property Sgconsts::TFPoint ViewDirection = {read=GetViewDirection, write=SetViewDirection};
	__property Sgconsts::TFPoint ViewTarget = {read=GetViewTarget, write=SetViewTarget};
	__property float ViewTwistAngle = {read=GetViewTwistAngle, write=SetViewTwistAngle};
	__property bool VisibleBoundary = {read=FVisibleBoundary, write=FVisibleBoundary, nodefault};
	__property AnsiString XDataAppName = {read=FXDataAppName, write=FXDataAppName};
};


class PASCALIMPLEMENTATION TsgDXFGroup : public TsgDXFObjectEntity 
{
	typedef TsgDXFObjectEntity inherited;
	
private:
	Sgconsts::TFRect FBox;
	Classes::TList* FEntities;
	
protected:
	int FViewPortOrdIndex;
	TsgDXFViewport* FViewPortWithMinIndex;
	virtual Sgconsts::TFRect __fastcall GetBox();
	virtual int __fastcall GetCount(void);
	virtual TsgDXFEntity* __fastcall GetEntity(int Index);
	virtual void __fastcall Loaded(TsgDXFConverter* AConverter);
	void __fastcall SortEntByHandle(void);
	__property Classes::TList* List = {read=FEntities};
	
public:
	__fastcall virtual TsgDXFGroup(void);
	__fastcall virtual ~TsgDXFGroup(void);
	virtual void __fastcall Iterate(TsgDXFConverter* AConverter, TsgCADEntityProc Proc, TsgCADEntityProc FinishProc);
};


class DELPHICLASS TsgDXFXref;
class PASCALIMPLEMENTATION TsgDXFXref : public TsgDXFObjectEntity 
{
	typedef TsgDXFObjectEntity inherited;
	
private:
	Sgconsts::TFRect FBox;
	System::TObject* FCADImage;
	AnsiString FName;
	AnsiString FPath;
	
protected:
	bool __fastcall AddCADImage(const AnsiString AFilePath, const AnsiString ASearchPath);
	virtual Sgconsts::TFRect __fastcall GetBox();
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
	virtual void __fastcall Invoke(TsgDXFConverter* AConverter, TsgCADEntityProc Proc, TsgCADEntityProc FinishProc);
	virtual void __fastcall Loaded(TsgDXFConverter* AConverter);
	
public:
	__fastcall virtual ~TsgDXFXref(void);
	__property System::TObject* CADImage = {read=FCADImage};
	__property AnsiString Name = {read=FName};
	__property AnsiString Path = {read=FPath};
public:
	#pragma option push -w-inl
	/* TsgDXFObjectEntity.Create */ inline __fastcall virtual TsgDXFXref(void) : TsgDXFObjectEntity() { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TsgDXFBlock : public TsgDXFGroup 
{
	typedef TsgDXFGroup inherited;
	
private:
	Byte FFlags;
	int FInserts;
	int FLCount;
	bool FLoaded;
	AnsiString FName;
	Sgconsts::TFPoint FOffset;
	AnsiString FSoftPointerID;
	bool FSpecPaperSpace;
	TsgDXFXref* FXref;
	AnsiString FXrefPath;
	void __fastcall ChkBox(TsgDXFConverter* AConverter);
	
protected:
	virtual bool __fastcall GetComplex(void);
	void __fastcall ApplyBox(void);
	virtual void __fastcall Loaded(TsgDXFConverter* AConverter);
	
public:
	__fastcall virtual TsgDXFBlock(void);
	virtual bool __fastcall AddEntity(TsgDXFEntity* Entity);
	bool __fastcall DeleteEntity(TsgDXFEntity* AEntity, bool DoFree);
	virtual AnsiString __fastcall EntName();
	__property Byte Flags = {read=FFlags, write=FFlags, nodefault};
	__property bool IsLoaded = {read=FLoaded, write=FLoaded, nodefault};
	__property AnsiString Name = {read=FName, write=FName};
	__property Sgconsts::TFPoint Offset = {read=FOffset, write=FOffset};
	__property bool SpecPaperSpace = {read=FSpecPaperSpace, nodefault};
	__property TsgDXFXref* Xref = {read=FXref};
	__property AnsiString XrefPath = {read=FXrefPath, write=FXrefPath};
	__property AnsiString SoftPointerID = {read=FSoftPointerID, write=FSoftPointerID};
public:
	#pragma option push -w-inl
	/* TsgDXFGroup.Destroy */ inline __fastcall virtual ~TsgDXFBlock(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgDXFAttrib;
class PASCALIMPLEMENTATION TsgDXFInsert : public TsgDXFCustomVertex 
{
	typedef TsgDXFCustomVertex inherited;
	
private:
	float FAngle;
	Classes::TList* FAttribs;
	TsgDXFBlock* FBlock;
	Graphics::TColor FColor;
	Sgconsts::TFPoint FExtrusion;
	double FLineWeight;
	double FMatrix[4][3];
	AnsiString FName;
	TsgDXFInsert* FOwner;
	double *FPrevMatrixPtr;
	Sgconsts::TFPoint FScale;
	
protected:
	Sgconsts::TFRect FBox;
	TsgDXFConverter* FResolveConverter;
	float __fastcall GetAngle(void);
	virtual Sgconsts::TFRect __fastcall GetBox();
	virtual Graphics::TColor __fastcall GetColor(void);
	virtual int __fastcall GetCount(void);
	virtual TsgDXFEntity* __fastcall GetEntity(int Index);
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
	virtual Sgconsts::TFPoint __fastcall GetExtrusion();
	virtual double __fastcall GetLineWeight(void);
	AnsiString __fastcall GetName();
	Sgconsts::TFPoint __fastcall GetScale();
	virtual void __fastcall InitializeMatrix(void);
	virtual void __fastcall Invoke(TsgDXFConverter* AConverter, TsgCADEntityProc Proc, TsgCADEntityProc FinishProc);
	virtual void __fastcall Loaded(TsgDXFConverter* AConverter);
	void __fastcall ReloadAttribs(TsgDXFConverter* AConverter);
	void __fastcall Resolve(TsgDXFConverter* AConverter);
	virtual void __fastcall SetAngle(float Value);
	virtual void __fastcall SetExtrusion(const Sgconsts::TFPoint &Value);
	virtual void __fastcall SetLineWeight(double Value);
	virtual void __fastcall SetPoint(const Sgconsts::TFPoint &AValue);
	void __fastcall SetScale(const Sgconsts::TFPoint &Value);
	
public:
	__fastcall virtual TsgDXFInsert(void);
	virtual bool __fastcall AddEntity(TsgDXFEntity* Entity);
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	TsgDXFAttrib* __fastcall Attrib(const AnsiString S, Sgconsts::TFPoint &P);
	__fastcall virtual ~TsgDXFInsert(void);
	virtual AnsiString __fastcall EntName();
	TsgDXFBlock* __fastcall FindBlock(TsgDXFConverter* AConverter, const AnsiString AName);
	double __fastcall GetMatrix();
	Graphics::TColor __fastcall RealColor(Graphics::TColor AColor);
	TsgDXFLayer* __fastcall RealLayer(void);
	virtual void __fastcall SetColor(Graphics::TColor Value);
	void __fastcall SetMatrix(double * Value);
	__property float Angle = {read=FAngle, write=SetAngle};
	__property Classes::TList* Attribs = {read=FAttribs};
	__property TsgDXFBlock* Block = {read=FBlock, write=FBlock};
	__property Sgconsts::TFPoint Extrusion = {read=GetExtrusion, write=SetExtrusion};
	__property Sgconsts::TFPoint Scale = {read=GetScale, write=SetScale};
	__property TsgDXFInsert* Owner = {read=FOwner};
};


struct TsgCADIterate
{
	
public:
	double Matrix[4][3];
	TsgDXFInsert* Insert;
	Graphics::TColor Color;
	float XScale;
	float YScale;
	float Angle;
	int Additional;
} ;

struct TsgArc;
typedef TsgArc *PsgArc;

struct TsgArc
{
	
public:
	Sgconsts::TFRect Rect;
	Sgconsts::TFPoint Center;
	Sgconsts::TFPoint Point1;
	Sgconsts::TFPoint Point2;
	double Ang1;
	double Ang2;
	double Rx;
	double Ry;
	bool Valid;
} ;

struct TsgTextParse;
typedef TsgTextParse *PsgTextParse;

#pragma pack(push,1)
struct TsgTextParse
{
	
public:
	double OffsetX;
	double OffsetY;
	double ParamPI;
	double ParamPL;
	double ParamPT;
	TsgDXFTextPos TextPos;
} ;
#pragma pack(pop)

struct TsgHeadVarStruct;
typedef TsgHeadVarStruct *PsgHeadVarStruct;

struct TsgHeadVarStruct
{
	
public:
	bool DimAlt;
	double DimAltF;
	AnsiString DimAPost;
	double DimAsz;
	double DimLFac;
	AnsiString DIMPOST;
	double DimScale;
	int CodePage;
	double LScale;
	bool Measurement;
	int PointDisplayMode;
	double PointDisplaySize;
	int TileMode;
	Sgconsts::TFPoint UCSORG;
	Sgconsts::TFPoint UCSXDir;
	Sgconsts::TFPoint UCSYDir;
} ;

typedef int TsgPolyFaceVertexIndexes[4];

typedef int *PsgPolyFaceVertexIndexes;

class DELPHICLASS TsgDXFVport;
class PASCALIMPLEMENTATION TsgDXFVport : public TsgDXFObjectEntity 
{
	typedef TsgDXFObjectEntity inherited;
	
protected:
	int FCircleZoomPercent;
	AnsiString FName;
	double FViewAspectRatio;
	Sgconsts::TFPoint FViewCenterPoint;
	Sgconsts::TFPoint FViewDirection;
	double FViewHeight;
	float FViewTwistAngle;
	Sgconsts::TFPoint FUCSOrigin;
	Sgconsts::TFPoint FUCSYDir;
	Sgconsts::TFPoint FUCSXDir;
	bool FUCSVP;
	Sgconsts::TFPoint __fastcall GetViewDirection();
	double __fastcall GetViewHeight(void);
	float __fastcall GetViewTwistAngle(void);
	void __fastcall SetViewDirection(const Sgconsts::TFPoint &Value);
	void __fastcall SetViewHeight(const double Value);
	void __fastcall SetViewTwistAngle(const float Value);
	virtual void __fastcall Loaded(TsgDXFConverter* AConverter);
	
public:
	__fastcall virtual TsgDXFVport(void);
	__property int CircleZoomPercent = {read=FCircleZoomPercent, write=FCircleZoomPercent, nodefault};
	__property AnsiString Name = {read=FName, write=FName};
	__property double ViewAspectRatio = {read=FViewAspectRatio, write=FViewAspectRatio};
	__property Sgconsts::TFPoint ViewCenterPoint = {read=FViewCenterPoint, write=FViewCenterPoint};
	__property Sgconsts::TFPoint ViewDirection = {read=GetViewDirection, write=SetViewDirection};
	__property double ViewHeight = {read=GetViewHeight, write=SetViewHeight};
	__property float ViewTwistAngle = {read=GetViewTwistAngle, write=SetViewTwistAngle};
	__property Sgconsts::TFPoint UCSOrigin = {read=FUCSOrigin, write=FUCSOrigin};
	__property Sgconsts::TFPoint UCSXDir = {read=FUCSYDir, write=FUCSYDir};
	__property Sgconsts::TFPoint UCSYDir = {read=FUCSXDir, write=FUCSXDir};
	__property bool UCSVP = {read=FUCSVP, write=FUCSVP, nodefault};
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TsgDXFVport(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgDXFSection;
class DELPHICLASS TsgDXFTable;
class PASCALIMPLEMENTATION TsgDXFTable : public TsgDXFGroup 
{
	typedef TsgDXFGroup inherited;
	
private:
	AnsiString FName;
	Classes::TStringList* FSortEntList;
	void __fastcall SetName(const AnsiString AName);
	
protected:
	virtual bool __fastcall GetComplex(void);
	TsgDXFEntity* __fastcall FindEntByName(const AnsiString AName);
	
public:
	__fastcall virtual TsgDXFTable(void);
	__fastcall virtual ~TsgDXFTable(void);
	virtual bool __fastcall AddEntity(TsgDXFEntity* Entity);
	virtual AnsiString __fastcall EntName();
	__property AnsiString Name = {read=FName, write=SetName};
};


class PASCALIMPLEMENTATION TsgDXFSection : public TsgDXFTable 
{
	typedef TsgDXFTable inherited;
	
protected:
	virtual void __fastcall Loaded(TsgDXFConverter* AConverter);
	
public:
	virtual bool __fastcall AddEntity(TsgDXFEntity* Entity);
public:
	#pragma option push -w-inl
	/* TsgDXFTable.Create */ inline __fastcall virtual TsgDXFSection(void) : TsgDXFTable() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TsgDXFTable.Destroy */ inline __fastcall virtual ~TsgDXFSection(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgDXFSortEntsTable;
class PASCALIMPLEMENTATION TsgDXFSortEntsTable : public TsgDXFObjectEntity 
{
	typedef TsgDXFObjectEntity inherited;
	
private:
	Classes::TList* FHandlesNew;
	Classes::TList* FHandlesOld;
	
protected:
	virtual void __fastcall Loaded(TsgDXFConverter* AConverter);
	
public:
	__fastcall virtual TsgDXFSortEntsTable(void);
	__fastcall virtual ~TsgDXFSortEntsTable(void);
	bool __fastcall ReplaceHandle(TsgDXFEntity* AEntity);
	__property Classes::TList* HandlesNew = {read=FHandlesNew};
	__property Classes::TList* HandlesOld = {read=FHandlesOld};
};


class DELPHICLASS TsgDXFDimensionStyle;
class DELPHICLASS TsgDXFImageDef;
class DELPHICLASS TsgDXFLayout;
class DELPHICLASS TsgDXFLineType;
class DELPHICLASS TsgDXFStyle;
class DELPHICLASS TsgDXFProxy;
class PASCALIMPLEMENTATION TsgDXFConverter : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TsgDXFVport* FActiveVPort;
	int FAddedDimensionsCount;
	Classes::TNotifyEvent FAfterRead;
	bool FAllArcsAsCurves;
	int FANSI;
	bool FAutoInsert;
	TsgDXFSection* FBlocks;
	TsgDXFTable* FBlockRecords;
	Classes::TNotifyEvent FBeforeRead;
	Graphics::TCanvas* FCanvas;
	int FCount;
	int FDefaultLayoutIndex;
	TsgDXFTable* FDimStyles;
	Sgconsts::TFRect FExtents;
	TsgHeadVarStruct FHeadVarStruct;
	bool FIsCrossoverMatrix;
	Sgconsts::TsgImportMode FImportMode;
	bool FIs3D;
	bool FIsHaveActiveVPort;
	TsgDXFTable* FLayers;
	Classes::TList* FLayouts;
	Classes::TList* FImageDefs;
	char *FLimit;
	char *FHeadEnd;
	bool FLoading;
	TsgDXFTable* FLTypes;
	TsgDXFSection* FMain;
	TsgDXFConverter* FMainConverter;
	int FMaxEntities;
	int FNumberOfPartsInSpline;
	int FNumberOfPartsInCircle;
	int FOEM;
	Classes::TNotifyEvent FOnCreate;
	Classes::TNotifyEvent FOnRead;
	bool FPaperSpace;
	TsgCADIterate *FParams;
	char *FPos;
	int FRefs;
	Shx::TsgSHXFontList* FSHXFonts;
	TsgDXFSortEntsTable* FSortEntsTable;
	Classes::TCustomMemoryStream* FSource;
	TsgDXFTable* FStyles;
	TsgDXFSection* FTables;
	double FTransform3D[4][3];
	Sgconsts::TFRect FViewPortRect;
	bool FViewPortCut;
	double FViewTwistMatrix[4][3];
	TsgDXFTable* FVPorts;
	Classes::TList* FXRefs;
	AnsiString FXRefSearchPath;
	bool FOwnSource;
	TsgDXFBlock* __fastcall FEntities(void);
	TsgDXFVport* __fastcall GetActiveVPort(void);
	float __fastcall GetAngle(void);
	TsgDXFBlock* __fastcall GetBlock(int Index);
	int __fastcall GetCodePage(void);
	int __fastcall GetCount(TConvSection Index);
	int __fastcall GetCircleZoomPercent(void);
	int __fastcall GetDefaultLayoutIndex(void);
	TsgDXFDimensionStyle* __fastcall GetDimStyle(int Index);
	TsgDXFEntity* __fastcall GetEntity(int Index);
	Sgconsts::TFRect __fastcall GetExtents();
	Sgconsts::TFPoint __fastcall GetHeadVarAsFPt(AnsiString AName);
	TsgDXFImageDef* __fastcall GetImageDef(int Index);
	TsgDXFLayer* __fastcall GetLayer(int Index);
	TsgDXFLayout* __fastcall GetLayout(int Index);
	int __fastcall GetLayoutsCount(void);
	TsgDXFLineType* __fastcall GetLType(int Index);
	TsgDXFConverter* __fastcall GetMainConverter(Sgconsts::PFMatrix AMatrix);
	int __fastcall GetPointDisplayMode(void);
	TsgDXFGroup* __fastcall GetSection(TConvSection Index);
	Shx::TsgSHXFontList* __fastcall GetSHXFonts(void);
	TsgDXFStyle* __fastcall GetStyle(int Index);
	TsgDXFTable* __fastcall GetTable(int Index);
	Sgconsts::TFPoint __fastcall GetVPort();
	TsgDXFVport* __fastcall GetVPortByIndex(const int AIndex);
	void __fastcall DeleteModelLayout(void);
	void __fastcall DeletePaperLayout(void);
	void __fastcall HeadVarStructInit(void);
	void __fastcall ScanOEM(const AnsiString S);
	void __fastcall SetSection(TConvSection Index, TsgDXFGroup* Value);
	void __fastcall FreeSource(void);
	void __fastcall SetAngle(const float Angle);
	void __fastcall SetCircleZoomPercent(const int AVal);
	void __fastcall SetNumberOfPartsInCircle(const int ACount);
	void __fastcall SetNumberOfPartsInSpline(const int ACount);
	void __fastcall SetSource(Classes::TCustomMemoryStream* Value);
	void __fastcall SetOwnSource(bool Value);
	void __fastcall SetVPort(const Sgconsts::TFPoint &APt);
	void __fastcall SetPointDisplayMode(const int Value);
	void __fastcall SetLScale(const double Value);
	
protected:
	void __fastcall AddACADLayout(TsgDXFLayout* ALayout);
	void __fastcall AddDrawingLayout(System::TObject* ACADImage, AnsiString AName);
	AnsiString __fastcall BlockRecordNameByHandle(const int AHandle);
	void __fastcall FinalizeSections(void);
	TsgDXFLayout* __fastcall GetModelLayout(void);
	void __fastcall LoadProxySubEntities(Classes::TList* FProxies);
	void __fastcall ReadProxyData(TsgDXFProxy* AProxy, Sgconsts::TsgInt64 &PBit);
	void __fastcall ReplaceLayout(int Index, TsgDXFLayout* ALayout);
	void __fastcall SetCodePage(int ACodePage);
	void __fastcall SetLoading(bool Value, char * APos);
	virtual void __fastcall Initialize(const AnsiString FileName);
	__property TsgDXFVport* ActiveVPort = {read=GetActiveVPort, write=FActiveVPort};
	__property TsgDXFVport* VPorts[int AIndex] = {read=GetVPortByIndex};
	
public:
	__fastcall TsgDXFConverter(const AnsiString FileName);
	__fastcall virtual ~TsgDXFConverter(void);
	void __fastcall AddLayout(TsgDXFLayout* ALayout);
	void __fastcall AddXRef(System::TObject* ACADFile, AnsiString AName, const Sgconsts::TFPoint &APos, const Sgconsts::TFPoint &AScale, float Rotation);
	TsgDXFInsert* __fastcall AddXRefEx(System::TObject* ACADFile, AnsiString AName, const Sgconsts::TFPoint &APos, const Sgconsts::TFPoint &AScale, float Rotation, TsgDXFLayout* ALayout);
	TsgDXFBlock* __fastcall BlockByName(const AnsiString AName);
	void __fastcall CleaningLayouts(bool ADeletePSpace);
	void __fastcall Clear(void);
	int __fastcall Count(void);
	bool __fastcall DeleteEntity(TsgDXFEntity* AEntity, bool DoFree);
	bool __fastcall DeleteBlock(TsgDXFBlock* ABlock, bool DoFree);
	void __fastcall DoExtents(void);
	void __fastcall GetLayerNames(Classes::TStrings* S, bool DoClear, bool IncludeUnused);
	double __fastcall GetLScale(void);
	double __fastcall GetUCS(TsgDXFLayout* ALayout);
	double __fastcall GetTransform3d();
	AnsiString __fastcall HeadVar(const AnsiString VName, int Code);
	Graphics::TColor __fastcall IntToColor(int Value);
	int __fastcall ImageDefCount(void);
	void __fastcall InitializeSections(void);
	void __fastcall Iterate(TsgCADEntityProc Proc, TsgCADEntityProc FinishProc, TsgCADIterate &Params);
	TsgDXFLayer* __fastcall LayerByName(const AnsiString AName);
	Sglines::TsgLines* __fastcall LinesByName(const AnsiString AName);
	void __fastcall Load(void);
	void __fastcall Loads(TsgDXFEntity* E);
	TsgDXFLineType* __fastcall LTypeByName(const AnsiString AName);
	TsgDXFEntity* __fastcall NewEntity(TsgDXFEntity* AOwner, TMetaClass* AClass);
	bool __fastcall OEM(void);
	int __fastcall Pos(void);
	void __fastcall Reference(void);
	void __fastcall Release(void);
	void __fastcall SetTransform3d(double * AMatrix);
	void __fastcall SortEntities(void);
	void __fastcall SortEntitiesInZDepth(void);
	virtual void __fastcall StopLoading(void);
	void __fastcall SetSourceStream(Classes::TStream* S);
	TsgDXFDimensionStyle* __fastcall DimensionStyleByName(const AnsiString AName);
	TsgDXFStyle* __fastcall StyleByName(const AnsiString AName);
	double __fastcall ViewTwistMatrix();
	__property Classes::TNotifyEvent AfterRead = {read=FAfterRead, write=FAfterRead};
	__property bool AllArcsAsCurves = {read=FAllArcsAsCurves, write=FAllArcsAsCurves, nodefault};
	__property float Angle = {read=GetAngle, write=SetAngle};
	__property bool AutoInsert = {read=FAutoInsert, write=FAutoInsert, nodefault};
	__property Classes::TNotifyEvent BeforeRead = {read=FBeforeRead, write=FBeforeRead};
	__property TsgDXFBlock* Blocks[int Index] = {read=GetBlock};
	__property int CircleZoomPercent = {read=GetCircleZoomPercent, write=SetCircleZoomPercent, nodefault};
	__property int CodePage = {read=GetCodePage, nodefault};
	__property int Counts[TConvSection Index] = {read=GetCount};
	__property int DefaultLayoutIndex = {read=GetDefaultLayoutIndex, write=FDefaultLayoutIndex, nodefault};
	__property TsgDXFDimensionStyle* DimensionStyles[int Index] = {read=GetDimStyle};
	__property TsgHeadVarStruct HeadVarStruct = {read=FHeadVarStruct, write=FHeadVarStruct};
	__property bool IsCrossoverMatrix = {read=FIsCrossoverMatrix, write=FIsCrossoverMatrix, nodefault};
	__property bool IsHaveActiveVPort = {read=FIsHaveActiveVPort, write=FIsHaveActiveVPort, nodefault};
	__property TsgDXFEntity* Entities[int Index] = {read=GetEntity};
	__property Sgconsts::TFRect Extents = {read=GetExtents, write=FExtents};
	__property char * HeadEnd = {read=FHeadEnd, write=FHeadEnd};
	__property Sgconsts::TsgImportMode ImportMode = {read=FImportMode, write=FImportMode, nodefault};
	__property bool Is3D = {read=FIs3D, write=FIs3D, nodefault};
	__property TsgDXFLayer* Layers[int Index] = {read=GetLayer};
	__property TsgDXFLayout* Layouts[int Index] = {read=GetLayout};
	__property TsgDXFImageDef* ImageDefs[int Index] = {read=GetImageDef};
	__property int LayoutsCount = {read=GetLayoutsCount, nodefault};
	__property double LScale = {read=GetLScale, write=SetLScale};
	__property TsgDXFLineType* LTypes[int Index] = {read=GetLType};
	__property TsgDXFSection* Main = {read=FMain};
	__property int MaxEntities = {read=FMaxEntities, write=FMaxEntities, nodefault};
	__property int NumberOfPartsInSpline = {read=FNumberOfPartsInSpline, write=SetNumberOfPartsInSpline, nodefault};
	__property int NumberOfPartsInCircle = {read=FNumberOfPartsInCircle, write=SetNumberOfPartsInCircle, nodefault};
	__property Classes::TNotifyEvent OnCreate = {read=FOnCreate, write=FOnCreate};
	__property Classes::TNotifyEvent OnRead = {read=FOnRead, write=FOnRead};
	__property bool PaperSpace = {read=FPaperSpace, write=FPaperSpace, nodefault};
	__property PsgCADIterate Params = {read=FParams, write=FParams};
	__property int PointDisplayMode = {read=GetPointDisplayMode, write=SetPointDisplayMode, nodefault};
	__property TsgDXFGroup* Sections[TConvSection Index] = {read=GetSection, write=SetSection};
	__property Shx::TsgSHXFontList* SHXFonts = {read=GetSHXFonts};
	__property Classes::TCustomMemoryStream* Source = {read=FSource, write=SetSource};
	__property bool OwnSource = {read=FOwnSource, write=SetOwnSource, nodefault};
	__property TsgDXFStyle* Styles[int Index] = {read=GetStyle};
	__property TsgDXFTable* Tables[int Index] = {read=GetTable};
	__property bool ViewPortCut = {read=FViewPortCut, nodefault};
	__property Sgconsts::TFPoint VPort = {read=GetVPort, write=SetVPort};
	__property Classes::TList* XRefs = {read=FXRefs};
	__property AnsiString XRefSearchPath = {read=FXRefSearchPath, write=FXRefSearchPath};
};


class DELPHICLASS TsgDXFEntitySample;
class DELPHICLASS TsgDXFImageEnt;
class DELPHICLASS TsgDXFSolid;
class DELPHICLASS TsgDXFLine;
class DELPHICLASS TsgDXFPenLine;
class PASCALIMPLEMENTATION TsgDXFPenLine : public TsgDXFPenEntity 
{
	typedef TsgDXFPenEntity inherited;
	
private:
	Sgconsts::TFPoint FExtrusion;
	TsgDXFLineType* FLineType;
	Sgconsts::TFPoint FPoint;
	double FLineWeight;
	float FZThick;
	
protected:
	void __fastcall AddThickness(Sgconsts::TFRect &R);
	virtual Sgconsts::TFRect __fastcall GetBox();
	virtual Sgconsts::TFPoint __fastcall GetExtrusion();
	Sglines::TsgLines* __fastcall GetLines(void);
	TsgDXFLineType* __fastcall GetLineType(void);
	virtual double __fastcall GetLineWeight(void);
	Sgconsts::TFPoint __fastcall GetPoint();
	virtual void __fastcall Loaded(TsgDXFConverter* AConverter);
	virtual void __fastcall SetExtrusion(const Sgconsts::TFPoint &Value);
	void __fastcall SetLineType(TsgDXFLineType* AValue);
	virtual void __fastcall SetLineWeight(double Value);
	void __fastcall SetPoint(const Sgconsts::TFPoint &AValue);
	
public:
	__fastcall virtual TsgDXFPenLine(void);
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	virtual double __fastcall GetThickness(void);
	__property Sgconsts::TFPoint Extrusion = {read=GetExtrusion, write=SetExtrusion};
	__property Sglines::TsgLines* Lines = {read=GetLines};
	__property TsgDXFLineType* LineType = {read=GetLineType, write=SetLineType};
	virtual void __fastcall SetLType(TsgDXFEntity* Value);
	virtual void __fastcall SetLWeight(int Value);
	__property Sgconsts::TFPoint Point = {read=FPoint, write=FPoint};
	__property float ZThick = {read=FZThick, write=FZThick};
public:
	#pragma option push -w-inl
	/* TsgDXFPenEntity.Destroy */ inline __fastcall virtual ~TsgDXFPenLine(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TsgDXFLine : public TsgDXFPenLine 
{
	typedef TsgDXFPenLine inherited;
	
private:
	Classes::TList* FDottedSingPts;
	Sgconsts::TFPoint FPoint1;
	
protected:
	virtual Sgconsts::TFRect __fastcall GetBox();
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
	Sgconsts::TFPoint __fastcall GetPoint1();
	void __fastcall AddZThick(Sgconsts::TFRect &R);
	virtual void __fastcall Loaded(TsgDXFConverter* AConverter);
	void __fastcall SetPoint1(const Sgconsts::TFPoint &AValue);
	
public:
	__fastcall virtual TsgDXFLine(void);
	__fastcall virtual ~TsgDXFLine(void);
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	virtual bool __fastcall GetBoxPoints(TFPointProc Proc, bool Full);
	__property Sgconsts::TFPoint Point1 = {read=FPoint1, write=FPoint1};
	__property Classes::TList* DottedSingPts = {read=FDottedSingPts};
};


class PASCALIMPLEMENTATION TsgDXFSolid : public TsgDXFLine 
{
	typedef TsgDXFLine inherited;
	
private:
	Sgconsts::TFPoint FPoint2;
	Sgconsts::TFPoint FPoint3;
	
protected:
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
	virtual Sgconsts::TFRect __fastcall GetBox();
	Sgconsts::TFPoint __fastcall GetPoint2();
	Sgconsts::TFPoint __fastcall GetPoint3();
	virtual void __fastcall Loaded(TsgDXFConverter* AConverter);
	void __fastcall SetPoint2(const Sgconsts::TFPoint &AValue);
	void __fastcall SetPoint3(const Sgconsts::TFPoint &AValue);
	
public:
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	virtual bool __fastcall GetBoxPoints(TFPointProc Proc, bool Full);
	__property Sgconsts::TFPoint Point2 = {read=GetPoint2, write=SetPoint2};
	__property Sgconsts::TFPoint Point3 = {read=GetPoint3, write=SetPoint3};
public:
	#pragma option push -w-inl
	/* TsgDXFLine.Create */ inline __fastcall virtual TsgDXFSolid(void) : TsgDXFLine() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TsgDXFLine.Destroy */ inline __fastcall virtual ~TsgDXFSolid(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TsgDXFImageEnt : public TsgDXFSolid 
{
	typedef TsgDXFSolid inherited;
	
private:
	Graphics::TPicture* FPicture;
	int FImageDef;
	double FRotate;
	bool FIsMonoChrome;
	void __fastcall SetMonochrome(void);
	
protected:
	bool FFound;
	Byte FFlag;
	virtual void __fastcall ChangeGraphic(void);
	void __fastcall DoRotate(const double Angle);
	virtual bool __fastcall GetAnimate(void);
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
	virtual void __fastcall Loaded(TsgDXFConverter* AConverter);
	
public:
	__fastcall virtual ~TsgDXFImageEnt(void);
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	virtual AnsiString __fastcall EntName();
	void __fastcall FindPicture(TsgDXFConverter* AConverter);
	void __fastcall SetImage(Graphics::TGraphic* Image);
	__property Graphics::TPicture* Picture = {read=FPicture};
	__property int ImageDef = {read=FImageDef, write=FImageDef, nodefault};
	__property double Rotate = {read=FRotate, write=FRotate};
	__property bool IsMonoChrome = {read=FIsMonoChrome, write=FIsMonoChrome, nodefault};
public:
	#pragma option push -w-inl
	/* TsgDXFLine.Create */ inline __fastcall virtual TsgDXFImageEnt(void) : TsgDXFSolid() { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TsgDXFEntitySample : public TsgDXFEntity 
{
	typedef TsgDXFEntity inherited;
	
private:
	TsgDXFImageEnt* FBackGroundImage;
	Graphics::TColor FColor;
	double FFontHeight;
	AnsiString FFontName;
	TsgDXFLayer* FLayer;
	TsgDXFLineType* FLineType;
	double FLineTypeScale;
	
protected:
	TsgDXFImageEnt* __fastcall GetBackGroundImage(void);
	virtual Graphics::TColor __fastcall GetColor(void);
	double __fastcall GetFontHeight(void);
	AnsiString __fastcall GetFontName();
	virtual TsgDXFLayer* __fastcall GetLayer(void);
	TsgDXFLineType* __fastcall GetLineType(void);
	virtual float __fastcall GetLineTypeScale(void);
	void __fastcall SetBackGroundImage(const TsgDXFImageEnt* Value);
	void __fastcall SetFontHeight(const double Value);
	void __fastcall SetFontName(const AnsiString Value);
	virtual void __fastcall SetLayer(const TsgDXFLayer* Value);
	void __fastcall SetLineType(const TsgDXFLineType* AValue);
	virtual void __fastcall SetLineTypeScale(float Value);
	
public:
	__fastcall virtual TsgDXFEntitySample(void);
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	__property TsgDXFImageEnt* BackGroundImage = {read=GetBackGroundImage, write=SetBackGroundImage};
	virtual void __fastcall SetColor(Graphics::TColor Value);
	__property double FontHeight = {read=GetFontHeight, write=SetFontHeight};
	__property AnsiString FontName = {read=GetFontName, write=SetFontName};
	__property TsgDXFLineType* LineType = {read=GetLineType, write=SetLineType};
	__property float LineTypeScale = {read=GetLineTypeScale, write=SetLineTypeScale};
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TsgDXFEntitySample(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgDXFSeqend;
class PASCALIMPLEMENTATION TsgDXFSeqend : public TsgDXFObjectEntity 
{
	typedef TsgDXFObjectEntity inherited;
	
public:
	#pragma option push -w-inl
	/* TsgDXFObjectEntity.Create */ inline __fastcall virtual TsgDXFSeqend(void) : TsgDXFObjectEntity() { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TsgDXFSeqend(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgDXFPenTableItem;
class PASCALIMPLEMENTATION TsgDXFPenTableItem : public TsgDXFPenEntity 
{
	typedef TsgDXFPenEntity inherited;
	
protected:
	AnsiString FName;
	AnsiString __fastcall GetName();
	void __fastcall SetName(const AnsiString AName);
	
public:
	virtual AnsiString __fastcall EntName();
	__property AnsiString Name = {read=GetName, write=SetName};
public:
	#pragma option push -w-inl
	/* TsgDXFPenEntity.Create */ inline __fastcall virtual TsgDXFPenTableItem(void) : TsgDXFPenEntity() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TsgDXFPenEntity.Destroy */ inline __fastcall virtual ~TsgDXFPenTableItem(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TsgDXFLineType : public TsgDXFPenTableItem 
{
	typedef TsgDXFPenTableItem inherited;
	
protected:
	Sglines::TsgLines* FLines;
	virtual void __fastcall Loaded(TsgDXFConverter* AConverter);
	
public:
	__fastcall virtual TsgDXFLineType(void);
	__fastcall virtual ~TsgDXFLineType(void);
	__property Sglines::TsgLines* Lines = {read=FLines};
};


class PASCALIMPLEMENTATION TsgDXFLayer : public TsgDXFPenTableItem 
{
	typedef TsgDXFPenTableItem inherited;
	
private:
	TsgDXFLineType* FLineType;
	double FLineWeight;
	
protected:
	Byte FFlags;
	bool FIsFrozenByViewPort;
	bool FIsPlotting;
	bool FUsed;
	bool FVisible;
	virtual bool __fastcall GetVisible(void);
	bool __fastcall GetFrozen(void);
	Sglines::TsgLines* __fastcall GetLines(void);
	TsgDXFLineType* __fastcall GetLineType(void);
	virtual double __fastcall GetLineWeight(void);
	void __fastcall SetFrozen(bool AFrozen);
	virtual void __fastcall SetLineWeight(double Value);
	virtual void __fastcall SetVisible(bool Value);
	
public:
	__fastcall virtual TsgDXFLayer(void);
	virtual void __fastcall Loaded(TsgDXFConverter* AConverter);
	__property Byte Flags = {read=FFlags, write=FFlags, nodefault};
	__property bool Frozen = {read=GetFrozen, write=SetFrozen, nodefault};
	__property bool IsFrozenByViewPort = {read=FIsFrozenByViewPort, nodefault};
	__property Sglines::TsgLines* Lines = {read=GetLines};
	__property TsgDXFLineType* LineType = {read=GetLineType, write=FLineType};
	__property bool IsPlotting = {read=FIsPlotting, write=FIsPlotting, nodefault};
	__property bool Used = {read=FUsed, write=FUsed, nodefault};
public:
	#pragma option push -w-inl
	/* TsgDXFPenEntity.Destroy */ inline __fastcall virtual ~TsgDXFLayer(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgDXFBlockRecord;
class PASCALIMPLEMENTATION TsgDXFBlockRecord : public TsgDXFPenTableItem 
{
	typedef TsgDXFPenTableItem inherited;
	
public:
	#pragma option push -w-inl
	/* TsgDXFPenEntity.Create */ inline __fastcall virtual TsgDXFBlockRecord(void) : TsgDXFPenTableItem() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TsgDXFPenEntity.Destroy */ inline __fastcall virtual ~TsgDXFBlockRecord(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgDXFVertex;
class PASCALIMPLEMENTATION TsgDXFVertex : public TsgDXFEntity 
{
	typedef TsgDXFEntity inherited;
	
private:
	Sgconsts::TFPoint FPoint;
	int __fastcall GetPolyFaceIndex1(void);
	int __fastcall GetPolyFaceIndex2(void);
	int __fastcall GetPolyFaceIndex3(void);
	int __fastcall GetPolyFaceIndex4(void);
	void __fastcall NewPolyFaceIndexes(void);
	void __fastcall SetPolyFaceIndex1(const int Value);
	void __fastcall SetPolyFaceIndex2(const int Value);
	void __fastcall SetPolyFaceIndex3(const int Value);
	void __fastcall SetPolyFaceIndex4(const int Value);
	
protected:
	double FBulge;
	float FEndWidth;
	Byte FFlags;
	int *FPolyFaceIndexes;
	float FStartWidth;
	virtual Sgconsts::TFRect __fastcall GetBox();
	Sgconsts::TFPoint __fastcall GetPoint();
	void __fastcall SetPoint(const Sgconsts::TFPoint &AValue);
	
public:
	__fastcall virtual ~TsgDXFVertex(void);
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	__property double Bulge = {read=FBulge, write=FBulge};
	__property float EndWidth = {read=FEndWidth, write=FEndWidth};
	__property Byte Flags = {read=FFlags, write=FFlags, nodefault};
	__property Sgconsts::TFPoint Point = {read=FPoint, write=FPoint};
	__property int PolyFaceVertexIndex1 = {read=GetPolyFaceIndex1, write=SetPolyFaceIndex1, nodefault};
	__property int PolyFaceVertexIndex2 = {read=GetPolyFaceIndex2, write=SetPolyFaceIndex2, nodefault};
	__property int PolyFaceVertexIndex3 = {read=GetPolyFaceIndex3, write=SetPolyFaceIndex3, nodefault};
	__property int PolyFaceVertexIndex4 = {read=GetPolyFaceIndex4, write=SetPolyFaceIndex4, nodefault};
	__property float StartWidth = {read=FStartWidth, write=FStartWidth};
public:
	#pragma option push -w-inl
	/* TsgDXFEntity.Create */ inline __fastcall virtual TsgDXFVertex(void) : TsgDXFEntity() { }
	#pragma option pop
	
};


class DELPHICLASS TsgDXFPoint;
class PASCALIMPLEMENTATION TsgDXFPoint : public TsgDXFCustomVertex 
{
	typedef TsgDXFCustomVertex inherited;
	
private:
	int FColor;
	Sgconsts::TFPoint FExtrusion;
	float FZThick;
	
protected:
	Classes::TList* FPoints;
	void __fastcall ClearPoints(void);
	virtual Sgconsts::TFRect __fastcall GetBox();
	virtual Graphics::TColor __fastcall GetColor(void);
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
	virtual Sgconsts::TFPoint __fastcall GetExtrusion();
	virtual void __fastcall Invoke(TsgDXFConverter* AConverter, TsgCADEntityProc Proc, TsgCADEntityProc FinishProc);
	virtual void __fastcall Loaded(TsgDXFConverter* AConverter);
	virtual void __fastcall SetExtrusion(const Sgconsts::TFPoint &Value);
	
public:
	__fastcall virtual TsgDXFPoint(void);
	__fastcall virtual ~TsgDXFPoint(void);
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	virtual bool __fastcall GetBoxPoints(TFPointProc Proc, bool Full);
	virtual void __fastcall SetColor(Graphics::TColor Value);
	__property Sgconsts::TFPoint Extrusion = {read=GetExtrusion, write=SetExtrusion};
	__property float ZThick = {read=FZThick, write=FZThick};
};


class DELPHICLASS TsgDXF3dFace;
class PASCALIMPLEMENTATION TsgDXF3dFace : public TsgDXFSolid 
{
	typedef TsgDXFSolid inherited;
	
protected:
	int FFlags;
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
	
public:
	__property int Flags = {read=FFlags, write=FFlags, nodefault};
public:
	#pragma option push -w-inl
	/* TsgDXFLine.Create */ inline __fastcall virtual TsgDXF3dFace(void) : TsgDXFSolid() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TsgDXFLine.Destroy */ inline __fastcall virtual ~TsgDXF3dFace(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgDXFPolyline;
class PASCALIMPLEMENTATION TsgDXFPolyline : public TsgDXFPenLine 
{
	typedef TsgDXFPenLine inherited;
	
public:
	Sgconsts::TFPoint operator[](int Index) { return Points[Index]; }
	
private:
	Classes::TList* FArrows;
	Sgconsts::TFRect FBox;
	Classes::TList* FDottedSingPts;
	Classes::TList* FEntities;
	int FFlags;
	int FMeshM;
	int FMeshN;
	Classes::TList* FPolyFaceVertexIndexes;
	Classes::TList* FPolyLineEntities;
	Classes::TList* FPolyPoints;
	float FStartW;
	float FEndW;
	float FGlobalW;
	void __fastcall ApplyBulgeByPoint(const Sgconsts::TFPoint &P1, const Sgconsts::TFPoint &P2, double Bulge, Classes::TList* AList, int ANumberOfCircleParts);
	void __fastcall DoArrows(void);
	void __fastcall DoExtrusions(void);
	void __fastcall DoVertexes(void);
	void __fastcall DoZThick(void);
	bool __fastcall GetIsPolygonMesh(void);
	bool __fastcall GetIsPolyFaceMesh(void);
	bool __fastcall GetIsPolyZThickness(void);
	bool __fastcall GetIsMeshMClosed(void);
	bool __fastcall GetIsMeshNClosed(void);
	HIDESBASE Sgconsts::TFPoint __fastcall GetPoint(int Index);
	Sgconsts::TFPoint __fastcall GetDottedPoint(int Index);
	TsgDXFVertex* __fastcall GetVertex(int Index);
	
protected:
	virtual Sgconsts::TFRect __fastcall GetBox();
	virtual int __fastcall GetCount(void);
	virtual TsgDXFEntity* __fastcall GetEntity(int Index);
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
	float __fastcall GetGlobalWidth(void);
	bool __fastcall GetClosed(void);
	void __fastcall SetClosed(const bool AClosed);
	void __fastcall SetGlobalWidth(float AValue);
	void __fastcall ApplyBox(void);
	virtual void __fastcall CreateDottedList(void);
	virtual void __fastcall Loaded(TsgDXFConverter* AConverter);
	virtual void __fastcall ReloadPolyPoints(void);
	__property Classes::TList* List = {read=FEntities};
	__property TsgDXFVertex* Vertexes[int Index] = {read=GetVertex};
	
public:
	__fastcall virtual TsgDXFPolyline(void);
	__fastcall virtual ~TsgDXFPolyline(void);
	virtual bool __fastcall AddEntity(TsgDXFEntity* Entity);
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	virtual bool __fastcall GetBoxPoints(TFPointProc Proc, bool Full);
	virtual void __fastcall Iterate(TsgDXFConverter* AConverter, TsgCADEntityProc Proc, TsgCADEntityProc FinishProc);
	__property Classes::TList* Arrows = {read=FArrows, write=FArrows};
	__property bool Closed = {read=GetClosed, write=SetClosed, nodefault};
	__property Classes::TList* DottedSingPts = {read=FDottedSingPts};
	__property Sgconsts::TFPoint DottedPoints[int Index] = {read=GetDottedPoint};
	__property float EndWidth = {read=FEndW, write=FEndW};
	__property int Flags = {read=FFlags, write=FFlags, nodefault};
	__property float GlobalWidth = {read=FGlobalW, write=FGlobalW};
	__property bool IsMeshMClosed = {read=GetIsMeshMClosed, nodefault};
	__property bool IsMeshNClosed = {read=GetIsMeshNClosed, nodefault};
	__property bool IsPolygonMesh = {read=GetIsPolygonMesh, nodefault};
	__property bool IsPolyFaceMesh = {read=GetIsPolyFaceMesh, nodefault};
	__property bool IsPolyZThickness = {read=GetIsPolyZThickness, nodefault};
	__property int MeshM = {read=FMeshM, write=FMeshM, nodefault};
	__property int MeshN = {read=FMeshN, write=FMeshN, nodefault};
	__property Sgconsts::TFPoint Points[int Index] = {read=GetPoint/*, default*/};
	__property Classes::TList* PolyFaceVertexIndexes = {read=FPolyFaceVertexIndexes};
	__property Classes::TList* PolyLineEntities = {read=FPolyLineEntities};
	__property Classes::TList* PolyPoints = {read=FPolyPoints};
	__property float StartWidth = {read=FStartW, write=FStartW};
};


class DELPHICLASS TsgDXFLWPolyline;
class PASCALIMPLEMENTATION TsgDXFLWPolyline : public TsgDXFPolyline 
{
	typedef TsgDXFPolyline inherited;
	
public:
	#pragma option push -w-inl
	/* TsgDXFPolyline.Create */ inline __fastcall virtual TsgDXFLWPolyline(void) : TsgDXFPolyline() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TsgDXFPolyline.Destroy */ inline __fastcall virtual ~TsgDXFLWPolyline(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgDWGPolyline;
class PASCALIMPLEMENTATION TsgDWGPolyline : public TsgDXFPolyline 
{
	typedef TsgDXFPolyline inherited;
	
public:
	virtual bool __fastcall AddEntity(TsgDXFEntity* Entity);
public:
	#pragma option push -w-inl
	/* TsgDXFPolyline.Create */ inline __fastcall virtual TsgDWGPolyline(void) : TsgDXFPolyline() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TsgDXFPolyline.Destroy */ inline __fastcall virtual ~TsgDWGPolyline(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgDXFACISEntity;
class PASCALIMPLEMENTATION TsgDXFACISEntity : public TsgDXFGroup 
{
	typedef TsgDXFGroup inherited;
	
private:
	bool FEncoded;
	TsgDXFPenLine* FPen;
	AnsiString FProprietaryData;
	Classes::TStringList* FParsedStrings;
	Sglines::TsgLines* __fastcall GetLines(void);
	TsgDXFLineType* __fastcall GetLineType(void);
	
protected:
	virtual Graphics::TColor __fastcall GetColor(void);
	virtual Sgconsts::TFPoint __fastcall GetExtrusion();
	virtual float __fastcall GetLineTypeScale(void);
	virtual void __fastcall Invoke(TsgDXFConverter* AConverter, TsgCADEntityProc Proc, TsgCADEntityProc FinishProc);
	virtual void __fastcall Loaded(TsgDXFConverter* AConverter);
	virtual void __fastcall SetLineTypeScale(float Value);
	
public:
	__fastcall virtual TsgDXFACISEntity(void);
	__fastcall virtual ~TsgDXFACISEntity(void);
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	virtual void __fastcall SetColor(Graphics::TColor Value);
	virtual void __fastcall SetLType(TsgDXFEntity* Value);
	__property bool Encoded = {read=FEncoded, write=FEncoded, nodefault};
	__property Sgconsts::TFPoint Extrusion = {read=GetExtrusion};
	__property Sglines::TsgLines* Lines = {read=GetLines};
	__property TsgDXFLineType* LineType = {read=GetLineType};
	__property TsgDXFPenLine* Pen = {read=FPen};
	__property AnsiString ProprietaryData = {read=FProprietaryData, write=FProprietaryData};
};


class DELPHICLASS TsgDXFRegion;
class PASCALIMPLEMENTATION TsgDXFRegion : public TsgDXFACISEntity 
{
	typedef TsgDXFACISEntity inherited;
	
protected:
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
public:
	#pragma option push -w-inl
	/* TsgDXFACISEntity.Create */ inline __fastcall virtual TsgDXFRegion(void) : TsgDXFACISEntity() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TsgDXFACISEntity.Destroy */ inline __fastcall virtual ~TsgDXFRegion(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgDXF3dSolid;
class PASCALIMPLEMENTATION TsgDXF3dSolid : public TsgDXFACISEntity 
{
	typedef TsgDXFACISEntity inherited;
	
protected:
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
public:
	#pragma option push -w-inl
	/* TsgDXFACISEntity.Create */ inline __fastcall virtual TsgDXF3dSolid(void) : TsgDXFACISEntity() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TsgDXFACISEntity.Destroy */ inline __fastcall virtual ~TsgDXF3dSolid(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgDXFBody;
class PASCALIMPLEMENTATION TsgDXFBody : public TsgDXFACISEntity 
{
	typedef TsgDXFACISEntity inherited;
	
protected:
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
public:
	#pragma option push -w-inl
	/* TsgDXFACISEntity.Create */ inline __fastcall virtual TsgDXFBody(void) : TsgDXFACISEntity() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TsgDXFACISEntity.Destroy */ inline __fastcall virtual ~TsgDXFBody(void) { }
	#pragma option pop
	
};


typedef void __fastcall (__closure *TsgDXFSplineProc)(const Sgconsts::TFPoint &P);

class DELPHICLASS TsgDXFSpline;
class PASCALIMPLEMENTATION TsgDXFSpline : public TsgDXFLWPolyline 
{
	typedef TsgDXFLWPolyline inherited;
	
private:
	Sgconsts::TFPoint FBeginningTangent;
	Classes::TList* FControls;
	Sgconsts::TFPoint FEndingTangent;
	Classes::TList* FFit;
	Classes::TList* FKnots;
	double FLen;
	void __fastcall AddKnot(Extended X);
	bool __fastcall GetIsByAngles(void);
	Sgconsts::TFPoint __fastcall GetControlPoint(int Index);
	Sgconsts::TFPoint __fastcall GetFitPoint(int Index);
	
protected:
	Sgconsts::TFPoint __fastcall GetBeginningTangent();
	void __fastcall SetBeginningTangent(const Sgconsts::TFPoint &AValue);
	Sgconsts::TFPoint __fastcall GetEndingTangent();
	void __fastcall SetEndingTangent(const Sgconsts::TFPoint &AValue);
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
	void __fastcall BuildSplineByAngles(const int ANumberOfParts);
	virtual void __fastcall CreateDottedList(void);
	void __fastcall GetSpline(const int ANumberOfParts);
	virtual void __fastcall Loaded(TsgDXFConverter* AConverter);
	virtual void __fastcall ReloadPolyPoints(void);
	
public:
	__fastcall virtual TsgDXFSpline(void);
	__fastcall virtual ~TsgDXFSpline(void);
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	int __fastcall ControlCount(void);
	int __fastcall FitCount(void);
	void __fastcall GetPoints(TsgDXFSplineProc Proc, Extended XScale, Extended YScale);
	__property Sgconsts::TFPoint BeginningTangent = {read=FBeginningTangent, write=FBeginningTangent};
	__property Sgconsts::TFPoint ControlPoints[int Index] = {read=GetControlPoint};
	__property Classes::TList* Controls = {read=FControls, write=FControls};
	__property Sgconsts::TFPoint EndingTangent = {read=FEndingTangent, write=FEndingTangent};
	__property Sgconsts::TFPoint FitPoints[int Index] = {read=GetFitPoint};
	__property Classes::TList* Fit = {read=FFit};
	__property bool IsByAngles = {read=GetIsByAngles, nodefault};
	__property Classes::TList* Knots = {read=FKnots};
	__property double Length = {read=FLen};
};


class DELPHICLASS TsgDXFCircle;
class PASCALIMPLEMENTATION TsgDXFCircle : public TsgDXFPolyline 
{
	typedef TsgDXFPolyline inherited;
	
private:
	double FRadius;
	
protected:
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
	double __fastcall GetRadius(void);
	void __fastcall SetRadius(double AValue);
	virtual void __fastcall CreateDottedList(void);
	virtual void __fastcall Loaded(TsgDXFConverter* AConverter);
	virtual void __fastcall Params(double &A, double &B, double &AStart, double &AEnd, double &ASin, double &ACos);
	virtual void __fastcall ReloadPolyPoints(void);
	
public:
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	__property double Radius = {read=GetRadius, write=SetRadius};
public:
	#pragma option push -w-inl
	/* TsgDXFPolyline.Create */ inline __fastcall virtual TsgDXFCircle(void) : TsgDXFPolyline() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TsgDXFPolyline.Destroy */ inline __fastcall virtual ~TsgDXFCircle(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgDXFArc;
class PASCALIMPLEMENTATION TsgDXFArc : public TsgDXFCircle 
{
	typedef TsgDXFCircle inherited;
	
private:
	double FEndAngle;
	double FStartAngle;
	Sgconsts::TFPoint __fastcall RotPt(Extended Angle);
	
protected:
	double __fastcall GetEndAngle(void);
	void __fastcall SetEndAngle(double AValue);
	double __fastcall GetStartAngle(void);
	void __fastcall SetStartAngle(double AValue);
	Sgconsts::TFPoint __fastcall GetEndingPoint();
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
	Sgconsts::TFPoint __fastcall GetStartingPoint();
	virtual void __fastcall Loaded(TsgDXFConverter* AConverter);
	virtual void __fastcall Params(double &A, double &B, double &AStart, double &AEnd, double &ASin, double &ACos);
	
public:
	__fastcall virtual TsgDXFArc(void);
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	__property double EndAngle = {read=GetEndAngle, write=SetEndAngle};
	__property Sgconsts::TFPoint EndPoint = {read=GetEndingPoint};
	__property double StartAngle = {read=GetStartAngle, write=SetStartAngle};
	__property Sgconsts::TFPoint StartPoint = {read=GetStartingPoint};
public:
	#pragma option push -w-inl
	/* TsgDXFPolyline.Destroy */ inline __fastcall virtual ~TsgDXFArc(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgDXFEllipse;
class PASCALIMPLEMENTATION TsgDXFEllipse : public TsgDXFArc 
{
	typedef TsgDXFArc inherited;
	
private:
	double FAngle;
	Sgconsts::TFPoint FRadPt;
	double FRatio;
	
protected:
	bool FIsExtruded;
	Sgconsts::TFPoint __fastcall GetRadPt();
	void __fastcall SetRadPt(const Sgconsts::TFPoint &AValue);
	double __fastcall GetRatio(void);
	void __fastcall SetRatio(double AValue);
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
	virtual void __fastcall Loaded(TsgDXFConverter* AConverter);
	virtual void __fastcall Params(double &A, double &B, double &AStart, double &AEnd, double &ASin, double &ACos);
	
public:
	__fastcall virtual TsgDXFEllipse(void);
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	__property double Angle = {read=FAngle, write=FAngle};
	__property Sgconsts::TFPoint EndPoint = {read=GetRadPt, write=SetRadPt};
	__property Sgconsts::TFPoint RadPt = {read=GetRadPt, write=SetRadPt};
	__property double Ratio = {read=GetRatio, write=SetRatio};
public:
	#pragma option push -w-inl
	/* TsgDXFPolyline.Destroy */ inline __fastcall virtual ~TsgDXFEllipse(void) { }
	#pragma option pop
	
};


struct TsgHatchPatternData;
typedef TsgHatchPatternData *PsgHatchPatternData;

struct TsgHatchPatternData
{
	
public:
	double LineAngle;
	Sgconsts::TFPoint BaseP;
	Sgconsts::TFPoint Offset;
	int DashNum;
	Sglines::TsgLines* Lines;
	bool IsDash;
} ;

class DELPHICLASS Tsg2DCurve;
class PASCALIMPLEMENTATION Tsg2DCurve : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	virtual int __fastcall GetCount(void);
	virtual Sgconsts::TF2DPoint __fastcall GetEndPoint();
	virtual Byte __fastcall GetEdgeType(void);
	virtual Sgconsts::TF2DPoint __fastcall GetPoints(const int AIndex);
	virtual Sgconsts::TF2DPoint __fastcall GetStartPoint();
	
protected:
	virtual void __fastcall Assign(const Tsg2DCurve* AVal);
	virtual void __fastcall ClearPoints(void);
	virtual void __fastcall Loaded(void);
	
public:
	__fastcall virtual Tsg2DCurve(void);
	__property Byte EdgeType = {read=GetEdgeType, nodefault};
	__property int Count = {read=GetCount, nodefault};
	__property Sgconsts::TF2DPoint EndPoint = {read=GetEndPoint};
	__property Sgconsts::TF2DPoint Points[int AIndex] = {read=GetPoints};
	__property Sgconsts::TF2DPoint StartPoint = {read=GetStartPoint};
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~Tsg2DCurve(void) { }
	#pragma option pop
	
};


class DELPHICLASS Tsg2DArc;
class PASCALIMPLEMENTATION Tsg2DArc : public Tsg2DCurve 
{
	typedef Tsg2DCurve inherited;
	
private:
	Sgconsts::TF2DPoint FCenterPoint;
	double FEndParam;
	Byte FFlag;
	Classes::TList* FPoints;
	double FRadius;
	double FStartParam;
	virtual int __fastcall GetCount(void);
	bool __fastcall GetCounterClockWise(void);
	virtual Sgconsts::TF2DPoint __fastcall GetEndPoint();
	virtual Byte __fastcall GetEdgeType(void);
	virtual double __fastcall GetParamByAngle(const double Angle);
	virtual Sgconsts::TF2DPoint __fastcall GetPoints(const int AIndex);
	virtual Sgconsts::TF2DPoint __fastcall GetStartPoint();
	void __fastcall SetCounterClockWise(const bool AVal);
	
protected:
	virtual void __fastcall Assign(const Tsg2DCurve* AVal);
	virtual void __fastcall ClearPoints(void);
	virtual void __fastcall Loaded(void);
	virtual void __fastcall Params(double &A, double &B, double &ASin, double &ACos);
	
public:
	__fastcall virtual Tsg2DArc(void);
	__fastcall virtual ~Tsg2DArc(void);
	__property Sgconsts::TF2DPoint CenterPoint = {read=FCenterPoint, write=FCenterPoint};
	__property bool CounterClockWise = {read=GetCounterClockWise, write=SetCounterClockWise, nodefault};
	__property double EndParam = {read=FEndParam, write=FEndParam};
	__property double Radius = {read=FRadius, write=FRadius};
	__property double StartParam = {read=FStartParam, write=FStartParam};
};


class DELPHICLASS Tsg2DEllipse;
class PASCALIMPLEMENTATION Tsg2DEllipse : public Tsg2DArc 
{
	typedef Tsg2DArc inherited;
	
private:
	Sgconsts::TF2DPoint FMajorPoint;
	virtual Byte __fastcall GetEdgeType(void);
	bool __fastcall GetIsAngleInParam(void);
	virtual double __fastcall GetParamByAngle(const double Angle);
	void __fastcall SetIsAngleInParam(const bool AVal);
	
protected:
	virtual void __fastcall Assign(const Tsg2DCurve* AVal);
	virtual void __fastcall Params(double &A, double &B, double &ASin, double &ACos);
	
public:
	__fastcall virtual Tsg2DEllipse(void);
	__property bool IsAngleInParam = {read=GetIsAngleInParam, write=SetIsAngleInParam, nodefault};
	__property Sgconsts::TF2DPoint MajorPoint = {read=FMajorPoint, write=FMajorPoint};
public:
	#pragma option push -w-inl
	/* Tsg2DArc.Destroy */ inline __fastcall virtual ~Tsg2DEllipse(void) { }
	#pragma option pop
	
};


class DELPHICLASS Tsg2DLine;
class PASCALIMPLEMENTATION Tsg2DLine : public Tsg2DCurve 
{
	typedef Tsg2DCurve inherited;
	
private:
	Sgconsts::TF2DPoint FEndPoint;
	Sgconsts::TF2DPoint FStartPoint;
	virtual int __fastcall GetCount(void);
	virtual Byte __fastcall GetEdgeType(void);
	virtual Sgconsts::TF2DPoint __fastcall GetEndPoint();
	virtual Sgconsts::TF2DPoint __fastcall GetPoints(const int AIndex);
	virtual Sgconsts::TF2DPoint __fastcall GetStartPoint();
	
protected:
	virtual void __fastcall Assign(const Tsg2DCurve* AVal);
	
public:
	void __fastcall SetEndPoint(const Sgconsts::TF2DPoint &AVal);
	void __fastcall SetStartPoint(const Sgconsts::TF2DPoint &AVal);
public:
	#pragma option push -w-inl
	/* Tsg2DCurve.Create */ inline __fastcall virtual Tsg2DLine(void) : Tsg2DCurve() { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~Tsg2DLine(void) { }
	#pragma option pop
	
};


class DELPHICLASS Tsg2DPolyline;
class PASCALIMPLEMENTATION Tsg2DPolyline : public Tsg2DCurve 
{
	typedef Tsg2DCurve inherited;
	
private:
	Classes::TList* FBulges;
	Classes::TList* FPoints;
	Byte FProps;
	Classes::TList* FVertexes;
	float __fastcall GetBulge(const int AIndex);
	int __fastcall GetBulgesCount(void);
	bool __fastcall GetClosed(void);
	virtual int __fastcall GetCount(void);
	virtual Sgconsts::TF2DPoint __fastcall GetEndPoint();
	virtual Byte __fastcall GetEdgeType(void);
	bool __fastcall GetHasBulge(void);
	virtual Sgconsts::TF2DPoint __fastcall GetPoints(const int AIndex);
	virtual Sgconsts::TF2DPoint __fastcall GetStartPoint();
	Sgconsts::TF2DPoint __fastcall GetVertex(const int AIndex);
	int __fastcall GetVertexesCount(void);
	void __fastcall SetBulge(const int AIndex, const float AVal);
	void __fastcall SetClosed(const bool AVal);
	void __fastcall SetHasBulge(const bool AVal);
	void __fastcall SetVertex(const int AIndex, const Sgconsts::TF2DPoint &APoint);
	
protected:
	virtual void __fastcall Assign(const Tsg2DCurve* AVal);
	virtual void __fastcall ClearPoints(void);
	virtual void __fastcall Loaded(void);
	__property float Bulges[int AIndex] = {read=GetBulge, write=SetBulge};
	__property Sgconsts::TF2DPoint Vertexes[int AIndex] = {read=GetVertex, write=SetVertex};
	__property int BulgesCount = {read=GetBulgesCount, nodefault};
	__property int VertexesCount = {read=GetVertexesCount, nodefault};
	
public:
	__fastcall virtual Tsg2DPolyline(void);
	__fastcall virtual ~Tsg2DPolyline(void);
	void __fastcall AddBulge(const float AVal);
	void __fastcall AddVertex(const Sgconsts::TF2DPoint &APoint);
	Sgconsts::PF2DPoint __fastcall GetLastVertex(void);
	__property bool Closed = {read=GetClosed, write=SetClosed, nodefault};
	__property bool HasBulge = {read=GetHasBulge, write=SetHasBulge, nodefault};
};


class DELPHICLASS Tsg2DSpline;
class PASCALIMPLEMENTATION Tsg2DSpline : public Tsg2DCurve 
{
	typedef Tsg2DCurve inherited;
	
private:
	Classes::TList* FControls;
	Classes::TList* FKnots;
	Classes::TList* FPoints;
	virtual int __fastcall GetCount(void);
	virtual Sgconsts::TF2DPoint __fastcall GetEndPoint();
	virtual Byte __fastcall GetEdgeType(void);
	float __fastcall GetKnot(const int AIndex);
	virtual Sgconsts::TF2DPoint __fastcall GetPoints(const int AIndex);
	virtual Sgconsts::TF2DPoint __fastcall GetStartPoint();
	Sgconsts::TF2DPoint __fastcall GetControl(const int AIndex);
	int __fastcall GetControlsCount(void);
	int __fastcall GetKnotsCount(void);
	void __fastcall SetControl(const int AIndex, const Sgconsts::TF2DPoint &APoint);
	void __fastcall SetKnot(const int AIndex, const float AVal);
	
protected:
	virtual void __fastcall Assign(const Tsg2DCurve* AVal);
	virtual void __fastcall ClearPoints(void);
	virtual void __fastcall Loaded(void);
	__property float Knots[int AIndex] = {read=GetKnot, write=SetKnot};
	__property Sgconsts::TF2DPoint Controls[int AIndex] = {read=GetControl, write=SetControl};
	__property int KnotsCount = {read=GetKnotsCount, nodefault};
	__property int ControlsCount = {read=GetControlsCount, nodefault};
	
public:
	__fastcall virtual Tsg2DSpline(void);
	__fastcall virtual ~Tsg2DSpline(void);
	void __fastcall AddControl(const Sgconsts::TF2DPoint &APoint);
	void __fastcall AddKnot(const float AVal);
	Sgconsts::PF2DPoint __fastcall GetLastVertex(void);
};


class DELPHICLASS Tsg2DBoundaryList;
class PASCALIMPLEMENTATION Tsg2DBoundaryList : public Classes::TList 
{
	typedef Classes::TList inherited;
	
private:
	Byte FBoundaryType;
	
protected:
	bool __fastcall GetIsTextBox(void);
	
public:
	__property Byte BoundaryType = {read=FBoundaryType, write=FBoundaryType, nodefault};
public:
	#pragma option push -w-inl
	/* TList.Destroy */ inline __fastcall virtual ~Tsg2DBoundaryList(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall Tsg2DBoundaryList(void) : Classes::TList() { }
	#pragma option pop
	
};


class DELPHICLASS TsgCADPolyPolygon;
class PASCALIMPLEMENTATION TsgCADPolyPolygon : public TsgDXFObjectEntity 
{
	typedef TsgDXFObjectEntity inherited;
	
private:
	Sgconsts::TFRect FBox;
	Classes::TList* FBoundaryPolylines;
	Graphics::TColor FColor;
	
protected:
	virtual void __fastcall CalcFMatrix(void);
	virtual void __fastcall ClearBoundaryData(void);
	virtual void __fastcall CloseBoundary(void);
	virtual Sgconsts::TFRect __fastcall BoxTransformation(TsgDXFConverter* AConverter, const Sgconsts::TFRect &ABox);
	virtual Sgconsts::TFRect __fastcall GetBox();
	virtual Graphics::TColor __fastcall GetColor(void);
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
	virtual AnsiString __fastcall GetHatchName();
	virtual void __fastcall Loaded(TsgDXFConverter* AConverter);
	virtual void __fastcall MakeBorderPolylines(TsgDXFConverter* AConverter);
	virtual void __fastcall ParseLines(void);
	virtual void __fastcall SetHatchName(const AnsiString AHatchName);
	
public:
	__fastcall virtual TsgCADPolyPolygon(void);
	__fastcall virtual ~TsgCADPolyPolygon(void);
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	virtual bool __fastcall GetBoxPoints(TFPointProc Proc, bool Full);
	virtual void __fastcall SetColor(Graphics::TColor Value);
	__property Classes::TList* Boundaries = {read=FBoundaryPolylines};
	__property AnsiString HatchName = {read=GetHatchName, write=SetHatchName};
};


class DELPHICLASS TsgCADGradientPolygon;
class PASCALIMPLEMENTATION TsgCADGradientPolygon : public TsgCADPolyPolygon 
{
	typedef TsgCADPolyPolygon inherited;
	
private:
	Graphics::TColor FGradientColor;
	double FGradientAngle;
	bool FGradientUseCenter;
	
protected:
	Sgconsts::TsgGradientType FType;
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
	virtual AnsiString __fastcall GetHatchName();
	AnsiString __fastcall GetGradintName();
	void __fastcall SetGradintName(const AnsiString AName);
	
public:
	__fastcall virtual TsgCADGradientPolygon(void);
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	__property double GradientAngle = {read=FGradientAngle, write=FGradientAngle};
	__property Graphics::TColor GradientColor = {read=FGradientColor, write=FGradientColor, nodefault};
	__property AnsiString GradientName = {read=GetGradintName, write=SetGradintName};
	__property bool GradientUseCenter = {read=FGradientUseCenter, write=FGradientUseCenter, nodefault};
public:
	#pragma option push -w-inl
	/* TsgCADPolyPolygon.Destroy */ inline __fastcall virtual ~TsgCADGradientPolygon(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgCADCurvePolygon;
class PASCALIMPLEMENTATION TsgCADCurvePolygon : public TsgCADGradientPolygon 
{
	typedef TsgCADGradientPolygon inherited;
	
private:
	Classes::TList* FBoundaryData;
	Sgconsts::TFPoint FElevation;
	Sgconsts::TFPoint FExtrusion;
	double FMatrix[4][3];
	
protected:
	virtual void __fastcall CalcFMatrix(void);
	virtual void __fastcall ClearBoundaryData(void);
	virtual Sgconsts::TFRect __fastcall BoxTransformation(TsgDXFConverter* AConverter, const Sgconsts::TFRect &ABox);
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
	virtual Sgconsts::TFPoint __fastcall GetExtrusion();
	virtual void __fastcall Invoke(TsgDXFConverter* AConverter, TsgCADEntityProc Proc, TsgCADEntityProc FinishProc);
	virtual bool __fastcall IsInvoke(TsgDXFConverter* AConverter);
	virtual void __fastcall MakeBorderPolylines(TsgDXFConverter* AConverter);
	virtual void __fastcall SetExtrusion(const Sgconsts::TFPoint &Value);
	
public:
	__fastcall virtual TsgCADCurvePolygon(void);
	__fastcall virtual ~TsgCADCurvePolygon(void);
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	virtual bool __fastcall GetBoxPoints(TFPointProc Proc, bool Full);
	__property Classes::TList* BoundaryData = {read=FBoundaryData};
	__property Sgconsts::TFPoint Elevation = {read=FElevation, write=FElevation};
	__property Sgconsts::TFPoint Extrusion = {read=GetExtrusion, write=SetExtrusion};
};


class DELPHICLASS TsgCADHatch;
class PASCALIMPLEMENTATION TsgCADHatch : public TsgCADCurvePolygon 
{
	typedef TsgCADCurvePolygon inherited;
	
private:
	AnsiString FHatchName;
	Classes::TList* FHatchPatternData;
	Sgconsts::TsgHatchStyle FHatchStyle;
	TsgDXFLineType* FLineType;
	Classes::TList* FParsedLines;
	double FLineWeight;
	
protected:
	double FPatternAngle;
	double FPatternScale;
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
	virtual AnsiString __fastcall GetHatchName();
	Sglines::TsgLines* __fastcall GetLines(void);
	TsgDXFLineType* __fastcall GetLineType(void);
	virtual double __fastcall GetLineWeight(void);
	double __fastcall GetPatternAngle(void);
	double __fastcall GetPatternScale(void);
	virtual void __fastcall ParseLines(void);
	virtual void __fastcall SetHatchName(const AnsiString AHatchName);
	virtual void __fastcall SetLineWeight(double Value);
	void __fastcall SetPatternAngle(const double AVal);
	void __fastcall SetPatternScale(const double AVal);
	
public:
	__fastcall virtual TsgCADHatch(void);
	__fastcall virtual ~TsgCADHatch(void);
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	virtual double __fastcall GetThickness(void);
	__property Classes::TList* HatchPatternData = {read=FHatchPatternData};
	__property Sgconsts::TsgHatchStyle HatchStyle = {read=FHatchStyle, write=FHatchStyle, nodefault};
	__property Sglines::TsgLines* Lines = {read=GetLines};
	__property TsgDXFLineType* LineType = {read=GetLineType, write=FLineType};
	__property Classes::TList* ParsedLines = {read=FParsedLines};
	__property double PatternAngle = {read=GetPatternAngle, write=SetPatternAngle};
	__property double PatternScale = {read=GetPatternScale, write=SetPatternScale};
};


class DELPHICLASS TsgDXFGradient;
class PASCALIMPLEMENTATION TsgDXFGradient : public TsgCADCurvePolygon 
{
	typedef TsgCADCurvePolygon inherited;
	
private:
	Sgconsts::TFPoint FCenterRadialGradient;
	Classes::TList* FColors;
	Classes::TList* FPercentFill;
	double FRadius;
	bool FVerticalGradient;
	
protected:
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
	virtual AnsiString __fastcall GetHatchName();
	
public:
	__fastcall virtual TsgDXFGradient(void);
	__fastcall virtual ~TsgDXFGradient(void);
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	__property Sgconsts::TFPoint CenterRadialGradient = {read=FCenterRadialGradient, write=FCenterRadialGradient};
	__property bool IsVerticalGradient = {read=FVerticalGradient, write=FVerticalGradient, nodefault};
	__property Classes::TList* GradientColors = {read=FColors};
	__property Classes::TList* PercentFill = {read=FPercentFill};
	__property double Radius = {read=FRadius, write=FRadius};
};


class DELPHICLASS TsgCADClipInsert;
class PASCALIMPLEMENTATION TsgCADClipInsert : public TsgDXFInsert 
{
	typedef TsgDXFInsert inherited;
	
protected:
	Sgconsts::TFRect FClipBox;
	virtual Sgconsts::TFRect __fastcall GetBox();
	virtual void __fastcall SetPoint(const Sgconsts::TFPoint &AValue);
	
public:
	__fastcall virtual TsgCADClipInsert(void);
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	__property Sgconsts::TFRect ClipBox = {read=FClipBox, write=FClipBox};
public:
	#pragma option push -w-inl
	/* TsgDXFInsert.Destroy */ inline __fastcall virtual ~TsgCADClipInsert(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgDXFDimension;
class PASCALIMPLEMENTATION TsgDXFDimension : public TsgDXFInsert 
{
	typedef TsgDXFInsert inherited;
	
private:
	TsgDXFEntity* FAssociated;
	Sgconsts::TFPoint FDefPoint;
	TsgDXFDimensionStyle* FDimStyle;
	Byte FFlags;
	Sgconsts::TFPoint FLinDefPoint1;
	Sgconsts::TFPoint FLinDefPoint2;
	Sgconsts::TFPoint FMiddlePoint;
	AnsiString FTextOverride;
	TsgDXFDimensionStyle* __fastcall GetProperties(void);
	
protected:
	TsgDXFDimensionStyle* FProperties;
	void __fastcall CreateBlock(const TsgDXFConverter* AConverter);
	double __fastcall GetArrowSize(void);
	void __fastcall GenerateBlock(const TsgDXFConverter* AConverter);
	Sgconsts::TFPoint __fastcall GetDefPoint();
	TsgDXFDimensionStyle* __fastcall GetStyle(void);
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
	Sgconsts::TFPoint __fastcall GetLinDefPoint1();
	Sgconsts::TFPoint __fastcall GetLinDefPoint2();
	double __fastcall GetTextHeight(void);
	AnsiString __fastcall GetTextOverride();
	bool __fastcall IsInternalDimension(void);
	virtual void __fastcall Loaded(TsgDXFConverter* AConverter);
	void __fastcall SetArrowSize(const double Value);
	void __fastcall SetDefPoint(const Sgconsts::TFPoint &Value);
	void __fastcall SetLinDefPoint1(const Sgconsts::TFPoint &Value);
	void __fastcall SetLinDefPoint2(const Sgconsts::TFPoint &Value);
	void __fastcall SetStyle(TsgDXFDimensionStyle* ADimStyle);
	void __fastcall SetTextHeight(const double Value);
	void __fastcall SetTextOverride(const AnsiString Value);
	__property TsgDXFDimensionStyle* Properties = {read=GetProperties};
	
public:
	__fastcall virtual ~TsgDXFDimension(void);
	__property double ArrowSize = {read=GetArrowSize, write=SetArrowSize};
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	__property TsgDXFEntity* Associated = {read=FAssociated, write=FAssociated};
	__property Sgconsts::TFPoint DefPoint = {read=GetDefPoint, write=SetDefPoint};
	__property Byte Flags = {read=FFlags, write=FFlags, nodefault};
	__property Sgconsts::TFPoint LinDefPoint1 = {read=GetLinDefPoint1, write=SetLinDefPoint1};
	__property Sgconsts::TFPoint LinDefPoint2 = {read=GetLinDefPoint2, write=SetLinDefPoint2};
	__property Sgconsts::TFPoint MiddlePoint = {read=FMiddlePoint, write=FMiddlePoint};
	__property TsgDXFDimensionStyle* Style = {read=GetStyle, write=SetStyle};
	__property double TextHeight = {read=GetTextHeight, write=SetTextHeight};
	__property AnsiString TextOverride = {read=GetTextOverride, write=SetTextOverride};
public:
	#pragma option push -w-inl
	/* TsgDXFInsert.Create */ inline __fastcall virtual TsgDXFDimension(void) : TsgDXFInsert() { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TsgDXFDimensionStyle : public TsgDXFPenTableItem 
{
	typedef TsgDXFPenTableItem inherited;
	
protected:
	double FArrowSize;
	double FExtLineExt;
	double FExtLineOffset;
	double FTextOffset;
	double FTextHeight;
	double FSizeCenterMark;
	
public:
	__fastcall virtual TsgDXFDimensionStyle(void);
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	__property double ArrowSize = {read=FArrowSize, write=FArrowSize};
	__property double ExtLineExt = {read=FExtLineExt, write=FExtLineExt};
	__property double ExtLineOffset = {read=FExtLineOffset, write=FExtLineOffset};
	__property double TextOffset = {read=FTextOffset, write=FTextOffset};
	__property double TextHeight = {read=FTextHeight, write=FTextHeight};
	__property double SizeCenterMark = {read=FSizeCenterMark, write=FSizeCenterMark};
public:
	#pragma option push -w-inl
	/* TsgDXFPenEntity.Destroy */ inline __fastcall virtual ~TsgDXFDimensionStyle(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgDXFLeader;
class PASCALIMPLEMENTATION TsgDXFLeader : public TsgDXFSpline 
{
	typedef TsgDXFSpline inherited;
	
private:
	bool FArrowhead;
	Sgconsts::TFPoint FArrowPoint;
	float FArrowScale;
	float FArrowSize;
	int FCodeValue;
	float FLineAngle;
	AnsiString FIDPointer;
	TsgDXFInsert* FInsert;
	bool FIsSpline;
	Sgconsts::TFPoint FTextPoint;
	TsgDXFBlock* __fastcall FindBlockByPointer(TsgDXFConverter* AConverter, AnsiString APointer);
	void __fastcall LoadInsert(TsgDXFConverter* AConverter, int NextControl);
	
protected:
	float __fastcall GetArrowSize(void);
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
	virtual void __fastcall Invoke(TsgDXFConverter* AConverter, TsgCADEntityProc Proc, TsgCADEntityProc FinishProc);
	virtual void __fastcall Loaded(TsgDXFConverter* AConverter);
	void __fastcall SetArrowSize(float AValue);
	virtual void __fastcall SetVisibility(const bool Value);
	
public:
	__fastcall virtual TsgDXFLeader(void);
	__fastcall virtual ~TsgDXFLeader(void);
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	virtual void __fastcall SetColor(Graphics::TColor Value);
	__property TsgDXFInsert* Insert = {read=FInsert};
	__property bool IsSpline = {read=FIsSpline, write=FIsSpline, nodefault};
	__property bool Arrowhead = {read=FArrowhead, write=FArrowhead, nodefault};
	__property float ArrowSize = {read=GetArrowSize, write=SetArrowSize};
	__property float ArrowScale = {read=FArrowScale, write=FArrowScale};
	__property AnsiString IDPointer = {read=FIDPointer, write=FIDPointer};
};


class DELPHICLASS TsgDXFText;
class DELPHICLASS TsgDXFMText;
class PASCALIMPLEMENTATION TsgDXFMText : public TsgDXFInsert 
{
	typedef TsgDXFInsert inherited;
	
private:
	Byte FAlign;
	double FHeight;
	Sgconsts::TFPoint FPoint1;
	float FRectHeight;
	float FRectWidth;
	TsgDXFStyle* FStyle;
	int FLineSpacing;
	AnsiString FText;
	double FLineWeight;
	void __fastcall AdjustChildren(void);
	Byte __fastcall GetAlign(void);
	void __fastcall SetAlign(const Byte Value);
	
protected:
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
	double __fastcall GetHeight(void);
	virtual double __fastcall GetLineWeight(void);
	TsgDXFStyle* __fastcall GetStyle(void);
	AnsiString __fastcall GetText();
	bool __fastcall HasSecond(void);
	virtual void __fastcall Loaded(TsgDXFConverter* AConverter);
	virtual void __fastcall SetAngle(float Value);
	void __fastcall SetHeight(double AValue);
	virtual void __fastcall SetLineWeight(double Value);
	void __fastcall SetStyle(TsgDXFStyle* AValue);
	void __fastcall SetTextValue(AnsiString AValue);
	
public:
	__fastcall virtual TsgDXFMText(void);
	__fastcall virtual ~TsgDXFMText(void);
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	virtual AnsiString __fastcall EntName();
	virtual double __fastcall GetThickness(void);
	virtual void __fastcall SetLWeight(int Value);
	__property Byte Align = {read=GetAlign, write=SetAlign, nodefault};
	__property double Height = {read=FHeight, write=FHeight};
	__property Sgconsts::TFPoint Point1 = {read=FPoint1, write=FPoint1};
	__property float RectHeight = {read=FRectHeight, write=FRectHeight};
	__property float RectWidth = {read=FRectWidth, write=FRectWidth};
	__property TsgDXFStyle* Style = {read=GetStyle, write=SetStyle};
	__property AnsiString Text = {read=FText, write=FText};
};


class PASCALIMPLEMENTATION TsgDXFText : public TsgDXFCustomVertex 
{
	typedef TsgDXFCustomVertex inherited;
	
private:
	Sgconsts::TFRect FBox;
	Mvfont::TmvExtFont* FFont;
	Byte FHAlign;
	double FHeight;
	bool FInsideMText;
	bool FIsSHXBox;
	TsgDXFMText* FMText;
	float FObliqueAngle;
	TsgTextParse *FTextParse;
	Sgconsts::TFPoint FPoint1;
	float FRotation;
	float FScale;
	Sgconsts::TFPoint FExtrusion;
	Sgconsts::TFPoint FStartPoint;
	AnsiString FSHXText;
	double FMatrix[4][3];
	WideString FSHXUnicodeText;
	TsgDXFStyle* FStyle;
	AnsiString FText;
	Byte FTextGenFlags;
	double FLineWeight;
	WideString FUnicodeText;
	Byte FVAlign;
	bool FWinFont;
	void __fastcall ApplyRotation(void);
	void __fastcall Expand(Extended AWidth, Extended AHeight, Extended AHeightMax, const Sgconsts::TFPoint &ASign);
	int __fastcall Parse(AnsiString &S, int &I, Classes::TList* ALevelText, TsgDXFBlock* ABlock);
	void __fastcall SetOblique(float Value);
	void __fastcall SetGeneration(const Byte Value);
	int __fastcall Sign(const double AValue);
	bool __fastcall GetBackward(void);
	Byte __fastcall GetGeneration(void);
	AnsiString __fastcall GetFontName();
	bool __fastcall GetIsSHXBox(void);
	WideChar __fastcall GetSymbolFromMultibyte(const Byte ALeft, const Byte ARight, const int ANumber, const bool AUnicodeAlways);
	WideString __fastcall GetSHXUnicodeText();
	WideString __fastcall GetUnicodeText();
	bool __fastcall GetUpsideDown(void);
	bool __fastcall GetIsUnicodeText(void);
	
protected:
	AnsiString FSHXFont;
	double __fastcall GetHeight(void);
	void __fastcall SetHeight(double AValue);
	Sgconsts::TFPoint __fastcall GetPoint1();
	void __fastcall SetPoint1(const Sgconsts::TFPoint &AValue);
	float __fastcall GetRotation(void);
	void __fastcall SetRotation(float AValue);
	TsgDXFStyle* __fastcall GetStyle(void);
	void __fastcall SetStyle(TsgDXFStyle* AStyle);
	AnsiString __fastcall GetText();
	void __fastcall SetTextValue(const AnsiString Value);
	virtual Sgconsts::TFRect __fastcall GetBox();
	virtual Graphics::TColor __fastcall GetColor(void);
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
	virtual Sgconsts::TFPoint __fastcall GetExtrusion();
	virtual double __fastcall GetLineWeight(void);
	bool __fastcall HasSecond(void);
	virtual void __fastcall Invoke(TsgDXFConverter* AConverter, TsgCADEntityProc Proc, TsgCADEntityProc FinishProc);
	virtual void __fastcall Loaded(TsgDXFConverter* AConverter);
	virtual void __fastcall SetExtrusion(const Sgconsts::TFPoint &Value);
	virtual void __fastcall SetLineWeight(double Value);
	
public:
	__fastcall virtual TsgDXFText(void);
	__fastcall virtual ~TsgDXFText(void);
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	virtual AnsiString __fastcall EntName();
	double __fastcall SHXMatrix();
	void __fastcall DoNewText(const AnsiString ANewText);
	virtual void __fastcall GetBase(Extended AWidth, Extended AHeight, Sgconsts::TFPoint &Base, Sgconsts::TFPoint &Start);
	double __fastcall GetMatrix();
	virtual double __fastcall GetThickness(void);
	virtual void __fastcall SetColor(Graphics::TColor Value);
	virtual void __fastcall SetLWeight(int Value);
	__property bool Backward = {read=GetBackward, nodefault};
	__property Sgconsts::TFPoint Extrusion = {read=GetExtrusion, write=SetExtrusion};
	__property Mvfont::TmvExtFont* Font = {read=FFont};
	__property AnsiString FontName = {read=GetFontName};
	__property Byte Generation = {read=GetGeneration, write=SetGeneration, nodefault};
	__property Byte HAlign = {read=FHAlign, write=FHAlign, nodefault};
	__property double Height = {read=GetHeight, write=SetHeight};
	__property bool InsideMText = {read=FInsideMText, nodefault};
	__property bool IsUnicodeText = {read=GetIsUnicodeText, nodefault};
	__property bool IsSHXFont = {read=GetIsSHXBox, nodefault};
	__property TsgDXFMText* MText = {read=FMText};
	__property float ObliqueAngle = {read=FObliqueAngle, write=SetOblique};
	__property Sgconsts::TFPoint Point1 = {read=GetPoint1, write=SetPoint1};
	__property float Rotation = {read=FRotation, write=FRotation};
	__property float Scale = {read=FScale, write=FScale};
	__property AnsiString SHXText = {read=FSHXText};
	__property WideString SHXUnicodeText = {read=GetSHXUnicodeText};
	__property AnsiString SHXFont = {read=FSHXFont};
	__property Sgconsts::TFPoint StartPoint = {read=FStartPoint};
	__property TsgDXFStyle* Style = {read=GetStyle, write=SetStyle};
	__property AnsiString Text = {read=FText, write=SetTextValue};
	__property WideString UnicodeText = {read=GetUnicodeText};
	__property bool UpsideDown = {read=GetUpsideDown, nodefault};
	__property Byte VAlign = {read=FVAlign, write=FVAlign, nodefault};
	__property bool WinFont = {read=FWinFont, nodefault};
	__property float XScale = {read=FScale};
};


class DELPHICLASS TsgDXFOle2Frame;
class PASCALIMPLEMENTATION TsgDXFOle2Frame : public TsgDXFCustomVertex 
{
	typedef TsgDXFCustomVertex inherited;
	
private:
	AnsiString FBinaryData;
	_di_IOleObject FOleObject;
	_di_ILockBytes FLockBytes;
	_di_IStorage FStorage;
	Sgconsts::TFPoint FPoint1;
	Byte FOLEObjectType;
	Byte FAspect;
	void __fastcall DestroyOleObject(void);
	
protected:
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
	virtual Sgconsts::TFRect __fastcall GetBox();
	Sgconsts::TFPoint __fastcall GetPoint1();
	void __fastcall SetPoint1(const Sgconsts::TFPoint &Value);
	virtual void __fastcall Loaded(TsgDXFConverter* AConverter);
	
public:
	__fastcall virtual TsgDXFOle2Frame(void);
	__fastcall virtual ~TsgDXFOle2Frame(void);
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	void __fastcall SetBinData(const AnsiString S);
	__property _di_IOleObject OleObject = {read=FOleObject};
	__property Byte OLEObjectType = {read=FOLEObjectType, write=FOLEObjectType, nodefault};
	__property Byte Aspect = {read=FAspect, write=FAspect, nodefault};
	__property Sgconsts::TFPoint Point1 = {read=GetPoint1, write=SetPoint1};
	__property AnsiString BinaryData = {read=FBinaryData, write=FBinaryData};
};


class DELPHICLASS TsgDXFAttdef;
class PASCALIMPLEMENTATION TsgDXFAttdef : public TsgDXFText 
{
	typedef TsgDXFText inherited;
	
private:
	bool FHasChanging;
	TsgDXFText* FOther;
	AnsiString FTag;
	TsgDXFText* __fastcall ReloadOther(TsgDXFAttdef* AOther);
	void __fastcall SetTag(const AnsiString ATag);
	
protected:
	Byte FFlags;
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
	virtual void __fastcall Invoke(TsgDXFConverter* AConverter, TsgCADEntityProc Proc, TsgCADEntityProc FinishProc);
	
public:
	__fastcall virtual ~TsgDXFAttdef(void);
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	virtual AnsiString __fastcall EntName();
	__property Byte Flags = {read=FFlags, write=FFlags, nodefault};
	__property AnsiString Tag = {read=FTag, write=SetTag};
public:
	#pragma option push -w-inl
	/* TsgDXFText.Create */ inline __fastcall virtual TsgDXFAttdef(void) : TsgDXFText() { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TsgDXFAttrib : public TsgDXFAttdef 
{
	typedef TsgDXFAttdef inherited;
	
protected:
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
public:
	#pragma option push -w-inl
	/* TsgDXFAttdef.Destroy */ inline __fastcall virtual ~TsgDXFAttrib(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TsgDXFText.Create */ inline __fastcall virtual TsgDXFAttrib(void) : TsgDXFAttdef() { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TsgDXFLayout : public TsgDXFObjectEntity 
{
	typedef TsgDXFObjectEntity inherited;
	
private:
	Sgconsts::TFRect FBox;
	System::TObject* FCADImage;
	Sgconsts::TsgCADSpace FCADSpace;
	AnsiString FName;
	TsgDXFBlock* FPaperSpaceBlock;
	TsgPlotSettings FPlotSettings;
	double FRotMatrix[4][3];
	double FRotZAngle;
	Sgconsts::TFPoint FUCSOrigin;
	Sgconsts::TFPoint FUCSXDir;
	Sgconsts::TFPoint FUCSYDir;
	void __fastcall DoExtents(void);
	bool __fastcall GetIsEmpty(void);
	bool __fastcall GetIsModel(void);
	TsgDXFBlock* __fastcall GetPaperSpaceBlock(void);
	void __fastcall SetPaperSpaceBlock(TsgDXFBlock* ABlock);
	
protected:
	virtual Sgconsts::TFRect __fastcall GetBox();
	virtual int __fastcall GetCount(void);
	virtual TsgDXFEntity* __fastcall GetEntity(int Index);
	virtual void __fastcall Loaded(TsgDXFConverter* AConverter);
	
public:
	__fastcall virtual TsgDXFLayout(void);
	__fastcall virtual ~TsgDXFLayout(void);
	virtual bool __fastcall AddEntity(TsgDXFEntity* Entity);
	void __fastcall Iterate(TsgDXFConverter* AConverter, TsgCADEntityProc Proc, TsgCADEntityProc FinishProc);
	double __fastcall RotMatrix();
	void __fastcall SetRotMatrix(double * ARotMatrix);
	__property Sgconsts::TsgCADSpace CADSpace = {read=FCADSpace, write=FCADSpace, nodefault};
	__property bool IsEmpty = {read=GetIsEmpty, nodefault};
	__property bool IsModel = {read=GetIsModel, nodefault};
	__property AnsiString Name = {read=FName, write=FName};
	__property TsgDXFBlock* PaperSpaceBlock = {read=GetPaperSpaceBlock, write=SetPaperSpaceBlock};
	__property TsgPlotSettings PlotSettings = {read=FPlotSettings, write=FPlotSettings};
	__property int PlotPaperUnits = {read=FPlotSettings.PlotPaperUnits, write=FPlotSettings.PlotPaperUnits, nodefault};
	__property double RotZAngle = {read=FRotZAngle, write=FRotZAngle};
	__property Sgconsts::TFPoint UCSOrigin = {read=FUCSOrigin, write=FUCSOrigin};
	__property Sgconsts::TFPoint UCSXDir = {read=FUCSXDir, write=FUCSXDir};
	__property Sgconsts::TFPoint UCSYDir = {read=FUCSYDir, write=FUCSYDir};
};


class PASCALIMPLEMENTATION TsgDXFImageDef : public TsgDXFObjectEntity 
{
	typedef TsgDXFObjectEntity inherited;
	
private:
	Graphics::TPicture* FPicture;
	AnsiString FFileName;
	
protected:
	virtual void __fastcall Loaded(TsgDXFConverter* AConverter);
	
public:
	__fastcall virtual TsgDXFImageDef(void);
	__fastcall virtual ~TsgDXFImageDef(void);
	__property Graphics::TPicture* Picture = {read=FPicture};
	__property AnsiString FileName = {read=FFileName, write=FFileName};
};


class PASCALIMPLEMENTATION TsgDXFStyle : public TsgDXFPenTableItem 
{
	typedef TsgDXFPenTableItem inherited;
	
private:
	bool __fastcall GetBackward(void);
	bool __fastcall GetUpsideDown(void);
	
protected:
	AnsiString FBigFont;
	Byte FFlags;
	float FFixedHeight;
	AnsiString FFontName;
	float FLastHeightUsed;
	float FObliqueAngle;
	AnsiString FPrimaryFont;
	Byte FTextGenFlags;
	float FWidthFactor;
	virtual void __fastcall Loaded(TsgDXFConverter* AConverter);
	
public:
	__fastcall virtual TsgDXFStyle(void);
	__property bool Backward = {read=GetBackward, nodefault};
	__property AnsiString BigFont = {read=FBigFont, write=FBigFont};
	__property float FixedHeight = {read=FFixedHeight, write=FFixedHeight};
	__property Byte Flags = {read=FFlags, write=FFlags, nodefault};
	__property AnsiString FontName = {read=FFontName, write=FFontName};
	__property float LastHeightUsed = {read=FLastHeightUsed, write=FLastHeightUsed};
	__property float ObliqueAngle = {read=FObliqueAngle, write=FObliqueAngle};
	__property AnsiString PrimaryFont = {read=FPrimaryFont, write=FPrimaryFont};
	__property Byte TextGenFlags = {read=FTextGenFlags, write=FTextGenFlags, nodefault};
	__property float WidthFactor = {read=FWidthFactor, write=FWidthFactor};
	__property bool UpsideDown = {read=GetUpsideDown, nodefault};
public:
	#pragma option push -w-inl
	/* TsgDXFPenEntity.Destroy */ inline __fastcall virtual ~TsgDXFStyle(void) { }
	#pragma option pop
	
};


#pragma option push -b-
enum TTableSubclassMarker { AcDbEntity, AcDbBlockReference, AcDbTable };
#pragma option pop

class DELPHICLASS TsgDXFAcadTable;
class PASCALIMPLEMENTATION TsgDXFAcadTable : public TsgDXFObjectEntity 
{
	typedef TsgDXFObjectEntity inherited;
	
private:
	int FColumns;
	int FRows;
	Sgconsts::TFPoint FInsPoint;
	AnsiString FBlockName;
	TsgDXFInsert* FInsert;
	void __fastcall DoInsert(TsgDXFConverter* AConverter);
	
protected:
	virtual Sgconsts::TFRect __fastcall GetBox();
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
	virtual void __fastcall Invoke(TsgDXFConverter* AConverter, TsgCADEntityProc Proc, TsgCADEntityProc FinishProc);
	virtual void __fastcall Loaded(TsgDXFConverter* AConverter);
	
public:
	__fastcall virtual TsgDXFAcadTable(void);
	__fastcall virtual ~TsgDXFAcadTable(void);
	__property AnsiString BlockName = {read=FBlockName, write=FBlockName};
	__property Sgconsts::TFPoint InsPoint = {read=FInsPoint, write=FInsPoint};
};


class PASCALIMPLEMENTATION TsgDXFProxy : public TsgDXFPenLine 
{
	typedef TsgDXFPenLine inherited;
	
protected:
	Sgconsts::TFRect FBox;
	Classes::TList* FEntities;
	Classes::TList* FSubEntitiesProps;
	virtual Sgconsts::TFRect __fastcall GetBox();
	virtual int __fastcall GetCount(void);
	virtual TsgDXFEntity* __fastcall GetEntity(int Index);
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
	virtual void __fastcall Invoke(TsgDXFConverter* AConverter, TsgCADEntityProc Proc, TsgCADEntityProc FinishProc);
	virtual void __fastcall Loaded(TsgDXFConverter* AConverter);
	
public:
	__property Classes::TList* SubEntitiesProps = {read=FSubEntitiesProps};
	__fastcall virtual TsgDXFProxy(void);
	__fastcall virtual ~TsgDXFProxy(void);
	virtual bool __fastcall AddEntity(TsgDXFEntity* Entity);
};


class DELPHICLASS TsgFlatEntity;
class PASCALIMPLEMENTATION TsgFlatEntity : public TsgDXFObjectEntity 
{
	typedef TsgDXFObjectEntity inherited;
	
private:
	Sgconsts::TFRect FBox;
	Classes::TList* FPoints;
	Classes::TList* FCounts;
	Graphics::TColor FColor;
	Sgconsts::TFPoint __fastcall GetXY(int Index);
	void __fastcall SetXY(int Index, const Sgconsts::TFPoint &Value);
	
protected:
	virtual Sgconsts::TFRect __fastcall GetBox();
	virtual Graphics::TColor __fastcall GetColor(void);
	
public:
	__fastcall virtual TsgFlatEntity(void);
	__fastcall virtual ~TsgFlatEntity(void);
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	int __fastcall PCount(void);
	virtual void __fastcall SetColor(Graphics::TColor Value);
	__property Classes::TList* Points = {read=FPoints};
	__property Classes::TList* Counts = {read=FCounts};
	__property Sgconsts::TFPoint XY[int Index] = {read=GetXY, write=SetXY};
};


class DELPHICLASS TsgFlatPoly;
class PASCALIMPLEMENTATION TsgFlatPoly : public TsgFlatEntity 
{
	typedef TsgFlatEntity inherited;
	
private:
	double FLineWeight;
	
protected:
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
	virtual double __fastcall GetLineWeight(void);
	virtual void __fastcall SetLineWeight(double Value);
	
public:
	bool __fastcall Accepts(TsgDXFPolyline* P);
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	virtual double __fastcall GetThickness(void);
	void __fastcall Add(TsgDXFPolyline* P);
public:
	#pragma option push -w-inl
	/* TsgFlatEntity.Create */ inline __fastcall virtual TsgFlatPoly(void) : TsgFlatEntity() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TsgFlatEntity.Destroy */ inline __fastcall virtual ~TsgFlatPoly(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgFlatHatch;
class PASCALIMPLEMENTATION TsgFlatHatch : public TsgFlatEntity 
{
	typedef TsgFlatEntity inherited;
	
protected:
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
	
public:
	bool __fastcall Accepts(TsgCADPolyPolygon* P);
	void __fastcall Add(TsgCADPolyPolygon* P);
public:
	#pragma option push -w-inl
	/* TsgFlatEntity.Create */ inline __fastcall virtual TsgFlatHatch(void) : TsgFlatEntity() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TsgFlatEntity.Destroy */ inline __fastcall virtual ~TsgFlatHatch(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgSVGInsert;
class PASCALIMPLEMENTATION TsgSVGInsert : public TsgDXFInsert 
{
	typedef TsgDXFInsert inherited;
	
private:
	double *FPrevMatrix;
	
protected:
	double __fastcall GetPrevMatrix();
	virtual void __fastcall InitializeMatrix(void);
	void __fastcall SetPrevMatrix(double const * AMatrix);
	__property TsgDXFConverter* ResolveConverter = {read=FResolveConverter, write=FResolveConverter};
	
public:
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	__fastcall virtual ~TsgSVGInsert(void);
public:
	#pragma option push -w-inl
	/* TsgDXFInsert.Create */ inline __fastcall virtual TsgSVGInsert(void) : TsgDXFInsert() { }
	#pragma option pop
	
};


class DELPHICLASS TsgSVGMText;
class PASCALIMPLEMENTATION TsgSVGMText : public TsgSVGInsert 
{
	typedef TsgSVGInsert inherited;
	
public:
	__fastcall virtual TsgSVGMText(void);
	__fastcall virtual ~TsgSVGMText(void);
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
};


class DELPHICLASS TsgSVGPath;
class PASCALIMPLEMENTATION TsgSVGPath : public TsgDXFPolyline 
{
	typedef TsgDXFPolyline inherited;
	
private:
	Sgconsts::TFPoint FFirstPoint;
	Sgconsts::TFPoint *FLastPoint;
	bool FIsAbsKoordinat;
	char FKeyChar;
	double *FMatrix;
	AnsiString FParametrs;
	void __fastcall CreateSpline(Classes::TList* APoints);
	void __fastcall CreateQuadraticSpline(const Sgconsts::TFPoint &APt1, const Sgconsts::TFPoint &APt2, const Sgconsts::TFPoint &APt3, Word Level);
	Sgconsts::TFPoint __fastcall GetLastPoint();
	
protected:
	void __fastcall AddPoint(const Sgconsts::PFPoint APoint);
	void __fastcall ApplyMatrix(void);
	int __fastcall DataToVertex(Classes::TList* AData);
	void __fastcall DeleteFisrtIPoints(Classes::TList* APoints, int AIndex);
	void __fastcall DoAbsKoordinat(Sgconsts::PFPoint APoint);
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
	void __fastcall MakeArc(Classes::TList* AData);
	void __fastcall MakeCloseFigure(Classes::TList* AData);
	void __fastcall MakeHorizLine(Classes::TList* AData);
	void __fastcall MakeLine(Classes::TList* AData);
	void __fastcall MakeMove(Classes::TList* AData);
	void __fastcall MakeShortSpline(Classes::TList* AData);
	void __fastcall MakeShortQuadraticBezier(Classes::TList* AData);
	void __fastcall MakeSpline(Classes::TList* AData);
	void __fastcall MakeQuadraticBezier(Classes::TList* AData);
	void __fastcall MakeVertLine(Classes::TList* AData);
	virtual void __fastcall ReloadPolyPoints(void);
	
public:
	__fastcall virtual TsgSVGPath(void);
	__fastcall virtual ~TsgSVGPath(void);
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
	double __fastcall GetMatrix();
	void __fastcall SetMatrix(double const * AMatrix);
	__property Sgconsts::TFPoint FirstPoint = {read=FFirstPoint, write=FFirstPoint};
	__property Sgconsts::TFPoint LastPoint = {read=GetLastPoint};
	__property AnsiString Parametrs = {read=FParametrs, write=FParametrs};
};


class DELPHICLASS TsgSVGPattern;
class PASCALIMPLEMENTATION TsgSVGPattern : public TsgSVGInsert 
{
	typedef TsgSVGInsert inherited;
	
private:
	Classes::TList* FPolylines;
	
protected:
	void __fastcall AddBoundary(Classes::TList* APoints);
	virtual Sgconsts::TsgCADEnities __fastcall GetEntType(void);
	virtual void __fastcall Invoke(TsgDXFConverter* AConverter, TsgCADEntityProc Proc, TsgCADEntityProc FinishProc);
	virtual void __fastcall Loaded(TsgDXFConverter* AConverter);
	__property Classes::TList* Polylines = {read=FPolylines};
	
public:
	__fastcall virtual TsgSVGPattern(void);
	__fastcall virtual ~TsgSVGPattern(void);
	virtual void __fastcall AssignEntity(TsgDXFEntity* Source);
};


//-- var, const, procedure ---------------------------------------------------
extern PACKAGE Classes::TStringList* MacroStrings;
extern PACKAGE WideString __fastcall ConvertToCodePage(const AnsiString AText, const int ACodePage);
extern PACKAGE WideChar __fastcall GetMultibyteSymbol(const Byte ALeft, const Byte ARight, const int ANumber);
extern PACKAGE Shx::PsgSHXVertex __fastcall GetVertex(Classes::TList* AList, int Index, const double ASy);
extern PACKAGE double __fastcall SGArcCos(const double X);
extern PACKAGE Sgconsts::TFRect __fastcall BadRect();
extern PACKAGE bool __fastcall IsBadRect(const Sgconsts::TFRect &ARect);
extern PACKAGE Sgconsts::TFRect __fastcall UnitRect();
extern PACKAGE int __fastcall IsSystemNotRasterFont(AnsiString AFontName);
extern PACKAGE TsgArc __fastcall EntArc(TsgDXFArc* E, const TsgCADIterate &P);
extern PACKAGE Graphics::TColor __fastcall EntColor(TsgDXFEntity* E, TsgDXFInsert* Ins);
extern PACKAGE TsgDXFLayer* __fastcall EntLayer(TsgDXFEntity* E, TsgDXFInsert* Ins);
extern PACKAGE double __fastcall EntLineWeight(TsgDXFEntity* E, TsgDXFInsert* Ins);
extern PACKAGE Graphics::TPenStyle __fastcall EntStyle(TsgDXFEntity* E);
extern PACKAGE void __fastcall GetSinglePts(Sgconsts::TFPoint * APts, const int APts_Size, Classes::TList* AList);
extern PACKAGE void __fastcall OffsetFRect(Sgconsts::TFRect &R, Extended DX, Extended DY, Extended DZ);
extern PACKAGE Sgconsts::TFPoint __fastcall RotateFPoint(const Sgconsts::TFPoint &P, Extended Angle);
extern PACKAGE void __fastcall RotateFRect(Sgconsts::TFRect &R, Extended Angle);
extern PACKAGE void __fastcall DoScale2D(TsgCADIterate &P);
extern PACKAGE void __fastcall TextParms(TsgCADIterate &P);
extern PACKAGE void __fastcall UnionFRect(Sgconsts::TFRect &Dst, const Sgconsts::TFRect &Src);
extern PACKAGE int __fastcall StringHexToIntDef(const AnsiString AStr, int ADef);
extern PACKAGE int __fastcall BSwap(int Value);
extern PACKAGE char * __fastcall StrPos(char * Str1, char * Str2, char * Limit);
extern PACKAGE int __fastcall StrIndex(const AnsiString S, AnsiString const * Map, const int Map_Size);

}	/* namespace Dxfconv */
using namespace Dxfconv;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Dxfconv
