void Sphere(GLdouble radius, GLint slices, GLint stacks )
{
   GLdouble x, y, z;
   GLint i, j, imax;

   for (j=0;j<=slices;j++) {
       sinez[j]=sin(j * 2*PI / (GLdouble) slices);
       cosez[j]=cos(j * 2*PI / (GLdouble) slices);
   }

   glBegin( GL_TRIANGLE_FAN );
   glNormal3d( 0.0, 0.0, 1.0 );
   glVertex3d( 0.0, 0.0, radius );
   for (j=0;j<=slices;j++) {
      x = -sinez[j] * sinez[1];
      y =  cosez[j] * sinez[1];
      z =  cosez[1];
      glNormal3d( x, y, z );
      glVertex3d( x*radius, y*radius, z*radius );
   }
   glEnd();

   // draw intermediate stacks as quad strips
   for (i=1,imax = stacks/2;i<imax;i++) {
      glBegin( GL_QUAD_STRIP );
      for (j=0;j<=slices;j++) {
         x = -sinez[j] * sinez[i];
         y =  cosez[j] * sinez[i];
         z =  cosez[i];
         glNormal3d( x, y, z );
         glVertex3d( x*radius, y*radius, z*radius );
         x = -sinez[j] * sinez[i+1];
         y =  cosez[j] * sinez[i+1];
         z =  cosez[i+1];
         glNormal3d( x, y, z );
         glVertex3d( x*radius, y*radius, z*radius );
      }
      glEnd();
   }

   glBegin( GL_TRIANGLE_FAN );
   glNormal3d( 0.0, 0.0, -1.0 );
   glVertex3d( 0.0, 0.0, -radius );
   
   for (i=slices/2-1, j=slices;j>=0;j--) {
      x = -sinez[j] * sinez[i];
      y =  cosez[j] * sinez[i];
      z =  cosez[i];
      glNormal3d( x, y, z );
      glVertex3d( x*radius, y*radius, z*radius );
   }
   glEnd();
}