/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.testing;

import java.util.Enumeration;
import java.util.Hashtable;
import junit.framework.Assert;
import org.nakedobjects.object.Naked;
import org.nakedobjects.object.NakedClass;
import org.nakedobjects.object.NakedCollection;
import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.NakedValue;
import org.nakedobjects.object.collection.InternalCollection;
import org.nakedobjects.object.control.Permission;
import org.nakedobjects.object.reflect.Action;
import org.nakedobjects.object.reflect.Association;
import org.nakedobjects.object.reflect.Field;
import org.nakedobjects.object.reflect.NakedClassException;
import org.nakedobjects.object.value.Date;
import org.nakedobjects.object.value.FloatingPointNumber;
import org.nakedobjects.object.value.Logical;
import org.nakedobjects.object.value.Option;
import org.nakedobjects.object.value.Percentage;
import org.nakedobjects.object.value.WholeNumber;
import org.nakedobjects.testing.AbstractView;
import org.nakedobjects.testing.Documentor;
import org.nakedobjects.testing.DragView;
import org.nakedobjects.testing.FieldView;
import org.nakedobjects.testing.IllegalActionError;
import org.nakedobjects.utility.NotImplementedException;

public class View
extends AbstractView {
    private final Hashtable fields;

    public View(NakedObject nakedObject) {
        this.forObject = nakedObject;
        this.fields = new Hashtable();
        if (nakedObject != null) {
            Field[] fieldArray = NakedClass.getNakedClass(this.forObject.getClass()).getFields();
            int n = 0;
            while (n < fieldArray.length) {
                Field field = fieldArray[n];
                if (field instanceof Association) {
                    NakedObject nakedObject2 = (NakedObject)fieldArray[n].get(nakedObject);
                    this.fields.put(fieldArray[n].getName(), new View(nakedObject2));
                } else {
                    this.fields.put(field.getName(), new FieldView((NakedValue)field.get(nakedObject)));
                }
                ++n;
            }
        }
    }

    public void assertFieldContains(String string, String string2, View view) {
        Naked naked = this.getField((String)string2).forObject;
        if (view == null) {
            if (naked instanceof InternalCollection) {
                int n = ((InternalCollection)naked).size();
                if (n > 0) {
                    Assert.fail((String)(this.expected(string) + " " + string2 + " collection to contain zero elements, but found " + n));
                }
            } else if (naked != null) {
                Assert.fail((String)(this.expected(string) + " an empty field, but found " + naked));
            }
        } else {
            Naked naked2 = view.getForObject();
            if (naked instanceof InternalCollection) {
                if (!((InternalCollection)naked).contains((NakedObject)naked2)) {
                    Assert.fail((String)(this.expected(string) + " " + string2 + " collection to contain " + naked2));
                }
            } else if (!naked.equals(naked2)) {
                Assert.fail((String)(this.expected(string) + " object of " + naked2 + " but got " + naked));
            }
        }
    }

    public void assertFieldContains(String string, View view) {
        this.assertFieldContains("", string, view);
    }

    public void assertFieldContains(String string, String string2) {
        this.assertFieldContains("", string, string2);
    }

    public void assertFieldContains(String string, String string2, String string3) {
        String string4 = this.getField((String)string2).forObject.title().toString();
        if (!string4.equals(string3)) {
            Assert.fail((String)(this.expected(string) + " value " + string3 + " but got " + string4));
        }
    }

    public void assertFieldReadOnly(String string) {
        try {
            NakedValue nakedValue = (NakedValue)this.getField(string).getForObject();
            String string2 = "";
            if (nakedValue instanceof WholeNumber) {
                string2 = "1";
            } else if (nakedValue instanceof Date) {
                string2 = "1-Dec-00";
            } else if (nakedValue instanceof FloatingPointNumber) {
                string2 = "1.0";
            } else if (nakedValue instanceof Logical) {
                string2 = "True";
            } else if (nakedValue instanceof Percentage) {
                string2 = "10%";
            }
            this.fieldEntry(string, string2);
            Assert.fail((String)("Field " + string + " could be set"));
        }
        catch (IllegalActionError illegalActionError) {
            // empty catch block
        }
    }

    public void assertCantDrop(DragView dragView) {
        NakedObject nakedObject = (NakedObject)dragView.getForObject();
        Action action = null;
        try {
            action = NakedClass.getNakedClass(this.forObject.getClass()).get1ParamClassAction(nakedObject.getClass());
        }
        catch (NakedClassException nakedClassException) {
            Assert.fail((String)("Can't drop a " + nakedObject.getClassName() + " onto a " + this.forObject.getClassName()));
        }
        Assert.assertTrue((String)("drop not allowed on " + this.forObject), (boolean)action.getAbout((NakedObject)this.forObject, nakedObject).canUse().isVetoed());
    }

    public void assertCantRightClick(String string) {
        Action action;
        try {
            action = NakedClass.getNakedClass(this.forObject.getClass()).get0ParamAction(string);
        }
        catch (NakedClassException nakedClassException) {
            Assert.fail((String)nakedClassException.getMessage());
            return;
        }
        Assert.assertTrue((String)("action " + string + " could not be invoked in current state "), (boolean)action.getAbout((NakedObject)this.forObject).canUse().isVetoed());
    }

    public void assertTitleEquals(String string) {
        this.assertTitleEquals("", string);
    }

    public void assertTitleEquals(String string, String string2) {
        if (!this.getTitle().equals(string2)) {
            Assert.fail((String)(this.expected(string) + " title of " + this.forObject + " as '" + string2 + "' but got '" + this.getTitle() + "'"));
        }
    }

    public void checkAssociation(String string, AbstractView abstractView) {
        Naked naked = this.getField(string).getForObject();
        Naked naked2 = abstractView.getForObject();
        if (naked instanceof InternalCollection) {
            if (!((InternalCollection)naked).contains((NakedObject)naked2)) {
                throw new IllegalActionError("Expected " + naked2 + " but received " + (InternalCollection)naked);
            }
        } else if (naked != naked2) {
            throw new IllegalActionError("Expected " + naked2 + " but received " + naked);
        }
        if (Documentor.isGenerating()) {
            this.doc("<p>Note that the field <em>" + string + "</em> in the " + this.objectString(this.getForObject()) + " contains the " + this.objectString(this.getField((String)string).forObject) + ".");
        }
    }

    public void checkCantDrop(DragView dragView) {
        Action action;
        NakedObject nakedObject = (NakedObject)dragView.getForObject();
        try {
            action = NakedClass.getNakedClass(this.forObject.getClass()).get1ParamAction(nakedObject.getClass());
        }
        catch (NakedClassException nakedClassException) {
            throw new IllegalActionError("Can't drop a " + nakedObject.getClassName() + " onto a " + this.forObject.getClassName());
        }
        if (action.getAbout((NakedObject)this.forObject, nakedObject).canUse().isVetoed()) {
            if (Documentor.isGenerating()) {
                this.doc("note that it can't be dropped onto the ");
                this.doc(this.objectString(this) + ". ");
            }
        } else {
            throw new IllegalActionError("drop not allowed on " + this.forObject);
        }
    }

    public void checkCantRightClick(String string) {
        Action action;
        try {
            action = NakedClass.getNakedClass(this.forObject.getClass()).get0ParamAction(string);
        }
        catch (NakedClassException nakedClassException) {
            throw new IllegalActionError(nakedClassException.getMessage());
        }
        if (action.getAbout((NakedObject)this.forObject).canUse().isVetoed()) {
            if (Documentor.isGenerating()) {
                this.doc("Right clicking on the " + this.objectString(this));
                this.doc(" shows that <strong>" + string);
                this.doc(action.hasReturnValue() ? "..." : "");
                this.doc("</strong> is not currently available. ");
            }
        } else {
            throw new IllegalActionError("action could be invoked in current state " + this.forObject);
        }
    }

    public void checkField(String string, String string2) {
        String string3 = this.getFieldTitle(string);
        Naked naked = this.getField((String)string).forObject;
        if (naked instanceof Option && !((Option)naked).hasOption(string2)) {
            throw new IllegalActionError("Expected option setting of " + string2 + " in field " + string + " is not a valid  option");
        }
        if (!string3.equals(string2)) {
            throw new IllegalActionError("Expected " + string2 + " but got " + string3 + " in field " + string);
        }
        if (Documentor.isGenerating()) {
            if (this.fieldFor(string).isValue()) {
                this.doc("<p>Note that the field <em>" + string + "</em> in the " + this.objectString(this.getForObject()) + " is now set to '" + this.getField((String)string).forObject.title() + "'.");
            } else {
                this.doc("<p>Note that object in the field <em>" + string + "</em> of " + this.objectString(this.getForObject()) + " now has a title of '" + this.getField((String)string).forObject.title() + "'.");
            }
        }
    }

    public void checkField(String string, NakedValue nakedValue) {
        AbstractView abstractView = this.getField(string);
        NakedValue nakedValue2 = (NakedValue)abstractView.getForObject();
        if (!nakedValue2.isSameAs(nakedValue)) {
            throw new IllegalActionError("Expected value " + nakedValue + " but got " + nakedValue2 + " in field " + string);
        }
        if (Documentor.isGenerating()) {
            this.doc("<p>Note that the field <em>" + string + "</em> in the " + this.objectString(this.getForObject()) + " is now set to '" + this.getField((String)string).forObject.title() + "'.");
        }
    }

    public void checkField(String string, AbstractView abstractView) {
        Naked naked = this.getField(string).getForObject();
        Naked naked2 = abstractView.getForObject();
        if (naked instanceof NakedCollection) {
            if (!((NakedCollection)naked).contains((NakedObject)naked2)) {
                throw new IllegalActionError("Expected " + naked2 + " but received " + (NakedCollection)naked);
            }
            this.doc("<em>" + string + "</em> contains the " + this.objectString(naked2) + "; ");
        } else {
            if (naked != naked2) {
                throw new IllegalActionError("Expected " + naked2 + " but received " + naked);
            }
            this.doc("<em>" + string + "</em> contains the " + this.objectString(naked) + "; ");
        }
    }

    public void checkTitle(String string) {
        String string2 = this.getTitle();
        if (!string2.equals(string)) {
            throw new IllegalActionError("Expected title " + string + " but got " + string2 + " in object " + this.getForObject());
        }
        if (Documentor.isGenerating()) {
            this.doc("Note the new  title: " + this.objectString(this.getForObject()) + " .");
        }
    }

    public DragView drag() {
        if (Documentor.isGenerating()) {
            this.doc("Drag the " + this.objectString(this) + " and ");
        }
        return new DragView(this);
    }

    public DragView drag(String string) {
        View view = (View)this.getField(string);
        if (Documentor.isGenerating()) {
            this.doc("Drag out the " + this.objectString(view) + " from the ");
            this.doc("<em>" + string + "</em> field within the " + this.objectString(this) + " and ");
        }
        return new DragView(view);
    }

    public DragView drag(String string, String string2) {
        View view = this.getField(string, string2);
        if (Documentor.isGenerating()) {
            this.doc("Drag out the " + this.objectString(view) + " from the ");
            this.doc("<em>" + string + "</em> field within the " + this.objectString(this) + " and ");
        }
        return new DragView(view);
    }

    public void drop(String string, DragView dragView) {
        AbstractView abstractView = this.getField(string);
        if (abstractView instanceof FieldView) {
            throw new IllegalActionError("drop(..) not allowed on value target field; use fieldEntry(..) instead");
        }
        if (abstractView.getForObject() != null && !(abstractView.getForObject() instanceof InternalCollection)) {
            throw new IllegalActionError("Field already contains an object: " + abstractView.getForObject());
        }
        Association association = (Association)this.fieldFor(string);
        NakedObject nakedObject = (NakedObject)dragView.getForObject();
        if (!association.getType().isAssignableFrom(nakedObject.getClass())) {
            throw new IllegalActionError("Can't drop a " + dragView.getForObject().getClassName() + " on to the " + string + " field");
        }
        association.set((NakedObject)this.forObject, nakedObject);
        if (Documentor.isGenerating()) {
            this.doc("drop it into the ");
            this.docln("<em>" + string + "</em> field within the " + this.objectString(this) + ". ");
        }
    }

    public View drop(DragView dragView) {
        NakedObject nakedObject;
        Action action;
        NakedObject nakedObject2 = (NakedObject)dragView.getForObject();
        try {
            action = NakedClass.getNakedClass(this.forObject.getClass()).get1ParamAction(nakedObject2.getClass());
        }
        catch (NakedClassException nakedClassException) {
            throw new IllegalActionError("Can't drop a " + nakedObject2.getClassName() + " onto a " + this.forObject.getClassName());
        }
        if (action.getAbout((NakedObject)this.forObject, nakedObject2).canUse().isVetoed()) {
            throw new IllegalActionError("drop not allowed on " + this.forObject);
        }
        if (Documentor.isGenerating()) {
            this.doc("drop it onto the ");
            this.doc(this.objectString(this));
        }
        if ((nakedObject = action.execute((NakedObject)this.forObject, nakedObject2)) == null) {
            if (Documentor.isGenerating()) {
                this.docln(". ");
            }
            return null;
        }
        if (Documentor.isGenerating()) {
            this.docln(", which returns " + this.simpleObjectString(nakedObject) + ". ");
        }
        return new View(nakedObject);
    }

    private String expected(String string) {
        return (string == null ? "E" : string + "; e") + "xpected";
    }

    public void fieldEntry(String string, String string2) {
        Object v;
        if (Documentor.isGenerating()) {
            this.doc("Set the <em>" + string + "</em> field within the " + this.objectString(this));
            this.docln(" to <code>" + string2 + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</code>. ");
        }
        if (this.fields.containsKey(string)) {
            v = this.fields.get(string);
            if (!(v instanceof FieldView)) {
                throw new IllegalActionError("Can only make an entry (eg by keyboard) into a value field");
            }
        } else {
            throw new IllegalArgumentException("Field " + string + " is not in the object " + this.forObject);
        }
        FieldView fieldView = (FieldView)v;
        fieldView.forObject = this.fieldFor(string).get((NakedObject)this.forObject);
        fieldView.fieldEntry(string2);
    }

    private Field fieldFor(String string) {
        Field field = NakedClass.getNakedClass(this.forObject.getClass()).getField(string);
        if (field == null) {
            Assert.fail((String)("No field called " + string + " in " + this.forObject.getClass().getName()));
            return null;
        }
        return field;
    }

    public AbstractView getField(String string) {
        if (this.fields.containsKey(string)) {
            AbstractView abstractView = (AbstractView)this.fields.get(string);
            abstractView.forObject = this.fieldFor(string).get((NakedObject)this.forObject);
            return abstractView;
        }
        throw new IllegalArgumentException("Field " + string + " is not in the object " + this.forObject);
    }

    public View getField(String string, String string2) {
        if (this.fields.containsKey(string)) {
            View view = (View)this.fields.get(string);
            view.forObject = this.fieldFor(string).get((NakedObject)this.forObject);
            if (!(view.getForObject() instanceof InternalCollection)) {
                throw new IllegalActionError("getField(String, String) only allows an object to be selected from an InternalCollection");
            }
            Enumeration enumeration = ((NakedCollection)view.forObject).elements();
            NakedObject nakedObject = null;
            int n = 0;
            while (enumeration.hasMoreElements()) {
                NakedObject nakedObject2 = (NakedObject)enumeration.nextElement();
                if (!nakedObject2.title().toString().equals(string2)) continue;
                nakedObject = nakedObject2;
                ++n;
            }
            if (n == 0) {
                throw new IllegalActionError("The field " + string + " must contain an object named " + string2 + " within it");
            }
            if (n > 1) {
                throw new IllegalActionError("The field " + string + " must only contain one object named " + string2 + " within it");
            }
            return new View(nakedObject);
        }
        throw new IllegalArgumentException("Field " + string + " is not in the object " + this.forObject);
    }

    public String getFieldTitle(String string) {
        if (this.getField((String)string).forObject == null) {
            throw new IllegalActionError("No object to get title from in field " + string + " within " + this.forObject);
        }
        return this.getField(string).getTitle();
    }

    public String getTitle() {
        if (this.forObject == null) {
            throw new IllegalActionError("??");
        }
        return this.forObject.title().toString();
    }

    public String objectString(View view) {
        return this.objectString(view.forObject);
    }

    public void removeReference(String string) {
        Documentor documentor = (Documentor)this.fields.get(string);
        if (documentor instanceof FieldView) {
            throw new IllegalActionError("set(..) not allowed on value target field; use fieldEntry(..) instead");
        }
        ((Association)this.fieldFor(string)).set((NakedObject)this.forObject, null);
    }

    public void removeReference(String string, String string2) {
        throw new NotImplementedException();
    }

    public View rightClick(String string) {
        Action action;
        try {
            action = NakedClass.getNakedClass(this.forObject.getClass()).get0ParamAction(string);
        }
        catch (NakedClassException nakedClassException) {
            throw new IllegalActionError(nakedClassException.getMessage());
        }
        Permission permission = action.getAbout((NakedObject)this.forObject).canUse();
        if (permission.isVetoed()) {
            throw new IllegalActionError("action " + string + " cannot be invoked on " + this.forObject + ": " + permission.getReason());
        }
        NakedObject nakedObject = action.execute((NakedObject)this.forObject);
        if (Documentor.isGenerating()) {
            this.doc("Right click on the " + this.objectString(this));
            this.doc(" and select the <strong>" + string);
            this.doc(action.hasReturnValue() ? "..." : "");
            this.doc("</strong> action");
            this.doc(nakedObject == null ? "." : ", which returns " + this.simpleObjectString(nakedObject) + ". ");
        }
        return nakedObject == null ? null : new View(nakedObject);
    }

    public final View select(String string) {
        if (!(this.getForObject() instanceof NakedCollection)) {
            throw new IllegalActionError("selectByTitle will only select from a collection!");
        }
        NakedCollection nakedCollection = (NakedCollection)this.getForObject();
        if (Documentor.isGenerating()) {
            this.doc("Select the instance within " + this.objectString(nakedCollection) + " (<img width=\"16\" height=\"16\" align=\"Center\" src=\"images/Collection16.gif\">) " + " class whose title matches <strong>" + string + "</strong>");
        }
        Enumeration enumeration = nakedCollection.elements();
        NakedObject nakedObject = null;
        int n = 0;
        while (enumeration.hasMoreElements()) {
            NakedObject nakedObject2 = (NakedObject)enumeration.nextElement();
            if (nakedObject2.title().toString().indexOf(string) < 0) continue;
            nakedObject = nakedObject2;
            ++n;
        }
        if (n == 0) {
            throw new IllegalActionError("selectByTitle must find an object within " + nakedCollection);
        }
        if (n > 1) {
            throw new IllegalActionError("selectByTitle must select only one object within " + nakedCollection);
        }
        if (Documentor.isGenerating()) {
            this.docln(", which returns " + this.objectString(nakedObject) + ". ");
        }
        return new View(nakedObject);
    }

    public void testField(String string, View view) {
        this.drop(string, new DragView(view));
        Assert.assertEquals((Object)view.getForObject(), (Object)this.getField(string).getForObject());
    }

    public void testField(String string, String string2) {
        this.testField(string, string2, string2);
    }

    public void testField(String string, String string2, String string3) {
        this.fieldEntry(string, string2);
        Assert.assertEquals((String)("Field " + string + "contains unexpected value"), (Object)string3, (Object)this.getField(string).getTitle());
    }
}

