/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.distribution;

import java.io.Serializable;
import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.NakedObjectStore;
import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.object.distribution.ObjectRequest;
import org.nakedobjects.object.distribution.Server;
import org.nakedobjects.object.reflect.Action;

public class ActionRequest
extends ObjectRequest {
    private static final long serialVersionUID = 1L;
    private String actionName;
    private Object[] parameterOids;

    public ActionRequest(NakedObject nakedObject, Action action, NakedObject[] nakedObjectArray) {
        super(nakedObject);
        this.actionName = action.getName();
        this.parameterOids = new Object[nakedObjectArray.length];
        int n = 0;
        while (n < nakedObjectArray.length) {
            if (nakedObjectArray[n].getOid() == null) {
                throw new IllegalArgumentException("All parameters must have an OID to used in a message");
            }
            this.parameterOids[n] = nakedObjectArray[n].getOid();
            ++n;
        }
    }

    public NakedObject executeAction() throws ObjectStoreException {
        this.sendRequest();
        Serializable serializable = this.response;
        if (serializable == null) {
            return null;
        }
        return this.getProxyObjectStore().getObject(serializable);
    }

    void generateResponse(Server server) {
        try {
            NakedObjectStore nakedObjectStore = server.getObjectStore();
            NakedObject nakedObject = nakedObjectStore.getObject(this.getOid());
            NakedObject[] nakedObjectArray = new NakedObject[this.parameterOids.length];
            int n = 0;
            while (n < this.parameterOids.length) {
                nakedObjectArray[n] = nakedObjectStore.getObject(this.parameterOids[n]);
                ++n;
            }
            Action action = nakedObjectArray.length == 0 ? nakedObject.getNakedClass().get0ParamAction(this.actionName) : nakedObject.getNakedClass().get1ParamAction(this.actionName);
            NakedObject nakedObject2 = action.execute(nakedObject, nakedObjectArray);
            this.response = nakedObject2 == null ? null : (Serializable)nakedObject2.getOid();
        }
        catch (ObjectStoreException objectStoreException) {
            this.response = objectStoreException;
        }
    }

    public String toString() {
        return "Action [" + this.actionName + "]";
    }
}

