/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.basicgui.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import org.nakedobjects.basicgui.view.ObjectViewer;
import org.nakedobjects.basicgui.view.StatusColor;
import org.nakedobjects.basicgui.view.TextStyle;
import org.nakedobjects.basicgui.view.ViewBorder;
import org.nakedobjects.basicgui.view.ViewColor;
import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.reflect.Field;

public class FormBorder
extends ViewBorder {
    private TextStyle style;

    public FormBorder() {
        this(TextStyle.getStyle(3));
    }

    public FormBorder(TextStyle textStyle) {
        this.style = textStyle;
    }

    public Insets getBorderInsets(ObjectViewer objectViewer) {
        int n = 0;
        Field[] fieldArray = objectViewer.getObject().getNakedClass().getFields();
        int n2 = 0;
        while (n2 < fieldArray.length) {
            n = Math.max(n, this.style.getMetrics().stringWidth(fieldArray[n2].getLabel(objectViewer.getObject()) + ": "));
            ++n2;
        }
        return new Insets(0, n + 5, 0, 0);
    }

    public void paint(Graphics graphics, Rectangle rectangle, ObjectViewer objectViewer) {
        NakedObject nakedObject = objectViewer.getObject();
        Field[] fieldArray = nakedObject.getNakedClass().getFields();
        Component[] componentArray = ((Container)((Object)objectViewer.getDisplay())).getComponents();
        graphics.setColor(StatusColor.colorFor(objectViewer.getDisplayState(), ViewColor.fieldLabel));
        graphics.setFont(this.style.getFont());
        int n = 0;
        int n2 = rectangle.x + 1;
        int n3 = 0;
        while (n3 < fieldArray.length) {
            String string = fieldArray[n3].getLabel(nakedObject) + ": ";
            n = n3 >= componentArray.length ? (n += 10) : componentArray[n3].getLocation().y;
            graphics.drawString(string, n2, n + this.style.getMetrics().getAscent());
            ++n3;
        }
    }
}

