/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.basicgui.event.dnd;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import org.nakedobjects.basicgui.event.dnd.DragDropEvent;
import org.nakedobjects.basicgui.event.dnd.DragSource;
import org.nakedobjects.basicgui.event.dnd.DropDestination;
import org.nakedobjects.basicgui.event.dnd.DroppableContainers;

public class DragDropProcessor {
    private static DragSource dragSource;
    private static DropDestination previousDropDestination;
    private DropDestination dropDestination;
    private static boolean isDraggable;

    private Point calculateLocation(MouseEvent mouseEvent) {
        Point point = mouseEvent.getComponent().getLocationOnScreen();
        point.translate(mouseEvent.getX(), mouseEvent.getY());
        return point;
    }

    private DragDropEvent createEvent(int n, MouseEvent mouseEvent) {
        Point point = mouseEvent.getComponent().getLocationOnScreen();
        point.translate(mouseEvent.getX(), mouseEvent.getY());
        int n2 = mouseEvent.getModifiers();
        return new DragDropEvent(n, n2, dragSource, this.dropDestination, point);
    }

    private void dragging(MouseEvent mouseEvent) {
        Component component = DroppableContainers.locate(this.calculateLocation(mouseEvent));
        if (component instanceof DropDestination) {
            if (component != previousDropDestination) {
                if (previousDropDestination != null) {
                    previousDropDestination.dragExit(this.createEvent(8, mouseEvent));
                }
                this.dropDestination = (DropDestination)((Object)component);
                this.dropDestination.dragEnter(this.createEvent(7, mouseEvent));
                previousDropDestination = this.dropDestination;
            }
            this.dropDestination.dragging(this.createEvent(2, mouseEvent));
        } else {
            if (previousDropDestination != null) {
                previousDropDestination.dragExit(this.createEvent(8, mouseEvent));
            }
            this.dropDestination = null;
            previousDropDestination = null;
        }
        dragSource.dragging(this.createEvent(2, mouseEvent));
    }

    private void drop(MouseEvent mouseEvent) {
        Component component = DroppableContainers.locate(this.calculateLocation(mouseEvent));
        if (component instanceof DropDestination) {
            DropDestination dropDestination = (DropDestination)((Object)component);
            if (dropDestination == dragSource) {
                dragSource.cancel(this.createEvent(9, mouseEvent));
            }
            if ((mouseEvent.getModifiers() & 8) == 8) {
                dragSource.move(this.createEvent(3, mouseEvent));
            } else {
                dragSource.copy(this.createEvent(4, mouseEvent));
            }
            dropDestination.drop(this.createEvent(5, mouseEvent));
            dragSource = null;
            dropDestination = null;
        } else {
            dragSource.vacantDrop(this.createEvent(6, mouseEvent));
            dragSource = null;
            this.dropDestination = null;
        }
    }

    private void init(MouseEvent mouseEvent) {
        dragSource = null;
        previousDropDestination = null;
        isDraggable = mouseEvent.getComponent() instanceof DragSource;
    }

    private boolean isDragging() {
        return isDraggable && dragSource != null;
    }

    private void newDrag(MouseEvent mouseEvent) {
        if (isDraggable) {
            dragSource = (DragSource)((Object)mouseEvent.getComponent());
            this.dropDestination = (DropDestination)((Object)dragSource);
            previousDropDestination = (DropDestination)((Object)dragSource);
            dragSource.drag(this.createEvent(1, mouseEvent));
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 8) > 0) {
            return;
        }
        if ((mouseEvent.getModifiers() & 4) > 0) {
            return;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                this.init(mouseEvent);
                break;
            }
            case 502: {
                if (!this.isDragging()) break;
                this.drop(mouseEvent);
                break;
            }
            case 506: {
                if (this.isDragging()) {
                    this.dragging(mouseEvent);
                    break;
                }
                this.newDrag(mouseEvent);
            }
        }
    }

    static {
        previousDropDestination = null;
    }
}

